/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.admadic.calculator.ui.CfgCalc;
import de.admadic.cfg.Cfg;
import de.admadic.ui.util.Dialog;
import de.admadic.util.FileUtil;
import de.admadic.util.PathManager;
import de.admadic.util.VersionName;
import de.admadic.util.VersionUtil;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class UpdateManager {
    static final boolean LOG = true;
    Logger logger = null;
    CfgCalc cfg;
    PathManager pathMan;
    Vector<String> versions;
    Vector<VersionName> versionNames;
    Hashtable<VersionName, String> versionNamesToVersions;
    Hashtable<String, File> cfgfiles;
    String curVer;
    int curVerIdx;
    String mergeSrcVer;
    Cfg cachePrevCfg;

    public UpdateManager(CfgCalc cfgCalc, PathManager pathManager) {
        this.cfg = cfgCalc;
        this.pathMan = pathManager;
        this.versions = new Vector();
        this.versionNames = new Vector();
        this.versionNamesToVersions = new Hashtable();
        this.cfgfiles = new Hashtable();
        this.curVer = null;
        this.curVerIdx = -1;
    }

    public void initLogging() {
        this.logger = Logger.getLogger("de.admadic");
    }

    public boolean isFresh() {
        return !this.cfg.existsCfgFile();
    }

    protected int compareVersion(VersionName versionName, VersionName versionName2) {
        if (versionName.getVersionRecord() == null && versionName2.getVersionRecord() == null) {
            return versionName.getCombinedName().compareTo(versionName2.getCombinedName());
        }
        if (versionName.getVersionRecord() == null && versionName2.getVersionRecord() != null) {
            return -1;
        }
        if (versionName.getVersionRecord() != null && versionName2.getVersionRecord() == null) {
            return 1;
        }
        return versionName.getVersionRecord().compareTo(versionName2.getVersionRecord());
    }

    public void detectInstalledVersions() {
        File file;
        File[] fileArray;
        String string = this.pathMan.getPathString(11);
        if (string == null) {
            if (this.logger != null) {
                this.logger.warning("could not detect user application group directory. update check cancelled.");
            }
            return;
        }
        if (this.logger != null) {
            this.logger.config("user application group directory = " + string);
        }
        if ((fileArray = (file = new File(string)).listFiles()) == null) {
            if (this.logger != null) {
                this.logger.warning("could not get list of entries in user application group directory. update check cancelled.");
            }
            return;
        }
        File file2 = null;
        for (File file3 : fileArray) {
            File file4 = new File(file3, "cfg/cfg.cfg");
            if (file4 == null || !file4.exists()) continue;
            String string2 = file3.getName();
            this.versions.add(string2);
            VersionName versionName = VersionUtil.getVersionNameFromFileName(string2);
            this.versionNames.add(versionName);
            this.versionNamesToVersions.put(versionName, string2);
            if (this.logger != null) {
                this.logger.config("found cfg file at " + file4.toString() + " (as version " + string2 + ")");
            }
            if (file.getName().equals("1.2.0")) {
                if (this.logger != null) {
                    this.logger.config("this was the cfg file for the current version. (app version 1.2.0)");
                }
                this.curVer = string2;
            }
            this.cfgfiles.put(string2, file4);
        }
        Comparator<VersionName> comparator = new Comparator<VersionName>(){

            @Override
            public int compare(VersionName versionName, VersionName versionName2) {
                return UpdateManager.this.compareVersion(versionName, versionName2);
            }
        };
        if (file2 == null) {
            if (this.logger != null) {
                this.logger.config("a cfg file could not be found for the current version. creating an entry for it.");
            }
            file2 = new File(this.pathMan.getPathString(13), "cfg.cfg");
            this.versions.add("1.2.0");
            this.cfgfiles.put("1.2.0", file2);
            this.curVer = "1.2.0";
        }
        Collections.sort(this.versionNames, comparator);
        UpdateManager.sortListByListAndHash(this.versions, this.versionNames, this.versionNamesToVersions);
        this.curVerIdx = this.versions.indexOf(this.curVer);
    }

    protected static <T1, T2> void sortListByListAndHash(List<T1> list, List<T2> list2, Hashtable<T2, T1> hashtable) {
        ListIterator<T2> listIterator = list2.listIterator();
        while (listIterator.hasPrevious()) {
            T2 T2 = listIterator.previous();
            T1 T1 = hashtable.get(T2);
            list.remove(T1);
            list.add(0, T1);
        }
    }

    public void useClosestMatch() {
        if (this.logger != null) {
            this.logger.config("trying to automatically use version which matches best.");
        }
        this.mergeSrcVer = null;
        if (this.curVerIdx < 0) {
            return;
        }
        int n = this.curVerIdx - 1;
        if (n < 0) {
            return;
        }
        this.mergeSrcVer = this.versions.get(n);
        if (this.logger != null) {
            this.logger.config("best match is " + this.mergeSrcVer);
        }
    }

    public void selectMergeSource() {
        ChoosePreviousVersionDialog choosePreviousVersionDialog = new ChoosePreviousVersionDialog();
        choosePreviousVersionDialog.initGUI(this.curVer, this.versions);
        choosePreviousVersionDialog.setVisible(true);
        if (choosePreviousVersionDialog.getResultCode() != 1) {
            if (this.logger != null) {
                this.logger.config("choose previous version: user cancelled");
            }
            this.mergeSrcVer = null;
        } else {
            this.mergeSrcVer = choosePreviousVersionDialog.getSelectedVersion();
            if (this.logger != null) {
                this.logger.config("choose previous version: user chose " + this.mergeSrcVer);
            }
        }
    }

    public boolean shouldMerge() {
        return this.mergeSrcVer != null;
    }

    public void doMerge() {
        if (this.mergeSrcVer == null) {
            if (this.logger != null) {
                this.logger.warning("doMerge: no previous version selected. aborting update process.");
            }
            return;
        }
        this.cachePrevCfg = CfgCalc.createTmpCfg(this.cfgfiles.get(this.mergeSrcVer).toString());
        this.cachePrevCfg.loadPreferences("/de.admadic.calculator");
        this.doMerge_CfgFile();
        this.doMerge_Modules();
        this.doMerge_LaFs();
        this.doMerge_Skins();
    }

    protected void copyCfgElement(String string) {
        Object object = this.cachePrevCfg.getValue(string, null);
        if (object == null) {
            if (this.logger != null) {
                this.logger.config("skipping - key not in previous cfg: " + string);
            }
            return;
        }
        this.cfg.putValue(string, object);
        if (this.logger != null) {
            this.logger.config("copying key/value: " + string + "/" + object.toString());
        }
    }

    protected void doMerge_CfgFile() {
        if (this.logger != null) {
            this.logger.config("copying simple settings from cfg file.");
        }
        this.copyCfgElement("ui.laf.enable");
        this.copyCfgElement("ui.button.loadgfx");
        this.copyCfgElement("ui.button.customfont");
        this.copyCfgElement("ui.button.paintfocus");
        this.copyCfgElement("ui.main.alwaysontop");
        this.copyCfgElement("ui.main.protocolwindow.on");
        this.copyCfgElement("ui.main.mathwindow.on");
        this.copyCfgElement("ui.main.panelmove");
        this.copyCfgElement("ui.main.preloadui");
        this.copyCfgElement("ui.extendedsettings");
        this.copyCfgElement("ui.main.skinmenu.flat");
        this.copyCfgElement("ui.layout.ccl.fixedcellsize");
        this.copyCfgElement("ui.layout.ccl.style.button.standard.width");
        this.copyCfgElement("ui.layout.ccl.style.button.standard.height");
        this.copyCfgElement("ui.layout.ccl.style.button.small.width");
        this.copyCfgElement("ui.layout.ccl.style.button.small.height");
        this.copyCfgElement("ui.layout.ccl.mincell.width");
        this.copyCfgElement("ui.layout.ccl.mincell.height");
        this.copyCfgElement("main.classpath.useextender");
        this.copyCfgElement("ui.number.format");
        this.copyCfgElement("ui.main.gmx.snow");
    }

    protected void doMerge_Modules() {
        Object object;
        Object[] objectArray;
        if (this.logger != null) {
            this.logger.config("copying module settings from cfg file.");
        }
        if ((objectArray = this.cachePrevCfg.getValueArray("module.list.")) != null) {
            this.cfg.putValueArray("module.list.", objectArray);
            if (this.logger != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    object = objectArray[i];
                    this.logger.config("copying key/value: module.list." + i + "/" + object.toString());
                }
            }
        }
        Vector<Object> vector = new Vector<Object>();
        object = this.cachePrevCfg.getCfgItemKeys();
        while (object.hasMoreElements()) {
            String string = object.nextElement();
            if (!string.startsWith("module.inames.")) continue;
            vector.add(string);
            if (this.logger == null) continue;
            this.logger.config("module tag found for: " + (String)string);
        }
        for (String string : vector) {
            String string2 = string.substring("module.inames.".length());
            this.doMerge_Module(string2);
        }
        this.doMerge_ModuleFiles();
    }

    private void doMerge_Module(String string) {
        String string2 = "mod." + string + ".";
        Vector<Object> vector = new Vector<Object>();
        Enumeration<String> enumeration = this.cachePrevCfg.getCfgItemKeys();
        while (enumeration.hasMoreElements()) {
            String string3 = enumeration.nextElement();
            if (!string3.startsWith(string2)) continue;
            vector.add(string3);
        }
        for (String string4 : vector) {
            String string5 = string4.substring(string2.length());
            Object object = this.cachePrevCfg.getValue(string4, null);
            if (object == null) {
                if (this.logger == null) continue;
                this.logger.config("skipping - key not in previous cfg: " + string4);
                continue;
            }
            String string6 = string2 + "prev." + string5;
            this.cfg.putValue(string6, object);
            if (this.logger == null) continue;
            this.logger.config("copying key/value: " + string4 + "/" + object.toString());
        }
    }

    private void doMerge_ModuleFiles() {
        File[] fileArray;
        File[] fileArray2;
        if (this.logger != null) {
            this.logger.config("copying module files.");
        }
        String string = this.pathMan.getPathString(17);
        String string2 = this.pathMan.getPathString(2);
        if (this.logger != null) {
            this.logger.config("sys-mod-dir = " + string);
        }
        if (this.logger != null) {
            this.logger.config("sys-appgrp-dir = " + string2);
        }
        File file = new File(string);
        File file2 = new File(string2);
        file2 = new File(file2, this.mergeSrcVer);
        file2 = new File(file2, "mod");
        if (this.logger != null) {
            this.logger.config("trying prev-sys-mod-dir = " + file2.toString());
        }
        if (!file2.exists()) {
            if (this.logger != null) {
                this.logger.config("Could not find previous laf-directory. cancelling laf-file copy.");
            }
            return;
        }
        File[] fileArray3 = file.listFiles();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < fileArray3.length; ++i) {
            fileArray2 = fileArray3[i];
            vector.add(fileArray2.getName());
        }
        fileArray2 = fileArray = file2.listFiles();
        int n = fileArray2.length;
        for (int i = 0; i < n; ++i) {
            File file3;
            File file4 = file3 = fileArray2[i];
            File file5 = new File(file, file3.getName());
            if (file5.exists()) {
                if (this.logger == null) continue;
                this.logger.config("mod-file exists in current version. skipping: " + file4.toString());
                continue;
            }
            if (!file4.isFile() && this.logger != null) {
                this.logger.warning("src is not a file: src: " + file4.toString());
            }
            if (!file4.toString().toLowerCase().endsWith(".jar")) {
                if (this.logger != null) {
                    this.logger.warning("src is not a jar file: src: " + file4.toString());
                }
                JOptionPane.showMessageDialog(null, "Could not copy the file:\n" + file4 + "\nIt is not a jar-file - only jar files are supported for updating.\nPlease copy the file or directory by yourself.", "Could not copy file", 0);
                continue;
            }
            if (this.logger != null) {
                this.logger.config("copying: src->dst: " + file4.toString() + " -> " + file5.toString());
            }
            if (FileUtil.copyFile(file4.toString(), file5.toString())) continue;
            if (this.logger != null) {
                this.logger.warning("copy failed: src->dst: " + file4.toString() + " -> " + file5.toString());
            }
            JOptionPane.showMessageDialog(null, "Could not copy the file:\n" + file4 + "\nover\n" + file5 + "\nPlease copy the file by yourself.", "Could not copy file", 0);
        }
        JOptionPane.showMessageDialog(null, "Some Modules were copied from the previous version to this version.\nYou should restart the calculator after the update is finished.\nIf the Modules are not visible, please go to Settings and check,\nwhether they are enabled or not.", "Installed Modules", 1);
    }

    protected void doMerge_LaFs() {
        File[] fileArray;
        File[] fileArray2;
        Object object;
        Object object2;
        Object object32;
        if (this.logger != null) {
            this.logger.config("copying Look-and-Feel settings.");
        }
        Vector<File[]> vector = new Vector<File[]>();
        Object[] objectArray = this.cachePrevCfg.getValueArray("ui.laf.listavail.");
        Object[] objectArray2 = this.cfg.getValueArray("ui.laf.listavail.");
        Vector<String> vector2 = new Vector<String>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object32 : objectArray2) {
            object2 = (File[])object32;
            object = object2.split(":");
            vector2.add(object[2]);
            arrayList.add(object2);
        }
        for (Object object32 : objectArray) {
            object2 = (String)object32;
            object = object2.split(":");
            if (vector2.contains(object[2])) continue;
            vector.add((File[])object2);
        }
        if (vector.size() < 1) {
            if (this.logger != null) {
                this.logger.config("there are no Look-and-Feels to be copied.");
            }
            return;
        }
        for (String string2 : vector) {
            if (this.logger != null) {
                this.logger.config("will copy Look-and-Feel: " + string2);
            }
            arrayList.add(string2);
        }
        this.cfg.putValueArray("ui.laf.listavail.", arrayList.toArray());
        if (this.logger != null) {
            this.logger.config("copied the listed Look-and-Feel settings.");
        }
        String string = this.pathMan.getPathString(7);
        String string2 = this.pathMan.getPathString(2);
        if (this.logger != null) {
            this.logger.config("sys-laf-dir = " + (String)string);
        }
        if (this.logger != null) {
            this.logger.config("sys-appgrp-dir = " + string2);
        }
        File file = new File(string);
        object32 = new File(string2);
        object32 = new File((File)object32, this.mergeSrcVer);
        object32 = new File((File)object32, "laf");
        if (this.logger != null) {
            this.logger.config("trying prev-sys-laf-dir = " + ((File)object32).toString());
        }
        if (!((File)object32).exists()) {
            if (this.logger != null) {
                this.logger.config("Could not find previous laf-directory. cancelling laf-file copy.");
            }
            JOptionPane.showMessageDialog(null, "The path to the Look-and-Feel files of the previous calculator version could not be found.\nPlease copy the missing Look-and-Feel files by yourself.", "Could not find LaF-path of previous version", 0);
            return;
        }
        object2 = file.listFiles();
        object = new Vector();
        for (int fileArray3 = 0; fileArray3 < ((File[])object2).length; ++fileArray3) {
            fileArray2 = object2[fileArray3];
            ((Vector)object).add(fileArray2.getName());
        }
        fileArray2 = fileArray = ((File)object32).listFiles();
        int n = fileArray2.length;
        for (int i = 0; i < n; ++i) {
            File file2;
            File file3 = file2 = fileArray2[i];
            File file4 = new File(file, file2.getName());
            if (file4.exists()) {
                if (this.logger == null) continue;
                this.logger.config("laf-file exists in current version. skipping: " + file3.toString());
                continue;
            }
            if (!file3.isFile() && this.logger != null) {
                this.logger.warning("src is not a file: src: " + file3.toString());
            }
            if (!file3.toString().toLowerCase().endsWith(".jar")) {
                if (this.logger != null) {
                    this.logger.warning("src is not a jar file: src: " + file3.toString());
                }
                JOptionPane.showMessageDialog(null, "Could not copy the file:\n" + file3 + "\nIt is not a jar-file - only jar files are supported for updating.\nPlease copy the file or directory by yourself.", "Could not copy file", 0);
                continue;
            }
            if (this.logger != null) {
                this.logger.config("copying: src->dst: " + file3.toString() + " -> " + file4.toString());
            }
            if (FileUtil.copyFile(file3.toString(), file4.toString())) continue;
            if (this.logger != null) {
                this.logger.warning("copy failed: src->dst: " + file3.toString() + " -> " + file4.toString());
            }
            JOptionPane.showMessageDialog(null, "Could not copy the file:\n" + file3 + "\nover\n" + file4 + "\nPlease copy the file by yourself.", "Could not copy file", 0);
        }
        JOptionPane.showMessageDialog(null, "Some Look-and-Feels were copied from the previous version to this version.\nYou should restart the calculator after the update is finished.\nIf the Look-and-Feels are not visible, please go to Settings and check,\nwhether they are enabled or not.", "Installed Look-and-Feels", 1);
    }

    protected void doMerge_Skins() {
        File[] fileArray;
        File[] fileArray2;
        Object object;
        File[] fileArray3;
        Object object22;
        if (this.logger != null) {
            this.logger.config("copying themepacks/skins settings.");
        }
        Vector<File[]> vector = new Vector<File[]>();
        Object[] objectArray = this.cachePrevCfg.getValueArray("ui.laf.skin.listavail.SkinLF.");
        Object[] objectArray2 = this.cfg.getValueArray("ui.laf.skin.listavail.SkinLF.");
        Vector<String> vector2 = new Vector<String>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object22 : objectArray2) {
            fileArray3 = (File[])object22;
            if (this.logger != null) {
                this.logger.config("this has: " + (String)fileArray3);
            }
            object = fileArray3.split(":");
            vector2.add(object[1]);
            arrayList.add(fileArray3);
        }
        for (Object object22 : objectArray) {
            fileArray3 = (String)object22;
            if (this.logger != null) {
                this.logger.config("prev has: " + (String)fileArray3);
            }
            if (vector2.contains((object = fileArray3.split(":"))[1])) continue;
            vector.add(fileArray3);
        }
        if (vector.size() < 1) {
            if (this.logger != null) {
                this.logger.config("there are no themepack/skins files to be copied.");
            }
            return;
        }
        for (String string2 : vector) {
            if (this.logger != null) {
                this.logger.config("will copy themepack/skin: " + string2);
            }
            arrayList.add(string2);
        }
        this.cfg.putValueArray("ui.laf.skin.listavail.SkinLF.", arrayList.toArray());
        if (this.logger != null) {
            this.logger.config("copied the listed cfg entries.");
        }
        String string = this.pathMan.getPathString(3);
        String string2 = this.pathMan.getPathString(2);
        if (this.logger != null) {
            this.logger.config("sys-app-dir = " + (String)string);
        }
        if (this.logger != null) {
            this.logger.config("sys-appgrp-dir = " + string2);
        }
        File file = new File(string);
        file = new File(file, this.cfg.getStringValue("ui.laf.impl.skinlf.themepack.path", "."));
        object22 = new File(string2);
        object22 = new File((File)object22, this.mergeSrcVer);
        object22 = new File((File)object22, this.cachePrevCfg.getStringValue("ui.laf.impl.skinlf.themepack.path", "."));
        if (this.logger != null) {
            this.logger.config("trying prev-sys-laf-theme-dir = " + ((File)object22).toString());
        }
        if (!((File)object22).exists()) {
            if (this.logger != null) {
                this.logger.config("Could not find previous laf-theme-directory. cancelling themepack/skin-file copy.");
            }
            JOptionPane.showMessageDialog(null, "The path to the Themepack files of the previous calculator version could not be found.\nPlease copy the missing Themepack files by yourself.", "Could not find Themepack-path of previous version", 0);
            return;
        }
        fileArray3 = file.listFiles();
        object = new Vector();
        for (int fileArray4 = 0; fileArray4 < fileArray3.length; ++fileArray4) {
            fileArray2 = fileArray3[fileArray4];
            ((Vector)object).add(fileArray2.getName());
        }
        fileArray2 = fileArray = ((File)object22).listFiles();
        int n = fileArray2.length;
        for (int i = 0; i < n; ++i) {
            File file2;
            File file3 = file2 = fileArray2[i];
            File file4 = new File(file, file2.getName());
            if (file4.exists()) {
                if (this.logger == null) continue;
                this.logger.config("themepack/skin-file exists in current version. skipping: " + file3.toString());
                continue;
            }
            if (!file3.toString().toLowerCase().endsWith(".zip")) {
                if (this.logger != null) {
                    this.logger.config("not a zip file. skipping: " + file3.toString());
                }
                JOptionPane.showMessageDialog(null, "Could not copy the file:\n" + file3 + "\nIt is not a zip-file - only zip files are supported for updating.\nPlease copy the file or directory by yourself.", "Could not copy file", 0);
                continue;
            }
            if (this.logger != null) {
                this.logger.config("copying: src->dst: " + file3.toString() + " -> " + file4.toString());
            }
            if (FileUtil.copyFile(file3.toString(), file4.toString())) continue;
            if (this.logger != null) {
                this.logger.warning("copy failed: src->dst: " + file3.toString() + " -> " + file4.toString());
            }
            JOptionPane.showMessageDialog(null, "Could not copy the file:\n" + file3 + "\nover\n" + file4 + "\nPlease copy the file by yourself.", "Could not copy file", 0);
        }
        JOptionPane.showMessageDialog(null, "Some themepack files (skins) were copied from the previous version to this version.\nIf the themepacks are not visible, please go to Settings \nand check, whether they are enabled or not.", "Installed Themepacks", 1);
    }

    class ChoosePreviousVersionDialog
    extends Dialog
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        JTextArea textMsg;
        JList versionList;
        JScrollPane versionScroll;
        JPanel buttonPanel;
        JButton btnOk;
        JButton btnCancel;
        Vector<String> versionsV;
        static final String CMD_OK = "cmd.ok";
        static final String CMD_CANCEL = "cmd.cancel";
        int selectedIndex = -1;
        String selectedValue;
        String insVerStr;
        int insVerIdx;

        public String getSelectedVersion() {
            return this.selectedValue;
        }

        public void initGUI(String string, Vector<String> vector) {
            FormLayout formLayout = new FormLayout("12px, p, 12px", "12px, p, 5px, p, 5px, p, 12px");
            this.setLayout(formLayout);
            CellConstraints cellConstraints = new CellConstraints();
            this.insVerStr = string;
            this.insVerIdx = vector.indexOf(this.insVerStr);
            this.versionsV = new Vector();
            this.versionsV.addAll(vector);
            if (this.versionsV.contains(this.insVerStr)) {
                this.versionsV.remove(this.insVerStr);
            }
            this.setTitle("admaDIC Calculator - Update settings from");
            this.setModal(true);
            this.textMsg = new JTextArea();
            this.textMsg.setText("The software seems to be started for the first time.\n\nThe following versions could be detected\non the computer. You may select a version from which\nthe settings will be imported into this version,\nor press Cancel to skip this step.\n\nPlease select the version from which you want to \ncopy the settings.\n(The current version is " + this.insVerStr + ")");
            this.textMsg.setEditable(false);
            this.add((Component)this.textMsg, cellConstraints.xy(2, 2));
            this.versionList = new JList<String>(this.versionsV);
            this.versionList.getSelectionModel().setSelectionMode(0);
            this.versionScroll = new JScrollPane(this.versionList, 22, 32);
            this.add((Component)this.versionScroll, cellConstraints.xy(2, 4));
            int n = vector.indexOf(string);
            if (n >= 0) {
                this.versionList.setSelectedIndex(n);
            }
            this.btnOk = new JButton("OK");
            this.btnOk.addActionListener(this);
            this.btnOk.setActionCommand(CMD_OK);
            this.btnCancel = new JButton("Cancel");
            this.btnCancel.addActionListener(this);
            this.btnCancel.setActionCommand(CMD_CANCEL);
            this.buttonPanel = new JPanel();
            this.buttonPanel.add(this.btnOk);
            this.buttonPanel.add(this.btnCancel);
            this.add((Component)this.buttonPanel, cellConstraints.xy(2, 6));
            this.pack();
            this.setLocationRelativeTo(null);
        }

        protected boolean shouldWarnAboutVersion(int n) {
            if (this.insVerIdx < 0) {
                return false;
            }
            return n >= this.insVerIdx;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(CMD_OK)) {
                int n;
                this.selectedIndex = this.versionList.getSelectedIndex();
                this.selectedValue = (String)this.versionList.getSelectedValue();
                if (this.selectedIndex < 0) {
                    JOptionPane.showMessageDialog(null, "No version selected. Please select a version from which the configuration shall be copied.", "No version selected", 0);
                    return;
                }
                if (this.shouldWarnAboutVersion(this.selectedIndex) && (n = JOptionPane.showConfirmDialog(null, "The installed version is " + this.insVerStr + ".\nThe version to use the data from is " + this.selectedValue + ".\nIt looks like you want to take the settings from a higher version than the one currently running.\nAre you sure you want to take settings from " + this.selectedValue + "?", "Check version", 0)) != 0) {
                    return;
                }
                this.setWindowCloseCode(1);
                this.setResultCode(1);
                this.setVisible(false);
            } else if (string.equals(CMD_CANCEL)) {
                this.selectedIndex = -1;
                this.selectedValue = null;
                this.setWindowCloseCode(2);
                this.setResultCode(2);
                this.setVisible(false);
            }
        }
    }
}

