/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.ui;

import de.admadic.calculator.appctx.AppContext;
import de.admadic.calculator.appctx.AppEvent;
import de.admadic.calculator.appctx.AppEventListener;
import de.admadic.calculator.appctx.CancelPhaseException;
import de.admadic.calculator.appmod.IModule;
import de.admadic.calculator.appmod.ModuleSpec;
import de.admadic.calculator.processor.ProcessorEvent;
import de.admadic.calculator.processor.ProcessorEventListener;
import de.admadic.calculator.processor.ProcessorException;
import de.admadic.calculator.processor.ProcessorUIActionFactory;
import de.admadic.calculator.processor.SimpleProcessor;
import de.admadic.calculator.types.CaDouble;
import de.admadic.calculator.types.CaDoubleFormat;
import de.admadic.calculator.types.CaDoubleFormatter;
import de.admadic.calculator.types.CaNumberFormatterContext;
import de.admadic.calculator.ui.AttachedWindow;
import de.admadic.calculator.ui.AttachedWindowManager;
import de.admadic.calculator.ui.CalcButton;
import de.admadic.calculator.ui.CalcCompCellConstraints;
import de.admadic.calculator.ui.CalcCompLayout;
import de.admadic.calculator.ui.CalcCompStyles;
import de.admadic.calculator.ui.CalcDisplay;
import de.admadic.calculator.ui.CalcDisplayExt;
import de.admadic.calculator.ui.CalcLaFManager;
import de.admadic.calculator.ui.CalcPanel;
import de.admadic.calculator.ui.CalcProtocol;
import de.admadic.calculator.ui.CalcProtocolTabular;
import de.admadic.calculator.ui.CalcToggleButton;
import de.admadic.calculator.ui.CmdEntry;
import de.admadic.calculator.ui.CmdSetSimple;
import de.admadic.calculator.ui.CmdStyleGrp;
import de.admadic.calculator.ui.LaFTestDialog;
import de.admadic.calculator.ui.settings.SettingsDialog;
import de.admadic.cfg.Cfg;
import de.admadic.laf.LaFChangeEvent;
import de.admadic.laf.LaFChangeListener;
import de.admadic.laf.LaFManager;
import de.admadic.ui.gmx.SnowEngine;
import de.admadic.ui.util.AboutDialog;
import de.admadic.ui.util.StringPrinter;
import de.admadic.ui.util.SyncButtonGroup;
import de.admadic.util.PathManager;
import de.admadic.util.VersionRecord;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;

public class SimpleCalcV0
extends JFrame
implements ComponentListener,
ProcessorEventListener,
AppEventListener {
    static final boolean DBGforce = false;
    static boolean DBGtesting = false;
    static final boolean LOG = true;
    Logger logger = null;
    static final String UI_ABOUT_APP = "admaDIC Calculator\nVersion 1.2.0-r199";
    static final String UI_ABOUT_COPY = "Copyright (c) 2005-2022 - admaDIC\nGermany";
    static final String UI_ABOUT_INF = "For updates or more information \nplease visit http://www.admadic.de/";
    static final String UI_ABOUT_SOFTLIBS = "This product includes software developed by\nL2FProd.com (http://www.L2FProd.com/).\n\nThis product includes the software JGoodies Forms:\nCopyright (c) 2002-2004 JGoodies Karsten Lentzsch.\nAll rights reserved.";
    static final String UI_ABOUT_TITLE = "About admaDIC Calculator";
    private static final long serialVersionUID = 1L;
    Cfg cfg = null;
    LaFManager lafMan = null;
    PathManager pathMan = null;
    AppContext appContext = null;
    SimpleProcessor calcProc = null;
    CmdSetSimple commandSet = null;
    CalcCompStyles styles = null;
    ClipboardHandler clipboardHandler = null;
    AttachedWindowManager atwpl = null;
    File lastCurDir = null;
    JPopupMenu popupMenu;
    SyncButtonGroup btnGrpProtocolWindow;
    SyncButtonGroup btnGrpMathWindow;
    SyncButtonGroup btnGrpStackWindow;
    SyncButtonGroup btnGrpAlwaysOnTop;
    SyncButtonGroup btnGrpMotionLockProtTxt;
    SyncButtonGroup btnGrpMotionLockProtTab;
    SyncButtonGroup btnGrpTestDialog;
    ButtonGroup btnGrpAngularArgMode;
    CalcToggleButton btnAngArgModRad;
    CalcToggleButton btnAngArgModDeg;
    CalcToggleButton btnAngArgModGra;
    LaFTestDialog lafTestDialog;
    CalcPanel panelCalc;
    JTextField textDisplay;
    JTextPane textStatus;
    CalcDisplay display;
    CalcDisplayExt displayCombo;
    CalcPanel panelLog;
    CalcPanel panelLogButtons;
    CalcPanel panelLogProtocol;
    CalcPanel panelMath;
    CalcPanel panelStack;
    CalcProtocol protocol;
    CalcPanel panelLogTab;
    CalcPanel panelLogProtocolTab;
    CalcProtocolTabular protocolTabular;
    JList listStack;
    JMenu skinMenu;
    Hashtable<String, CalcButton> cmd2btn = null;
    CalcCompLayout panelCalcLayout;
    CalcCompLayout panelMathLayout;
    CalcCompLayout panelLogButtonsLayout;
    AttachedWindow windowLogTab;
    AttachedWindow windowLog;
    AttachedWindow windowMath;
    AttachedWindow windowStack;
    SnowEngine snowEngine;
    ActionListener commandActionListener = null;
    JFileChooser cached_FileChooser;
    SettingsDialog cached_SettingsDialog;
    CaNumberFormatterContext numberFormatterContext;
    String appTitle;
    boolean valueInTitle;
    boolean useTxtProtocol;
    boolean useTabProtocol;

    public SimpleCalcV0(AppContext appContext) {
        this.initLogging();
        this.appContext = appContext;
        this.cfg = appContext.getCfg();
        this.lafMan = appContext.getLafManager();
        this.pathMan = appContext.getPathManager();
        String string = System.getProperty("admadic.testing");
        if (string != null && string.toLowerCase().equals("yes")) {
            DBGtesting = true;
        }
        this.appContext.addAppListener(this);
    }

    public void initLogging() {
        this.logger = Logger.getLogger("de.admadic");
    }

    public void start() {
        this.doPhaseFindModules();
        this.doPhaseBuildCore();
        this.appContext.fireAppEventNoExc(1);
        this.doPhaseBuildGUI();
        this.appContext.fireAppEventNoExc(2);
        this.doPhasePlace();
        if (this.appContext.getSplashWindow() != null) {
            this.appContext.getSplashWindow().updateStatus("Done.", 100);
        }
        this.appContext.fireAppEventNoExc(3);
        this.doPhaseShow();
        this.appContext.fireAppEventNoExc(4);
        this.appContext.fireAppEventNoExc(5);
    }

    private void doPhaseFindModules() {
        Object object;
        Object[] objectArray = this.cfg.getValueArray("module.list.");
        for (int i = 0; i < objectArray.length; ++i) {
            String[] stringArray = ((String)objectArray[i]).split(":");
            boolean bl = Boolean.parseBoolean(stringArray[2]);
            object = new ModuleSpec(stringArray[0], stringArray[1], bl);
            this.appContext.getModuleManager().add((ModuleSpec)object);
        }
        Vector<ModuleSpec> vector = this.appContext.getModuleManager().validateVersionRequirements(VersionRecord.valueOf("1.2.0-r199"));
        if (vector != null) {
            object = null;
            for (ModuleSpec moduleSpec : vector) {
                String string = moduleSpec.getName() + " requires calculator version " + moduleSpec.getRequiredAppVersion().getMjMnMcRvVersionString();
                if (object == null) {
                    object = string;
                    continue;
                }
                object = (String)object + "\n" + string;
            }
            JOptionPane.showMessageDialog(this, "The following modules have been disabled, because they require a newer version of the Calculator:\n" + object, "Modules requiring newer version of Calculator", 0);
        }
        this.appContext.getModuleManager().collectDescriptions();
        this.appContext.getModuleManager().initializeModules(this.appContext);
        for (int i = 0; i < this.appContext.getModuleManager().getModuleCount(); ++i) {
            IModule iModule = this.appContext.getModuleManager().getModule(i);
            this.cfg.putBooleanValue("module.inames." + iModule.getModuleDesc().getCfgName(), true);
        }
    }

    @Override
    public void processPhase(AppEvent appEvent) throws CancelPhaseException {
    }

    private void initGUI() {
        try {
            this.commandActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SimpleCalcV0.this.processActionCommand(actionEvent.getActionCommand());
                }
            };
            this.numberFormatterContext = new CaNumberFormatterContext();
            String string = this.cfg.getStringValue("ui.number.format", "fixed,12,2");
            CaDoubleFormatter caDoubleFormatter = CaDoubleFormatter.valueOf(string);
            this.numberFormatterContext.put(CaDouble.class, caDoubleFormatter);
            this.setResizable(false);
            this.appTitle = "admaDIC Calculator";
            this.setValueInTitle(this.cfg.getBooleanValue("ui.main.valueintitle", true));
            this.setUseTxtProtocol(this.cfg.getBooleanValue("ui.main.showtextprot", false));
            this.setUseTabProtocol(this.cfg.getBooleanValue("ui.main.showtabprot", true));
            this.setDefaultCloseOperation(0);
            this.initGUICalcCompStyles();
            this.initGUIIcons();
            this.initGUIMenu();
            this.initGUIPanelCalc();
            this.initGUIPanelLog();
            this.initGUIPanelLogTab();
            this.initGUIPanelMath();
            this.initGUIPanelStack();
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    SimpleCalcV0.this.doPhaseExit();
                }
            });
            this.pack();
            this.setLocationRelativeTo(null);
            this.addComponentListener(this);
            if (this.windowLogTab != null) {
                this.updateCalcComp(this.protocolTabular.getMotionLockButton(), "atw.pin.prottab");
            }
            this.windowLog.setDefaultCloseOperation(0);
            this.windowLog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    super.windowClosing(windowEvent);
                    SimpleCalcV0.this.btnGrpProtocolWindow.setSelected(false);
                }
            });
            this.windowLogTab.setDefaultCloseOperation(0);
            this.windowLogTab.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    super.windowClosing(windowEvent);
                    SimpleCalcV0.this.btnGrpProtocolWindow.setSelected(false);
                }
            });
            this.windowMath.setDefaultCloseOperation(0);
            this.windowMath.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    super.windowClosing(windowEvent);
                    SimpleCalcV0.this.btnGrpMathWindow.setSelected(false);
                }
            });
            this.windowStack.setDefaultCloseOperation(0);
            this.windowStack.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    super.windowClosing(windowEvent);
                    SimpleCalcV0.this.btnGrpStackWindow.setSelected(false);
                }
            });
            boolean bl = this.cfg.getBooleanValue("ui.main.alwaysontop", false);
            this.btnGrpAlwaysOnTop.setSelected(bl);
            if (DBGtesting) {
                this.btnGrpTestDialog = new SyncButtonGroup();
                this.lafTestDialog = new LaFTestDialog(this);
                this.lafMan.addComponentToHead(this.lafTestDialog);
                this.btnGrpTestDialog.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        boolean bl;
                        boolean bl2 = bl = itemEvent.getStateChange() == 1;
                        if (DBGtesting) {
                            SimpleCalcV0.this.lafTestDialog.setVisible(bl);
                        }
                    }
                });
                this.lafTestDialog.setDefaultCloseOperation(0);
                this.lafTestDialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent windowEvent) {
                        super.windowClosing(windowEvent);
                        SimpleCalcV0.this.btnGrpTestDialog.setSelected(false);
                    }
                });
            }
            this.atwpl.setPlacerCfgPath("ui.main.atwm.placers");
            this.popupMenu.pack();
            if (this.lafMan != null) {
                this.lafMan.addComponent(this.windowLog);
                this.lafMan.addComponent(this.windowLogTab);
                this.lafMan.addComponent(this.windowMath);
                this.lafMan.addComponent(this.windowStack);
                this.lafMan.addComponent(this.popupMenu);
                this.lafMan.addComponent(this);
            }
            this.initKeyCommands();
            this.initGUIPreload();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doPhaseBuildCore() {
        this.configureLocaleManager();
        this.calcProc = new SimpleProcessor();
        this.calcProc.setLocaleProvider(this.appContext.getLocaleManager());
        String string = this.cfg.getStringValue("ui.number.format", "fixed,12,2");
        CaDoubleFormat caDoubleFormat = CaDoubleFormat.valueOf(string);
        this.calcProc.setNumberFormat(caDoubleFormat);
        this.calcProc.addProcessorListener(this);
        this.commandSet = new CmdSetSimple(this);
        this.styles = new CalcCompStyles();
        this.clipboardHandler = new ClipboardHandler();
        this.cmd2btn = new Hashtable();
        this.atwpl = new AttachedWindowManager(this, this.cfg);
    }

    protected void configureLocaleManager() {
        int n;
        int[] nArray = new int[]{0, 1, 2, 3};
        String[] stringArray = new String[]{"ui.main.locale.default", "ui.main.locale.input", "ui.main.locale.output", "ui.main.locale.export"};
        for (n = 0; n < nArray.length; ++n) {
            String string = this.cfg.getStringValue(stringArray[n], null);
            if (string == null) continue;
            String[] stringArray2 = string.split(":");
            String string2 = "";
            String string3 = "";
            if (stringArray2.length > 0) {
                string2 = stringArray2[0];
            }
            if (stringArray2.length > 1) {
                string3 = stringArray2[1];
            }
            this.appContext.getLocaleManager().setLocale(nArray[n], new Locale(string2, string3));
        }
        n = this.cfg.getBooleanValue("ui.main.locale.sameasdefault", true) ? 1 : 0;
        this.appContext.getLocaleManager().setSameAsDefault(n != 0);
        Locale locale = this.appContext.getLocaleManager().getDefaultLocale();
        if (locale != null) {
            if (this.logger != null) {
                this.logger.config("setting default locale " + locale.toString());
            }
            Locale.setDefault(locale);
        }
        this.appContext.getLocaleManager().notifyLocaleNumberFormatChanged();
    }

    public void doPhaseBuildGUI() {
        this.initGUI();
        this.calcProc.fireAll();
    }

    public void doPhasePlace() {
        Rectangle rectangle = this.cfg.getRectangleValue("ui.main.window.bounds", null);
        if (rectangle != null) {
            this.setLocation(rectangle.getLocation());
        } else {
            this.setLocationRelativeTo(null);
        }
        this.atwpl.loadSettings();
        boolean bl = this.atwpl.isMotionLock(this.windowLog);
        this.btnGrpMotionLockProtTxt.setSelected(bl);
        bl = this.atwpl.isMotionLock(this.windowLogTab);
        this.btnGrpMotionLockProtTab.setSelected(bl);
        this.atwpl.placeWindows(true);
    }

    public void doPhaseShow() {
        this.setVisible(true);
        this.atwpl.setEnableNotifications(true);
        boolean bl = this.cfg.getBooleanValue("ui.main.protocolwindow.on", false);
        this.btnGrpProtocolWindow.setSelected(bl);
        bl = this.cfg.getBooleanValue("ui.main.mathwindow.on", false);
        this.btnGrpMathWindow.setSelected(bl);
        if (this.cfg.getBooleanValue("ui.main.gmx.snow", true)) {
            this.installSnow(true);
        }
    }

    protected void installSnow(boolean bl) {
        if (bl) {
            try {
                if (this.lafMan.getSelectedLaFSkin().getDataName().toLowerCase().equals("xmasthemepack.zip")) {
                    this.snowEngine = SnowEngine.createInFirstScrollpane(this.protocol, 2);
                }
            }
            catch (NullPointerException nullPointerException) {}
        } else if (this.snowEngine != null) {
            SnowEngine.removeFromFirstScrollpane(this.protocol);
        }
    }

    void doPhaseExit() {
        try {
            this.appContext.fireAppEvent(6);
        }
        catch (CancelPhaseException cancelPhaseException) {
            return;
        }
        this.cfg.storeObjectsToPreferences();
        this.cfg.storePreferences("/de.admadic.calculator");
        this.appContext.fireAppEventNoExc(7);
        System.exit(0);
    }

    private void initGUIIcons() {
        URL uRL = this.getClass().getClassLoader().getResource("de/admadic/calculator/ui/res/icon.jpg");
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        this.setIconImage(image);
    }

    private void initGUIMenu() {
        String[][] stringArrayArray = new String[][]{{"Copy (Display)", "mnu.cpy.display", "ctrl", "C"}, {"Copy (Log)", "mnu.cpy.log", null, null}, {"<separator>", null, null, null}, {"Save Log As...", "mnu.sav.log", "ctrl", "S"}, {"<separator>", null, null, null}, {"Settings...", "mnu.settings", null, null}, {"About...", "mnu.about", null, null}, {"<separator>", null, null, null}, {"Skins", "mnu.skins", null, null}, {"Modules", "mnu.modules", null, null}, {"<separator>", null, null, null}, {"Exit", "mnu.exit", null, null}, {"View Stack", "mnu.viewstack", null, null}, {"Testdialog", "mnu.testdlg", null, null}};
        JPopupMenu jPopupMenu = this.popupMenu = new JPopupMenu();
        for (int i = 0; i < stringArrayArray.length; ++i) {
            String string = stringArrayArray[i][0];
            if (string.equals("<separator>")) {
                jPopupMenu.add(new JSeparator());
                continue;
            }
            if (string.equals("Testdialog") && !DBGtesting || string.equals("View Stack") && !DBGtesting) continue;
            String string2 = stringArrayArray[i][1];
            if (string2.equals("mnu.skins")) {
                if (this.lafMan == null) continue;
                this.skinMenu = new JMenu();
                jPopupMenu.add((Component)this.skinMenu);
                this.skinMenu.setText(string);
                boolean bl = this.cfg.getBooleanValue("ui.main.skinmenu.flat", true);
                this.lafMan.createLaFSkinMenu(this.skinMenu, !bl);
                this.lafMan.addLaFChangeListener(new LaFChangeListener(){

                    @Override
                    public void lafChanged(LaFChangeEvent laFChangeEvent) {
                        SimpleCalcV0.this.atwpl.setEnableNotifications(true);
                        SimpleCalcV0.this.atwpl.placeWindows(true);
                        String string = laFChangeEvent.getLafName();
                        String string2 = laFChangeEvent.getSkinName();
                        if (string2 == null) {
                            string2 = "";
                        }
                        SimpleCalcV0.this.cfg.putStringValue("ui.laf.select", string);
                        SimpleCalcV0.this.cfg.putStringValue("ui.laf.skin." + string, string2);
                    }

                    @Override
                    public void lafChangeBegin(LaFChangeEvent laFChangeEvent) {
                        SimpleCalcV0.this.atwpl.setEnableNotifications(false);
                        if (SimpleCalcV0.this.snowEngine != null) {
                            SimpleCalcV0.this.installSnow(false);
                        }
                    }

                    @Override
                    public void lafChangeFailed(LaFChangeEvent laFChangeEvent) {
                        SimpleCalcV0.this.atwpl.setEnableNotifications(true);
                        SimpleCalcV0.this.atwpl.placeWindows(true);
                    }

                    @Override
                    public void lafChangedUI(LaFChangeEvent laFChangeEvent) {
                        if (SimpleCalcV0.this.cfg.getBooleanValue("ui.main.gmx.snow", true)) {
                            SimpleCalcV0.this.installSnow(true);
                        }
                    }
                });
                continue;
            }
            if (string2.equals("mnu.modules")) {
                if (this.appContext.getModuleManager() == null) continue;
                JMenu jMenu = new JMenu();
                jPopupMenu.add((Component)jMenu);
                jMenu.setText(string);
                this.appContext.getModuleManager().createModulesMenu(jMenu);
                continue;
            }
            JMenuItem jMenuItem = new JMenuItem();
            jPopupMenu.add((Component)jMenuItem);
            jMenuItem.setText(string);
            jMenuItem.setActionCommand(string2);
            jMenuItem.addActionListener(this.commandActionListener);
            String string3 = stringArrayArray[i][2];
            String string4 = stringArrayArray[i][3];
            int n = 0;
            int n2 = 32;
            if (string4 != null && string3 != null) {
                if (string3.equals("ctrl")) {
                    n = 128;
                } else if (string3.equals("alt")) {
                    n = 512;
                } else if (string3.equals("shift")) {
                    n = 64;
                } else if (string3.equals("meta")) {
                    n = 256;
                } else {
                    string4 = null;
                }
                n2 = string4.charAt(0);
            }
            if (string4 == null || string3 == null) continue;
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n2, n));
        }
    }

    protected void initGUIPreload() {
        if (!this.cfg.getBooleanValue("ui.main.preloadui", false)) {
            return;
        }
        this.cached_FileChooser = new JFileChooser();
        if (this.lafMan != null) {
            this.lafMan.addComponentToHead(this.cached_FileChooser);
        }
        this.cached_SettingsDialog = new SettingsDialog(this.appContext, this);
        if (this.lafMan != null) {
            this.lafMan.addComponentToHead(this.cached_SettingsDialog);
        }
    }

    private void initGUICalcCompStyles() {
        this.styles.addStyle("button.standard", this.cfg.getIntValue("ui.layout.ccl.style.button.standard.width", 7), this.cfg.getIntValue("ui.layout.ccl.style.button.standard.height", 6), 1, 1);
        this.styles.addStyle("button.small", this.cfg.getIntValue("ui.layout.ccl.style.button.small.width", 7), this.cfg.getIntValue("ui.layout.ccl.style.button.small.height", 5), 1, 1);
    }

    private void updateCalcComp(JComponent jComponent, String string) {
        CmdEntry cmdEntry = this.commandSet.get(string);
        if (cmdEntry == null) {
            System.err.println("Error: could not retrieve CommandEntry for " + string);
            return;
        }
        CmdStyleGrp cmdStyleGrp = this.commandSet.getGroupOfCommand(cmdEntry.getCmd());
        if (cmdStyleGrp == null) {
            System.err.println("Error: could not retrieve CommandGroup for " + string);
        }
        if (jComponent instanceof CalcButton || jComponent instanceof CalcToggleButton) {
            AbstractButton abstractButton;
            if (jComponent instanceof CalcButton) {
                abstractButton = (CalcButton)jComponent;
                this.cmd2btn.put(cmdEntry.getCmd(), (CalcButton)abstractButton);
            }
            if (jComponent instanceof CalcToggleButton) {
                // empty if block
            }
            abstractButton = (AbstractButton)jComponent;
            if (!cmdEntry.getGroupName().equals("mod")) {
                if (cmdEntry.getToolTip() != null && !cmdEntry.getToolTip().equals("")) {
                    jComponent.setToolTipText(cmdEntry.getToolTip());
                }
                abstractButton.setText(cmdEntry.getDisplay());
                abstractButton.setActionCommand(cmdEntry.getCmd());
            }
            abstractButton.setMargin(new Insets(1, 1, 1, 1));
            abstractButton.setHorizontalTextPosition(0);
            abstractButton.setVerticalTextPosition(0);
            abstractButton.setFocusPainted(this.cfg.getBooleanValue("ui.button.paintfocus", false));
            if (jComponent instanceof CalcButton) {
                ((CalcButton)jComponent).setUseCustomFont(this.cfg.getBooleanValue("ui.button.customfont", false));
                ((CalcButton)jComponent).setUseCustomGfx(this.cfg.getBooleanValue("ui.button.loadgfx", false));
                ((CalcButton)jComponent).setCmdStyle(cmdEntry, cmdStyleGrp);
            } else if (jComponent instanceof CalcToggleButton) {
                ((CalcToggleButton)jComponent).setUseCustomFont(this.cfg.getBooleanValue("ui.button.customfont", false));
                ((CalcToggleButton)jComponent).setUseCustomGfx(this.cfg.getBooleanValue("ui.button.loadgfx", false));
                ((CalcToggleButton)jComponent).setCmdStyle(cmdEntry, cmdStyleGrp);
            }
            if (cmdEntry.getCmd().equals("aot.toggle")) {
                this.btnGrpAlwaysOnTop = new SyncButtonGroup();
                this.btnGrpAlwaysOnTop.add(abstractButton);
                this.btnGrpAlwaysOnTop.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        boolean bl = itemEvent.getStateChange() == 1;
                        SimpleCalcV0.this.setAlwaysOnTop(bl);
                        SimpleCalcV0.this.cfg.putBooleanValue("ui.main.alwaysontop", bl);
                    }
                });
            } else if (cmdEntry.getCmd().equals("log.toggle")) {
                this.btnGrpProtocolWindow = new SyncButtonGroup();
                this.btnGrpProtocolWindow.add(abstractButton);
                this.btnGrpProtocolWindow.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        boolean bl;
                        boolean bl2 = bl = itemEvent.getStateChange() == 1;
                        if (SimpleCalcV0.this.isUseTxtProtocol()) {
                            SimpleCalcV0.this.windowLog.setVisible(bl);
                        }
                        if (SimpleCalcV0.this.isUseTabProtocol()) {
                            SimpleCalcV0.this.windowLogTab.setVisible(bl);
                        }
                        SimpleCalcV0.this.cfg.putBooleanValue("ui.main.protocolwindow.on", bl);
                    }
                });
            } else if (cmdEntry.getCmd().equals("math.toggle")) {
                this.btnGrpMathWindow = new SyncButtonGroup();
                this.btnGrpMathWindow.add(abstractButton);
                this.btnGrpMathWindow.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        boolean bl = itemEvent.getStateChange() == 1;
                        SimpleCalcV0.this.windowMath.setVisible(bl);
                        SimpleCalcV0.this.cfg.putBooleanValue("ui.main.mathwindow.on", bl);
                    }
                });
            } else if (cmdEntry.getCmd().equals("stack.toggle")) {
                this.btnGrpStackWindow = new SyncButtonGroup();
                this.btnGrpStackWindow.add(abstractButton);
                this.btnGrpStackWindow.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        boolean bl = itemEvent.getStateChange() == 1;
                        SimpleCalcV0.this.windowStack.setVisible(bl);
                    }
                });
            } else if (cmdEntry.getCmd().equals("atw.pin.prottxt")) {
                this.btnGrpMotionLockProtTxt = new SyncButtonGroup();
                this.btnGrpMotionLockProtTxt.add(abstractButton);
                this.btnGrpMotionLockProtTxt.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        boolean bl = itemEvent.getStateChange() == 1;
                        SimpleCalcV0.this.atwpl.setMotionLock(SimpleCalcV0.this.windowLog, bl);
                    }
                });
            } else if (cmdEntry.getCmd().equals("atw.pin.prottab")) {
                this.btnGrpMotionLockProtTab = new SyncButtonGroup();
                this.btnGrpMotionLockProtTab.add(abstractButton);
                this.btnGrpMotionLockProtTab.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        boolean bl = itemEvent.getStateChange() == 1;
                        SimpleCalcV0.this.atwpl.setMotionLock(SimpleCalcV0.this.windowLogTab, bl);
                    }
                });
            } else {
                abstractButton.addActionListener(this.commandActionListener);
            }
        } else if (jComponent instanceof JTextField || jComponent instanceof JTextArea || jComponent instanceof JTextPane || jComponent instanceof JPanel) {
            // empty if block
        }
    }

    private void initGUICalcComponents() {
        int n;
        int n2;
        Object object;
        int n3 = 1;
        int n4 = 1;
        CalcCompStyles.Style style = this.styles.getStyle("button.small");
        CalcCompStyles.Style style2 = this.styles.getStyle("button.standard");
        this.displayCombo = new CalcDisplayExt();
        this.panelCalc.add((Component)this.displayCombo, new CalcCompCellConstraints("dsp.display").defineSpan(5, 5).defineStretch(true, false).defineMajorGrid(1, 1).definePan(1, 1).defineFit(2));
        this.setPopup(this.displayCombo);
        CalcCompCellConstraints calcCompCellConstraints = new CalcCompCellConstraints("sep1").defineLinkNorth("dsp.display", 0).definePan(n3, n4).defineMajorGrid(1, 1).defineStretch(true, false);
        JSeparator jSeparator = new JSeparator();
        this.panelCalc.add((Component)jSeparator, calcCompCellConstraints);
        CalcCompCellConstraints[] calcCompCellConstraintsArray = CalcCompCellConstraints.createGrid(5, 1, "m.+,m.-,m.s,m.r,m.c".split(","), null, 2, new CalcCompCellConstraints("<template>").defineLinkNorth("sep1", 0).defineMajorGrid(style.width, style.height).definePan(style.ipan, style.opan));
        this.styles.addCellsForStyle("button.small", calcCompCellConstraintsArray);
        for (int i = 0; i < calcCompCellConstraintsArray.length; ++i) {
            object = new CalcButton();
            this.panelCalc.add((Component)object, calcCompCellConstraintsArray[i]);
            this.updateCalcComp((JComponent)object, calcCompCellConstraintsArray[i].getName());
        }
        calcCompCellConstraints = new CalcCompCellConstraints("sep2").defineLinkNorth("m.c", 0).definePan(n3, n4).defineMajorGrid(1, 1).defineStretch(true, false);
        JSeparator jSeparator2 = new JSeparator();
        this.panelCalc.add((Component)jSeparator2, calcCompCellConstraints);
        calcCompCellConstraintsArray = CalcCompCellConstraints.createGrid(3, 4, "7,8,9,4,5,6,1,2,3,0,.,+/-".split(","), null, 2, new CalcCompCellConstraints("<template>").defineMajorGrid(style2.width, style2.height).defineLinkNorth("sep2", 0).definePan(style2.ipan, style2.opan));
        this.styles.addCellsForStyle("button.standard", calcCompCellConstraintsArray);
        for (n2 = 0; n2 < calcCompCellConstraintsArray.length; ++n2) {
            object = new CalcButton();
            this.panelCalc.add((Component)object, calcCompCellConstraintsArray[n2]);
            this.updateCalcComp((JComponent)object, calcCompCellConstraintsArray[n2].getName());
        }
        calcCompCellConstraintsArray = CalcCompCellConstraints.createGrid(1, 4, "*,/,+,-".split(","), null, 2, new CalcCompCellConstraints("<template>").defineMajorGrid(style2.width, style2.height).defineLinkNorth("sep2", 0).defineLinkWest("9", 0).definePan(style2.ipan, style2.opan));
        for (n2 = 0; n2 < calcCompCellConstraintsArray.length; ++n2) {
            object = new CalcButton();
            this.panelCalc.add((Component)object, calcCompCellConstraintsArray[n2]);
            this.updateCalcComp((JComponent)object, calcCompCellConstraintsArray[n2].getName());
        }
        calcCompCellConstraintsArray = CalcCompCellConstraints.createGrid(1, 4, "c.a,c.e,=,dummy1".split(","), null, 1, new CalcCompCellConstraints("<template>").defineMajorGrid(style2.width, style2.height).defineLinkNorth("sep2", 0).defineLinkWest("*", 0).definePan(n3, n4));
        calcCompCellConstraintsArray = CalcCompCellConstraints.mergeCells(calcCompCellConstraintsArray, new String[]{"=", "dummy1"});
        this.styles.addCellsForStyle("button.standard", calcCompCellConstraintsArray);
        for (n2 = 0; n2 < calcCompCellConstraintsArray.length; ++n2) {
            object = new CalcButton();
            this.panelCalc.add((Component)object, calcCompCellConstraintsArray[n2]);
            this.updateCalcComp((JComponent)object, calcCompCellConstraintsArray[n2].getName());
        }
        calcCompCellConstraintsArray = CalcCompCellConstraints.createGrid(2, 1, "percent,percent.ex".split(","), null, 1, new CalcCompCellConstraints("<template>").defineMajorGrid(style2.width, style2.height).defineLinkNorth("0", 0).definePan(n3, n4));
        this.styles.addCellsForStyle("button.small", calcCompCellConstraintsArray);
        for (n2 = 0; n2 < calcCompCellConstraintsArray.length; ++n2) {
            object = new CalcButton();
            this.panelCalc.add((Component)object, calcCompCellConstraintsArray[n2]);
            this.updateCalcComp((JComponent)object, calcCompCellConstraintsArray[n2].getName());
        }
        calcCompCellConstraints = new CalcCompCellConstraints("sep3").defineLinkNorth("percent", 0).definePan(n3, n4).defineMajorGrid(1, 1).defineStretch(true, false);
        JSeparator jSeparator3 = new JSeparator();
        this.panelCalc.add((Component)jSeparator3, calcCompCellConstraints);
        calcCompCellConstraintsArray = CalcCompCellConstraints.createGrid(5, 1, "log.toggle,math.toggle,atw.snap,aot.toggle,mnu.show".split(","), null, 1, new CalcCompCellConstraints("<template>").defineMajorGrid(style.width, style.height).defineLinkNorth("sep3", 0).definePan(n3, n4));
        this.styles.addCellsForStyle("button.small", calcCompCellConstraintsArray);
        for (n = 0; n < calcCompCellConstraintsArray.length; ++n) {
            object = calcCompCellConstraintsArray[n].getName().equals("atw.snap") || calcCompCellConstraintsArray[n].getName().equals("mnu.show") ? new CalcButton() : new CalcToggleButton();
            this.panelCalc.add((Component)object, calcCompCellConstraintsArray[n]);
            this.updateCalcComp((JComponent)object, calcCompCellConstraintsArray[n].getName());
        }
        n = this.appContext.getModuleManager().getModuleCount();
        if (n > 0) {
            Action[] actionArray;
            int n5;
            object = new int[n];
            int n6 = 0;
            Object object2 = null;
            for (n5 = 0; n5 < n; ++n5) {
                actionArray = this.appContext.getModuleManager().getModule(n5).getActions();
                if (actionArray == null || actionArray.length < 1) continue;
                object[n6++] = n5;
                object2 = object2 == null ? "mod." + n5 : (String)object2 + ",mod." + n5;
            }
            if (n6 > 0) {
                calcCompCellConstraintsArray = CalcCompCellConstraints.createGrid(n6, 1, ((String)object2).split(","), null, 1, new CalcCompCellConstraints("<template>").defineMajorGrid(style.width, style.height).defineLinkNorth("log.toggle", 0).definePan(n3, n4));
                this.styles.addCellsForStyle("button.small", calcCompCellConstraintsArray);
                for (n5 = 0; n5 < calcCompCellConstraintsArray.length; ++n5) {
                    CalcButton calcButton = new CalcButton();
                    actionArray = this.appContext.getModuleManager().getModule((int)object[n5]).getActions();
                    calcButton.setAction(actionArray[0]);
                    this.panelCalc.add((Component)calcButton, calcCompCellConstraintsArray[n5]);
                    this.updateCalcComp(calcButton, calcCompCellConstraintsArray[n5].getName());
                }
            }
        }
    }

    void updateUISettings() {
        Object object;
        if (this.cfg.getBooleanValue("ui.main.gmx.snow", true)) {
            this.installSnow(true);
        } else {
            this.installSnow(false);
        }
        String string = this.cfg.getStringValue("ui.number.format", "fixed,12,2");
        CaDoubleFormat caDoubleFormat = CaDoubleFormat.valueOf(string);
        this.calcProc.setNumberFormat(caDoubleFormat);
        this.setValueInTitle(this.cfg.getBooleanValue("ui.main.valueintitle", true));
        this.setUseTxtProtocol(this.cfg.getBooleanValue("ui.main.showtextprot", false));
        this.setUseTabProtocol(this.cfg.getBooleanValue("ui.main.showtabprot", true));
        if (this.numberFormatterContext != null) {
            object = (CaDoubleFormatter)this.numberFormatterContext.get(CaDouble.class);
            CaDoubleFormatter.valueOf(string, (CaDoubleFormatter)object);
        }
        if (this.protocolTabular != null) {
            this.protocolTabular.refreshDisplay();
        }
        this.configureLocaleManager();
        object = new Dimension();
        ((Dimension)object).width = this.cfg.getIntValue("ui.layout.ccl.mincell.width", 4);
        ((Dimension)object).height = this.cfg.getIntValue("ui.layout.ccl.mincell.height", 4);
        boolean bl = this.cfg.getBooleanValue("ui.layout.ccl.fixedcellsize", true);
        if (this.panelCalcLayout != null) {
            this.panelCalcLayout.setMinCellSize(new Dimension((Dimension)object));
            this.panelCalcLayout.setFixedCellSize(bl);
        }
        if (this.panelMathLayout != null) {
            this.panelMathLayout.setMinCellSize(new Dimension((Dimension)object));
            this.panelMathLayout.setFixedCellSize(bl);
        }
        if (this.panelLogButtonsLayout != null) {
            this.panelLogButtonsLayout.setMinCellSize(new Dimension((Dimension)object));
            this.panelLogButtonsLayout.setFixedCellSize(bl);
        }
        CalcCompStyles.Style style = this.styles.getStyle("button.standard");
        style.width = this.cfg.getIntValue("ui.layout.ccl.style.button.standard.width", 7);
        style.height = this.cfg.getIntValue("ui.layout.ccl.style.button.standard.height", 7);
        style = this.styles.getStyle("button.small");
        style.width = this.cfg.getIntValue("ui.layout.ccl.style.button.small.width", 7);
        style.height = this.cfg.getIntValue("ui.layout.ccl.style.button.small.height", 5);
        this.styles.updateCellsForAllStyles();
        CalcLaFManager.updateLaFManager();
        this.skinMenu.removeAll();
        this.lafMan.createLaFSkinMenu(this.skinMenu, !this.cfg.getBooleanValue("ui.main.skinmenu.flat", true));
        this.protocol.setColumns(this.calcProc.getProtocolWidth());
        if (this.panelCalcLayout != null) {
            this.panelCalcLayout.invalidateLayout(this.panelCalc);
        }
        if (this.panelMathLayout != null) {
            this.panelMathLayout.invalidateLayout(this.panelMath);
        }
        this.invalidate();
        this.panelCalc.invalidate();
        this.panelMath.invalidate();
        this.pack();
    }

    private void initGUIPanelCalc() {
        BorderLayout borderLayout = new BorderLayout();
        this.getContentPane().setLayout(borderLayout);
        this.panelCalc = new CalcPanel();
        this.setPopup(this.panelCalc);
        this.getContentPane().add((Component)this.panelCalc, "Center");
        this.panelCalcLayout = new CalcCompLayout();
        this.panelCalcLayout.setShrinkWrap(true);
        this.panelCalcLayout.setShrinkPan(2);
        this.panelCalcLayout.setAlignmentY(0.0f);
        this.panelCalcLayout.setMinCellSize(new Dimension(this.cfg.getIntValue("ui.layout.ccl.mincell.width", 4), this.cfg.getIntValue("ui.layout.ccl.mincell.height", 4)));
        if (this.cfg.getBooleanValue("ui.layout.ccl.fixedcellsize", true)) {
            this.panelCalcLayout.setFixedCellSize(true);
            this.panelCalcLayout.setForceFixedCellSize(true);
        }
        this.panelCalc.setLayout(this.panelCalcLayout);
        if (this.cfg.getBooleanValue("ui.main.panelmove", false)) {
            this.panelCalc.linkSurfaceDragging(this);
        }
        this.initGUICalcComponents();
    }

    private void initGUIPanelLogWindow() {
        this.panelLogButtons = new CalcPanel();
        this.panelLog.add((Component)this.panelLogButtons, "North");
        this.panelLogProtocol = new CalcPanel();
        this.panelLog.add((Component)this.panelLogProtocol, "Center");
        this.panelLogButtonsLayout = new CalcCompLayout();
        this.panelLogButtons.setLayout(this.panelLogButtonsLayout);
        this.panelLogButtonsLayout.setShrinkWrap(true);
        this.panelLogButtonsLayout.setShrinkPan(2);
        this.panelLogButtonsLayout.setAlignmentY(0.0f);
        this.panelLogButtonsLayout.setMinCellSize(new Dimension(this.cfg.getIntValue("ui.layout.ccl.mincell.width", 4), this.cfg.getIntValue("ui.layout.ccl.mincell.height", 4)));
        if (this.cfg.getBooleanValue("ui.layout.ccl.fixedcellsize", true)) {
            this.panelLogButtonsLayout.setFixedCellSize(true);
            this.panelLogButtonsLayout.setForceFixedCellSize(true);
        }
        this.panelLogProtocol.setLayout(new BorderLayout());
        CalcCompStyles.Style style = this.styles.getStyle("button.small");
        CalcCompCellConstraints[] calcCompCellConstraintsArray = CalcCompCellConstraints.createGrid(5, 1, "l.c,l.cl,l.p,l.s,atw.pin.prottxt".split(","), null, 2, new CalcCompCellConstraints("<template>").defineMajorGrid(style.width, style.height).definePan(style.ipan, style.opan));
        this.styles.addCellsForStyle("button.small", calcCompCellConstraintsArray);
        for (int i = 0; i < calcCompCellConstraintsArray.length; ++i) {
            AbstractButton abstractButton = calcCompCellConstraintsArray[i].getName().equals("atw.pin.prottxt") ? new CalcToggleButton() : new CalcButton();
            this.panelLogButtons.add((Component)abstractButton, calcCompCellConstraintsArray[i]);
            this.updateCalcComp(abstractButton, calcCompCellConstraintsArray[i].getName());
        }
        this.protocol = new CalcProtocol(this.numberFormatterContext);
        this.panelLogProtocol.add((Component)this.protocol, "Center");
        this.protocol.setColumns(this.calcProc.getProtocolWidth());
        this.calcProc.addProtocolListener(this.protocol);
    }

    private void initGUIPanelLog() {
        this.panelLog = new CalcPanel();
        this.setPopup(this.panelLog);
        this.windowLog = new AttachedWindow(this);
        this.windowLog.setName("protocol");
        this.windowLog.setTitle("Protocol");
        BorderLayout borderLayout = new BorderLayout();
        this.panelLog.setLayout(borderLayout);
        this.initGUIPanelLogWindow();
        this.windowLog.placePanel(this.panelLog);
        this.windowLog.pack();
        this.windowLog.setResizable(true);
        this.atwpl.addEast(this.windowLog);
        this.atwpl.enableMethod(this.windowLog, 32, true);
    }

    private void initGUIPanelLogWindowTab() {
        this.panelLogProtocolTab = new CalcPanel();
        this.panelLogTab.add((Component)this.panelLogProtocolTab, "Center");
        this.panelLogProtocolTab.setLayout(new BorderLayout());
        this.protocolTabular = new CalcProtocolTabular(this.numberFormatterContext);
        this.panelLogProtocolTab.add((Component)this.protocolTabular, "Center");
        this.calcProc.addProtocolListener(this.protocolTabular);
        this.protocolTabular.setProcessorCalculation(this.calcProc);
    }

    private void initGUIPanelLogTab() {
        this.panelLogTab = new CalcPanel();
        this.setPopup(this.panelLogTab);
        this.windowLogTab = new AttachedWindow(this);
        this.windowLogTab.setName("protocoltab");
        this.windowLogTab.setTitle("Tabular Protocol");
        BorderLayout borderLayout = new BorderLayout();
        this.panelLogTab.setLayout(borderLayout);
        this.initGUIPanelLogWindowTab();
        this.windowLogTab.placePanel(this.panelLogTab);
        this.windowLogTab.pack();
        this.windowLogTab.setResizable(true);
        this.atwpl.addEast(this.windowLogTab);
        this.atwpl.enableMethod(this.windowLogTab, 32, true);
    }

    private void initGUIPanelMathWindow() {
        AbstractButton abstractButton;
        int n = 1;
        int n2 = 1;
        CalcCompStyles.Style style = this.styles.getStyle("button.small");
        CalcCompCellConstraints[] calcCompCellConstraintsArray = CalcCompCellConstraints.createGrid(3, 1, "am.rad,am.deg,am.gra".split(","), null, 2, new CalcCompCellConstraints("<template>").defineMajorGrid(style.width, 4).definePan(style.ipan, style.opan));
        this.styles.addCellsForStyle("button.small", calcCompCellConstraintsArray);
        for (int i = 0; i < calcCompCellConstraintsArray.length; ++i) {
            abstractButton = new CalcToggleButton();
            this.btnGrpAngularArgMode.add(abstractButton);
            this.panelMath.add((Component)abstractButton, calcCompCellConstraintsArray[i]);
            this.updateCalcComp(abstractButton, calcCompCellConstraintsArray[i].getName());
            if (i == 0) {
                this.btnAngArgModRad = abstractButton;
            }
            if (i == 1) {
                this.btnAngArgModDeg = abstractButton;
            }
            if (i != 2) continue;
            this.btnAngArgModGra = abstractButton;
        }
        this.btnAngArgModRad.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    SimpleCalcV0.this.calcProc.setAngularArgMode(0);
                }
            }
        });
        this.btnAngArgModDeg.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    SimpleCalcV0.this.calcProc.setAngularArgMode(1);
                }
            }
        });
        this.btnAngArgModGra.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    SimpleCalcV0.this.calcProc.setAngularArgMode(2);
                }
            }
        });
        CalcCompCellConstraints calcCompCellConstraints = new CalcCompCellConstraints("sep1").defineLinkNorth("am.rad", 1).definePan(n, n2).defineMajorGrid(1, 1).defineStretch(true, false);
        JSeparator jSeparator = new JSeparator();
        this.panelMath.add((Component)jSeparator, calcCompCellConstraints);
        calcCompCellConstraintsArray = CalcCompCellConstraints.createGrid(5, 6, "xinv,sqr,sqrt,pow,xrt,e,exp,exp10,ln,log,pi,sin,cos,tan,cot,sec,arcsin,arccos,arctan,arccot,cosec,sinh,cosh,tanh,coth,gamma,arsinh,arcosh,artanh,arcoth".split(","), null, 2, new CalcCompCellConstraints("<template>").defineLinkNorth("sep1", 1).defineMajorGrid(style.width, style.height).definePan(style.ipan, style.opan));
        this.styles.addCellsForStyle("button.small", calcCompCellConstraintsArray);
        for (int i = 0; i < calcCompCellConstraintsArray.length; ++i) {
            abstractButton = new CalcButton();
            this.panelMath.add((Component)abstractButton, calcCompCellConstraintsArray[i]);
            this.updateCalcComp(abstractButton, calcCompCellConstraintsArray[i].getName());
        }
    }

    private void initGUIPanelMath() {
        this.panelMath = new CalcPanel();
        this.setPopup(this.panelMath);
        this.windowMath = new AttachedWindow(this);
        this.windowMath.setName("math");
        this.windowMath.setTitle("Mathematics");
        this.panelMathLayout = new CalcCompLayout();
        this.panelMathLayout.setShrinkWrap(true);
        this.panelMathLayout.setShrinkPan(2);
        this.panelMathLayout.setAlignmentY(0.0f);
        this.panelMathLayout.setMinCellSize(new Dimension(this.cfg.getIntValue("ui.layout.ccl.mincell.width", 4), this.cfg.getIntValue("ui.layout.ccl.mincell.height", 4)));
        if (this.cfg.getBooleanValue("ui.layout.ccl.fixedcellsize", true)) {
            this.panelMathLayout.setFixedCellSize(true);
            this.panelMathLayout.setForceFixedCellSize(true);
        }
        this.panelMath.setLayout(this.panelMathLayout);
        this.btnGrpAngularArgMode = new ButtonGroup();
        this.initGUIPanelMathWindow();
        this.windowMath.placePanel(this.panelMath, 0, 0, 5, 0);
        this.windowMath.pack();
        this.windowMath.setResizable(false);
        this.atwpl.addSouth(this.windowMath);
        this.atwpl.enableMethod(this.windowMath, 16, true);
    }

    private void initGUIPanelStack() {
        this.btnGrpStackWindow = new SyncButtonGroup();
        this.btnGrpStackWindow.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = itemEvent.getStateChange() == 1;
                SimpleCalcV0.this.windowStack.setVisible(bl);
            }
        });
        this.panelStack = new CalcPanel();
        this.setPopup(this.panelStack);
        this.windowStack = new AttachedWindow(this);
        this.windowStack.setName("stack");
        this.windowStack.setTitle("Stack");
        this.panelStack.setLayout(new BorderLayout());
        this.listStack = new JList();
        JScrollPane jScrollPane = new JScrollPane(this.listStack);
        this.panelStack.add((Component)jScrollPane, "Center");
        jScrollPane.setVerticalScrollBarPolicy(22);
        this.windowStack.placePanel(this.panelStack, 0, 0, 5, 0);
        this.windowStack.pack();
        this.windowStack.setResizable(true);
        this.atwpl.addWest(this.windowStack);
        this.atwpl.enableMethod(this.windowStack, 32, true);
    }

    File getSaveFileNameJFC() {
        File file = null;
        JFileChooser jFileChooser = this.cached_FileChooser != null ? this.cached_FileChooser : new JFileChooser();
        class TextFilter
        extends FileFilter {
            TextFilter() {
            }

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = null;
                String string2 = file.getName();
                int n = string2.lastIndexOf(46);
                if (n > 0 && n < string2.length() - 1) {
                    string = string2.substring(n + 1).toLowerCase();
                }
                if (string != null) {
                    boolean bl = string.equals("txt");
                    return bl;
                }
                return false;
            }

            @Override
            public String getDescription() {
                return "Text Files (*.txt)";
            }
        }
        jFileChooser.addChoosableFileFilter(new TextFilter());
        jFileChooser.setFileHidingEnabled(false);
        String string = this.cfg.getStringValue("ui.main.workingdir", null);
        if (string != null && !string.equals("")) {
            this.lastCurDir = new File(string);
        }
        if (this.lastCurDir != null) {
            jFileChooser.setCurrentDirectory(this.lastCurDir);
        }
        int n = jFileChooser.showSaveDialog(this);
        this.lastCurDir = jFileChooser.getCurrentDirectory();
        String string2 = this.lastCurDir.getPath();
        this.cfg.putStringValue("ui.main.workingdir", string2);
        switch (n) {
            case 0: {
                file = jFileChooser.getSelectedFile();
                if (file.exists()) {
                    int n2 = JOptionPane.showConfirmDialog(this, "The file " + file.toString() + " already exist.\nOverwrite?");
                    if (n2 == 0) {
                        return file;
                    }
                    return null;
                }
                return file;
            }
            case 1: {
                break;
            }
        }
        return null;
    }

    void saveLogToFile() {
        if (this.isUseTabProtocol() && this.protocolTabular != null) {
            this.protocolTabular.saveProtocolTxt();
            return;
        }
        if (this.isUseTxtProtocol() && this.protocol != null) {
            File file = this.getSaveFileNameJFC();
            if (file == null) {
                return;
            }
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                bufferedWriter.write(this.calcProc.getLogDisplay());
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, iOException, "Error saving file", 0);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Cannot copy data - no protocol is active.", "No protocol active", 0);
        }
    }

    void printLog() {
        if (this.isUseTabProtocol() && this.protocolTabular != null) {
            this.protocolTabular.printData();
            return;
        }
        if (this.isUseTxtProtocol() && this.protocol != null) {
            StringPrinter stringPrinter = new StringPrinter(this, this.calcProc.getLogDisplay());
            stringPrinter.doPrint(false);
        } else {
            JOptionPane.showMessageDialog(this, "Cannot print data - no protocol is active.", "No protocol active", 0);
        }
    }

    private void setComponentPopupMenu(final Component component, final JPopupMenu jPopupMenu) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    jPopupMenu.show(component, mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    jPopupMenu.show(component, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    private void setPopup(Component component) {
        this.setComponentPopupMenu(component, this.popupMenu);
    }

    void processKeyCommand(String string) {
        CalcButton calcButton = this.cmd2btn.get(string);
        if (calcButton != null) {
            calcButton.doClick();
        } else {
            this.processCommand(string);
        }
    }

    private void processCommand(String string) {
        if (string.equals("log.toggle")) {
            return;
        }
        if (string.equals("math.toggle")) {
            return;
        }
        if (string.equals("aot.toggle")) {
            boolean bl = this.isAlwaysOnTop();
            boolean bl2 = bl = !bl;
            if (bl) {
                // empty if block
            }
            this.setAlwaysOnTop(bl);
            this.cfg.putBooleanValue("ui.main.alwaysontop", bl);
            return;
        }
        try {
            this.calcProc.processCommand(string);
        }
        catch (ProcessorException processorException) {
            if (this.logger != null) {
                this.logger.warning("Processor exception: " + processorException.getMessage());
            }
            JOptionPane.showMessageDialog(this, "An error occured in the calculation core:\n" + processorException.getMessage() + "\nPlease contact customer support.", "Calculator error", 0);
        }
    }

    void processActionCommand(String string) {
        if (string.equals("l.s")) {
            this.saveLogToFile();
            return;
        }
        if (string.equals("l.p")) {
            this.printLog();
            return;
        }
        if (string.equals("off")) {
            this.doPhaseExit();
            return;
        }
        if (string.equals("atw.snap")) {
            this.atwpl.snapAll();
            return;
        }
        if (string.equals("mnu.show")) {
            Point point = this.getMousePosition(true);
            if (point == null) {
                point = this.getLocation();
                point.x += this.getWidth() / 2;
                point.y += this.getHeight() / 2;
            }
            this.popupMenu.show(this, (int)point.getX(), (int)point.getY());
            return;
        }
        if (string.equals("mnu.exit")) {
            this.doPhaseExit();
            return;
        }
        if (string.equals("mnu.sav.log")) {
            this.saveLogToFile();
            return;
        }
        if (string.equals("mnu.about")) {
            AboutDialog aboutDialog = new AboutDialog(this);
            aboutDialog.setAboutInfo(UI_ABOUT_APP, UI_ABOUT_COPY, UI_ABOUT_INF, UI_ABOUT_SOFTLIBS);
            aboutDialog.setTitle(UI_ABOUT_TITLE);
            aboutDialog.setLogo("logo48x48.png");
            aboutDialog.setVisible(true);
            return;
        }
        if (string.equals("mnu.settings")) {
            SettingsDialog settingsDialog;
            if (this.cached_SettingsDialog != null) {
                settingsDialog = this.cached_SettingsDialog;
                settingsDialog.resetSettings();
            } else {
                settingsDialog = new SettingsDialog(this.appContext, this);
            }
            settingsDialog.loadSettings();
            settingsDialog.pack();
            settingsDialog.setVisible(true);
            if (settingsDialog.getResultCode() == 1) {
                this.updateUISettings();
            }
            return;
        }
        if (string.equals("mnu.cpy.display")) {
            this.setClipboardContents(this.calcProc.getAccDisplay());
            return;
        }
        if (string.equals("mnu.cpy.log")) {
            if (this.isUseTabProtocol() && this.protocolTabular != null) {
                this.protocolTabular.copyData();
            } else if (this.isUseTxtProtocol() && this.protocol != null) {
                this.setClipboardContents(this.calcProc.getLogDisplay());
            }
            return;
        }
        if (DBGtesting) {
            if (string.equals("mnu.testdlg")) {
                this.btnGrpTestDialog.setSelected(true);
                return;
            }
            if (string.equals("mnu.viewstack")) {
                this.btnGrpStackWindow.setSelected(!this.btnGrpStackWindow.isSelected());
                return;
            }
        }
        this.processCommand(string);
    }

    void initKeyCommands() {
        ProcessorUIActionFactory.fillMaps(this.calcProc, this.getRootPane());
        ProcessorUIActionFactory.fillMaps(this.calcProc, this.windowLog.getRootPane());
        ProcessorUIActionFactory.fillMaps(this.calcProc, this.windowMath.getRootPane());
    }

    void setClipboardContents(String string) {
        StringSelection stringSelection = new StringSelection(string);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this.clipboardHandler);
    }

    public String getClipboardContents() {
        String string;
        block5: {
            boolean bl;
            string = "";
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable transferable = clipboard.getContents(null);
            boolean bl2 = bl = transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor);
            if (bl) {
                try {
                    string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    if (this.logger != null) {
                        this.logger.warning("Clipboard flavor error: " + unsupportedFlavorException.getMessage());
                    }
                }
                catch (IOException iOException) {
                    if (this.logger == null) break block5;
                    this.logger.warning("Clipboard io error: " + iOException.getMessage());
                }
            }
        }
        return string;
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.cfg.putRectangleValue("ui.main.window.bounds", this.getBounds());
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        this.cfg.putRectangleValue("ui.main.window.bounds", this.getBounds());
        if (this.snowEngine != null) {
            this.snowEngine.shake();
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.atwpl.placeWindows();
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void passedDisplayEvent(ProcessorEvent processorEvent) {
        if (this.textDisplay != null) {
            this.textDisplay.setText(this.calcProc.getDisplay());
        }
        if (this.display != null) {
            this.display.updateDisplay(this.calcProc.getDisplay());
        }
        if (this.displayCombo != null) {
            this.displayCombo.updateOutput(this.calcProc.getDisplay(), this.calcProc.getStatusDisplay());
        }
        if (this.isValueInTitle()) {
            this.updateTitle();
        }
    }

    protected void updateListStack() {
        Stack<Object> stack = this.calcProc.getActionStack();
        DefaultListModel<CallSite> defaultListModel = new DefaultListModel<CallSite>();
        for (int i = stack.size() - 1; i >= 0; --i) {
            String string;
            Object e = stack.elementAt(i);
            if (e instanceof String) {
                string = i + " " + (String)e;
                defaultListModel.addElement((CallSite)((Object)string));
                continue;
            }
            if (e instanceof CaDouble) {
                string = i + " " + ((CaDouble)e).toString();
                defaultListModel.addElement((CallSite)((Object)string));
                continue;
            }
            string = i + " <unknown>";
            defaultListModel.addElement((CallSite)((Object)string));
        }
        this.listStack.setModel(defaultListModel);
    }

    @Override
    public void passedProtocolEvent(ProcessorEvent processorEvent) {
        if (this.protocol != null) {
            // empty if block
        }
    }

    @Override
    public void passedStatusEvent(ProcessorEvent processorEvent) {
        if ((processorEvent.getMask() & 1) != 0) {
            if (this.textStatus != null) {
                this.textStatus.setText(this.calcProc.getStatusDisplay());
            }
            if (this.displayCombo != null) {
                this.displayCombo.updateOutput(this.calcProc.getDisplay(), this.calcProc.getStatusDisplay());
            }
        }
        if ((processorEvent.getMask() & 2) != 0 && this.listStack != null) {
            this.updateListStack();
        }
        if ((processorEvent.getMask() & 4) != 0) {
            switch (this.calcProc.getAngularArgMode()) {
                case 0: {
                    if (this.btnAngArgModRad == null) break;
                    this.btnAngArgModRad.setSelected(true);
                    break;
                }
                case 1: {
                    if (this.btnAngArgModDeg == null) break;
                    this.btnAngArgModDeg.setSelected(true);
                    break;
                }
                case 2: {
                    if (this.btnAngArgModGra == null) break;
                    this.btnAngArgModGra.setSelected(true);
                }
            }
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    public boolean isValueInTitle() {
        return this.valueInTitle;
    }

    public void setValueInTitle(boolean bl) {
        this.valueInTitle = bl;
        this.updateTitle();
    }

    public void updateTitle() {
        if (this.valueInTitle) {
            this.setTitle(this.calcProc.getDisplay().trim() + " :: " + this.appTitle);
        } else {
            this.setTitle(this.appTitle);
        }
    }

    public boolean isUseTabProtocol() {
        return this.useTabProtocol;
    }

    public void setUseTabProtocol(boolean bl) {
        this.useTabProtocol = bl;
        if (!bl && this.windowLogTab != null && this.windowLogTab.isVisible()) {
            this.windowLogTab.setVisible(false);
        }
    }

    public boolean isUseTxtProtocol() {
        return this.useTxtProtocol;
    }

    public void setUseTxtProtocol(boolean bl) {
        this.useTxtProtocol = bl;
        if (!bl && this.windowLog != null && this.windowLog.isVisible()) {
            this.windowLog.setVisible(false);
        }
    }

    class ClipboardHandler
    implements ClipboardOwner {
        ClipboardHandler() {
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        }
    }
}

