/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.ui;

import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;

public class CmdEntry {
    String display;
    String cmd;
    String groupName;
    String toolTip;
    public static final int ICON_TEMPLATE = 0;
    public static final int ICON_STANDARD = 1;
    public static final int ICON_PRESSED = 2;
    public static final int ICON_ROLLOVER = 3;
    public static final int ICON_SELECTED = 4;
    public static final int ICON_DISABLED = 5;
    public static final int ICON_ROLLOVER_SELECTED = 6;
    static final int ICON_ARRAY_SIZE = 7;
    String[] iconNames;
    Image[] iconImages;
    CmdType cmdType;
    boolean adjustIconColor;

    public CmdEntry(String string, String string2) {
        this.cmd = string;
        this.display = string2;
        this.groupName = "";
        this.iconNames = new String[7];
        this.iconImages = new Image[7];
        this.cmdType = CmdType.NONE;
        this.adjustIconColor = false;
    }

    public CmdEntry(String string, String string2, String string3) {
        this.cmd = string;
        this.display = string2;
        this.groupName = string3;
        this.iconNames = new String[7];
        this.iconImages = new Image[7];
        this.cmdType = CmdType.NONE;
        this.adjustIconColor = false;
    }

    public CmdEntry(String string, String string2, String string3, String string4) {
        this.cmd = string;
        this.display = string2;
        this.groupName = string3;
        this.toolTip = string4;
        this.iconNames = new String[7];
        this.iconImages = new Image[7];
        this.cmdType = CmdType.NONE;
        this.adjustIconColor = false;
    }

    public CmdType getCmdType() {
        return this.cmdType;
    }

    public void setCmdType(CmdType cmdType) {
        this.cmdType = cmdType;
    }

    public void setCmdType(String string) {
        if (string.equals("btn")) {
            this.cmdType = CmdType.BUTTON;
        } else if (string.equals("dsp")) {
            this.cmdType = CmdType.DISPLAY;
        } else if (string.equals("spc")) {
            this.cmdType = CmdType.SPECIAL;
        } else if (string.equals("sep")) {
            this.cmdType = CmdType.SEPARATOR;
        } else if (string.equals("tgl")) {
            this.cmdType = CmdType.TOGGLE;
        } else {
            System.err.println("CmdEntry: type " + string + " is not valid");
            this.cmdType = CmdType.NONE;
        }
    }

    public void setIconName(int n, String string) {
        if (n < 0 || n >= this.iconNames.length) {
            System.err.println("CommandEndtry.setIconName: type out of range");
            return;
        }
        if (string.equals("")) {
            return;
        }
        this.iconNames[n] = string;
    }

    public void loadImages(MediaTracker mediaTracker) {
        for (int i = 0; i < 7; ++i) {
            this.loadImage(i);
            if (mediaTracker == null || this.iconImages[i] == null) continue;
            mediaTracker.addImage(this.iconImages[i], 0);
        }
    }

    public void loadImage(int n) {
        if (n < 0 || n >= this.iconNames.length) {
            System.err.println("CommandEndtry.loadImage: type out of range");
            return;
        }
        if (this.iconNames.length != this.iconImages.length) {
            System.err.println("CommandEndtry.loadImage: icon arrays not same size");
            return;
        }
        if (this.iconNames[n] == null) {
            return;
        }
        if (this.iconNames[n].equals("")) {
            return;
        }
        URL uRL = this.getClass().getClassLoader().getResource("de/admadic/calculator/ui/res/" + this.iconNames[n]);
        this.iconImages[n] = Toolkit.getDefaultToolkit().getImage(uRL);
    }

    public Image getIconImage(int n) {
        if (n < 0 || n >= this.iconImages.length) {
            return null;
        }
        return this.iconImages[n];
    }

    public String getCmd() {
        return this.cmd;
    }

    public void setCmd(String string) {
        this.cmd = string;
    }

    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String string) {
        this.display = string;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String string) {
        this.groupName = string;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public void setToolTip(String string) {
        this.toolTip = string;
    }

    public boolean isAdjustIconColor() {
        return this.adjustIconColor;
    }

    public void setAdjustIconColor(boolean bl) {
        this.adjustIconColor = bl;
    }

    static enum CmdType {
        NONE,
        SPECIAL,
        BUTTON,
        DISPLAY,
        SEPARATOR,
        TOGGLE;

    }
}

