/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.ui;

import de.admadic.cfg.Cfg;
import de.admadic.cfg.CfgPersistenceXML;
import de.admadic.util.FileUtil;
import de.admadic.util.PathManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.JOptionPane;

public class CfgCalc
extends Cfg {
    static boolean DBG = false;
    public static final char ITEM_SEPARATOR = ':';
    public static final String ITEM_SEPARATOR_STR = ":";
    public static final String PREFERENCES_PATH = "/de.admadic.calculator";
    public static final String UI_LAF_TYPE_PRIMARY = "p";
    public static final String UI_LAF_TYPE_SYSTEM = "s";
    public static final String UI_LAF_TYPE_EXTRA = "x";
    public static final String KEY_UI_LAF_ENABLE = "ui.laf.enable";
    public static final String KEY_UI_LAF_SELECT = "ui.laf.select";
    public static final String KEY_UI_LAF_SKIN_SELECT_BASE = "ui.laf.skin.";
    public static final String KEY_UI_LAF_IMPL_SKINLF_THEMEPACK_PATH = "ui.laf.impl.skinlf.themepack.path";
    public static final String KEY_UI_LAF_LISTAVAIL_BASE = "ui.laf.listavail.";
    public static final String KEY_UI_LAF_LISTUSE_BASE = "ui.laf.listuse.";
    public static final String KEY_UI_LAF_SKIN_LISTAVAIL_BASE = "ui.laf.skin.listavail.";
    public static final String KEY_UI_LAF_SKIN_LISTUSE_BASE = "ui.laf.skin.listuse.";
    public static final String KEY_UI_LAF_LISTUSEFILLIFEMPTY = "ui.laf.listusefillifempty";
    public static final String KEY_BASE_CLASSPATH_JAR = "main.classpath.jar.";
    public static final String KEY_CLASSPATH_DIRS = "main.classpath.dirs";
    public static final String KEY_CLASSPATH_USE_EXTENDER = "main.classpath.useextender";
    public static final String UI_LAF_STD_XPLATFORM_NAME = "Java";
    public static final String UI_LAF_STD_SYSTEM_NAME = "System";
    public static final String UI_LAF_STD_WINDOWS_NAME = "Windows";
    public static final String UI_LAF_STD_GTK_NAME = "GTK";
    public static final String UI_LAF_STD_MOTIF_NAME = "Motif";
    public static final String UI_LAF_STD_WINDOWS_CLASS = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    public static final String UI_LAF_STD_GTK_CLASS = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
    public static final String UI_LAF_STD_MOTIF_CLASS = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    public static final String UI_LAF_IMPL_SKINLF_NAME = "SkinLF";
    public static final String UI_LAF_IMPL_SKINLF_CLASS = "com.l2fprod.gui.plaf.skin.SkinLookAndFeel";
    public static final String UI_LAF_IMPL_SKINLF_IMPLCLASS = "de.admadic.laf.LaFSkinLF";
    public static final String UI_LAF_IMPL_BIROSOFT_LIQUID_NAME = "Birosoft Liquid";
    public static final String UI_LAF_IMPL_BIROSOFT_LIQUID_CLASS = "com.birosoft.liquid.LiquidLookAndFeel";
    public static final String UI_LAF_IMPL_BIROSOFT_LIQUID_IMPLCLASS = "de.admadic.laf.LaFBirosoftLiquid";
    public static final String UI_LAF_IMPL_KUNSTSTOFF_NAME = "Kunststoff";
    public static final String UI_LAF_IMPL_KUNSTSTOFF_CLASS = "com.incors.plaf.kunststoff.KunststoffLookAndFeel";
    public static final String UI_LAF_IMPL_METOUIA_NAME = "Metouia";
    public static final String UI_LAF_IMPL_METOUIA_CLASS = "net.sourceforge.mlf.metouia.MetouiaLookAndFeel";
    public static final String UI_LAF_IMPL_JGOODIESPLASTICS_NAME = "JGoodies-Plastics";
    public static final String UI_LAF_IMPL_JGOODIESPLASTICS_CLASS = "com.jgoodies.looks.plastic.PlasticLookAndFeel";
    public static final String UI_LAF_IMPL_JGOODIESWINDOWS_NAME = "JGoodies-Windows";
    public static final String UI_LAF_IMPL_JGOODIESWINDOWS_CLASS = "com.jgoodies.looks.windows.WindowsLookAndFeel";
    public static final String UI_STYLE_BUTTON_STANDARD = "button.standard";
    public static final String UI_STYLE_BUTTON_SMALL = "button.small";
    public static final String KEY_UI_LAYOUT_CCL_STYLE_BASE = "ui.layout.ccl.style.";
    public static final String KEY_UI_LAYOUT_CCL_MINCELL_BASE = "ui.layout.ccl.mincell";
    public static final String KEY_UI_LAYOUT_CCL_FIXEDCELLSIZE = "ui.layout.ccl.fixedcellsize";
    public static final String KEY_UI_MAIN_ALWAYSONTOP = "ui.main.alwaysontop";
    public static final String KEY_UI_MAIN_PROTOCOLWINDOW_ON = "ui.main.protocolwindow.on";
    public static final String KEY_UI_MAIN_MATHWINDOW_ON = "ui.main.mathwindow.on";
    public static final String KEY_UI_MAIN_ATWM_PLACERS = "ui.main.atwm.placers";
    public static final String KEY_UI_MAIN_PANEL_BACKGROUND = "ui.main.panel.background";
    public static final String KEY_UI_MAIN_PANEL_BACKGROUND_FILE = "ui.main.panel.background.file";
    public static final String KEY_UI_MAIN_EXTENDEDSETTINGS = "ui.extendedsettings";
    public static final String KEY_UI_BUTTON_CUSTOMFONT = "ui.button.customfont";
    public static final String KEY_UI_BUTTON_LOADGFX = "ui.button.loadgfx";
    public static final String KEY_UI_BUTTON_PAINTFOCUS = "ui.button.paintfocus";
    public static final String KEY_UI_MAIN_PANELMOVE = "ui.main.panelmove";
    public static final String KEY_UI_MAIN_WINDOW_BOUNDS = "ui.main.window.bounds";
    public static final String KEY_UI_MAIN_WORKINGDIR = "ui.main.workingdir";
    public static final String KEY_UI_MAIN_PRELOAD_UI = "ui.main.preloadui";
    public static final String KEY_UI_MAIN_VALUE_IN_TITLE = "ui.main.valueintitle";
    public static final String KEY_UI_MAIN_SHOW_TXT_PROT = "ui.main.showtextprot";
    public static final String KEY_UI_MAIN_SHOW_TAB_PROT = "ui.main.showtabprot";
    public static final String KEY_UI_MAIN_SKINMENU_FLAT = "ui.main.skinmenu.flat";
    public static final String KEY_UI_NUMBER_FORMAT = "ui.number.format";
    public static final String UI_NUMBER_FORMAT_DEFAULT = "fixed,12,2";
    public static final String KEY_UI_MAIN_GMX_SNOW = "ui.main.gmx.snow";
    public static final String KEY_UI_MAIN_LOCALE_DEFAULT = "ui.main.locale.default";
    public static final String KEY_UI_MAIN_LOCALE_SAMEASDEFAULT = "ui.main.locale.sameasdefault";
    public static final String KEY_UI_MAIN_LOCALE_INPUT = "ui.main.locale.input";
    public static final String KEY_UI_MAIN_LOCALE_OUTPUT = "ui.main.locale.output";
    public static final String KEY_UI_MAIN_LOCALE_EXPORT = "ui.main.locale.export";
    public static final String KEY_MODULE_LIST_BASE = "module.list.";
    public static final String KEY_MODULE_INAMES_BASE = "module.inames.";
    public static final String PREFIX_MODULES = "mod.";
    public static final String INFIX_MODULES_PREV = "prev";
    public static final String RSC_ICON = "de/admadic/calculator/ui/res/icon.jpg";
    public static final String RSC_SPLASH_IMAGE = "de/admadic/calculator/ui/res/splash.png";
    public static final String KEY_UI_MAIN_LIC_NAME = "ui.main.lic.name";
    public static final String KEY_UI_MAIN_LIC_COMPANY = "ui.main.lic.company";
    public static final String KEY_UI_MAIN_LIC_SN = "ui.main.lic.sn";
    public static final String KEY_UI_SN_STAT_SN = "ui.sns.sn";
    Object[][] stdValues = new Object[][]{{"ui.laf.enable", Boolean.TRUE}, {"ui.laf.listavail.0", "p:SkinLF:com.l2fprod.gui.plaf.skin.SkinLookAndFeel:de.admadic.laf.LaFSkinLF"}, {"ui.laf.listavail.1", "s:Java:<xplatform>"}, {"ui.laf.listavail.2", "s:System:<system>"}, {"ui.laf.listavail.3", "s:Windows:com.sun.java.swing.plaf.windows.WindowsLookAndFeel"}, {"ui.laf.listavail.4", "s:GTK:com.sun.java.swing.plaf.gtk.GTKLookAndFeel"}, {"ui.laf.listavail.5", "s:Motif:com.sun.java.swing.plaf.motif.MotifLookAndFeel"}, {"ui.laf.listusefillifempty", Boolean.TRUE}, {"ui.laf.select", "SkinLF"}, {"ui.laf.skin.SkinLF", "admaDIC:admadicthemepack.zip"}, {"ui.laf.skin.listavail.SkinLF.0", "admaDIC:admadicthemepack.zip"}, {"ui.laf.skin.listavail.SkinLF.1", "SkinLF:themepack.zip"}, {"ui.laf.skin.listavail.SkinLF.2", "Xmas:xmasthemepack.zip"}, {"ui.laf.impl.skinlf.themepack.path", "./laf/SkinLF/themes/"}, {"ui.button.loadgfx", Boolean.TRUE}, {"ui.button.customfont", Boolean.TRUE}, {"ui.button.paintfocus", Boolean.TRUE}, {"ui.main.panel.background", Boolean.FALSE}, {"ui.main.panel.background.file", ""}, {"ui.main.alwaysontop", Boolean.FALSE}, {"ui.main.protocolwindow.on", Boolean.TRUE}, {"ui.main.mathwindow.on", Boolean.TRUE}, {"ui.main.panelmove", Boolean.FALSE}, {"ui.main.preloadui", Boolean.TRUE}, {"ui.extendedsettings", Boolean.FALSE}, {"ui.main.skinmenu.flat", Boolean.TRUE}, {"ui.layout.ccl.fixedcellsize", Boolean.TRUE}, {"ui.layout.ccl.style.button.standard.width", 7}, {"ui.layout.ccl.style.button.standard.height", 6}, {"ui.layout.ccl.style.button.small.width", 7}, {"ui.layout.ccl.style.button.small.height", 5}, {"ui.layout.ccl.mincell.width", 4}, {"ui.layout.ccl.mincell.height", 4}, {"ui.main.lic.name", ""}, {"ui.main.lic.company", ""}, {"ui.main.lic.sn", ""}, {"ui.sns.sn", ""}, {"main.classpath.useextender", Boolean.TRUE}, {"main.classpath.dirs", "./laf/:./lib/:./mod/"}, {"ui.number.format", "fixed,12,2"}, {"ui.main.gmx.snow", Boolean.TRUE}, {"ui.main.valueintitle", Boolean.TRUE}, {"ui.main.showtabprot", Boolean.TRUE}, {"ui.main.showtextprot", Boolean.FALSE}, {"module.list.0", "Matrx:de.admadic.calculator.modules.matrx.MatrxModule:true"}, {"module.list.1", "MaSCa:de.admadic.calculator.modules.masca.MaSCaModule:true"}, {"module.list.2", "InDXp:de.admadic.calculator.modules.indxp.InDXpModule:true"}, {"ui.main.locale.default", "en:US"}, {"ui.main.locale.sameasdefault", Boolean.TRUE}, {"ui.main.locale.input", "en:US"}, {"ui.main.locale.output", "en:US"}, {"ui.main.locale.export", "en:US"}};
    Properties props;
    String cfgPath;
    String cfgFile;
    String cfgFullName;

    public CfgCalc() {
        String string = System.getProperty("admadic.debug");
        if (string != null && string.toLowerCase().equals("yes")) {
            DBG = true;
        }
        this.props = new Properties();
    }

    protected void error(String string) {
        this.error(string, true);
    }

    protected void error(String string, boolean bl) {
        System.err.println("Calculator: " + string);
        if (bl) {
            JOptionPane.showMessageDialog(null, string, "Configuration Error", 0);
        }
    }

    public void initCfgPaths(PathManager pathManager) {
        File file = null;
        if (DBG) {
            System.out.println("CfgCalc: initCfgPaths");
        }
        try {
            file = new File(pathManager.getPathString(5) + "/cfg.cfg");
            FileInputStream fileInputStream = new FileInputStream(file);
            this.props.load(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (DBG) {
                fileNotFoundException.printStackTrace();
            }
            InputStream inputStream = this.getClass().getResourceAsStream("/cfg/cfg.cfg");
            try {
                this.props.load(inputStream);
            }
            catch (IOException iOException) {
                if (DBG) {
                    iOException.printStackTrace();
                }
                this.error("The main cfg file could not be found! (looking for cfg.cfg)\nsys-cfg-dir = " + pathManager.getPathString(5));
            }
        }
        catch (IOException iOException) {
            if (DBG) {
                iOException.printStackTrace();
            }
            this.error("a cfg file exists, but could not be read! (" + (file != null ? file.toString() : "<null>") + ")");
        }
        this.cfgPath = this.props.getProperty("de.admadic.calculator.ui.CfgCalc.cfgpath");
        this.cfgFile = this.props.getProperty("de.admadic.calculator.ui.CfgCalc.cfgfile");
        if (this.cfgPath == null) {
            this.cfgPath = pathManager.getPathString(13);
        }
        file = PathManager.expandFilename(this.cfgPath);
        this.cfgPath = file.toString();
        file = new File(file, this.cfgFile);
        this.cfgFullName = file.toString();
    }

    public boolean existsCfgFile() {
        File file = new File(this.cfgFullName);
        return file.exists();
    }

    public boolean copyCfgFile(String string) {
        return FileUtil.copyTextFile(string, this.cfgFullName);
    }

    protected void tryPath() {
        File file = new File(this.cfgPath);
        if (!file.exists() && !file.mkdirs()) {
            this.error("Could not create cfg path (" + this.cfgPath + ")");
        }
    }

    public void initialize(boolean bl) {
        this.initStandard();
        this.registerPersistanceBackend(new CfgPersistenceXML(this, this.cfgFullName));
        if (bl) {
            this.loadPreferences(PREFERENCES_PATH);
        }
        this.postLoadFixup();
    }

    public static Cfg createTmpCfg(String string) {
        Cfg cfg = new Cfg();
        cfg.registerPersistanceBackend(new CfgPersistenceXML(cfg, string));
        return cfg;
    }

    public void initStandard() {
        for (int i = 0; i < this.stdValues.length; ++i) {
            if (this.stdValues[i].length != 2) {
                this.error("stdCfgEntry x[" + i + "] does not have 2 elements.", false);
                continue;
            }
            String string = (String)this.stdValues[i][0];
            this.getDefaultCfg().putValue(string, this.stdValues[i][1]);
        }
        this.getDefaultCfg().getCfgItem(KEY_UI_MAIN_LIC_NAME).setCiFlags(1, true);
        this.getDefaultCfg().getCfgItem(KEY_UI_MAIN_LIC_COMPANY).setCiFlags(1, true);
        this.getDefaultCfg().getCfgItem(KEY_UI_MAIN_LIC_SN).setCiFlags(1, true);
        this.getDefaultCfg().getCfgItem(KEY_UI_SN_STAT_SN).setCiFlags(1, true);
        this.setDefaults();
    }

    public void postLoadFixup() {
        if (this.getBooleanValue(KEY_UI_LAF_LISTUSEFILLIFEMPTY, true)) {
            Object[] objectArray;
            Object[] objectArray2;
            if (!this.entries.containsKey("ui.laf.listuse.0")) {
                objectArray2 = this.getValueArray(KEY_UI_LAF_LISTAVAIL_BASE);
                objectArray = new Integer[objectArray2.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = new Integer(i);
                }
                this.putValueArray(KEY_UI_LAF_LISTUSE_BASE, objectArray);
            }
            for (Object object : objectArray2 = this.getValueArray(KEY_UI_LAF_LISTAVAIL_BASE)) {
                Object object2;
                if (!(object instanceof String) || (objectArray = ((String)object).split(ITEM_SEPARATOR_STR)).length < 2 || !this.entries.containsKey(KEY_UI_LAF_SKIN_LISTAVAIL_BASE + (String)(object2 = objectArray[1]) + ".0") || this.entries.containsKey(KEY_UI_LAF_SKIN_LISTUSE_BASE + (String)object2 + ".0")) continue;
                Object[] objectArray3 = this.getValueArray(KEY_UI_LAF_SKIN_LISTAVAIL_BASE + (String)object2 + ".");
                Object[] objectArray4 = new Integer[objectArray3.length];
                for (int i = 0; i < objectArray4.length; ++i) {
                    objectArray4[i] = new Integer(i);
                }
                this.putValueArray(KEY_UI_LAF_SKIN_LISTUSE_BASE + (String)object2 + ".", objectArray4);
            }
        }
    }
}

