/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.ui;

import de.admadic.calculator.ui.CmdEntry;
import de.admadic.calculator.ui.CmdStyleGrp;
import de.admadic.ui.util.Colorizer;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

public class CalcToggleButton
extends JToggleButton {
    private static final long serialVersionUID = 1L;
    CmdEntry cmdE = null;
    CmdStyleGrp cmdG = null;
    boolean useCustomFont = false;
    boolean useCustomGfx = false;

    public CalcToggleButton() {
    }

    public CalcToggleButton(Icon icon) {
        super(icon);
    }

    public CalcToggleButton(Icon icon, boolean bl) {
        super(icon, bl);
    }

    public CalcToggleButton(String string) {
        super(string);
    }

    public CalcToggleButton(String string, boolean bl) {
        super(string, bl);
    }

    public CalcToggleButton(Action action) {
        super(action);
    }

    public CalcToggleButton(String string, Icon icon) {
        super(string, icon);
    }

    public CalcToggleButton(String string, Icon icon, boolean bl) {
        super(string, icon, bl);
    }

    public void setCmdStyle(CmdEntry cmdEntry, CmdStyleGrp cmdStyleGrp) {
        this.cmdE = cmdEntry;
        this.cmdG = cmdStyleGrp;
        this.updateCmdStyle();
    }

    private void updateCmdStyle() {
        this.updateColor();
        if (this.isUseCustomFont()) {
            this.updateFont();
        }
        if (this.isUseCustomGfx()) {
            this.updateGfx();
        }
    }

    private void updateGfx() {
        if (this.cmdG == null || this.cmdE == null) {
            return;
        }
        Color color = this.cmdG.getTextColor();
        Color color2 = UIManager.getColor("Button.foreground");
        if (color2 == null) {
            color2 = UIManager.getColor("controlText");
        }
        Color color3 = color2;
        Color color4 = this.getBackground();
        boolean bl = false;
        Image image = this.cmdE.getIconImage(0);
        if (image != null) {
            // empty if block
        }
        if (image != null) {
            bl = true;
        }
        if ((image = this.cmdE.getIconImage(1)) != null) {
            this.setIcon(Colorizer.makeIcon(image, this.cmdE.isAdjustIconColor(), color4, color3, color));
        }
        if (image != null) {
            bl = true;
        }
        if ((image = this.cmdE.getIconImage(2)) != null) {
            this.setPressedIcon(Colorizer.makeIcon(image, this.cmdE.isAdjustIconColor(), color4, color3, color));
        }
        if (image != null) {
            bl = true;
        }
        if ((image = this.cmdE.getIconImage(3)) != null) {
            this.setRolloverIcon(Colorizer.makeIcon(image, this.cmdE.isAdjustIconColor(), color4, color3, color));
        }
        if (image != null) {
            bl = true;
        }
        if ((image = this.cmdE.getIconImage(4)) != null) {
            this.setSelectedIcon(Colorizer.makeIcon(image, this.cmdE.isAdjustIconColor(), color4, color3, color));
        }
        if (image != null) {
            bl = true;
        }
        if ((image = this.cmdE.getIconImage(5)) != null) {
            this.setDisabledIcon(Colorizer.makeIcon(image, this.cmdE.isAdjustIconColor(), color4, color3, color));
        }
        if (image != null) {
            bl = true;
        }
        if ((image = this.cmdE.getIconImage(6)) != null) {
            this.setRolloverSelectedIcon(Colorizer.makeIcon(image, this.cmdE.isAdjustIconColor(), color4, color3, null));
        }
        if (image != null) {
            bl = true;
        }
        if (bl) {
            this.setText(null);
        }
    }

    private void updateFont() {
        if (this.cmdG == null) {
            return;
        }
        Font font = this.cmdG.getFont();
        if (font != null) {
            this.setFont(font);
        }
    }

    private void updateColor() {
        if (this.cmdG == null) {
            return;
        }
        Color color = this.cmdG.getTextColor();
        if (color != null) {
            Color color2 = UIManager.getColor("Button.foreground");
            if (color2 == null) {
                color2 = UIManager.getColor("controlText");
            }
            if (color2 != null) {
                color = Colorizer.adjustColor(null, color2, color);
            }
            if (color != null) {
                this.setForeground(color);
            }
        }
    }

    public boolean isUseCustomFont() {
        return this.useCustomFont;
    }

    public void setUseCustomFont(boolean bl) {
        this.useCustomFont = bl;
    }

    public boolean isUseCustomGfx() {
        return this.useCustomGfx;
    }

    public void setUseCustomGfx(boolean bl) {
        this.useCustomGfx = bl;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.updateCmdStyle();
    }
}

