/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.ui;

import de.admadic.calculator.processor.IProcessorCalculation;
import de.admadic.calculator.processor.ProcessorUnknownOpException;
import de.admadic.calculator.processor.ProtocolEvent;
import de.admadic.calculator.processor.ProtocolEventListener;
import de.admadic.calculator.types.CaDouble;
import de.admadic.calculator.types.CaDoubleFormatter;
import de.admadic.calculator.types.CaNumber;
import de.admadic.calculator.types.CaNumberFormatterContext;
import de.admadic.calculator.ui.CalcToggleButton;
import de.admadic.ui.util.AbstractRendererEditorColumnAccessor;
import de.admadic.ui.util.ListRefTableModel;
import de.admadic.ui.util.RendererEditorColumnAccessor;
import de.admadic.ui.util.StringPrinter;
import de.admadic.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;

public class CalcProtocolTabular
extends JPanel
implements ProtocolEventListener {
    private static final long serialVersionUID = 1L;
    CaNumberFormatterContext numFmtCtx;
    ListRefTableModel tableModel;
    AbstractRendererEditorColumnAccessor columnAccessor;
    JTable tableProtocol;
    JScrollPane scrollPane;
    CalcSequence calcSequence;
    JLabel labelStatus;
    TableRenderer tableRenderer;
    TableEditor tableEditor;
    JToolBar toolBar;
    String[] columnNames;
    int columnCount;
    int[] columnWidths;
    IProcessorCalculation processorCalculation;
    UpdateAction actionUpdate;
    CalcToggleButton btnMotionLock;
    String statusText = "ok";
    boolean dirty = false;
    static String strLF = "\n";

    public CalcProtocolTabular() {
        this.initContents();
    }

    public CalcProtocolTabular(CaNumberFormatterContext caNumberFormatterContext) {
        this.numFmtCtx = caNumberFormatterContext;
        this.initContents();
    }

    private String[] sublist(String[] stringArray, int n) {
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        return stringArray2;
    }

    private void initContents() {
        try {
            String string;
            strLF = string = System.getProperty("line.separator", "\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.columnNames = new String[]{"Comment", "Op", "Expression", "Value", "(subres)", "(res)"};
        this.columnCount = 4;
        this.columnWidths = new int[]{100, 20, 100, 100, 60, 60};
        this.calcSequence = new CalcSequence();
        this.setLayout(new BorderLayout());
        this.tableProtocol = new JTable();
        this.scrollPane = new JScrollPane(this.tableProtocol, 22, 32);
        this.add((Component)this.scrollPane, "Center");
        this.labelStatus = new JLabel();
        this.add((Component)this.labelStatus, "Last");
        this.setStatusText("ok");
        this.scrollPane.setBorder(BorderFactory.createBevelBorder(1));
        this.columnAccessor = new CalcRowColumnAccessor();
        this.tableModel = new ListRefTableModel();
        this.tableModel.setData(this.calcSequence.getRowsList());
        this.tableModel.setColumnAccessor(this.columnAccessor);
        this.tableModel.setColumns(this.sublist(this.columnNames, this.columnCount));
        this.tableRenderer = new TableRenderer(this.columnAccessor);
        if (this.numFmtCtx != null) {
            this.tableRenderer.setNumFmtCtx(this.numFmtCtx);
        }
        this.tableEditor = new TableEditor(this.columnAccessor);
        if (this.numFmtCtx != null) {
            this.tableEditor.setNumFmtCtx(this.numFmtCtx);
        }
        this.tableProtocol.setDefaultRenderer(CalcRowBase.class, this.tableRenderer);
        this.tableProtocol.setDefaultEditor(CalcRowBase.class, this.tableEditor);
        this.tableProtocol.setModel(this.tableModel);
        this.tableProtocol.setShowHorizontalLines(false);
        this.tableProtocol.getTableHeader().setReorderingAllowed(false);
        for (int i = 0; i < this.columnCount; ++i) {
            this.tableProtocol.getColumnModel().getColumn(i).setPreferredWidth(this.columnWidths[i]);
        }
        this.toolBar = new JToolBar();
        this.add((Component)this.toolBar, "First");
        this.toolBar.add(new SaveAction());
        this.toolBar.add(new PrintAction());
        this.toolBar.add(new CopyAction());
        this.toolBar.addSeparator();
        this.actionUpdate = new UpdateAction();
        this.toolBar.add(this.actionUpdate);
        this.toolBar.addSeparator();
        this.toolBar.add(new InsertAction());
        this.toolBar.add(new InsertResultAction());
        this.toolBar.add(new InsertCommentAction());
        this.toolBar.addSeparator();
        this.toolBar.add(new ClearAllAction());
        this.toolBar.add(new DeleteAction());
        this.toolBar.addSeparator();
        this.toolBar.add(new MoveUpAction());
        this.toolBar.add(new MoveDownAction());
        this.toolBar.addSeparator();
        this.btnMotionLock = new CalcToggleButton();
        this.toolBar.add(this.btnMotionLock);
    }

    public CalcToggleButton getMotionLockButton() {
        return this.btnMotionLock;
    }

    protected void setStatusText(String string) {
        String string2 = this.isDirty() ? "(Update Calculation!)" : "";
        if (string != null) {
            this.statusText = string;
        }
        this.labelStatus.setText("Status: " + this.statusText + " " + string2);
    }

    public void refreshDisplay() {
        this.tableModel.fireTableDataChanged();
    }

    protected void updateScrollPos() {
        this.tableProtocol.scrollRectToVisible(this.tableProtocol.getCellRect(this.tableProtocol.getRowCount() - 1, 0, true));
    }

    @Override
    public void addOp(ProtocolEvent protocolEvent) {
        CalcRowOp calcRowOp = new CalcRowOp();
        calcRowOp.setOperation(protocolEvent.getOperation());
        try {
            calcRowOp.setValue(protocolEvent.getValue().clone());
            if (protocolEvent.getLastSubResult() != null) {
                calcRowOp.setLastResultValue(protocolEvent.getLastSubResult().clone());
            }
            if (protocolEvent.getCurResult() != null) {
                calcRowOp.setResultValue(protocolEvent.getCurResult().clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        this.calcSequence.add(calcRowOp);
        int n = this.calcSequence.getRowsList().size() - 1;
        this.tableModel.fireTableRowsInserted(n, n);
        this.updateScrollPos();
    }

    @Override
    public void addSubExprOp(ProtocolEvent protocolEvent) {
        CalcRowOp calcRowOp = new CalcRowOp();
        calcRowOp.setOperation(protocolEvent.getOperation());
        try {
            calcRowOp.setValue(protocolEvent.getValue().clone());
            if (protocolEvent.getLastSubResult() != null) {
                calcRowOp.setLastResultValue(protocolEvent.getLastSubResult().clone());
            }
            if (protocolEvent.getCurResult() != null) {
                calcRowOp.setResultValue(protocolEvent.getCurResult().clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        calcRowOp.setSubExpr(protocolEvent.getSubExpression());
        this.calcSequence.add(calcRowOp);
        int n = this.calcSequence.getRowsList().size() - 1;
        this.tableModel.fireTableRowsInserted(n, n);
        this.updateScrollPos();
    }

    @Override
    public void addResult(ProtocolEvent protocolEvent) {
        CalcRowResult calcRowResult = new CalcRowResult();
        calcRowResult.setOperation(protocolEvent.getOperation());
        try {
            calcRowResult.setValue(protocolEvent.getValue().clone());
            if (protocolEvent.getCurResult() != null) {
                calcRowResult.setResultValue(protocolEvent.getCurResult().clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        this.calcSequence.add(calcRowResult);
        CalcRowComment calcRowComment = new CalcRowComment();
        this.calcSequence.add(calcRowComment);
        int n = this.calcSequence.getRowsList().size() - 1;
        this.tableModel.fireTableRowsInserted(n - 1, n);
        this.updateScrollPos();
    }

    @Override
    public void addClear(ProtocolEvent protocolEvent) {
        CalcRowComment calcRowComment = new CalcRowComment();
        calcRowComment.setOperation(".clear");
        this.calcSequence.add(calcRowComment);
        int n = this.calcSequence.getRowsList().size() - 1;
        this.tableModel.fireTableRowsInserted(n, n);
        this.updateScrollPos();
    }

    protected void updateProtocolCalculation() {
        if (this.getProcessorCalculation() == null) {
            return;
        }
        boolean bl = true;
        List<CalcRowBase> list = this.calcSequence.getRowsList();
        CaDouble caDouble = new CaDouble();
        CaDouble caDouble2 = new CaDouble();
        for (CalcRowBase calcRowBase : list) {
            CaDouble caDouble3 = null;
            String string = null;
            Object object = null;
            calcRowBase.setStatus(0);
            try {
                if (calcRowBase instanceof CalcRowComment) continue;
                if (calcRowBase instanceof CalcRowOp || calcRowBase instanceof CalcRowResult) {
                    if (calcRowBase.getLastResultValue() == null) {
                        calcRowBase.setLastResultValue(new CaDouble());
                    }
                    caDouble.cloneTo((CaDouble)calcRowBase.getLastResultValue());
                }
                if (calcRowBase instanceof CalcRowResult) {
                    caDouble.cloneTo((CaDouble)calcRowBase.getValue());
                    calcRowBase.setResultValue(new CaDouble());
                    caDouble.cloneTo((CaDouble)calcRowBase.getResultValue());
                    continue;
                }
                if (calcRowBase instanceof CalcRowOp) {
                    string = calcRowBase.getOperation();
                }
                if ((object = calcRowBase.getSubExpr()) != null && !((String)object).equals("")) {
                    if (((String)object).contains("ans")) {
                        object = ((String)object).replaceAll("ans", caDouble.toString());
                    }
                    if (((String)object).contains("%") && string != null && (string.equals("+") || string.equals("-"))) {
                        object = (String)object + " * " + caDouble.toString();
                    }
                    caDouble3 = new CaDouble();
                    try {
                        this.getProcessorCalculation().calcSubExpr((String)object, caDouble3);
                    }
                    catch (ProcessorUnknownOpException processorUnknownOpException) {
                        throw new Exception(processorUnknownOpException.getMessage());
                    }
                    if (calcRowBase.getValue() == null) {
                        calcRowBase.setValue(new CaDouble());
                    }
                    caDouble3.cloneTo((CaDouble)calcRowBase.getValue());
                } else {
                    caDouble3 = new CaDouble();
                    ((CaDouble)calcRowBase.getValue()).cloneTo(caDouble3);
                }
                if (string != null && !string.equals("")) {
                    try {
                        int n = this.getProcessorCalculation().getOpOrder(string);
                        switch (n) {
                            case 0: {
                                this.getProcessorCalculation().calcConstantOp(string, caDouble2);
                                break;
                            }
                            case 1: {
                                this.getProcessorCalculation().calcUnaryOp(string, caDouble3, caDouble2);
                                if (calcRowBase.getValue() == null) {
                                    calcRowBase.setValue(new CaDouble());
                                }
                                caDouble2.cloneTo((CaDouble)calcRowBase.getValue());
                                break;
                            }
                            case 2: {
                                this.getProcessorCalculation().calcBinaryOp(string, caDouble, caDouble3, caDouble2);
                            }
                        }
                    }
                    catch (ProcessorUnknownOpException processorUnknownOpException) {
                        throw new Exception(processorUnknownOpException.getMessage());
                    }
                } else {
                    caDouble3.cloneTo(caDouble2);
                }
                if (calcRowBase.getResultValue() == null) {
                    calcRowBase.setResultValue(new CaDouble());
                }
                caDouble2.cloneTo((CaDouble)calcRowBase.getResultValue());
                caDouble2.cloneTo(caDouble);
            }
            catch (Exception exception) {
                calcRowBase.setStatus(1);
                this.setStatusText("Error: " + exception.getMessage());
                bl = false;
                break;
            }
        }
        if (bl) {
            this.setDirty(false);
            this.setStatusText("ok");
        }
    }

    protected File getSaveFileNameJFC() {
        File file = null;
        JFileChooser jFileChooser = new JFileChooser();
        class TextFilter
        extends FileFilter {
            TextFilter() {
            }

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = null;
                String string2 = file.getName();
                int n = string2.lastIndexOf(46);
                if (n > 0 && n < string2.length() - 1) {
                    string = string2.substring(n + 1).toLowerCase();
                }
                if (string != null) {
                    boolean bl = string.equals("txt");
                    return bl;
                }
                return false;
            }

            @Override
            public String getDescription() {
                return "Text Files (*.txt)";
            }
        }
        jFileChooser.addChoosableFileFilter(new TextFilter());
        jFileChooser.setFileHidingEnabled(false);
        int n = jFileChooser.showSaveDialog(this);
        switch (n) {
            case 0: {
                file = jFileChooser.getSelectedFile();
                if (file.exists()) {
                    int n2 = JOptionPane.showConfirmDialog(this, "The file " + file.toString() + " already exist.\nOverwrite?");
                    if (n2 == 0) {
                        return file;
                    }
                    return null;
                }
                return file;
            }
            case 1: {
                break;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveProtocolTxt() {
        File file = this.getSaveFileNameJFC();
        if (file == null) {
            return;
        }
        CalcSequenceExportTxt calcSequenceExportTxt = new CalcSequenceExportTxt(this.calcSequence, this.numFmtCtx);
        String string = calcSequenceExportTxt.createExportString();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(string.getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Could not write the export data to the file.\nError: " + exception.getMessage(), "Error saving file", 0);
        }
        finally {
            Object var4_5 = null;
            file = null;
        }
    }

    public ImageIcon loadIcon(String string) {
        String string2 = "de/admadic/calculator/ui/res/" + string;
        URL uRL = this.getClass().getClassLoader().getResource(string2);
        if (uRL == null) {
            return null;
        }
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        if (image == null) {
            return null;
        }
        return new ImageIcon(image);
    }

    public IProcessorCalculation getProcessorCalculation() {
        return this.processorCalculation;
    }

    public void printData() {
        if (this.calcSequence.getRowsList().size() < 1) {
            this.setStatusText("Nothing to print.");
            return;
        }
        ProtocolPrintStringRenderer protocolPrintStringRenderer = new ProtocolPrintStringRenderer(this.calcSequence, this.numFmtCtx);
        String string = protocolPrintStringRenderer.createString();
        StringPrinter stringPrinter = new StringPrinter((JFrame)null, string);
        stringPrinter.doPrint(false);
    }

    public void copyData() {
        TabularCopyPasteCore tabularCopyPasteCore = new TabularCopyPasteCore(this.columnAccessor, this.numFmtCtx);
        tabularCopyPasteCore.doCopyFrom(this.tableProtocol);
    }

    public void cancelCellEditing() {
        if (this.tableProtocol == null) {
            return;
        }
        TableCellEditor tableCellEditor = this.tableProtocol.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.cancelCellEditing();
        }
    }

    public void insertRowComment() {
        int n = this.tableProtocol.getSelectedRow();
        if (n < 0) {
            n = this.tableProtocol.getRowCount();
        }
        CalcRowComment calcRowComment = new CalcRowComment();
        this.calcSequence.getRowsList().add(n, calcRowComment);
        this.tableModel.fireTableRowsInserted(n, n);
    }

    public void insertRowResult() {
        int n = this.tableProtocol.getSelectedRow();
        if (n < 0) {
            n = this.tableProtocol.getRowCount();
        }
        CalcRowResult calcRowResult = new CalcRowResult();
        this.calcSequence.getRowsList().add(n, calcRowResult);
        this.tableModel.fireTableRowsInserted(n, n);
    }

    public void insertRowOp() {
        int n = this.tableProtocol.getSelectedRow();
        if (n < 0) {
            n = this.tableProtocol.getRowCount();
        }
        CalcRowOp calcRowOp = new CalcRowOp();
        this.calcSequence.getRowsList().add(n, calcRowOp);
        this.tableModel.fireTableRowsInserted(n, n);
    }

    public void removeSelectedRows() {
        int[] nArray = this.tableProtocol.getSelectedRows();
        if (nArray == null) {
            return;
        }
        if (nArray.length == 0) {
            this.setStatusText("cannot delete rows: no rows selected");
            return;
        }
        int n = JOptionPane.showConfirmDialog(null, "Please confirm, that the selected rows shall be deleted.\nDo you want to delete the selected rows?", "Confirm delete rows", 0);
        if (n != 0) {
            return;
        }
        this.cancelCellEditing();
        if (nArray.length == 1) {
            this.calcSequence.getRowsList().remove(nArray[0]);
            this.tableModel.fireTableRowsDeleted(nArray[0], nArray[0]);
        } else {
            for (int i = nArray.length - 1; i >= 0; --i) {
                this.calcSequence.getRowsList().remove(nArray[i]);
            }
            this.tableModel.fireTableDataChanged();
        }
    }

    public void moveDown() {
        int n = this.tableProtocol.getRowCount();
        int n2 = this.tableProtocol.getSelectedRow();
        if (n2 < 0) {
            this.setStatusText("Must select a row for move down.");
            return;
        }
        if (n2 >= n - 1) {
            return;
        }
        this.cancelCellEditing();
        Collections.swap(this.calcSequence.getRowsList(), n2, n2 + 1);
        this.tableModel.fireTableRowsUpdated(n2, n2 + 1);
        this.tableProtocol.setRowSelectionInterval(n2 + 1, n2 + 1);
    }

    public void moveUp() {
        int n = this.tableProtocol.getSelectedRow();
        if (n < 0) {
            this.setStatusText("Must select a row for move up.");
            return;
        }
        if (n < 1) {
            return;
        }
        this.cancelCellEditing();
        Collections.swap(this.calcSequence.getRowsList(), n, n - 1);
        this.tableModel.fireTableRowsUpdated(n - 1, n);
        this.tableProtocol.setRowSelectionInterval(n - 1, n - 1);
    }

    public void clearSequence() {
        int n = this.calcSequence.getRowsList().size();
        if (n < 1) {
            return;
        }
        int n2 = JOptionPane.showConfirmDialog(null, "Do you wish to clear the protocol completely?", "Confirm clearing protocol", 0);
        if (n2 != 0) {
            return;
        }
        this.cancelCellEditing();
        this.calcSequence.clear();
        this.tableModel.fireTableRowsDeleted(0, n - 1);
        this.refreshDisplay();
    }

    public void setProcessorCalculation(IProcessorCalculation iProcessorCalculation) {
        this.processorCalculation = iProcessorCalculation;
        if (this.actionUpdate != null) {
            this.actionUpdate.setEnabled(iProcessorCalculation != null);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
        this.setStatusText(null);
    }

    public class ProtocolPrintStringRenderer {
        CalcSequence calcSeq;
        CaNumberFormatterContext numFmtCtx;
        CaDoubleFormatter numFmt;
        int[] fieldWidths = new int[]{20, 6, 20, 15};
        int pageWidth = 61;
        static final int ALIGN_LEFT = 0;
        static final int ALIGN_CENTER = 1;
        static final int ALIGN_RIGHT = 2;

        public ProtocolPrintStringRenderer(CalcSequence calcSequence, CaNumberFormatterContext caNumberFormatterContext) {
            this.calcSeq = calcSequence;
            this.numFmtCtx = caNumberFormatterContext;
            this.numFmt = caNumberFormatterContext == null ? new CaDoubleFormatter() : (CaDoubleFormatter)caNumberFormatterContext.get(CaDouble.class);
        }

        public String createString() {
            StringBuffer stringBuffer = new StringBuffer("");
            for (CalcRowBase calcRowBase : this.calcSeq.getRowsList()) {
                String string = calcRowBase.getComment();
                String string2 = calcRowBase.getOperation();
                String string3 = calcRowBase.getSubExpr();
                String string4 = calcRowBase.getValueRenderString(this.numFmt);
                StringBuffer stringBuffer2 = new StringBuffer("");
                stringBuffer2.append(this.formatField(string, this.fieldWidths[0], 0));
                stringBuffer2.append(this.formatField(string2, this.fieldWidths[1], 1));
                string3 = string3 == null ? "" : calcRowBase.getSubExpressionRenderString(this.numFmt);
                stringBuffer2.append(this.formatField(string3, this.fieldWidths[2], 0));
                stringBuffer2.append(this.formatField(string4, this.fieldWidths[3], 2));
                stringBuffer2.append(strLF);
                if (calcRowBase instanceof CalcRowResult) {
                    stringBuffer.append(StringUtil.fill('-', this.pageWidth));
                    stringBuffer.append(strLF);
                }
                stringBuffer.append(stringBuffer2);
                if (!(calcRowBase instanceof CalcRowResult)) continue;
                stringBuffer.append(StringUtil.fill('=', this.pageWidth));
                stringBuffer.append(strLF);
            }
            return stringBuffer.toString();
        }

        private String formatField(String string, int n, int n2) {
            string = string == null ? "" : string;
            Object object = string;
            switch (n2) {
                case 0: {
                    if (string.length() < n - 1) {
                        object = string + StringUtil.fill(' ', n - string.length());
                        break;
                    }
                    object = string.substring(0, n - 4) + "... ";
                    break;
                }
                case 1: {
                    if (string.length() < n - 1) {
                        int n3 = (n - string.length()) / 2;
                        int n4 = n - string.length() - n3;
                        object = StringUtil.fill(' ', n3) + string + StringUtil.fill(' ', n4);
                        break;
                    }
                    object = string.substring(0, n - 4) + "... ";
                    break;
                }
                case 2: {
                    object = string.length() < n - 1 ? StringUtil.fill(' ', n - string.length()) + string : " ..." + string.substring(string.length() - n + 4, string.length());
                }
            }
            return object;
        }
    }

    public class TabularCopyPasteCore {
        Clipboard clipboard;
        AbstractRendererEditorColumnAccessor columnAccessor;
        CaNumberFormatterContext numFmtCtx;
        CaDoubleFormatter numFmt;

        public TabularCopyPasteCore(AbstractRendererEditorColumnAccessor abstractRendererEditorColumnAccessor, CaNumberFormatterContext caNumberFormatterContext) {
            this.columnAccessor = abstractRendererEditorColumnAccessor;
            this.numFmtCtx = caNumberFormatterContext;
            this.numFmt = caNumberFormatterContext != null ? (CaDoubleFormatter)caNumberFormatterContext.get(CaDouble.class) : new CaDoubleFormatter();
            this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }

        public void doCopyFrom(JTable jTable) {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = jTable.getSelectedRowCount();
            int[] nArray = jTable.getSelectedRows();
            int n3 = 0;
            if (nArray.length > 0) {
                n3 = nArray.length == 1 ? 1 : (n3 += nArray[nArray.length - 1] - nArray[0] + 1);
            }
            if (n2 == 0) {
                n2 = jTable.getRowCount();
                nArray = new int[n2];
                for (n = 0; n < nArray.length; ++n) {
                    nArray[n] = n;
                }
                n3 = n2;
            }
            if (n2 != nArray.length || n2 != n3) {
                JOptionPane.showMessageDialog(null, "Not a continuous selection.", "Invalid selection for Copy", 0);
                return;
            }
            for (n = 0; n < nArray.length; ++n) {
                Object object = jTable.getValueAt(nArray[n], 0);
                CalcRowBase calcRowBase = (CalcRowBase)object;
                String string = calcRowBase.getCommentRenderString();
                stringBuffer.append(string != null ? string : "");
                stringBuffer.append("\t");
                string = calcRowBase.getOperationRenderString();
                stringBuffer.append(string != null ? string : "");
                stringBuffer.append("\t");
                string = calcRowBase.getSubExpressionRenderString(this.numFmt);
                stringBuffer.append(string != null ? string : "");
                stringBuffer.append("\t");
                string = calcRowBase.getValueRenderString(this.numFmt);
                stringBuffer.append(string != null ? string : "");
                stringBuffer.append(strLF);
            }
            StringSelection stringSelection = new StringSelection(stringBuffer.toString());
            this.clipboard.setContents(stringSelection, stringSelection);
        }

        public void doPasteInto(JTable jTable, boolean bl) {
        }
    }

    public class CopyPasteCore {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();

        public void doCopyFrom(JTextField jTextField) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(jTextField.getText());
            StringSelection stringSelection = new StringSelection(stringBuffer.toString());
            this.clipboard.setContents(stringSelection, stringSelection);
        }

        public void doPasteInto(JTextField jTextField) {
            try {
                String string = (String)this.clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor);
                if (jTextField.isEditable()) {
                    jTextField.setText(string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public class SaveAction
    extends AbstractProtocolAction {
        private static final long serialVersionUID = 1L;

        public SaveAction() {
            this.putValue("Name", "Save");
            this.putValue("ShortDescription", "Save the protocol.");
            this.putValue("SmallIcon", CalcProtocolTabular.this.loadIcon("btn-save.png"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CalcProtocolTabular.this.saveProtocolTxt();
        }
    }

    public class ClearAllAction
    extends AbstractProtocolAction {
        private static final long serialVersionUID = 1L;

        public ClearAllAction() {
            this.putValue("Name", "Clear All");
            this.putValue("ShortDescription", "Clear the protocol.");
            this.putValue("SmallIcon", CalcProtocolTabular.this.loadIcon("btn-prot-clr.png"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CalcProtocolTabular.this.clearSequence();
        }
    }

    public class MoveDownAction
    extends AbstractProtocolAction {
        private static final long serialVersionUID = 1L;

        public MoveDownAction() {
            this.putValue("Name", "Down");
            this.putValue("ShortDescription", "Move the line downwards.");
            this.putValue("SmallIcon", CalcProtocolTabular.this.loadIcon("btn-arw-down.png"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CalcProtocolTabular.this.moveDown();
        }
    }

    public class MoveUpAction
    extends AbstractProtocolAction {
        private static final long serialVersionUID = 1L;

        public MoveUpAction() {
            this.putValue("Name", "Up");
            this.putValue("ShortDescription", "Move the line upwards.");
            this.putValue("SmallIcon", CalcProtocolTabular.this.loadIcon("btn-arw-up.png"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CalcProtocolTabular.this.moveUp();
        }
    }

    public class PrintAction
    extends AbstractProtocolAction {
        private static final long serialVersionUID = 1L;

        public PrintAction() {
            this.putValue("Name", "Print");
            this.putValue("ShortDescription", "Print the protocol.");
            this.putValue("SmallIcon", CalcProtocolTabular.this.loadIcon("btn-print.png"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CalcProtocolTabular.this.printData();
        }
    }

    public class CopyAction
    extends AbstractProtocolAction {
        private static final long serialVersionUID = 1L;

        public CopyAction() {
            this.putValue("Name", "Copy");
            this.putValue("ShortDescription", "Copy to clipboard.");
            this.putValue("SmallIcon", CalcProtocolTabular.this.loadIcon("btn-copy.png"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CalcProtocolTabular.this.copyData();
        }
    }

    public class InsertCommentAction
    extends AbstractProtocolAction {
        private static final long serialVersionUID = 1L;

        public InsertCommentAction() {
            this.putValue("Name", "Insert Comment");
            this.putValue("ShortDescription", "Insert a comment row.");
            this.putValue("SmallIcon", CalcProtocolTabular.this.loadIcon("btn-prot-addcmt.png"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CalcProtocolTabular.this.insertRowComment();
        }
    }

    public class InsertResultAction
    extends AbstractProtocolAction {
        private static final long serialVersionUID = 1L;

        public InsertResultAction() {
            this.putValue("Name", "Insert Result");
            this.putValue("ShortDescription", "Insert a result row.");
            this.putValue("SmallIcon", CalcProtocolTabular.this.loadIcon("btn-prot-addres.png"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CalcProtocolTabular.this.insertRowResult();
        }
    }

    public class InsertAction
    extends AbstractProtocolAction {
        private static final long serialVersionUID = 1L;

        public InsertAction() {
            this.putValue("Name", "Insert");
            this.putValue("ShortDescription", "Insert a row.");
            this.putValue("SmallIcon", CalcProtocolTabular.this.loadIcon("btn-prot-addline.png"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CalcProtocolTabular.this.insertRowOp();
        }
    }

    public class DeleteAction
    extends AbstractProtocolAction {
        private static final long serialVersionUID = 1L;

        public DeleteAction() {
            this.putValue("Name", "Delete");
            this.putValue("ShortDescription", "Delete the selected row.");
            this.putValue("SmallIcon", CalcProtocolTabular.this.loadIcon("btn-prot-clrll.png"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CalcProtocolTabular.this.removeSelectedRows();
        }
    }

    public class UpdateAction
    extends AbstractProtocolAction {
        private static final long serialVersionUID = 1L;

        public UpdateAction() {
            this.putValue("Name", "Update");
            this.putValue("ShortDescription", "Update the protocols calculations.");
            this.putValue("SmallIcon", CalcProtocolTabular.this.loadIcon("btn-prot-update.png"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CalcProtocolTabular.this.updateProtocolCalculation();
            CalcProtocolTabular.this.refreshDisplay();
        }
    }

    public static abstract class AbstractProtocolAction
    extends AbstractAction {
    }

    public static class CalcRowComment
    extends CalcRowBase {
    }

    public static class CalcRowResult
    extends CalcRowBase {
        public CalcRowResult() {
            this.setOperation("=");
            this.setValue(new CaDouble());
        }
    }

    public static class CalcRowOp
    extends CalcRowBase {
        public CalcRowOp() {
            this.setOperation("");
            this.setValue(new CaDouble());
        }
    }

    public static class CalcRowBase {
        boolean editable;
        String operation;
        String subExpr;
        CaNumber value;
        CaNumber resultValue;
        String comment;
        CaNumber lastResultValue;
        String commentValue;
        public static final int OK = 0;
        public static final int BAD = 1;
        int status = 0;

        public String getCommentRenderString() {
            return this.getComment();
        }

        public String getOperationRenderString() {
            return this.getOperation();
        }

        public String getSubExpressionRenderString(CaDoubleFormatter caDoubleFormatter) {
            if (this instanceof CalcRowOp) {
                String string = this.getSubExpr();
                if (string != null) {
                    Object object = string;
                    CaNumber caNumber = this.getLastResultValue();
                    if (((String)object).contains("ans")) {
                        object = ((String)object).replaceAll("ans", caDoubleFormatter.formatNumber(caNumber).trim());
                    }
                    if (((String)object).contains("%")) {
                        String string2 = this.getOperation();
                        if (string2 == null) {
                            string2 = "";
                        }
                        if (string2.equals("+") || string2.equals("-")) {
                            object = ((String)object).startsWith("ex") ? (String)object + " : " + caDoubleFormatter.formatNumber(caNumber).trim() : (String)object + " x " + caDoubleFormatter.formatNumber(caNumber).trim();
                        }
                    }
                    string = object;
                }
                return string;
            }
            return this.getSubExpr();
        }

        public String getValueRenderString(CaDoubleFormatter caDoubleFormatter) {
            if (this instanceof CalcRowComment) {
                return this.getCommentValue();
            }
            CaDouble caDouble = (CaDouble)this.getValue();
            String string = caDoubleFormatter.formatNumber(caDouble).trim();
            return string;
        }

        public boolean isEditable() {
            return this.editable;
        }

        public void setEditable(boolean bl) {
            this.editable = bl;
        }

        public String getOperation() {
            return this.operation;
        }

        public void setOperation(String string) {
            this.operation = string;
        }

        public String getSubExpr() {
            return this.subExpr;
        }

        public void setSubExpr(String string) {
            this.subExpr = string;
        }

        public CaNumber getValue() {
            return this.value;
        }

        public void setValue(CaNumber caNumber) {
            this.value = caNumber;
        }

        public CaNumber getResultValue() {
            return this.resultValue;
        }

        public void setResultValue(CaNumber caNumber) {
            this.resultValue = caNumber;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String string) {
            this.comment = string;
        }

        public CaNumber getLastResultValue() {
            return this.lastResultValue;
        }

        public void setLastResultValue(CaNumber caNumber) {
            this.lastResultValue = caNumber;
        }

        public String toString() {
            Object object = this.getClass().getSimpleName();
            object = (String)object + " ed=" + this.editable;
            object = (String)object + " op=" + this.operation;
            object = (String)object + " sx=" + this.subExpr;
            object = (String)object + " va=" + (this.value != null ? this.value.toString() : "./.");
            object = (String)object + " rv=" + (this.resultValue != null ? this.resultValue.toString() : "./.");
            object = (String)object + " co=" + this.comment;
            object = (String)object + " lr=" + (this.lastResultValue != null ? this.lastResultValue.toString() : "./.");
            return ((String)object).toString();
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int n) {
            this.status = n;
        }

        public String getCommentValue() {
            return this.commentValue;
        }

        public void setCommentValue(String string) {
            this.commentValue = string;
        }
    }

    public static class CalcSequenceExportTxt {
        CalcSequence calcSeq;
        CaNumberFormatterContext numFmtCtx;

        public CalcSequenceExportTxt(CalcSequence calcSequence, CaNumberFormatterContext caNumberFormatterContext) {
            this.calcSeq = calcSequence;
            this.numFmtCtx = caNumberFormatterContext;
        }

        public String createExportString() {
            StringBuffer stringBuffer = new StringBuffer();
            CaDoubleFormatter caDoubleFormatter = (CaDoubleFormatter)this.numFmtCtx.get(CaDouble.class);
            stringBuffer.append("Comment\tOp\tSub-Expression\tValue\n");
            for (CalcRowBase calcRowBase : this.calcSeq.getRowsList()) {
                if (calcRowBase.getComment() != null) {
                    stringBuffer.append(calcRowBase.getCommentRenderString());
                }
                stringBuffer.append('\t');
                if (calcRowBase.getOperation() != null) {
                    stringBuffer.append(calcRowBase.getOperationRenderString());
                }
                stringBuffer.append('\t');
                if (calcRowBase.getSubExpr() != null) {
                    stringBuffer.append(calcRowBase.getSubExpressionRenderString(caDoubleFormatter));
                }
                stringBuffer.append('\t');
                if (calcRowBase.getValue() != null) {
                    stringBuffer.append(calcRowBase.getValueRenderString(caDoubleFormatter));
                }
                stringBuffer.append(strLF);
            }
            return stringBuffer.toString();
        }
    }

    public static class CalcSequence {
        ArrayList<CalcRowBase> rows = new ArrayList();

        public List<CalcRowBase> getRowsList() {
            return this.rows;
        }

        public boolean add(CalcRowBase calcRowBase) {
            return this.rows.add(calcRowBase);
        }

        public void clear() {
            this.rows.clear();
        }
    }

    public class TableEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1L;
        CaDoubleFormatter doubleFormatter;
        JTextField cellEditor;
        CalcRowBase lastValue;
        int lastColumn;
        RendererEditorColumnAccessor columnAccessor;
        CaNumberFormatterContext numFmtCtx;

        public TableEditor(RendererEditorColumnAccessor rendererEditorColumnAccessor) {
            super(new JTextField());
            this.columnAccessor = rendererEditorColumnAccessor;
            this.cellEditor = (JTextField)this.editorComponent;
            this.lastValue = null;
            this.lastColumn = -1;
            this.doubleFormatter = new CaDoubleFormatter();
        }

        @Override
        public Object getCellEditorValue() {
            return this.cellEditor.getText();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.lastValue = (CalcRowBase)object;
            this.lastColumn = n2;
            Object object2 = this.columnAccessor.getEditorValueAt(this.lastValue, n2);
            String string = object2 instanceof String ? (String)object2 : (object2 instanceof CaNumber ? this.doubleFormatter.formatNumber((CaNumber)object2) : "");
            this.cellEditor.setText(string.trim());
            return this.cellEditor;
        }

        @Override
        public void cancelCellEditing() {
            super.cancelCellEditing();
            this.lastValue = null;
            this.lastColumn = -1;
        }

        @Override
        public boolean stopCellEditing() {
            if (this.lastValue != null) {
                String string = this.cellEditor.getText();
                Object object = string;
                if (this.lastColumn == 3 && !(this.lastValue instanceof CalcRowComment)) {
                    CaNumber caNumber = (CaNumber)this.columnAccessor.getEditorValueAt(this.lastValue, this.lastColumn);
                    try {
                        this.doubleFormatter.parseNumber(string, caNumber);
                        object = caNumber;
                    }
                    catch (NumberFormatException numberFormatException) {
                        CalcProtocolTabular.this.setStatusText("number format error");
                        return false;
                    }
                }
                CalcProtocolTabular.this.setDirty(true);
                this.columnAccessor.setEditorValueAt(this.lastValue, object, this.lastColumn);
                this.lastValue = null;
                this.lastColumn = -1;
            }
            return super.stopCellEditing();
        }

        public CaNumberFormatterContext getNumFmtCtx() {
            return this.numFmtCtx;
        }

        public void setNumFmtCtx(CaNumberFormatterContext caNumberFormatterContext) {
            this.numFmtCtx = caNumberFormatterContext;
            this.doubleFormatter = (CaDoubleFormatter)caNumberFormatterContext.get(CaDouble.class);
        }
    }

    public static class TableRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        Border borderSimpleStyle;
        Border borderExtendedStyle;
        RendererEditorColumnAccessor columnAccessor;
        CaNumberFormatterContext numFmtCtx;
        CaDoubleFormatter numFmt;
        Border badBorder;

        public TableRenderer(RendererEditorColumnAccessor rendererEditorColumnAccessor) {
            this.columnAccessor = rendererEditorColumnAccessor;
            this.borderSimpleStyle = BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLACK);
            this.borderExtendedStyle = BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLACK), BorderFactory.createEmptyBorder(0, 0, 1, 0)), BorderFactory.createMatteBorder(1, 0, 1, 0, Color.BLACK));
            this.badBorder = BorderFactory.createMatteBorder(2, 0, 2, 0, Color.RED);
            this.numFmt = new CaDoubleFormatter();
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2 = this.columnAccessor.getRendererValueAt(object, n2);
            if (object2 instanceof CaDouble) {
                object2 = ((CalcRowBase)object).getValueRenderString(this.numFmt);
            }
            if (n2 == 2) {
                object2 = ((CalcRowBase)object).getSubExpressionRenderString(this.numFmt);
            }
            Component component = super.getTableCellRendererComponent(jTable, object2, bl, bl2, n, n2);
            switch (n2) {
                case 0: {
                    this.setHorizontalAlignment(2);
                    break;
                }
                case 1: {
                    this.setHorizontalAlignment(0);
                    break;
                }
                case 3: {
                    this.setHorizontalAlignment(4);
                    break;
                }
                case 2: {
                    this.setHorizontalAlignment(2);
                    break;
                }
                default: {
                    this.setHorizontalAlignment(2);
                }
            }
            if (object instanceof CalcRowResult) {
                ((JLabel)component).setBorder(this.borderExtendedStyle);
            }
            if (((CalcRowBase)object).getStatus() == 1 && !bl2) {
                ((JLabel)component).setBorder(this.badBorder);
            }
            return component;
        }

        public CaNumberFormatterContext getNumFmtCtx() {
            return this.numFmtCtx;
        }

        public void setNumFmtCtx(CaNumberFormatterContext caNumberFormatterContext) {
            this.numFmtCtx = caNumberFormatterContext;
            if (caNumberFormatterContext != null) {
                this.numFmt = (CaDoubleFormatter)caNumberFormatterContext.get(CaDouble.class);
            }
        }
    }

    public static class CalcRowColumnAccessor
    extends AbstractRendererEditorColumnAccessor {
        public static final int COL_CMT = 0;
        public static final int COL_OP = 1;
        public static final int COL_SUBEXPR = 2;
        public static final int COL_VALUE = 3;
        public static final int COL_LASTSUBRESULT = 4;
        public static final int COL_RESULT = 5;

        @Override
        public void setValueAt(Object object, Object object2, int n) {
        }

        @Override
        public Object getValueAt(Object object, int n) {
            if (object == null) {
                return null;
            }
            return object;
        }

        @Override
        public boolean isCellEditable(Object object, int n) {
            if (object instanceof CalcRowResult) {
                return n == 0;
            }
            return n != 4 && n != 5;
        }

        @Override
        public Class getColumnClass(int n) {
            return CalcRowBase.class;
        }

        @Override
        public Object getRendererValueAt(Object object, int n) {
            if (object == null) {
                return null;
            }
            CalcRowBase calcRowBase = (CalcRowBase)object;
            switch (n) {
                case 0: {
                    return calcRowBase.getComment();
                }
                case 1: {
                    return calcRowBase.getOperation();
                }
                case 2: {
                    return calcRowBase.getSubExpr();
                }
                case 3: {
                    if (object instanceof CalcRowComment) {
                        return calcRowBase.getCommentValue();
                    }
                    return calcRowBase.getValue();
                }
                case 4: {
                    return calcRowBase.getLastResultValue();
                }
                case 5: {
                    return calcRowBase.getResultValue();
                }
            }
            return null;
        }

        @Override
        public void setRendererValueAt(Object object, Object object2, int n) {
            CalcRowBase calcRowBase = (CalcRowBase)object;
            switch (n) {
                case 0: {
                    calcRowBase.setComment((String)object2);
                    break;
                }
                case 1: {
                    calcRowBase.setOperation((String)object2);
                    break;
                }
                case 2: {
                    calcRowBase.setSubExpr((String)object2);
                    break;
                }
                case 3: {
                    if (object instanceof CalcRowComment) {
                        calcRowBase.setCommentValue((String)object2);
                        break;
                    }
                    calcRowBase.setValue((CaNumber)object2);
                }
            }
        }
    }
}

