/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.ui;

import de.admadic.calculator.processor.ProtocolEvent;
import de.admadic.calculator.processor.ProtocolEventListener;
import de.admadic.calculator.types.CaDouble;
import de.admadic.calculator.types.CaDoubleFormatter;
import de.admadic.calculator.types.CaNumber;
import de.admadic.calculator.types.CaNumberFormatterContext;
import de.admadic.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class CalcProtocol
extends JPanel
implements ProtocolEventListener {
    private static final long serialVersionUID = 1L;
    JScrollPane scrollPane;
    JTextArea text;
    Font font;
    int columns;
    int opColumns = 6;
    CaNumberFormatterContext numFmtCtx;
    CaDoubleFormatter numFmt;
    String protocolData = "";

    public CalcProtocol() {
        this.numFmt = new CaDoubleFormatter();
        this.initContents();
    }

    public CalcProtocol(CaNumberFormatterContext caNumberFormatterContext) {
        this.numFmtCtx = caNumberFormatterContext;
        this.numFmt = caNumberFormatterContext != null ? (CaDoubleFormatter)caNumberFormatterContext.get(CaDouble.class) : new CaDoubleFormatter();
        this.initContents();
    }

    private void initContents() {
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane();
        this.add((Component)this.scrollPane, "Center");
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.text = new JTextArea();
        this.scrollPane.setViewportView(this.text);
        this.font = new Font("Courier New", 0, 12);
        this.text.setFont(this.font);
        this.text.setEditable(false);
        this.columns = 25;
        this.text.setColumns(this.columns);
        this.scrollPane.setBorder(BorderFactory.createBevelBorder(1));
        this.updateMinimumSize();
    }

    public void updateMinimumSize() {
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int n) {
        this.columns = n;
        this.text.setColumns(n);
        this.updateMinimumSize();
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    public void setProtocolFont(Font font) {
        this.font = font;
        this.text.setFont(font);
        this.updateMinimumSize();
    }

    public void setProtocolText(String string) {
        this.protocolData = string;
        this.text.setText(string);
    }

    public void setRows(int n) {
        if (this.text != null) {
            this.text.setRows(n);
        }
    }

    @Override
    public void addOp(ProtocolEvent protocolEvent) {
        String string;
        String string2;
        String string3 = string2 = protocolEvent.getOperation();
        Object object = "";
        CaDouble caDouble = (CaDouble)protocolEvent.getValue();
        if (string2.equals("")) {
            string3 = ".";
        }
        object = (string = string3).length() > this.getOpColumns() ? (String)object + "\n-> " + string + "\n" + (string2 + "                 ").substring(0, this.getOpColumns()) + " " + (caDouble != null ? this.numFmt.format(caDouble) : "./.") : (String)object + "\n" + (string + "            ").substring(0, this.getOpColumns()) + " " + (caDouble != null ? this.numFmt.format(caDouble) : "./.");
        this.protocolData = this.protocolData + (String)object;
        this.text.append((String)object);
    }

    @Override
    public void addSubExprOp(ProtocolEvent protocolEvent) {
        Object object;
        String string;
        String string2 = string = protocolEvent.getOperation();
        String string3 = protocolEvent.getSubExpression();
        Object object2 = "";
        CaDouble caDouble = (CaDouble)protocolEvent.getValue();
        if (string3 != null) {
            object = protocolEvent.getLastSubResult();
            if (string3.contains("ans")) {
                string3 = string3.replaceAll("ans", this.numFmt.formatNumber((CaNumber)object).trim());
            }
            object2 = (String)object2 + "\n-> " + string3;
            if (string3.contains("%")) {
                object2 = string3.startsWith("ex") ? (String)object2 + " : " + this.numFmt.formatNumber((CaNumber)object).trim() : (String)object2 + " x " + this.numFmt.formatNumber((CaNumber)object).trim();
            }
        }
        object2 = ((String)(object = string2)).length() > this.getOpColumns() ? (String)object2 + "\n-> " + (String)object + "\n" + (string + "                 ").substring(0, this.getOpColumns()) + " " + (caDouble != null ? this.numFmt.format(caDouble) : "./.") : (String)object2 + "\n" + ((String)object + "            ").substring(0, this.getOpColumns()) + " " + (caDouble != null ? this.numFmt.format(caDouble) : "./.");
        this.protocolData = this.protocolData + (String)object2;
        this.text.append((String)object2);
    }

    @Override
    public void addResult(ProtocolEvent protocolEvent) {
        String string = protocolEvent.getOperation();
        Object object = "";
        CaDouble caDouble = (CaDouble)protocolEvent.getValue();
        object = (String)object + "\n" + StringUtil.fill('-', this.getColumns());
        object = (String)object + "\n" + (string + "                  ").substring(0, this.getOpColumns()) + " " + (caDouble != null ? this.numFmt.format(caDouble) : "./.");
        object = (String)object + "\n" + StringUtil.fill('=', this.getColumns());
        object = (String)object + "\n";
        this.protocolData = this.protocolData + (String)object;
        this.text.append((String)object);
    }

    @Override
    public void addClear(ProtocolEvent protocolEvent) {
        Object object = "";
        object = (String)object + "\n.clear\n";
        this.protocolData = this.protocolData + (String)object;
        this.text.append((String)object);
    }

    public int getOpColumns() {
        return this.opColumns;
    }

    public void setOpColumns(int n) {
        this.opColumns = n;
    }
}

