/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.ui;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JWindow;

public class CalcPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
ComponentListener {
    private static final long serialVersionUID = 1L;
    Image bgImage = null;
    JFrame frame = null;
    Point lastp;
    boolean dragging = false;
    boolean dragging2 = false;
    JWindow hint = null;

    public void initBgImage(String string) {
        MediaTracker mediaTracker = new MediaTracker(this);
        URL uRL = this.getClass().getClassLoader().getResource("de/admadic/calculator/ui/res/" + string);
        this.bgImage = Toolkit.getDefaultToolkit().getImage(uRL);
        mediaTracker.addImage(this.bgImage, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.bgImage == null) {
            super.paintComponent(graphics);
        } else {
            graphics.drawImage(this.bgImage, 0, 0, this.getWidth(), this.getHeight(), 0, 0, this.bgImage.getWidth(null), this.bgImage.getHeight(null), null);
        }
    }

    public void linkSurfaceDragging(JFrame jFrame) {
        this.frame = jFrame;
        if (this.frame != null) {
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
            this.frame.addComponentListener(this);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.dragging) {
            if (this.hint == null) {
                this.hint = new JWindow();
                this.hint.setBounds(this.frame.getBounds());
                this.hint.setVisible(true);
                this.frame.toFront();
            }
            Point point = this.hint.getLocation();
            if (this.lastp.distance(mouseEvent.getPoint()) == 0.0) {
                return;
            }
            point.translate(mouseEvent.getX() - this.lastp.x, mouseEvent.getY() - this.lastp.y);
            this.lastp.setLocation(mouseEvent.getPoint());
            this.hint.setLocation(point);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.dragging = true;
        if (this.lastp == null) {
            this.lastp = new Point(mouseEvent.getPoint());
        } else {
            this.lastp.setLocation(mouseEvent.getPoint());
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.dragging = false;
        if (this.hint != null) {
            Point point = this.hint.getLocation();
            this.hint.dispose();
            this.hint = null;
            this.frame.setLocation(point);
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }
}

