/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class CalcDisplayExt
extends JPanel {
    private static final long serialVersionUID = 1L;
    String lastDisplay;
    String lastStatus;
    Display display = new Display();

    public CalcDisplayExt() {
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        this.add((Component)this.display, "Center");
        this.display.updateText("(display)", "(status)");
        this.display.setFont(new Font("Courier New", 1, 14));
        this.display.setAutoscrolls(false);
        this.display.setAlignmentX(0.0f);
        this.display.setOpaque(false);
        this.setBorder(BorderFactory.createBevelBorder(1));
    }

    public void updateDisplay(String string) {
        this.updateOutput(string, this.lastStatus);
    }

    public void updateStatus(String string) {
        this.updateOutput(this.lastDisplay, string);
    }

    public void updateOutput(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        this.display.updateText(string, string2);
        this.display.repaint();
    }

    class Display
    extends JPanel {
        private static final long serialVersionUID = 1L;
        String display2;
        String status;
        Font displayFont;
        Font statusFont;

        Display() {
        }

        public void updateText(String string, String string2) {
            this.display2 = string;
            this.status = string2;
            this.displayFont = new Font("Arial", 0, 20);
            this.statusFont = new Font("Arial", 0, 9);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            FontMetrics fontMetrics;
            Rectangle2D rectangle2D;
            super.paintComponent(graphics);
            Insets insets = this.getInsets();
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            Font font = this.displayFont;
            int n = 3;
            int n2 = 0;
            do {
                if (n2 <= 0) continue;
                font = font.deriveFont((float)font.getSize() * 0.8f);
            } while (!((rectangle2D = (fontMetrics = graphics2D.getFontMetrics(font)).getStringBounds(this.display2, graphics2D)).getWidth() <= (double)(this.getWidth() - insets.left - insets.right)) && ++n2 < n);
            graphics2D.setFont(font);
            graphics2D.drawString(this.display2, this.getWidth() - insets.right - (int)rectangle2D.getWidth(), insets.top + fontMetrics.getMaxAscent());
            fontMetrics = graphics2D.getFontMetrics(this.statusFont);
            graphics2D.setFont(this.statusFont);
            graphics2D.drawString(this.status, insets.left, this.getHeight() - insets.bottom - fontMetrics.getMaxDescent());
            graphics2D.dispose();
        }
    }
}

