/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.ui;

import de.admadic.calculator.ui.CalcCompCellConstraints;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.Hashtable;

public class CalcCompLayout
implements LayoutManager2 {
    boolean DBGforce = false;
    boolean DBGfitting = false;
    boolean DBGgridsize = false;
    boolean DBGreset = false;
    Dimension gridSize;
    Dimension majorGridSize;
    Dimension minCellSize;
    boolean fixedCellSize;
    boolean forceFixedCellSize;
    Hashtable<Component, CalcCompCellConstraints> compTable;
    HorzSpec[] colBounds;
    VertSpec[] rowBounds;
    float alignmentX;
    float alignmentY;
    boolean shrinkWrap;
    int shrinkPan;
    Hashtable<String, CalcCompCellConstraints> conHash;
    Dimension lastPreferredSize;

    public CalcCompLayout() {
        this(new Dimension(1, 1));
    }

    public CalcCompLayout(Dimension dimension) {
        if (dimension.width <= 0 || dimension.height <= 0) {
            throw new IllegalArgumentException("dimensions must be greater than zero");
        }
        this.gridSize = new Dimension(dimension);
        this.majorGridSize = new Dimension(1, 1);
        this.minCellSize = null;
        this.compTable = new Hashtable();
        this.alignmentX = 0.5f;
        this.alignmentY = 0.5f;
        this.shrinkWrap = false;
        this.shrinkPan = 0;
        this.conHash = null;
        this.fixedCellSize = false;
    }

    public Dimension getGridSize() {
        return new Dimension(this.gridSize);
    }

    public void setGridSize(Dimension dimension) {
        this.setGridSize(dimension.width, dimension.height);
    }

    public void setGridSize(int n, int n2) {
        this.gridSize = new Dimension(n, n2);
    }

    public void setConstraints(Component component, CalcCompCellConstraints calcCompCellConstraints) {
        if (calcCompCellConstraints.isTemplate()) {
            calcCompCellConstraints = new CalcCompCellConstraints(calcCompCellConstraints);
            calcCompCellConstraints.setTemplate(false);
        }
        this.compTable.put(component, calcCompCellConstraints);
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.compTable.remove(component);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        this.lastPreferredSize = this.getLayoutSize(container, true);
        return new Dimension(this.lastPreferredSize);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.getLayoutSize(container, false);
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return this.getLayoutSize(container, true);
    }

    protected void updateGridSize() {
        int n = 0;
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MAX_VALUE;
        if (this.compTable == null) {
            return;
        }
        boolean bl = false;
        Object object = "";
        for (CalcCompCellConstraints calcCompCellConstraints : this.compTable.values()) {
            if (bl || this.DBGgridsize) {
                object = " < cell=" + calcCompCellConstraints.getName() + " (w/h)=(" + calcCompCellConstraints.majorGridWidth + "/" + calcCompCellConstraints.majorGridHeight + ")";
            }
            if (calcCompCellConstraints.getMaxCol() > n) {
                n = calcCompCellConstraints.getMaxCol();
                if (bl || this.DBGgridsize) {
                    System.err.println("    >>maxcol = " + n + (String)object);
                }
            }
            if (calcCompCellConstraints.getMaxRow() > n2) {
                n2 = calcCompCellConstraints.getMaxRow();
                if (bl || this.DBGgridsize) {
                    System.err.println("  vv  maxrow = " + n2 + (String)object);
                }
            }
            if (calcCompCellConstraints.getCol() < n3) {
                n3 = calcCompCellConstraints.getCol();
                if (bl || this.DBGgridsize) {
                    System.err.println("<<    mincol = " + n3 + (String)object);
                }
            }
            if (calcCompCellConstraints.getRow() >= n4) continue;
            n4 = calcCompCellConstraints.getRow();
            if (!bl && !this.DBGgridsize) continue;
            System.err.println("  ^^  minrow = " + n4 + (String)object);
        }
        if (bl || this.DBGforce) {
            System.err.println("grid: mincol/minrow=" + n3 + "/" + n4 + " maxcol/maxrow=" + n + "/" + n2);
        }
        if (this.shrinkWrap) {
            if (bl || this.DBGforce) {
                System.err.println("shrink");
            }
            this.setGridSize(n - n3 + 1 + 2 * this.shrinkPan, n2 - n4 + 1 + 2 * this.shrinkPan);
            for (CalcCompCellConstraints calcCompCellConstraints : this.compTable.values()) {
                calcCompCellConstraints.col -= n3 - this.shrinkPan;
                calcCompCellConstraints.row -= n4 - this.shrinkPan;
            }
        } else if (++n > this.gridSize.width || ++n2 > this.gridSize.height) {
            this.setGridSize(n, n2);
        }
    }

    protected Dimension getLayoutSize(Container container, boolean bl) {
        boolean bl2 = false;
        if (bl2 || this.DBGforce) {
            System.err.println("getLayoutSize:");
        }
        Dimension dimension = this.getLargestCellSize(container, bl);
        if (bl2 || this.DBGforce) {
            System.err.println("ccl: ls-cell: " + dimension + " (gs=" + this.gridSize + ")");
        }
        Insets insets = container.getInsets();
        if (bl2 || this.DBGforce) {
            System.err.println("ccl: ls-inst: " + insets);
        }
        dimension.width = dimension.width * this.gridSize.width + insets.left + insets.right;
        dimension.height = dimension.height * this.gridSize.height + insets.top + insets.bottom;
        if (bl2 || this.DBGforce) {
            System.err.println("ccl: ls-layt: " + dimension);
        }
        return dimension;
    }

    protected Dimension getLargestCellSize(Container container, boolean bl) {
        this.resetStretch(container);
        this.processFitBuildConHash(container);
        this.processFit(container);
        this.updateGridSize();
        this.processStretch(container);
        boolean bl2 = false;
        if (this.fixedCellSize) {
            if (this.minCellSize != null && this.minCellSize.height != 0 && this.minCellSize.width != 0 && (bl2 || this.DBGforce)) {
                System.err.println("getLargestCellSize: fixed");
            }
            return new Dimension(this.minCellSize);
        }
        if (bl2 || this.DBGforce) {
            System.err.println("getLargestCellSize: dynamic");
        }
        int n = container.getComponentCount();
        Dimension dimension = new Dimension(0, 0);
        if (this.minCellSize != null) {
            dimension = new Dimension(this.minCellSize);
        }
        if (bl2 || this.DBGforce) {
            System.out.println("largest cell size:");
        }
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            CalcCompCellConstraints calcCompCellConstraints = this.compTable.get(component);
            if (component == null || calcCompCellConstraints == null) continue;
            Dimension dimension2 = bl ? component.getPreferredSize() : component.getMinimumSize();
            if (dimension2.width / calcCompCellConstraints.colspan > dimension.width) {
                dimension.width = dimension2.width / calcCompCellConstraints.colspan;
                if (bl2 || this.DBGforce) {
                    System.out.println("layout: grow width: (" + dimension.width + ") " + component);
                }
            }
            if (dimension2.height / calcCompCellConstraints.rowspan <= dimension.height) continue;
            dimension.height = dimension2.height / calcCompCellConstraints.rowspan;
            if (!bl2 && !this.DBGforce) continue;
            System.out.println("layout: grow height: (" + dimension.height + ") " + component);
        }
        if (bl2 || this.DBGforce) {
            System.out.println("largest cell size (" + bl + ") = " + dimension);
        }
        return dimension;
    }

    protected void initCellBounds() {
        if (this.colBounds == null || this.colBounds.length != this.gridSize.width) {
            this.colBounds = new HorzSpec[this.gridSize.width];
        }
        if (this.rowBounds == null || this.rowBounds.length != this.gridSize.height) {
            this.rowBounds = new VertSpec[this.gridSize.height];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            boolean bl = false;
            if (bl || this.DBGforce) {
                System.err.println("layoutContainer");
            }
            if ((n6 = container.getComponentCount()) == 0) {
                return;
            }
            this.resetStretch(container);
            this.processFitBuildConHash(container);
            this.processFit(container);
            this.updateGridSize();
            this.processStretch(container);
            this.initCellBounds();
            Insets insets = container.getInsets();
            Dimension dimension = container.getSize();
            if (this.lastPreferredSize != null && Math.abs(this.lastPreferredSize.height - dimension.height) <= 1) {
                dimension = new Dimension(this.lastPreferredSize);
            }
            if (bl || this.DBGforce) {
                System.err.println("size=" + dimension + " insets=" + insets);
            }
            int n7 = dimension.width - (insets.left + insets.right);
            int n8 = dimension.height - (insets.top + insets.bottom);
            if (this.isForceFixedCellSize()) {
                n5 = this.minCellSize.width;
                n4 = this.minCellSize.height;
                n3 = this.minCellSize.width;
                n2 = this.minCellSize.height;
            } else {
                n5 = n7 / this.gridSize.width;
                n4 = n8 / this.gridSize.height;
                n3 = n7 / this.gridSize.width;
                n2 = n8 / this.gridSize.height;
            }
            if (bl || this.DBGforce) {
                System.err.println("gridSize=" + this.gridSize + " totalCellW/H=" + n5 + "," + n4);
            }
            for (n = 0; n < this.gridSize.width; ++n) {
                this.colBounds[n] = new HorzSpec(insets.left + n5 * n, insets.left + n5 * n + n3);
            }
            for (n = 0; n < this.gridSize.height; ++n) {
                this.rowBounds[n] = new VertSpec(insets.top + n4 * n, insets.top + n4 * n + n2);
            }
            for (n = 0; n < n6; ++n) {
                Component component = container.getComponent(n);
                CalcCompCellConstraints calcCompCellConstraints = this.compTable.get(component);
                if (calcCompCellConstraints == null) continue;
                try {
                    int n9 = this.colBounds[calcCompCellConstraints.col].xl;
                    int n10 = this.rowBounds[calcCompCellConstraints.row].yt;
                    int n11 = this.colBounds[calcCompCellConstraints.getMaxCol()].xr - n9;
                    int n12 = this.rowBounds[calcCompCellConstraints.getMaxRow()].yb - n10;
                    component.setBounds(n9, n10, n11, n12);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    arrayIndexOutOfBoundsException.printStackTrace();
                    System.err.println(arrayIndexOutOfBoundsException);
                    System.err.println("comp: " + component.getName() + " / ...");
                    System.err.println("cell: " + calcCompCellConstraints);
                    System.exit(1);
                }
            }
        }
    }

    protected void processFitBuildConHash(Container container) {
        this.conHash = new Hashtable();
        int n = container.getComponentCount();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            CalcCompCellConstraints calcCompCellConstraints = this.compTable.get(component);
            if (calcCompCellConstraints == null) continue;
            this.conHash.put(calcCompCellConstraints.getName(), calcCompCellConstraints);
        }
    }

    protected void processFit(Container container) {
        int n = container.getComponentCount();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            CalcCompCellConstraints calcCompCellConstraints = this.compTable.get(component);
            if (calcCompCellConstraints == null) continue;
            this.processFitCell(calcCompCellConstraints);
        }
    }

    protected void processStretch(Container container) {
        int n = container.getComponentCount();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            CalcCompCellConstraints calcCompCellConstraints = this.compTable.get(component);
            if (calcCompCellConstraints == null) continue;
            this.processStretchCell(calcCompCellConstraints);
        }
    }

    protected void resetStretch(Container container) {
        int n = container.getComponentCount();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            CalcCompCellConstraints calcCompCellConstraints = this.compTable.get(component);
            if (calcCompCellConstraints == null) continue;
            calcCompCellConstraints.updateSpans();
        }
    }

    protected void processFitCell(CalcCompCellConstraints calcCompCellConstraints) {
        CalcCompCellConstraints calcCompCellConstraints2;
        if (calcCompCellConstraints.isFixed()) {
            return;
        }
        if (calcCompCellConstraints.isFitted()) {
            return;
        }
        if (calcCompCellConstraints.isFitting()) {
            throw new Error(this.getClass() + ": constraints are cyclic (found at cell " + calcCompCellConstraints.getName() + ")");
        }
        if (this.conHash == null) {
            throw new Error(this.getClass() + ".processFitCell: conHash has not been built");
        }
        calcCompCellConstraints.setFitting(true);
        boolean bl = false;
        if (bl || this.DBGfitting) {
            System.err.println("->fitting cell " + calcCompCellConstraints.name);
        }
        calcCompCellConstraints.setMajorGrid(false);
        if (calcCompCellConstraints.hasNorthLink()) {
            calcCompCellConstraints2 = this.conHash.get(calcCompCellConstraints.getLinkNorth());
            if (calcCompCellConstraints2 != null) {
                if (!calcCompCellConstraints2.isFitted()) {
                    this.processFitCell(calcCompCellConstraints2);
                }
                calcCompCellConstraints.setRow(calcCompCellConstraints2.getMaxRow() + 1 + calcCompCellConstraints.getOffsetNorth() + calcCompCellConstraints.getInnerPan());
            }
        } else if (!calcCompCellConstraints.hasSouthLink()) {
            calcCompCellConstraints.setRow(0 + calcCompCellConstraints.getOuterPan());
        }
        if (calcCompCellConstraints.hasWestLink()) {
            calcCompCellConstraints2 = this.conHash.get(calcCompCellConstraints.getLinkWest());
            if (calcCompCellConstraints2 != null) {
                if (!calcCompCellConstraints2.isFitted()) {
                    this.processFitCell(calcCompCellConstraints2);
                }
                calcCompCellConstraints.setCol(calcCompCellConstraints2.getMaxCol() + 1 + calcCompCellConstraints.getOffsetWest() + calcCompCellConstraints.getInnerPan());
            }
        } else if (!calcCompCellConstraints.hasEastLink()) {
            calcCompCellConstraints.setCol(0 + calcCompCellConstraints.getOuterPan());
        }
        if (calcCompCellConstraints.hasSouthLink() && (calcCompCellConstraints2 = this.conHash.get(calcCompCellConstraints.getLinkSouth())) != null) {
            if (!calcCompCellConstraints2.isFitted()) {
                this.processFitCell(calcCompCellConstraints2);
            }
            calcCompCellConstraints.setRow(calcCompCellConstraints2.getRow() - calcCompCellConstraints.getInnerPan() - calcCompCellConstraints.getOffsetSouth() - calcCompCellConstraints.getRowspan());
        }
        if (calcCompCellConstraints.hasEastLink() && (calcCompCellConstraints2 = this.conHash.get(calcCompCellConstraints.getLinkEast())) != null) {
            if (!calcCompCellConstraints2.isFitted()) {
                this.processFitCell(calcCompCellConstraints2);
            }
            calcCompCellConstraints.setCol(calcCompCellConstraints2.getCol() - calcCompCellConstraints.getInnerPan() - calcCompCellConstraints.getOffsetEast() - calcCompCellConstraints.getColspan());
        }
        if (bl || this.DBGfitting) {
            System.err.println("<-don fit cell " + calcCompCellConstraints.name + " :(c[s]/r[s]) " + calcCompCellConstraints.getCol() + "[" + calcCompCellConstraints.getColspan() + "]/" + calcCompCellConstraints.getRow() + "[" + calcCompCellConstraints.getRowspan() + "]");
        }
        calcCompCellConstraints.setFitted(true);
        calcCompCellConstraints.setFitting(false);
    }

    protected void processStretchCell(CalcCompCellConstraints calcCompCellConstraints) {
        int n;
        int n2;
        int n3;
        if (!calcCompCellConstraints.isFitted()) {
            return;
        }
        if (!calcCompCellConstraints.isStretching()) {
            return;
        }
        if (this.conHash == null) {
            throw new Error(this.getClass() + ".processFitCell: conHash has not been built");
        }
        if (calcCompCellConstraints.isStretchColspan()) {
            n3 = calcCompCellConstraints.col;
            n2 = this.gridSize.width - 1 - this.shrinkPan;
            if (calcCompCellConstraints.hasWestLink()) {
                n3 = this.conHash.get(calcCompCellConstraints.getLinkWest()).getMaxCol() + 1;
                n3 += calcCompCellConstraints.getInnerPan();
            }
            if (calcCompCellConstraints.hasEastLink()) {
                n2 = this.conHash.get(calcCompCellConstraints.getLinkEast()).getCol() - 1;
                n2 -= calcCompCellConstraints.getInnerPan();
            }
            if ((n = n2 - n3 + 1) < 1) {
                n = 1;
            }
            calcCompCellConstraints.setColspan(n);
        }
        if (calcCompCellConstraints.isStretchRowspan()) {
            n3 = calcCompCellConstraints.row;
            n2 = this.gridSize.height - 1 - this.shrinkPan;
            if (calcCompCellConstraints.hasNorthLink()) {
                n3 = this.conHash.get(calcCompCellConstraints.getLinkNorth()).getMaxRow() + 1;
                n3 += calcCompCellConstraints.getInnerPan();
            }
            if (calcCompCellConstraints.hasSouthLink()) {
                n2 = this.conHash.get(calcCompCellConstraints.getLinkSouth()).getRow() - 1;
                n2 -= calcCompCellConstraints.getInnerPan();
            }
            if ((n = n2 - n3 + 1) < 1) {
                n = 1;
            }
            calcCompCellConstraints.setRowspan(n);
        }
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof CalcCompCellConstraints) {
            CalcCompCellConstraints calcCompCellConstraints = (CalcCompCellConstraints)object;
            if (calcCompCellConstraints.colspan <= 0 || calcCompCellConstraints.rowspan <= 0) {
                throw new IllegalArgumentException("cannot add to layout: cell must have positive colspan and rowspan");
            }
            if (calcCompCellConstraints.col < 0 || calcCompCellConstraints.row < 0) {
                throw new IllegalArgumentException("cannot add to layout: cell col and row must be >= 0");
            }
            this.setConstraints(component, calcCompCellConstraints);
        } else if (object != null) {
            throw new IllegalArgumentException("cannot add to layout: constraint must be a CellConstraint");
        }
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return this.alignmentX;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return this.alignmentY;
    }

    @Override
    public void invalidateLayout(Container container) {
        int n;
        boolean bl = false;
        if (bl || this.DBGforce) {
            System.err.println("invalidateLayout: " + container);
        }
        if ((n = container.getComponentCount()) == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            CalcCompCellConstraints calcCompCellConstraints = this.compTable.get(component);
            if (calcCompCellConstraints == null) continue;
            if (bl || this.DBGreset) {
                System.err.println("  reset cell " + calcCompCellConstraints.name);
            }
            calcCompCellConstraints.setFitted(false);
            calcCompCellConstraints.setFitting(false);
            calcCompCellConstraints.updateSpans();
        }
    }

    public float getAlignmentX() {
        return this.alignmentX;
    }

    public void setAlignmentX(float f) {
        this.alignmentX = f;
    }

    public float getAlignmentY() {
        return this.alignmentY;
    }

    public void setAlignmentY(float f) {
        this.alignmentY = f;
    }

    public boolean isShrinkWrap() {
        return this.shrinkWrap;
    }

    public void setShrinkWrap(boolean bl) {
        this.shrinkWrap = bl;
    }

    public Dimension getMajorGridSize() {
        return this.majorGridSize;
    }

    public void setMajorGridSize(Dimension dimension) {
        this.majorGridSize = dimension;
    }

    public int getShrinkPan() {
        return this.shrinkPan;
    }

    public void setShrinkPan(int n) {
        this.shrinkPan = n;
    }

    public Dimension getMinCellSize() {
        return this.minCellSize;
    }

    public void setMinCellSize(Dimension dimension) {
        this.minCellSize = dimension;
    }

    public boolean isFixedCellSize() {
        return this.fixedCellSize;
    }

    public void setFixedCellSize(boolean bl) {
        this.fixedCellSize = bl;
    }

    public boolean isForceFixedCellSize() {
        return this.forceFixedCellSize;
    }

    public void setForceFixedCellSize(boolean bl) {
        this.forceFixedCellSize = bl;
    }

    class VertSpec {
        int yt;
        int yb;

        public VertSpec(int n, int n2) {
            this.yt = n;
            this.yb = n2;
        }
    }

    class HorzSpec {
        int xl;
        int xr;

        public HorzSpec(int n, int n2) {
            this.xl = n;
            this.xr = n2;
        }
    }
}

