/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.ui;

import de.admadic.calculator.ui.CalcCompCellConstraints;
import java.awt.Dimension;
import java.util.Hashtable;
import java.util.Iterator;

public class CalcCompGroup {
    String name;
    CalcCompCellConstraints groupCell;
    Hashtable<String, CalcCompCellConstraints> cells = new Hashtable();
    Dimension gridSize;

    public CalcCompGroup(String string) {
        this(string, 1, 1);
    }

    public CalcCompGroup(String string, int n, int n2) {
        this.name = string;
        this.gridSize = new Dimension(n, n2);
        this.groupCell = new CalcCompCellConstraints("(group)", 0, 0, n, n2);
    }

    public void addByRow(String string) {
        this.addByRow(string, 1);
    }

    public void addByCol(String string) {
        this.addByCol(string, 1);
    }

    public void addByRow(String string, int n) {
        CalcCompCellConstraints calcCompCellConstraints2;
        if (this.cells.contains(string)) {
            return;
        }
        int[] nArray = new int[this.gridSize.height];
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = -1;
        }
        for (CalcCompCellConstraints calcCompCellConstraints2 : this.cells.values()) {
            if (calcCompCellConstraints2.getMaxCol() > nArray[calcCompCellConstraints2.row]) {
                nArray[calcCompCellConstraints2.row] = calcCompCellConstraints2.getMaxCol();
            }
            if (calcCompCellConstraints2.row <= n2) continue;
            n2 = calcCompCellConstraints2.row;
        }
        int n3 = n2;
        int n4 = nArray[n3];
        if (++n4 + n - 1 >= this.gridSize.width) {
            ++n3;
            n4 = 0;
        }
        if (n3 >= this.gridSize.height) {
            return;
        }
        calcCompCellConstraints2 = new CalcCompCellConstraints(string, n4, n3, n, 1);
        this.cells.put(string, calcCompCellConstraints2);
    }

    public void addByCol(String string, int n) {
        CalcCompCellConstraints calcCompCellConstraints2;
        if (this.cells.contains(string)) {
            return;
        }
        int[] nArray = new int[this.gridSize.width];
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = -1;
        }
        for (CalcCompCellConstraints calcCompCellConstraints2 : this.cells.values()) {
            if (calcCompCellConstraints2.getMaxRow() > nArray[calcCompCellConstraints2.col]) {
                nArray[calcCompCellConstraints2.col] = calcCompCellConstraints2.getMaxRow();
            }
            if (calcCompCellConstraints2.col <= n2) continue;
            n2 = calcCompCellConstraints2.col;
        }
        int n3 = n2;
        int n4 = nArray[n3];
        if (++n4 + n - 1 >= this.gridSize.height) {
            ++n3;
            n4 = 0;
        }
        if (n3 >= this.gridSize.width) {
            return;
        }
        calcCompCellConstraints2 = new CalcCompCellConstraints(string, n3, n4, 1, n);
        this.cells.put(string, calcCompCellConstraints2);
    }

    public void addAt(String string, int n, int n2, int n3, int n4) {
        if (this.cells.contains(string)) {
            return;
        }
        CalcCompCellConstraints calcCompCellConstraints = new CalcCompCellConstraints(string, n, n2, n3, n4);
        this.cells.put(string, calcCompCellConstraints);
    }

    public CalcCompGroup expandGrid(int n, int n2, int n3) {
        CalcCompGroup calcCompGroup = null;
        int n4 = this.gridSize.width * (n + n2) + n + 2 * n3;
        int n5 = this.gridSize.height * (n + n2) + n + 2 * n3;
        calcCompGroup = new CalcCompGroup(this.name, n4, n5);
        Iterator<CalcCompCellConstraints> iterator = this.getIterator();
        if (iterator == null) {
            return null;
        }
        while (iterator.hasNext()) {
            CalcCompCellConstraints calcCompCellConstraints = iterator.next();
            CalcCompCellConstraints calcCompCellConstraints2 = new CalcCompCellConstraints(calcCompCellConstraints.name, n3 + n + calcCompCellConstraints.col * (n2 + n), n3 + n + calcCompCellConstraints.row * (n2 + n), calcCompCellConstraints.colspan * (n + n2) - n, calcCompCellConstraints.rowspan * (n + n2) - n);
            calcCompGroup.cells.put(calcCompCellConstraints2.name, calcCompCellConstraints2);
        }
        calcCompGroup.updateGridSize();
        return calcCompGroup;
    }

    public void shrinkRow(int n, int n2) {
        this.groupCell.rowspan -= n2;
        Iterator<CalcCompCellConstraints> iterator = this.getIterator();
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            CalcCompCellConstraints calcCompCellConstraints = iterator.next();
            if (calcCompCellConstraints.getMaxRow() < n) continue;
            if (calcCompCellConstraints.getRow() > n + n2 - 1) {
                calcCompCellConstraints.translate(0, -n2);
                continue;
            }
            int n3 = 0;
            if (calcCompCellConstraints.getRow() > n) {
                n3 = calcCompCellConstraints.getRow() - n;
                calcCompCellConstraints.translate(0, -n3);
            }
            calcCompCellConstraints.rowspan -= n2 - n3;
        }
    }

    public String toString() {
        Object object = "";
        object = (String)object + this.getClass() + ":[";
        object = (String)object + "name=" + this.name;
        object = (String)object + ", grid=" + this.gridSize;
        object = (String)object + ", groupCell=" + this.groupCell + "\n";
        object = (String)object + "elements (" + this.cells.size() + ")\n";
        Iterator<CalcCompCellConstraints> iterator = this.getIterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                CalcCompCellConstraints calcCompCellConstraints = iterator.next();
                object = (String)object + "  cell=" + calcCompCellConstraints + "\n";
            }
        }
        object = (String)object + "]";
        return object;
    }

    public void updateGridSize() {
        CalcCompCellConstraints calcCompCellConstraints2;
        int n = 0;
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MAX_VALUE;
        if (this.cells == null) {
            return;
        }
        for (CalcCompCellConstraints calcCompCellConstraints2 : this.cells.values()) {
            if (calcCompCellConstraints2.getMaxCol() > n) {
                n = calcCompCellConstraints2.getMaxCol();
            }
            if (calcCompCellConstraints2.getMaxRow() > n2) {
                n2 = calcCompCellConstraints2.getMaxRow();
            }
            if (calcCompCellConstraints2.getCol() < n3) {
                n3 = calcCompCellConstraints2.getCol();
            }
            if (calcCompCellConstraints2.getRow() >= n4) continue;
            n4 = calcCompCellConstraints2.getRow();
        }
        calcCompCellConstraints2 = this.groupCell;
        if (calcCompCellConstraints2.getMaxCol() > n) {
            n = calcCompCellConstraints2.getMaxCol();
        }
        if (calcCompCellConstraints2.getMaxRow() > n2) {
            n2 = calcCompCellConstraints2.getMaxRow();
        }
        if (calcCompCellConstraints2.getCol() < n3) {
            n3 = calcCompCellConstraints2.getCol();
        }
        if (calcCompCellConstraints2.getRow() < n4) {
            n4 = calcCompCellConstraints2.getRow();
        }
        int n5 = n - n3 + 1;
        int n6 = n2 - n4 + 1;
        this.setGridSize(n5, n6);
    }

    public void translate(int n, int n2) {
        Iterator<CalcCompCellConstraints> iterator = this.getIterator();
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            CalcCompCellConstraints calcCompCellConstraints = iterator.next();
            calcCompCellConstraints.translate(n, n2);
        }
        this.groupCell.translate(n, n2);
        this.updateGridSize();
    }

    public Iterator<CalcCompCellConstraints> getIterator() {
        if (this.cells.isEmpty()) {
            return null;
        }
        return this.cells.values().iterator();
    }

    public CalcCompCellConstraints getCellInfo(String string) {
        if (this.cells.contains(string)) {
            return this.cells.get(string);
        }
        return null;
    }

    public CalcCompCellConstraints getGroupCell() {
        return this.groupCell;
    }

    public void setGroupCell(CalcCompCellConstraints calcCompCellConstraints) {
        this.groupCell = calcCompCellConstraints;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Dimension getGridSize() {
        return new Dimension(this.gridSize);
    }

    public void setGridSize(int n, int n2) {
        this.gridSize = new Dimension(n, n2);
    }

    public void setGridSize(Dimension dimension) {
        this.gridSize = new Dimension(dimension);
    }
}

