/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.ui;

public class CalcCompCellConstraints {
    public static final int FIT_NONE = -1;
    public static final int FIT_FIXED = 0;
    public static final int FIT_BY_COL = 1;
    public static final int FIT_BY_ROW = 2;
    public static final int FIT_DEFAULT = 2;
    public static final int NORTH = 0;
    public static final int WEST = 1;
    public static final int EAST = 2;
    public static final int SOUTH = 3;
    public static final int DIRECTIONS = 4;
    String name;
    int col;
    int row;
    int colspanBase;
    int rowspanBase;
    int colspan;
    int rowspan;
    boolean stretchColspan;
    boolean stretchRowspan;
    int majorGridWidth;
    int majorGridHeight;
    int innerPan;
    int outerPan;
    boolean majorGrid;
    int fit;
    boolean fitted;
    boolean fitting;
    Link[] links;
    String linkNorth;
    int offsetNorth;
    String linkWest;
    int offsetWest;
    String linkSouth;
    int offsetSouth;
    String linkEast;
    int offsetEast;
    boolean layoutComponents;
    boolean template;

    public String toString() {
        Object object = "";
        object = "CalcCompCellConstraints:( cmd=" + this.name + " col=" + this.col + " row=" + this.row + " colspan=" + this.colspan + " rowspan=" + this.rowspan;
        object = (String)object + " )";
        return object;
    }

    public CalcCompCellConstraints(CalcCompCellConstraints calcCompCellConstraints) {
        this.template = calcCompCellConstraints.template;
        this.name = calcCompCellConstraints.name;
        this.col = calcCompCellConstraints.col;
        this.row = calcCompCellConstraints.row;
        this.colspan = calcCompCellConstraints.colspan;
        this.rowspan = calcCompCellConstraints.rowspan;
        this.colspanBase = calcCompCellConstraints.colspanBase;
        this.rowspanBase = calcCompCellConstraints.rowspanBase;
        this.majorGrid = calcCompCellConstraints.majorGrid;
        this.majorGridWidth = calcCompCellConstraints.majorGridWidth;
        this.majorGridHeight = calcCompCellConstraints.majorGridHeight;
        this.fit = calcCompCellConstraints.fit;
        this.linkNorth = calcCompCellConstraints.linkNorth;
        this.offsetNorth = calcCompCellConstraints.offsetNorth;
        this.linkWest = calcCompCellConstraints.linkWest;
        this.offsetWest = calcCompCellConstraints.offsetWest;
        this.linkEast = calcCompCellConstraints.linkEast;
        this.offsetEast = calcCompCellConstraints.offsetEast;
        this.linkSouth = calcCompCellConstraints.linkSouth;
        this.offsetSouth = calcCompCellConstraints.offsetSouth;
        this.layoutComponents = calcCompCellConstraints.layoutComponents;
        this.innerPan = calcCompCellConstraints.innerPan;
        this.outerPan = calcCompCellConstraints.outerPan;
        this.fitted = calcCompCellConstraints.fitted;
        this.fitting = calcCompCellConstraints.fitting;
        this.stretchColspan = calcCompCellConstraints.stretchColspan;
        this.stretchRowspan = calcCompCellConstraints.stretchRowspan;
        this.links = new Link[4];
        if (calcCompCellConstraints.links != null) {
            try {
                for (int i = 0; i < this.links.length; ++i) {
                    this.links[i] = calcCompCellConstraints.links[i] != null ? calcCompCellConstraints.links[i].clone() : calcCompCellConstraints.links[i];
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
    }

    public CalcCompCellConstraints(String string) {
        this(string, 0, 0, 1, 1, 2, true);
    }

    public CalcCompCellConstraints(String string, int n, int n2) {
        this(string, n, n2, 1, 1, 2, true);
    }

    public CalcCompCellConstraints(String string, int n, int n2, int n3, int n4) {
        this(string, n, n2, n3, n4, 2, true);
    }

    public CalcCompCellConstraints(String string, int n, int n2, int n3, boolean bl) {
        this(string, 0, 0, n, n2, n3, bl);
    }

    public CalcCompCellConstraints(String string, int n, int n2, int n3, int n4, int n5, boolean bl) {
        this.template = false;
        this.majorGridWidth = 1;
        this.majorGridHeight = 1;
        this.name = string;
        this.col = n;
        this.row = n2;
        this.colspanBase = n3;
        this.rowspanBase = n4;
        this.fit = n5;
        this.majorGrid = bl;
        this.links = new Link[4];
        this.linkNorth = "";
        this.offsetNorth = 0;
        this.linkWest = "";
        this.offsetWest = 0;
        this.linkEast = "";
        this.offsetEast = 0;
        this.linkSouth = "";
        this.offsetSouth = 0;
        this.layoutComponents = false;
        this.innerPan = 0;
        this.outerPan = 0;
        this.fitted = false;
        this.fitting = false;
        this.stretchColspan = false;
        this.stretchRowspan = false;
        this.updateSpans();
    }

    public static CalcCompCellConstraints[] createGrid(int n, int n2, String[] stringArray) {
        return CalcCompCellConstraints.createGrid(n, n2, stringArray, null, 2, null);
    }

    public static CalcCompCellConstraints[] createGrid(int n, int n2, String[] stringArray, String string, int n3, CalcCompCellConstraints calcCompCellConstraints) {
        int n4;
        int n5 = n * n2;
        if (calcCompCellConstraints == null) {
            calcCompCellConstraints = new CalcCompCellConstraints("<template>");
            calcCompCellConstraints.defineSpan(1, 1);
        }
        if (n3 != -1) {
            calcCompCellConstraints.defineFit(n3);
        }
        if (stringArray == null) {
            stringArray = new String[n5];
        } else if (stringArray.length < n5) {
            String[] stringArray2 = new String[n5];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray = stringArray2;
        }
        for (n4 = 0; n4 < stringArray.length; ++n4) {
            if (stringArray[n4] != null && !stringArray[n4].equals("")) continue;
            stringArray[n4] = (string == null ? "cell" : string) + Integer.toString(n4);
        }
        CalcCompCellConstraints[] calcCompCellConstraintsArray = new CalcCompCellConstraints[n5];
        for (int i = 0; i < n5; ++i) {
            calcCompCellConstraintsArray[i] = new CalcCompCellConstraints(calcCompCellConstraints);
            calcCompCellConstraintsArray[i].resetLinks();
            calcCompCellConstraintsArray[i].setName(stringArray[i]);
            switch (calcCompCellConstraints.fit) {
                case -1: 
                case 0: {
                    throw new Error("CalcCompCellConstraints.createGrid: fit NONE or FIXED is not allowed.");
                }
                case 1: {
                    int n6 = i / n2;
                    n4 = i % n2;
                    if (n6 > 0) {
                        calcCompCellConstraintsArray[i].setLinkWest(calcCompCellConstraintsArray[i - n2].getName(), 0);
                    } else if (calcCompCellConstraints.hasWestLink()) {
                        calcCompCellConstraintsArray[i].setLinkWest(calcCompCellConstraints.getLinkWest(), calcCompCellConstraints.getOffsetWest());
                    }
                    if (n4 > 0) {
                        calcCompCellConstraintsArray[i].setLinkNorth(calcCompCellConstraintsArray[i - 1].getName(), 0);
                        break;
                    }
                    if (!calcCompCellConstraints.hasNorthLink()) break;
                    calcCompCellConstraintsArray[i].setLinkNorth(calcCompCellConstraints.getLinkNorth(), calcCompCellConstraints.getOffsetNorth());
                    break;
                }
                case 2: {
                    int n6 = i % n;
                    n4 = i / n;
                    if (n6 > 0) {
                        calcCompCellConstraintsArray[i].setLinkWest(calcCompCellConstraintsArray[i - 1].getName(), 0);
                    } else if (calcCompCellConstraints.hasWestLink()) {
                        calcCompCellConstraintsArray[i].setLinkWest(calcCompCellConstraints.getLinkWest(), calcCompCellConstraints.getOffsetWest());
                    }
                    if (n4 > 0) {
                        calcCompCellConstraintsArray[i].setLinkNorth(calcCompCellConstraintsArray[i - n].getName(), 0);
                        break;
                    }
                    if (!calcCompCellConstraints.hasNorthLink()) break;
                    calcCompCellConstraintsArray[i].setLinkNorth(calcCompCellConstraints.getLinkNorth(), calcCompCellConstraints.getOffsetNorth());
                    break;
                }
                default: {
                    throw new Error("CalcCompCellConstraints.createGrid: invalid fit value: " + calcCompCellConstraints.fit);
                }
            }
            calcCompCellConstraintsArray[i].setCol(n6 *= calcCompCellConstraints.getColspan());
            calcCompCellConstraintsArray[i].setRow(n4 *= calcCompCellConstraints.getRowspan());
        }
        return calcCompCellConstraintsArray;
    }

    public static void mergeCells(CalcCompCellConstraints calcCompCellConstraints, CalcCompCellConstraints calcCompCellConstraints2) {
        if (calcCompCellConstraints.getCol() == calcCompCellConstraints2.getCol()) {
            if (!calcCompCellConstraints.hasWestLink() && calcCompCellConstraints2.hasWestLink()) {
                calcCompCellConstraints.setLinkWest(calcCompCellConstraints2.getLinkWest(), calcCompCellConstraints2.getOffsetWest());
            }
            if (!calcCompCellConstraints.hasEastLink() && calcCompCellConstraints2.hasEastLink()) {
                calcCompCellConstraints.setLinkEast(calcCompCellConstraints2.getLinkEast(), calcCompCellConstraints2.getOffsetEast());
            }
            if (!calcCompCellConstraints.hasSouthLink() && calcCompCellConstraints2.hasSouthLink()) {
                calcCompCellConstraints.setLinkSouth(calcCompCellConstraints2.getLinkSouth(), calcCompCellConstraints2.getOffsetSouth());
            }
            calcCompCellConstraints.rowspanBase += calcCompCellConstraints2.rowspanBase;
        } else if (calcCompCellConstraints.getRow() == calcCompCellConstraints2.getRow()) {
            if (!calcCompCellConstraints.hasNorthLink() && calcCompCellConstraints2.hasNorthLink()) {
                calcCompCellConstraints.setLinkNorth(calcCompCellConstraints2.getLinkNorth(), calcCompCellConstraints2.getOffsetNorth());
            }
            if (!calcCompCellConstraints.hasSouthLink() && calcCompCellConstraints2.hasSouthLink()) {
                calcCompCellConstraints.setLinkSouth(calcCompCellConstraints2.getLinkSouth(), calcCompCellConstraints2.getOffsetSouth());
            }
            if (!calcCompCellConstraints.hasEastLink() && calcCompCellConstraints2.hasEastLink()) {
                calcCompCellConstraints.setLinkEast(calcCompCellConstraints2.getLinkEast(), calcCompCellConstraints2.getOffsetEast());
            }
            calcCompCellConstraints.colspanBase += calcCompCellConstraints2.colspanBase;
        } else {
            throw new Error("Cannot merge cells without same col or same row");
        }
    }

    public static CalcCompCellConstraints[] mergeCells(CalcCompCellConstraints[] calcCompCellConstraintsArray, String[] stringArray) {
        int n;
        if (calcCompCellConstraintsArray == null) {
            return null;
        }
        if (stringArray == null) {
            return calcCompCellConstraintsArray;
        }
        if (stringArray.length <= 1) {
            return calcCompCellConstraintsArray;
        }
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                throw new Error("some names for cells to merge are null");
            }
            if (stringArray[i].equals("")) {
                throw new Error("some names for cells to merge are empty");
            }
            nArray[i] = -1;
            for (n = 0; n < calcCompCellConstraintsArray.length; ++n) {
                if (!calcCompCellConstraintsArray[n].getName().equals(stringArray[i])) continue;
                nArray[i] = n;
                break;
            }
            if (nArray[i] != -1) continue;
            throw new Error("some names cannot be found in constraints (" + stringArray[i] + ")");
        }
        CalcCompCellConstraints[] calcCompCellConstraintsArray2 = new CalcCompCellConstraints[calcCompCellConstraintsArray.length - stringArray.length + 1];
        n = 0;
        for (int i = 0; i < calcCompCellConstraintsArray.length; ++i) {
            boolean bl = false;
            int n2 = -1;
            for (int j = 1; j < nArray.length; ++j) {
                if (i != nArray[j]) continue;
                bl = true;
                n2 = j;
                break;
            }
            if (bl) {
                CalcCompCellConstraints calcCompCellConstraints = calcCompCellConstraintsArray[nArray[0]];
                CalcCompCellConstraints calcCompCellConstraints2 = calcCompCellConstraintsArray[nArray[n2]];
                CalcCompCellConstraints.mergeCells(calcCompCellConstraints, calcCompCellConstraints2);
                continue;
            }
            calcCompCellConstraintsArray2[n] = calcCompCellConstraintsArray[i];
            ++n;
        }
        return calcCompCellConstraintsArray2;
    }

    public static CalcCompCellConstraints[] removeCells(CalcCompCellConstraints[] calcCompCellConstraintsArray, String[] stringArray) {
        if (calcCompCellConstraintsArray == null) {
            return null;
        }
        if (stringArray == null) {
            return calcCompCellConstraintsArray;
        }
        if (stringArray.length <= 1) {
            return calcCompCellConstraintsArray;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                throw new Error("some names for cells to remove are null");
            }
            if (!stringArray[i].equals("")) continue;
            throw new Error("some names for cells to remove are empty");
        }
        CalcCompCellConstraints[] calcCompCellConstraintsArray2 = new CalcCompCellConstraints[calcCompCellConstraintsArray.length - stringArray.length];
        int n = 0;
        for (int i = 0; i < calcCompCellConstraintsArray.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < stringArray.length; ++j) {
                if (!calcCompCellConstraintsArray[i].getName().equals(stringArray[j])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            calcCompCellConstraintsArray2[n] = calcCompCellConstraintsArray[i];
            ++n;
        }
        return calcCompCellConstraintsArray;
    }

    public CalcCompCellConstraints defineSpan(int n, int n2) {
        this.colspanBase = n;
        this.rowspanBase = n2;
        this.updateSpans();
        return this;
    }

    public CalcCompCellConstraints defineFit(int n) {
        this.fit = n;
        return this;
    }

    public CalcCompCellConstraints definePlace(int n, int n2) {
        this.col = n;
        this.row = n2;
        return this;
    }

    public CalcCompCellConstraints defineMajorGrid(int n, int n2) {
        this.majorGridWidth = n;
        this.majorGridHeight = n2;
        this.updateSpans();
        return this;
    }

    public CalcCompCellConstraints defineLinkNorth(String string) {
        this.linkNorth = string;
        return this;
    }

    public CalcCompCellConstraints defineLinkWest(String string) {
        this.linkWest = string;
        return this;
    }

    public CalcCompCellConstraints defineLinkEast(String string) {
        this.linkEast = string;
        return this;
    }

    public CalcCompCellConstraints defineLinkSouth(String string) {
        this.linkSouth = string;
        return this;
    }

    public CalcCompCellConstraints defineLinkNorth(String string, int n) {
        this.linkNorth = string;
        this.offsetNorth = n;
        return this;
    }

    public CalcCompCellConstraints defineLinkWest(String string, int n) {
        this.linkWest = string;
        this.offsetWest = n;
        return this;
    }

    public CalcCompCellConstraints defineLinkEast(String string, int n) {
        this.linkEast = string;
        this.offsetEast = n;
        return this;
    }

    public CalcCompCellConstraints defineLinkSouth(String string, int n) {
        this.linkSouth = string;
        this.offsetSouth = n;
        return this;
    }

    public CalcCompCellConstraints defineLayoutComponents(boolean bl) {
        this.layoutComponents = bl;
        return this;
    }

    public CalcCompCellConstraints definePan(int n, int n2) {
        this.innerPan = n;
        this.outerPan = n2;
        this.updateSpans();
        return this;
    }

    public CalcCompCellConstraints defineStretch(boolean bl, boolean bl2) {
        this.stretchColspan = bl;
        this.stretchRowspan = bl2;
        return this;
    }

    public void translate(int n, int n2) {
        this.col += n;
        this.row += n2;
    }

    public void resetLinks() {
        this.setLinkNorth(null);
        this.setLinkWest(null);
        this.setLinkEast(null);
        this.setLinkSouth(null);
    }

    public void updateSpans() {
        this.colspan = this.colspanBase * this.majorGridWidth + (this.colspanBase - 1) * this.innerPan;
        this.rowspan = this.rowspanBase * this.majorGridHeight + (this.rowspanBase - 1) * this.innerPan;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getCol() {
        return this.col;
    }

    public void setCol(int n) {
        this.col = n;
    }

    public int getColspan() {
        return this.colspan;
    }

    public void setColspan(int n) {
        this.colspan = n;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int n) {
        this.row = n;
    }

    public int getRowspan() {
        return this.rowspan;
    }

    public void setRowspan(int n) {
        this.rowspan = n;
    }

    public int getMaxRow() {
        return this.row + this.rowspan - 1;
    }

    public int getMaxCol() {
        return this.col + this.colspan - 1;
    }

    public boolean isLayoutComponents() {
        return this.layoutComponents;
    }

    public void setLayoutComponents(boolean bl) {
        this.layoutComponents = bl;
    }

    public String getLinkEast() {
        return this.linkEast;
    }

    public void setLinkEast(String string) {
        this.setLinkEast(string, 0);
    }

    public void setLinkEast(String string, int n) {
        this.linkEast = string;
        this.offsetEast = n;
    }

    public String getLinkNorth() {
        return this.linkNorth;
    }

    public void setLinkNorth(String string) {
        this.setLinkNorth(string, 0);
    }

    public void setLinkNorth(String string, int n) {
        this.linkNorth = string;
        this.offsetNorth = n;
    }

    public String getLinkSouth() {
        return this.linkSouth;
    }

    public void setLinkSouth(String string) {
        this.setLinkSouth(string, 0);
    }

    public void setLinkSouth(String string, int n) {
        this.linkSouth = string;
        this.offsetSouth = n;
    }

    public String getLinkWest() {
        return this.linkWest;
    }

    public void setLinkWest(String string) {
        this.setLinkWest(string, 0);
    }

    public void setLinkWest(String string, int n) {
        this.linkWest = string;
        this.offsetWest = n;
    }

    public int getOffsetEast() {
        return this.offsetEast;
    }

    public void setOffsetEast(int n) {
        this.offsetEast = n;
    }

    public int getOffsetNorth() {
        return this.offsetNorth;
    }

    public void setOffsetNorth(int n) {
        this.offsetNorth = n;
    }

    public int getOffsetSouth() {
        return this.offsetSouth;
    }

    public void setOffsetSouth(int n) {
        this.offsetSouth = n;
    }

    public int getOffsetWest() {
        return this.offsetWest;
    }

    public void setOffsetWest(int n) {
        this.offsetWest = n;
    }

    public boolean isMajorGrid() {
        return this.majorGrid;
    }

    public void setMajorGrid(boolean bl) {
        this.majorGrid = bl;
    }

    public int getInnerPan() {
        return this.innerPan;
    }

    public void setInnerPan(int n) {
        this.innerPan = n;
    }

    public int getOuterPan() {
        return this.outerPan;
    }

    public void setOuterPan(int n) {
        this.outerPan = n;
    }

    public boolean isFitted() {
        return this.fitted;
    }

    public void setFitted(boolean bl) {
        this.fitted = bl;
    }

    public boolean isFitting() {
        return this.fitting;
    }

    public void setFitting(boolean bl) {
        this.fitting = bl;
    }

    public boolean hasNorthLink() {
        return this.linkNorth != null && !this.linkNorth.equals("");
    }

    public boolean hasWestLink() {
        return this.linkWest != null && !this.linkWest.equals("");
    }

    public boolean hasEastLink() {
        return this.linkEast != null && !this.linkEast.equals("");
    }

    public boolean hasSouthLink() {
        return this.linkSouth != null && !this.linkSouth.equals("");
    }

    public boolean isFixed() {
        return this.fit == 0;
    }

    public boolean isStretching() {
        return this.stretchColspan || this.stretchRowspan;
    }

    public boolean isStretchColspan() {
        return this.stretchColspan;
    }

    public void setStretchColspan(boolean bl) {
        this.stretchColspan = bl;
    }

    public boolean isStretchRowspan() {
        return this.stretchRowspan;
    }

    public void setStretchRowspan(boolean bl) {
        this.stretchRowspan = bl;
    }

    public int getColspanBase() {
        return this.colspanBase;
    }

    public void setColspanBase(int n) {
        this.colspanBase = n;
    }

    public int getRowspanBase() {
        return this.rowspanBase;
    }

    public void setRowspanBase(int n) {
        this.rowspanBase = n;
    }

    public int getMajorGridHeight() {
        return this.majorGridHeight;
    }

    public void setMajorGridHeight(int n) {
        this.majorGridHeight = n;
    }

    public int getMajorGridWidth() {
        return this.majorGridWidth;
    }

    public void setMajorGridWidth(int n) {
        this.majorGridWidth = n;
    }

    public boolean isTemplate() {
        return this.template;
    }

    public void setTemplate(boolean bl) {
        this.template = bl;
    }

    public static class Link
    implements Cloneable {
        public static final int SRC_OUTERPAN = 0;
        public static final int SRC_INNERPAN = 1;
        public static final int DST_OUTERPAN = 2;
        public static final int DST_INNERPAN = 3;
        String cellName;
        int type;
        int value;

        public Link(String string, int n, int n2) {
            this.cellName = string;
            this.type = n;
            this.value = n2;
        }

        public Link clone() throws CloneNotSupportedException {
            Link link = (Link)super.clone();
            link.cellName = this.cellName;
            link.type = this.type;
            link.value = this.value;
            return link;
        }
    }
}

