/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.ui;

import de.admadic.calculator.ui.CmdEntry;
import de.admadic.calculator.ui.CmdStyleGrp;
import de.admadic.ui.util.Colorizer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;

public class CalcButton
extends JButton {
    private static final long serialVersionUID = 1L;
    Image bgImage = null;
    BufferedImage bufImg = null;
    int iw;
    int ih;
    boolean regionCheckEnabled = false;
    CmdEntry cmdE = null;
    CmdStyleGrp cmdG = null;
    boolean useCustomFont = false;
    boolean useCustomGfx = false;

    public CalcButton() {
    }

    public CalcButton(Action action) {
        super(action);
    }

    public CalcButton(Icon icon) {
        super(icon);
    }

    public CalcButton(String string, Icon icon) {
        super(string, icon);
    }

    public CalcButton(String string) {
        super(string);
    }

    public void initBgImage(Image image, boolean bl) {
        this.bgImage = image;
        Dimension dimension = new Dimension(this.bgImage.getWidth(null), this.bgImage.getHeight(null));
        if (bl) {
            this.setPreferredSize(dimension);
        }
        this.setMinimumSize(dimension);
    }

    public void initBgImage(String string, boolean bl) {
        MediaTracker mediaTracker = new MediaTracker(this);
        URL uRL = this.getClass().getClassLoader().getResource("de/admadic/calculator/ui/res/" + string);
        this.bgImage = Toolkit.getDefaultToolkit().getImage(uRL);
        mediaTracker.addImage(this.bgImage, 0);
        try {
            mediaTracker.waitForAll();
            Dimension dimension = new Dimension(this.bgImage.getWidth(null), this.bgImage.getHeight(null));
            if (bl) {
                this.setPreferredSize(dimension);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.bgImage != null) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            graphics.drawImage(this.bgImage, (n - this.bgImage.getWidth(null)) / 2, (n2 - this.bgImage.getHeight(null)) / 2, null, null);
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paintComponent(graphics2D);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    @Override
    public boolean contains(int n, int n2) {
        if (this.bufImg == null) {
            return super.contains(n, n2);
        }
        return this.isInRegion(n, n2);
    }

    public void enableRegionCheck() {
        if (this.bgImage == null) {
            return;
        }
        this.bufImg = new BufferedImage(this.bgImage.getWidth(null), this.bgImage.getHeight(null), 2);
        Graphics graphics = this.bufImg.getGraphics();
        graphics.drawImage(this.bgImage, 0, 0, null);
        graphics.dispose();
        this.iw = this.bufImg.getWidth();
        this.ih = this.bufImg.getHeight();
        this.regionCheckEnabled = true;
    }

    public boolean isInRegion(int n, int n2) {
        if (this.bufImg == null) {
            return true;
        }
        int[] nArray = new int[4];
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        int n5 = n - (n3 - this.iw) / 2;
        int n6 = n2 - (n4 - this.ih) / 2;
        boolean bl = true;
        if (n5 < 0) {
            bl = false;
        }
        if (n6 < 0) {
            bl = false;
        }
        if (n5 >= this.iw) {
            bl = false;
        }
        if (n6 >= this.ih) {
            bl = false;
        }
        if (bl) {
            this.bufImg.getData().getPixel(n5, n6, nArray);
            if (nArray[3] == 0) {
                bl = false;
            }
        }
        return bl;
    }

    public void setCmdStyle(CmdEntry cmdEntry, CmdStyleGrp cmdStyleGrp) {
        this.cmdE = cmdEntry;
        this.cmdG = cmdStyleGrp;
        this.updateCmdStyle();
    }

    private void updateCmdStyle() {
        this.updateColor();
        if (this.isUseCustomFont()) {
            this.updateFont();
        }
        if (this.isUseCustomGfx()) {
            this.updateGfx();
        }
    }

    private void updateGfx() {
        if (this.cmdG == null || this.cmdE == null) {
            return;
        }
        Color color = this.cmdG.getTextColor();
        Color color2 = UIManager.getColor("Button.foreground");
        if (color2 == null) {
            color2 = UIManager.getColor("controlText");
        }
        Color color3 = color2;
        Color color4 = this.getBackground();
        boolean bl = false;
        Image image = this.cmdE.getIconImage(0);
        if (image != null) {
            this.initBgImage(image, true);
        }
        if (image != null) {
            bl = true;
        }
        if ((image = this.cmdE.getIconImage(1)) != null) {
            this.setIcon(Colorizer.makeIcon(image, this.cmdE.isAdjustIconColor(), color4, color3, color));
        }
        if (image != null) {
            bl = true;
        }
        if ((image = this.cmdE.getIconImage(2)) != null) {
            this.setPressedIcon(Colorizer.makeIcon(image, this.cmdE.isAdjustIconColor(), color4, color3, color));
        }
        if (image != null) {
            bl = true;
        }
        if ((image = this.cmdE.getIconImage(3)) != null) {
            this.setRolloverIcon(Colorizer.makeIcon(image, this.cmdE.isAdjustIconColor(), color4, color3, color));
        }
        if (image != null) {
            bl = true;
        }
        if ((image = this.cmdE.getIconImage(4)) != null) {
            this.setSelectedIcon(Colorizer.makeIcon(image, this.cmdE.isAdjustIconColor(), color4, color3, color));
        }
        if (image != null) {
            bl = true;
        }
        if ((image = this.cmdE.getIconImage(5)) != null) {
            this.setDisabledIcon(Colorizer.makeIcon(image, this.cmdE.isAdjustIconColor(), color4, color3, color));
        }
        if (image != null) {
            bl = true;
        }
        if ((image = this.cmdE.getIconImage(6)) != null) {
            this.setRolloverSelectedIcon(Colorizer.makeIcon(image, this.cmdE.isAdjustIconColor(), color4, color3, null));
        }
        if (image != null) {
            bl = true;
        }
        if (bl) {
            this.setText(null);
        }
    }

    private void updateFont() {
        if (this.cmdG == null) {
            return;
        }
        Font font = this.cmdG.getFont();
        if (font != null) {
            this.setFont(font);
        }
    }

    private void updateColor() {
        if (this.cmdG == null) {
            return;
        }
        Color color = this.cmdG.getTextColor();
        if (color != null) {
            Color color2 = UIManager.getColor("Button.foreground");
            if (color2 == null) {
                color2 = UIManager.getColor("controlText");
            }
            if (color2 != null) {
                color = Colorizer.adjustColor(null, color2, color);
            }
            if (color != null) {
                this.setForeground(color);
            }
        }
    }

    public boolean isUseCustomFont() {
        return this.useCustomFont;
    }

    public void setUseCustomFont(boolean bl) {
        this.useCustomFont = bl;
    }

    public boolean isUseCustomGfx() {
        return this.useCustomGfx;
    }

    public void setUseCustomGfx(boolean bl) {
        this.useCustomGfx = bl;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.updateCmdStyle();
    }
}

