/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.ui;

import de.admadic.calculator.ui.AttachedWindow;
import de.admadic.calculator.ui.PlacementListener;
import de.admadic.cfg.Cfg;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.Hashtable;

public class AttachedWindowManager
implements PlacementListener,
ComponentListener {
    ArrayList<AttachedWindow> windows;
    Hashtable<AttachedWindow, Placer> placers;
    Window mainWindow;
    Cfg cfg;
    String placerCfgPath;
    boolean enableNotifications = false;

    public AttachedWindowManager(Window window) {
        this(window, null);
    }

    public AttachedWindowManager(Window window, Cfg cfg) {
        this.cfg = cfg;
        this.mainWindow = window;
        this.windows = new ArrayList();
        this.placers = new Hashtable();
        window.addComponentListener(this);
    }

    public void setEnableNotifications(boolean bl) {
        this.enableNotifications = bl;
    }

    public void add(AttachedWindow attachedWindow, Placer placer) {
        if (placer == null) {
            placer = new Placer();
        }
        this.windows.add(attachedWindow);
        this.placers.put(attachedWindow, placer);
        attachedWindow.addPlacementListener(this);
    }

    public void addNorth(AttachedWindow attachedWindow) {
        this.add(attachedWindow, new Placer(1));
    }

    public void addWest(AttachedWindow attachedWindow) {
        this.add(attachedWindow, new Placer(2));
    }

    public void addSouth(AttachedWindow attachedWindow) {
        this.add(attachedWindow, new Placer(8));
    }

    public void addEast(AttachedWindow attachedWindow) {
        this.add(attachedWindow, new Placer(4));
    }

    public void remove(AttachedWindow attachedWindow) {
        this.windows.remove(attachedWindow);
        attachedWindow.removePlacementListener(this);
    }

    public void enableMethod(AttachedWindow attachedWindow, int n, boolean bl) {
        Placer placer = this.placers.get(attachedWindow);
        placer.enableMethod(n, bl);
    }

    public String getPlacerCfgPath() {
        return this.placerCfgPath;
    }

    public void setPlacerCfgPath(String string) {
        this.placerCfgPath = string;
    }

    public void loadSettings() {
        if (this.cfg == null) {
            return;
        }
        for (AttachedWindow attachedWindow : this.windows) {
            Object object;
            if (attachedWindow == null || attachedWindow.getName() == null || attachedWindow.getName().equals("") || this.placerCfgPath == null || (object = this.cfg.getValue(this.placerCfgPath + "." + attachedWindow.getName() + ".placer", null)) == null || !(object instanceof Placer)) continue;
            Placer placer = (Placer)object;
            placer.method = this.placers.get((Object)attachedWindow).method;
            this.placers.get(attachedWindow).copyFrom(placer);
        }
    }

    public void storeSettings() {
        if (this.cfg == null) {
            return;
        }
        for (AttachedWindow attachedWindow : this.windows) {
            if (attachedWindow == null || attachedWindow.getName() == null || attachedWindow.getName().equals("") || this.placerCfgPath == null) continue;
            this.cfg.putValue(this.placerCfgPath + "." + attachedWindow.getName() + ".placer", this.placers.get(attachedWindow));
        }
    }

    public void placeWindow(AttachedWindow attachedWindow, Placer placer) {
        Rectangle rectangle = this.mainWindow.getBounds();
        Rectangle rectangle2 = attachedWindow.getBounds();
        if (placer == null) {
            placer = this.placers.get(attachedWindow);
        }
        rectangle2 = placer.place(rectangle, rectangle2);
        attachedWindow.placeWindow(rectangle2);
        this.storeSettings();
    }

    public void placeWindows() {
        this.placeWindows(false);
    }

    public void placeWindows(boolean bl) {
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = this.mainWindow.getBounds();
        for (AttachedWindow attachedWindow : this.windows) {
            rectangle = attachedWindow.getBounds(rectangle);
            Placer placer = this.placers.get(attachedWindow);
            if (placer.isMotionLock() && !bl) {
                placer.updateOffset(rectangle2, rectangle);
                continue;
            }
            rectangle = placer.place(rectangle2, rectangle);
            attachedWindow.placeWindow(rectangle);
        }
        this.storeSettings();
    }

    @Override
    public void notifyMove(AttachedWindow attachedWindow) {
        if (this.mainWindow == null) {
            return;
        }
        if (!this.enableNotifications) {
            return;
        }
        Rectangle rectangle = this.mainWindow.getBounds();
        Rectangle rectangle2 = attachedWindow.getBounds();
        this.placers.get(attachedWindow).updateOffset(rectangle, rectangle2);
        this.storeSettings();
    }

    @Override
    public void notifyResize(AttachedWindow attachedWindow) {
        if (this.mainWindow == null) {
            return;
        }
        if (!this.enableNotifications) {
            return;
        }
        Rectangle rectangle = this.mainWindow.getBounds();
        Rectangle rectangle2 = attachedWindow.getBounds();
        this.placers.get(attachedWindow).updateSize(rectangle, rectangle2);
        this.storeSettings();
    }

    @Override
    public void snap(AttachedWindow attachedWindow) {
        Placer placer = this.placers.get(attachedWindow);
        placer.resetOffset();
        placer.resetSize();
        this.placeWindow(attachedWindow, placer);
    }

    public void snapAll() {
        for (AttachedWindow attachedWindow : this.windows) {
            this.snap(attachedWindow);
        }
    }

    @Override
    public void setMotionLock(AttachedWindow attachedWindow, boolean bl) {
        Placer placer = this.placers.get(attachedWindow);
        placer.setMotionLock(bl);
    }

    public boolean isMotionLock(AttachedWindow attachedWindow) {
        Placer placer = this.placers.get(attachedWindow);
        return placer.isMotionLock();
    }

    public void setMotionLockForAll(boolean bl) {
        for (AttachedWindow attachedWindow : this.windows) {
            this.setMotionLock(attachedWindow, bl);
        }
    }

    public boolean isAnyMotionLock() {
        for (AttachedWindow attachedWindow : this.windows) {
            Placer placer = this.placers.get(attachedWindow);
            if (!placer.isMotionLock()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (!componentEvent.getSource().equals(this.mainWindow)) {
            return;
        }
        if (this.enableNotifications) {
            this.placeWindows();
        }
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        if (!componentEvent.getSource().equals(this.mainWindow)) {
            return;
        }
        if (this.enableNotifications) {
            this.placeWindows();
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        if (!componentEvent.getSource().equals(this.mainWindow)) {
            return;
        }
        if (this.enableNotifications) {
            this.placeWindows();
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    public static class Placer {
        public static final int NORTH = 1;
        public static final int WEST = 2;
        public static final int EAST = 4;
        public static final int SOUTH = 8;
        public static final int WIDTH = 16;
        public static final int HEIGHT = 32;
        int method;
        int offsetX = 0;
        int offsetY = 0;
        int sizeW = 0;
        int sizeH = 0;
        boolean motionLock;

        public Placer() {
            this(0);
        }

        public Placer(int n) {
            this.method = n;
            this.motionLock = false;
        }

        public void copyFrom(Placer placer) {
            this.method = placer.method;
            this.offsetX = placer.offsetX;
            this.offsetY = placer.offsetY;
            this.sizeW = placer.sizeW;
            this.sizeH = placer.sizeH;
            this.motionLock = placer.motionLock;
        }

        public void enableMethod(int n, boolean bl) {
            this.method = bl ? (this.method |= n) : (this.method &= ~n);
        }

        public Rectangle place(Rectangle rectangle, Rectangle rectangle2) {
            return this.place(rectangle, rectangle2, true);
        }

        public Rectangle place(Rectangle rectangle, Rectangle rectangle2, boolean bl) {
            Rectangle rectangle3 = new Rectangle(rectangle2);
            rectangle3.x = rectangle.x;
            rectangle3.y = rectangle.y;
            if ((this.method & 1) != 0) {
                rectangle3.y = rectangle.y - rectangle2.height;
            }
            if ((this.method & 2) != 0) {
                rectangle3.x = rectangle.x - rectangle2.width;
            }
            if ((this.method & 8) != 0) {
                rectangle3.y = rectangle.y + rectangle.height;
            }
            if ((this.method & 4) != 0) {
                rectangle3.x = rectangle.x + rectangle.width;
            }
            if ((this.method & 0x10) != 0) {
                rectangle3.width = rectangle.width;
            }
            if ((this.method & 0x20) != 0) {
                rectangle3.height = rectangle.height;
            }
            if (bl) {
                rectangle3.x += this.offsetX;
                rectangle3.y += this.offsetY;
            }
            if (this.sizeW > 0) {
                rectangle3.width = this.sizeW;
            }
            if (this.sizeH > 0) {
                rectangle3.height = this.sizeH;
            }
            return rectangle3;
        }

        public void updateOffset(Rectangle rectangle, Rectangle rectangle2) {
            Rectangle rectangle3 = this.place(rectangle, rectangle2, false);
            this.offsetX = rectangle2.x - rectangle3.x;
            this.offsetY = rectangle2.y - rectangle3.y;
        }

        public void updateSize(Rectangle rectangle, Rectangle rectangle2) {
            if (rectangle == null) {
                // empty if block
            }
            this.sizeW = rectangle2.width;
            this.sizeH = rectangle2.height;
        }

        public void resetOffset() {
            this.offsetX = 0;
            this.offsetY = 0;
        }

        public void resetSize() {
            this.sizeW = 0;
            this.sizeH = 0;
        }

        public void setOffset(int n, int n2) {
            this.offsetX = n;
            this.offsetY = n2;
        }

        public boolean isMotionLock() {
            return this.motionLock;
        }

        public void setMotionLock(boolean bl) {
            this.motionLock = bl;
        }

        public String toString() {
            Object object = "";
            object = (String)object + this.method;
            object = (String)object + "," + this.offsetX;
            object = (String)object + "," + this.offsetY;
            object = (String)object + "," + this.sizeW;
            object = (String)object + "," + this.sizeH;
            object = (String)object + "," + this.motionLock;
            return object;
        }

        public static Placer valueOf(String string) {
            Placer placer = null;
            String[] stringArray = string.split(",");
            if (stringArray.length != 6) {
                return null;
            }
            placer = new Placer();
            try {
                placer.method = Integer.parseInt(stringArray[0]);
                placer.offsetX = Integer.parseInt(stringArray[1]);
                placer.offsetY = Integer.parseInt(stringArray[2]);
                placer.sizeW = Integer.parseInt(stringArray[3]);
                placer.sizeH = Integer.parseInt(stringArray[4]);
                placer.motionLock = Boolean.parseBoolean(stringArray[5]);
            }
            catch (Exception exception) {
                return null;
            }
            return placer;
        }
    }
}

