/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.ui;

import de.admadic.calculator.ui.PlacementListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class AttachedWindow
extends JDialog
implements ComponentListener,
ActionListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    PlacementListener placementListener = null;
    JButton snapBtn;
    JToggleButton lockBtn;
    JPanel btnPanel;
    Image pinDown;
    Image pinUp;
    Image snap;
    boolean deferFocus = true;
    boolean ignoreNextMoveEvent = false;
    boolean ignoreNextResizeEvent = false;
    static final String CMD_SNAP = "snap";
    static final String CMD_LOCK = "lock";

    public AttachedWindow(JFrame jFrame) {
        super(jFrame);
        this.setDefaultCloseOperation(0);
        this.getRootPane().setDefaultButton(null);
        this.getContentPane().setLayout(new BorderLayout());
        this.btnPanel = new JPanel();
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL uRL = classLoader.getResource("de/admadic/calculator/ui/res/atw-pin-down.png");
        this.pinDown = Toolkit.getDefaultToolkit().getImage(uRL);
        uRL = classLoader.getResource("de/admadic/calculator/ui/res/atw-pin-up.png");
        this.pinUp = Toolkit.getDefaultToolkit().getImage(uRL);
        uRL = classLoader.getResource("de/admadic/calculator/ui/res/atw-snap.png");
        this.snap = Toolkit.getDefaultToolkit().getImage(uRL);
        this.snapBtn = new JButton();
        this.snapBtn.setActionCommand(CMD_SNAP);
        this.snapBtn.addActionListener(this);
        this.snapBtn.setMargin(new Insets(1, 1, 1, 1));
        this.btnPanel.add(this.snapBtn);
        this.snapBtn.setIcon(new ImageIcon(this.snap));
        this.lockBtn = new JToggleButton();
        this.lockBtn.setActionCommand(CMD_LOCK);
        this.lockBtn.addItemListener(this);
        this.lockBtn.setMargin(new Insets(1, 1, 1, 1));
        this.btnPanel.add(this.lockBtn);
        this.lockBtn.setSelectedIcon(new ImageIcon(this.pinDown));
        this.lockBtn.setRolloverSelectedIcon(new ImageIcon(this.pinDown));
        this.lockBtn.setIcon(new ImageIcon(this.pinUp));
        this.addComponentListener(this);
    }

    public void addPlacementListener(PlacementListener placementListener) {
        this.placementListener = placementListener;
    }

    public void removePlacementListener(PlacementListener placementListener) {
        if (placementListener == null) {
            // empty if block
        }
        this.placementListener = null;
    }

    public void placePanel(JPanel jPanel) {
        this.placePanel(jPanel, 0, 5, 5, 5);
    }

    public void placePanel(JPanel jPanel, int n, int n2, int n3, int n4) {
        this.getContentPane().add((Component)jPanel, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(n, n2, n3, n4));
        this.pack();
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (this.ignoreNextResizeEvent) {
            this.ignoreNextResizeEvent = false;
            return;
        }
        if (this.placementListener != null) {
            this.placementListener.notifyResize(this);
        }
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        if (this.ignoreNextMoveEvent) {
            this.ignoreNextMoveEvent = false;
            return;
        }
        if (this.placementListener != null) {
            this.placementListener.notifyMove(this);
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    public boolean isIgnoreNextMoveEvent() {
        return this.ignoreNextMoveEvent;
    }

    public void setIgnoreNextMoveEvent(boolean bl) {
        this.ignoreNextMoveEvent = bl;
    }

    public boolean isIgnoreNextResizeEvent() {
        return this.ignoreNextResizeEvent;
    }

    public void setIgnoreNextResizeEvent(boolean bl) {
        this.ignoreNextResizeEvent = bl;
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.deferFocus) {
            super.setVisible(bl);
        } else {
            super.setVisible(bl);
        }
    }

    public void placeWindow(Rectangle rectangle) {
        this.setIgnoreNextMoveEvent(true);
        this.setBounds(rectangle);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CMD_SNAP) && this.placementListener != null) {
            this.placementListener.snap(this);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.lockBtn)) {
            boolean bl;
            boolean bl2 = bl = itemEvent.getStateChange() == 1;
            if (this.placementListener != null) {
                this.placementListener.setMotionLock(this, bl);
            }
        }
    }
}

