/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.types;

import de.admadic.calculator.types.CaByte;
import de.admadic.calculator.types.CaComplex;
import de.admadic.calculator.types.CaDouble;
import de.admadic.calculator.types.CaFloat;
import de.admadic.calculator.types.CaInteger;
import de.admadic.calculator.types.CaLong;
import de.admadic.calculator.types.CaNumber;
import de.admadic.calculator.types.CaShort;
import java.util.LinkedList;

public class CaRatio
extends CaNumber
implements Cloneable {
    int valueSig = 1;
    long valueInt = 0L;
    long valueNum = 0L;
    long valueDen = 1L;
    boolean useIntPart = true;
    long maxDen = 0L;
    long upperlimit = Long.MAX_VALUE;
    long lowerlimit = Long.MIN_VALUE;

    public CaRatio() {
        this.setZero();
    }

    public CaRatio(long l, long l2, long l3) {
        this.setValue(l, l2, l3);
    }

    public CaRatio(long l, long l2) {
        this.setValue(l, l2);
    }

    public CaRatio(long l) {
        this.setValue(l);
    }

    @Override
    public CaRatio clone() throws CloneNotSupportedException {
        CaRatio caRatio = (CaRatio)super.clone();
        this.cloneTo(caRatio);
        return caRatio;
    }

    public void cloneTo(CaRatio caRatio) {
        super.cloneTo(caRatio);
        caRatio.valueSig = this.valueSig;
        caRatio.valueInt = this.valueInt;
        caRatio.valueNum = this.valueNum;
        caRatio.valueDen = this.valueDen;
        caRatio.useIntPart = this.useIntPart;
        caRatio.maxDen = this.maxDen;
        caRatio.upperlimit = this.upperlimit;
        caRatio.lowerlimit = this.lowerlimit;
    }

    public void setValue(long l, long l2, long l3) {
        this.valueSig = 1;
        this.valueInt = l;
        this.valueNum = l2;
        this.valueDen = l3;
        this.setStateNormal();
    }

    public void setValue(long l, long l2) {
        this.setValue(0L, l, l2);
    }

    public void setValue(long l) {
        this.setValue(0L, l, 1L);
    }

    public void calcRatio(double d, double d2) {
        long l;
        long l2;
        double d3;
        int n;
        LinkedList<Long> linkedList = new LinkedList<Long>();
        int n2 = 1000;
        int n3 = 0;
        int n4 = n = d >= 0.0 ? 1 : -1;
        if (d < 0.0) {
            d = -d;
        }
        if ((d3 = d - (double)(l2 = (long)Math.floor(d))) <= d2) {
            this.setValue((long)n * l2, 0L, 1L);
            return;
        }
        while (d3 > d2) {
            d3 = 1.0 / d3;
            l = (long)Math.floor(d3);
            d3 -= (double)l;
            linkedList.add(new Long(l));
            if (++n3 < n2) continue;
            System.err.printf("Warning: calcRatio stopped after %d steps with an error of %f\n", n3, d3);
            break;
        }
        long l3 = 0L;
        long l4 = 1L;
        while (!linkedList.isEmpty()) {
            l = (Long)linkedList.getLast();
            l3 += l * l4;
            l = l3;
            l3 = l4;
            l4 = l;
            linkedList.removeLast();
        }
        this.setValue((long)n * l2, l3, l4);
    }

    @Override
    public void setZero() {
        super.setZero();
        this.setValue(0L, 0L, 1L);
    }

    @Override
    public void setUnity() {
        super.setUnity();
        this.setValue(0L, 1L, 1L);
    }

    public void checkStates(CaLong caLong) {
        if (this.isNaN()) {
            caLong.setState(1);
        } else if (this.isPosZero()) {
            caLong.value = 0L;
        } else if (this.isNegZero()) {
            caLong.value = 0L;
        } else if (this.isInf()) {
            caLong.setState(this.getState());
        } else {
            long l = this.valueInt;
            if (this.valueNum > this.valueDen) {
                l += this.valueNum / this.valueDen;
            }
            if ((l *= (long)this.valueSig) > caLong.upperlimit) {
                caLong.setState(2);
            } else if (l < caLong.lowerlimit) {
                caLong.setState(3);
            } else {
                caLong.value = l;
            }
        }
    }

    public void checkStates(CaDouble caDouble) {
        if (this.getState() != 0) {
            caDouble.setState(this.getState());
        } else if (this.valueDen == 0L) {
            caDouble.setState(1);
        } else {
            double d = this.valueInt;
            d += (double)this.valueNum / (double)this.valueDen;
            if ((d *= (double)this.valueSig) > caDouble.upperlimit) {
                caDouble.setState(2);
            } else if (d < caDouble.lowerlimit) {
                caDouble.setState(3);
            } else {
                caDouble.value = d;
            }
        }
    }

    @Override
    public CaByte byteValue() {
        CaByte caByte = new CaByte();
        this.checkStates(caByte);
        return caByte;
    }

    @Override
    public CaShort shortValue() {
        CaShort caShort = new CaShort();
        this.checkStates(caShort);
        return caShort;
    }

    @Override
    public CaInteger intValue() {
        CaInteger caInteger = new CaInteger();
        this.checkStates(caInteger);
        return caInteger;
    }

    @Override
    public CaLong longValue() {
        CaLong caLong = new CaLong();
        this.checkStates(caLong);
        return caLong;
    }

    @Override
    public CaFloat floatValue() {
        CaFloat caFloat = new CaFloat();
        this.checkStates(caFloat);
        return caFloat;
    }

    @Override
    public CaDouble doubleValue() {
        CaDouble caDouble = new CaDouble();
        this.checkStates(caDouble);
        return caDouble;
    }

    @Override
    public CaComplex complexValue() {
        CaDouble caDouble = new CaDouble();
        this.checkStates(caDouble);
        CaComplex caComplex = caDouble.complexValue();
        return caComplex;
    }

    @Override
    public CaRatio ratioValue() {
        CaRatio caRatio = new CaRatio();
        if (this.getState() != 0) {
            caRatio.setState(this.getState());
        } else {
            caRatio.valueSig = this.valueSig;
            caRatio.valueInt = this.valueInt;
            caRatio.valueNum = this.valueNum;
            caRatio.valueDen = this.valueDen;
            caRatio.setState(0);
        }
        return caRatio;
    }
}

