/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.types;

import de.admadic.calculator.types.CaByte;
import de.admadic.calculator.types.CaComplex;
import de.admadic.calculator.types.CaDouble;
import de.admadic.calculator.types.CaFloat;
import de.admadic.calculator.types.CaInteger;
import de.admadic.calculator.types.CaLong;
import de.admadic.calculator.types.CaNumberFmt;
import de.admadic.calculator.types.CaNumberFormatter;
import de.admadic.calculator.types.CaNumberFormatterContext;
import de.admadic.calculator.types.CaNumberUnity;
import de.admadic.calculator.types.CaNumberValue;
import de.admadic.calculator.types.CaRatio;
import de.admadic.calculator.types.CaShort;

public class CaNumber
implements Cloneable,
CaNumberValue,
CaNumberUnity,
CaNumberFmt {
    public static final int STATE_NORMAL = 0;
    public static final int STATE_NAN = 1;
    public static final int STATE_POSINF = 2;
    public static final int STATE_NEGINF = 3;
    public static final int STATE_POSZERO = 4;
    public static final int STATE_NEGZERO = 5;
    int state = 0;

    public CaNumber() {
        this.setZero();
    }

    public CaNumber clone() throws CloneNotSupportedException {
        CaNumber caNumber = (CaNumber)super.clone();
        this.cloneTo(caNumber);
        return caNumber;
    }

    public void cloneTo(CaNumber caNumber) {
        caNumber.state = this.state;
    }

    @Override
    public void setZero() {
        this.setStateNormal();
    }

    @Override
    public void setUnity() {
        this.setStateNormal();
    }

    public String getStateString() {
        switch (this.state) {
            case 0: {
                return new String("Normal");
            }
            case 1: {
                return new String("NaN");
            }
            case 2: {
                return new String("+Inf");
            }
            case 3: {
                return new String("-Inf");
            }
            case 4: {
                return new String("+Zero");
            }
            case 5: {
                return new String("-Zero");
            }
        }
        return new String("unknown");
    }

    public void setState(int n) {
        this.state = n;
    }

    public void setStateNormal() {
        this.setState(0);
    }

    public int getState() {
        return this.state;
    }

    public boolean isNotNormal() {
        return this.state != 0;
    }

    public boolean isNaN() {
        return this.state == 1;
    }

    public boolean isInf() {
        return this.state == 2 || this.state == 3;
    }

    public boolean isPosInf() {
        return this.state == 2;
    }

    public boolean isNegInf() {
        return this.state == 3;
    }

    public boolean isPosZero() {
        return this.state == 4;
    }

    public boolean isNegZero() {
        return this.state == 5;
    }

    public void setNaN() {
        this.state = 1;
    }

    public void setPosInf() {
        this.state = 2;
    }

    public void setNegInf() {
        this.state = 3;
    }

    public void setPosZero() {
        this.state = 4;
    }

    public void setNegZero() {
        this.state = 5;
    }

    @Override
    public CaInteger intValue() {
        return null;
    }

    @Override
    public CaByte byteValue() {
        return null;
    }

    @Override
    public CaComplex complexValue() {
        return null;
    }

    @Override
    public CaDouble doubleValue() {
        return null;
    }

    @Override
    public CaFloat floatValue() {
        return null;
    }

    @Override
    public CaLong longValue() {
        return null;
    }

    @Override
    public CaRatio ratioValue() {
        return null;
    }

    @Override
    public CaShort shortValue() {
        return null;
    }

    @Override
    public String formatNumber(CaNumberFormatter caNumberFormatter) {
        return caNumberFormatter.formatNumber(this);
    }

    @Override
    public void parseNumber(String string, CaNumberFormatter caNumberFormatter) throws NumberFormatException {
        caNumberFormatter.parseNumber(string, this);
    }

    @Override
    public String formatNumber(CaNumberFormatterContext caNumberFormatterContext) {
        CaNumberFormatter caNumberFormatter = caNumberFormatterContext.get(this);
        return this.formatNumber(caNumberFormatter);
    }

    @Override
    public void parseNumber(String string, CaNumberFormatterContext caNumberFormatterContext) throws NumberFormatException {
        CaNumberFormatter caNumberFormatter = caNumberFormatterContext.get(this);
        this.parseNumber(string, caNumberFormatter);
    }
}

