/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.types;

import de.admadic.calculator.types.CaByte;
import de.admadic.calculator.types.CaComplex;
import de.admadic.calculator.types.CaDouble;
import de.admadic.calculator.types.CaFloat;
import de.admadic.calculator.types.CaInteger;
import de.admadic.calculator.types.CaNumber;
import de.admadic.calculator.types.CaRatio;
import de.admadic.calculator.types.CaShort;

public class CaLong
extends CaNumber
implements Cloneable {
    long value = 0L;
    long upperlimit = Long.MAX_VALUE;
    long lowerlimit = Long.MIN_VALUE;

    public CaLong() {
    }

    public CaLong(long l) {
        this.value = l;
    }

    @Override
    public CaLong clone() throws CloneNotSupportedException {
        CaLong caLong = (CaLong)super.clone();
        this.cloneTo(caLong);
        return caLong;
    }

    public void cloneTo(CaLong caLong) {
        super.cloneTo(caLong);
        caLong.value = this.value;
        caLong.upperlimit = this.upperlimit;
        caLong.lowerlimit = this.lowerlimit;
    }

    public void setValue(long l) {
        this.value = l;
        this.setStateNormal();
    }

    @Override
    public void setZero() {
        super.setZero();
        this.value = 0L;
    }

    @Override
    public void setUnity() {
        super.setUnity();
        this.value = 1L;
    }

    public void checkStates(CaLong caLong) {
        if (this.getState() != 0) {
            caLong.setState(this.getState());
        } else if (this.value > caLong.upperlimit) {
            caLong.setState(2);
        } else if (this.value < caLong.lowerlimit) {
            caLong.setState(3);
        } else {
            caLong.setValue(this.value);
        }
    }

    public void checkStates(CaDouble caDouble) {
        if (this.getState() != 0) {
            caDouble.setState(this.getState());
        } else if ((double)this.value > caDouble.upperlimit) {
            caDouble.setState(2);
        } else if ((double)this.value < caDouble.lowerlimit) {
            caDouble.setState(3);
        } else {
            caDouble.setValue(this.value);
        }
    }

    public void checkStates(CaRatio caRatio) {
        if (this.getState() != 0) {
            caRatio.setState(this.getState());
        } else if (this.value > caRatio.upperlimit) {
            caRatio.setState(2);
        } else if (this.value < caRatio.lowerlimit) {
            caRatio.setState(3);
        } else {
            caRatio.setValue(this.value, 1L);
        }
    }

    @Override
    public CaByte byteValue() {
        CaByte caByte = new CaByte();
        this.checkStates(caByte);
        return caByte;
    }

    @Override
    public CaShort shortValue() {
        CaShort caShort = new CaShort();
        this.checkStates(caShort);
        return caShort;
    }

    @Override
    public CaInteger intValue() {
        CaInteger caInteger = new CaInteger();
        this.checkStates(caInteger);
        return caInteger;
    }

    @Override
    public CaLong longValue() {
        CaLong caLong = new CaLong();
        this.checkStates(caLong);
        return caLong;
    }

    @Override
    public CaComplex complexValue() {
        CaDouble caDouble = this.doubleValue();
        CaComplex caComplex = caDouble.complexValue();
        return caComplex;
    }

    @Override
    public CaDouble doubleValue() {
        CaDouble caDouble = new CaDouble();
        this.checkStates(caDouble);
        return caDouble;
    }

    @Override
    public CaFloat floatValue() {
        CaFloat caFloat = new CaFloat();
        this.checkStates(caFloat);
        return caFloat;
    }

    @Override
    public CaRatio ratioValue() {
        CaRatio caRatio = new CaRatio();
        this.checkStates(caRatio);
        return caRatio;
    }
}

