/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.types;

import de.admadic.calculator.types.CaDouble;
import de.admadic.calculator.types.CaNumber;
import de.admadic.calculator.types.CaNumberFormatter;
import java.util.Locale;

public class CaDoubleFormatter
implements CaNumberFormatter {
    int width;
    int prec;
    int type;
    Locale locale;
    public static final int TYPE_AUTO = 0;
    public static final int TYPE_FIXED = 1;
    public static final int TYPE_ENG = 2;
    String fmtCache;

    public CaDoubleFormatter() {
        this(0, 1, 0);
    }

    public CaDoubleFormatter(int n, int n2, int n3) {
        this.type = n;
        this.width = n2;
        this.prec = n3;
        this.locale = null;
        this.fmtCache = CaDoubleFormatter.updateFmt(n, n2, n3);
    }

    protected void updateFmt() {
        this.fmtCache = CaDoubleFormatter.updateFmt(this.type, this.width, this.prec);
    }

    protected static String updateFmt(int n, int n2, int n3) {
        String string;
        switch (n) {
            case 1: {
                if (n2 != 0) {
                    string = "%" + n2 + "." + n3 + "f";
                    break;
                }
                string = "%." + n3 + "f";
                break;
            }
            case 2: {
                if (n2 != 0) {
                    string = "%" + n2 + "." + n3 + "e";
                    break;
                }
                string = "%." + n3 + "e";
                break;
            }
            default: {
                string = n2 != 0 ? "%" + n2 + "." + n3 + "g" : "%." + n3 + "g";
            }
        }
        return string;
    }

    public String toString() {
        Object object = "";
        object = (String)object + CaDoubleFormatter.type2String(this.type);
        object = (String)object + "," + this.width;
        object = (String)object + "," + this.prec;
        return object;
    }

    public static CaDoubleFormatter valueOf(String string) {
        CaDoubleFormatter caDoubleFormatter = null;
        String[] stringArray = string.split(",");
        if (stringArray.length != 3) {
            return caDoubleFormatter;
        }
        int n = CaDoubleFormatter.string2Type(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        caDoubleFormatter = new CaDoubleFormatter(n, n2, n3);
        return caDoubleFormatter;
    }

    public static CaDoubleFormatter valueOf(String string, CaDoubleFormatter caDoubleFormatter) {
        String[] stringArray;
        CaDoubleFormatter caDoubleFormatter2 = caDoubleFormatter;
        if (caDoubleFormatter2 == null) {
            caDoubleFormatter2 = new CaDoubleFormatter();
        }
        if ((stringArray = string.split(",")).length != 3) {
            return caDoubleFormatter2;
        }
        int n = CaDoubleFormatter.string2Type(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        caDoubleFormatter2.setType(n);
        caDoubleFormatter2.setWidth(n2);
        caDoubleFormatter2.setPrec(n3);
        caDoubleFormatter2.updateFmt();
        return caDoubleFormatter2;
    }

    public static String type2String(int n) {
        switch (n) {
            case 0: {
                return "auto";
            }
            case 1: {
                return "fixed";
            }
            case 2: {
                return "eng";
            }
        }
        return "auto";
    }

    public static String type2DisplayString(int n) {
        switch (n) {
            case 1: {
                return "Fix.";
            }
            case 2: {
                return "Eng.";
            }
        }
        return "Auto";
    }

    public static int string2Type(String string) {
        if (string.equals("auto")) {
            return 0;
        }
        if (string.equals("fixed")) {
            return 1;
        }
        if (string.equals("eng")) {
            return 2;
        }
        return 0;
    }

    public String format(CaDouble caDouble) {
        return String.format(this.locale, this.fmtCache, caDouble.getValue());
    }

    @Override
    public String formatNumber(CaNumber caNumber) {
        CaDouble caDouble = (CaDouble)caNumber;
        return this.format(caDouble);
    }

    @Override
    public CaNumber parseNumber(String string, CaNumber caNumber) throws NumberFormatException {
        if (caNumber == null) {
            caNumber = new CaDouble();
        }
        CaDouble caDouble = (CaDouble)caNumber;
        double d = Double.parseDouble(string);
        caDouble.setValue(d);
        return caDouble;
    }

    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public int getPrec() {
        return this.prec;
    }

    public void setPrec(int n) {
        this.prec = n;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }
}

