/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.types;

import de.admadic.calculator.types.CaDouble;
import java.util.Locale;

public class CaDoubleFormat {
    int width;
    int prec;
    int type;
    Locale locale;
    public static final int TYPE_AUTO = 0;
    public static final int TYPE_FIXED = 1;
    public static final int TYPE_ENG = 2;
    String fmtCache;

    public CaDoubleFormat() {
        this(0, 1, 0);
    }

    public CaDoubleFormat(int n, int n2, int n3) {
        this.type = n;
        this.width = n2;
        this.prec = n3;
        this.locale = null;
        this.fmtCache = CaDoubleFormat.updateFmt(n, n2, n3);
    }

    public String toString() {
        Object object = "";
        object = (String)object + CaDoubleFormat.type2String(this.type);
        object = (String)object + "," + this.width;
        object = (String)object + "," + this.prec;
        return object;
    }

    public static CaDoubleFormat valueOf(String string) {
        CaDoubleFormat caDoubleFormat = null;
        String[] stringArray = string.split(",");
        if (stringArray.length != 3) {
            return caDoubleFormat;
        }
        int n = CaDoubleFormat.string2Type(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        caDoubleFormat = new CaDoubleFormat(n, n2, n3);
        return caDoubleFormat;
    }

    protected void updateFmt() {
        this.fmtCache = CaDoubleFormat.updateFmt(this.type, this.width, this.prec);
    }

    protected static String updateFmt(int n, int n2, int n3) {
        String string;
        switch (n) {
            case 1: {
                if (n2 != 0) {
                    string = "%" + n2 + "." + n3 + "f";
                    break;
                }
                string = "%." + n3 + "f";
                break;
            }
            case 2: {
                if (n2 != 0) {
                    string = "%" + n2 + "." + n3 + "e";
                    break;
                }
                string = "%." + n3 + "e";
                break;
            }
            default: {
                string = n2 != 0 ? "%" + n2 + "." + n3 + "g" : "%." + n3 + "g";
            }
        }
        return string;
    }

    public static String type2String(int n) {
        switch (n) {
            case 0: {
                return "auto";
            }
            case 1: {
                return "fixed";
            }
            case 2: {
                return "eng";
            }
        }
        return "auto";
    }

    public static String type2DisplayString(int n) {
        switch (n) {
            case 1: {
                return "Fix.";
            }
            case 2: {
                return "Eng.";
            }
        }
        return "Auto";
    }

    public static int string2Type(String string) {
        if (string.equals("auto")) {
            return 0;
        }
        if (string.equals("fixed")) {
            return 1;
        }
        if (string.equals("eng")) {
            return 2;
        }
        return 0;
    }

    public String format(CaDouble caDouble) {
        return String.format(this.locale, this.fmtCache, caDouble.getValue());
    }

    public static String format(int n, int n2, int n3, CaDouble caDouble) {
        String string = CaDoubleFormat.updateFmt(n, n2, n3);
        return String.format(string, caDouble.getValue());
    }

    public static String format(Locale locale, int n, int n2, int n3, CaDouble caDouble) {
        String string = CaDoubleFormat.updateFmt(n, n2, n3);
        return String.format(locale, string, caDouble.getValue());
    }

    public int getPrec() {
        return this.prec;
    }

    public void setPrec(int n) {
        this.prec = n;
        this.updateFmt();
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
        this.updateFmt();
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
        this.updateFmt();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

