/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.types;

import de.admadic.calculator.types.CaByte;
import de.admadic.calculator.types.CaComplex;
import de.admadic.calculator.types.CaFloat;
import de.admadic.calculator.types.CaInteger;
import de.admadic.calculator.types.CaLong;
import de.admadic.calculator.types.CaNumber;
import de.admadic.calculator.types.CaRatio;
import de.admadic.calculator.types.CaShort;

public class CaDouble
extends CaNumber
implements Cloneable {
    public double value;
    public double upperlimit = Double.MAX_VALUE;
    public double lowerlimit = -1.7976931348623157E308;

    public CaDouble() {
    }

    public CaDouble(double d) {
        this.value = d;
    }

    @Override
    public CaDouble clone() throws CloneNotSupportedException {
        CaDouble caDouble = (CaDouble)super.clone();
        this.cloneTo(caDouble);
        return caDouble;
    }

    public void cloneTo(CaDouble caDouble) {
        super.cloneTo(caDouble);
        caDouble.value = this.value;
        caDouble.upperlimit = this.upperlimit;
        caDouble.lowerlimit = this.lowerlimit;
    }

    public void setValue(double d) {
        this.value = d;
        this.setStateNormal();
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public void setZero() {
        super.setZero();
        this.value = 0.0;
    }

    @Override
    public void setUnity() {
        super.setUnity();
        this.value = 1.0;
    }

    public String toString() {
        if (this.isNotNormal()) {
            return this.getStateString();
        }
        return String.valueOf(this.value);
    }

    public String toString(int n) {
        Object object;
        if (this.isNotNormal()) {
            return this.getStateString();
        }
        if (n == 0) {
            object = "" + this.value;
        } else {
            double d = Math.abs(Math.log10(Math.abs(this.value)));
            String string = this.value == 0.0 || d < (double)(n - 3) ? "%" + String.format("%d", n) + ".2f" : "%" + String.format("%d", n) + "g";
            object = String.format(string, this.value);
        }
        return object;
    }

    public void checkStates(CaDouble caDouble) {
        if (this.getState() != 0) {
            caDouble.setState(this.getState());
        } else if (this.value > caDouble.upperlimit) {
            caDouble.setState(2);
        } else if (this.value < caDouble.lowerlimit) {
            caDouble.setState(3);
        } else {
            caDouble.setValue(this.value);
        }
    }

    public void checkStates(CaComplex caComplex) {
        if (this.getState() != 0) {
            caComplex.setState(this.getState());
        } else if (this.value > caComplex.upperlimit) {
            caComplex.setState(2);
        } else if (this.value < caComplex.lowerlimit) {
            caComplex.setState(3);
        } else {
            caComplex.setValue(this.value, 0.0);
        }
    }

    public void checkStates(CaLong caLong) {
        if (this.isNaN()) {
            caLong.setState(1);
        } else if (this.isPosZero()) {
            caLong.setState(4);
        } else if (this.isNegZero()) {
            caLong.setState(5);
        } else if (this.isInf()) {
            caLong.setState(this.getState());
        } else if (this.value > (double)caLong.upperlimit) {
            caLong.setState(2);
        } else if (this.value < (double)caLong.lowerlimit) {
            caLong.setState(3);
        } else {
            caLong.setValue(Math.round(this.value));
        }
    }

    public void checkStates(CaRatio caRatio) {
        if (this.getState() != 0) {
            caRatio.setState(this.getState());
        } else if (this.value > (double)caRatio.upperlimit) {
            caRatio.setState(2);
        } else if (this.value < (double)caRatio.lowerlimit) {
            caRatio.setState(3);
        } else {
            caRatio.calcRatio(this.value, 0.0);
        }
    }

    @Override
    public CaByte byteValue() {
        CaByte caByte = new CaByte();
        this.checkStates(caByte);
        return caByte;
    }

    @Override
    public CaShort shortValue() {
        CaShort caShort = new CaShort();
        this.checkStates(caShort);
        return caShort;
    }

    @Override
    public CaInteger intValue() {
        CaInteger caInteger = new CaInteger();
        this.checkStates(caInteger);
        return caInteger;
    }

    @Override
    public CaLong longValue() {
        CaLong caLong = new CaLong();
        this.checkStates(caLong);
        return caLong;
    }

    @Override
    public CaFloat floatValue() {
        CaFloat caFloat = new CaFloat();
        this.checkStates(caFloat);
        return caFloat;
    }

    @Override
    public CaDouble doubleValue() {
        CaDouble caDouble = new CaDouble();
        this.checkStates(caDouble);
        return caDouble;
    }

    @Override
    public CaComplex complexValue() {
        CaComplex caComplex = new CaComplex();
        this.checkStates(caComplex);
        return caComplex;
    }

    @Override
    public CaRatio ratioValue() {
        CaRatio caRatio = new CaRatio();
        this.checkStates(caRatio);
        return caRatio;
    }
}

