/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.types;

import de.admadic.calculator.types.CaByte;
import de.admadic.calculator.types.CaDouble;
import de.admadic.calculator.types.CaFloat;
import de.admadic.calculator.types.CaInteger;
import de.admadic.calculator.types.CaLong;
import de.admadic.calculator.types.CaNumber;
import de.admadic.calculator.types.CaRatio;
import de.admadic.calculator.types.CaShort;

public class CaComplex
extends CaNumber
implements Cloneable {
    double valueRe = 0.0;
    double valueIm = 0.0;
    double upperlimit = Double.MAX_VALUE;
    double lowerlimit = -1.7976931348623157E308;

    public CaComplex() {
        this.setZero();
    }

    public CaComplex(double d, double d2) {
        this.setValue(d, d2);
    }

    @Override
    public CaComplex clone() throws CloneNotSupportedException {
        CaComplex caComplex = (CaComplex)super.clone();
        this.cloneTo(caComplex);
        return caComplex;
    }

    public void cloneTo(CaComplex caComplex) {
        super.cloneTo(caComplex);
        caComplex.valueRe = this.valueRe;
        caComplex.valueIm = this.valueIm;
        caComplex.upperlimit = this.upperlimit;
        caComplex.lowerlimit = this.lowerlimit;
    }

    public void setValue(double d, double d2) {
        this.valueRe = d;
        this.valueIm = d2;
        this.setStateNormal();
    }

    @Override
    public void setZero() {
        super.setZero();
        this.setValue(0.0, 0.0);
    }

    @Override
    public void setUnity() {
        super.setUnity();
        this.setValue(1.0, 0.0);
    }

    public void checkStates(CaLong caLong) {
        if (this.isNaN()) {
            caLong.setState(1);
        } else if (this.isPosZero()) {
            caLong.value = 0L;
        } else if (this.isNegZero()) {
            caLong.value = 0L;
        } else if (this.isInf()) {
            caLong.setState(this.getState());
        } else if (this.valueRe > (double)caLong.upperlimit) {
            caLong.setState(2);
        } else if (this.valueRe < (double)caLong.lowerlimit) {
            caLong.setState(3);
        } else {
            caLong.value = Math.round(this.valueRe);
        }
    }

    public void checkStates(CaDouble caDouble) {
        if (this.getState() != 0) {
            caDouble.setState(this.getState());
        } else if (this.valueRe > caDouble.upperlimit) {
            caDouble.setState(2);
        } else if (this.valueRe < caDouble.lowerlimit) {
            caDouble.setState(3);
        } else {
            caDouble.value = this.valueRe;
        }
    }

    public void checkStates(CaComplex caComplex) {
        if (this.getState() != 0) {
            caComplex.setState(this.getState());
        } else {
            caComplex.valueRe = this.valueRe;
            caComplex.valueIm = this.valueIm;
        }
    }

    @Override
    public CaByte byteValue() {
        CaByte caByte = new CaByte();
        this.checkStates(caByte);
        return caByte;
    }

    @Override
    public CaShort shortValue() {
        CaShort caShort = new CaShort();
        this.checkStates(caShort);
        return caShort;
    }

    @Override
    public CaInteger intValue() {
        CaInteger caInteger = new CaInteger();
        this.checkStates(caInteger);
        return caInteger;
    }

    @Override
    public CaLong longValue() {
        CaLong caLong = new CaLong();
        this.checkStates(caLong);
        return caLong;
    }

    @Override
    public CaFloat floatValue() {
        CaFloat caFloat = new CaFloat();
        this.checkStates(caFloat);
        return caFloat;
    }

    @Override
    public CaDouble doubleValue() {
        CaDouble caDouble = new CaDouble();
        this.checkStates(caDouble);
        return caDouble;
    }

    @Override
    public CaComplex complexValue() {
        CaComplex caComplex = new CaComplex();
        this.checkStates(caComplex);
        return caComplex;
    }

    @Override
    public CaRatio ratioValue() {
        CaDouble caDouble = this.doubleValue();
        CaRatio caRatio = caDouble.ratioValue();
        return caRatio;
    }
}

