/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.processor;

import de.admadic.calculator.math.DMath;
import de.admadic.calculator.processor.IProcessor;
import de.admadic.calculator.processor.ProcessorEvent;
import de.admadic.calculator.processor.ProcessorEventListener;
import de.admadic.calculator.processor.ProcessorException;
import de.admadic.calculator.processor.ProtocolEventListener;
import de.admadic.calculator.types.CaDouble;
import java.util.Stack;
import javax.swing.event.EventListenerList;

public class SimpleProcessorV1
implements IProcessor {
    static final boolean DBG = true;
    EventListenerList listenerList = new EventListenerList();
    CaDouble acc = null;
    CaDouble accmem = null;
    int maxinputlength = 17;
    int displaywidth = 20;
    int sign = 1;
    String inputstr = null;
    String lastop = null;
    String lastcmd = null;
    boolean appendToInput = true;
    boolean hasNewInput = true;
    boolean accChanged = false;
    String logstr = null;
    Stack<String> cmdStack = null;
    Stack<CaDouble> accStack = null;

    public SimpleProcessorV1() {
        System.out.println("SimpleProcessor: <init>");
        this.acc = new CaDouble();
        this.accmem = new CaDouble();
        this.accStack = new Stack();
        this.cmdStack = new Stack();
        this.appendToInput = true;
        this.hasNewInput = true;
        this.accChanged = false;
        this.inputstr = "0";
        this.lastop = "";
        this.logstr = "";
        this.lastcmd = "";
    }

    public CaDouble getAccuValue() throws ProcessorException {
        try {
            return this.acc.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ProcessorException("calculateStack: clone failed. check Number implementation.");
        }
    }

    @Override
    public String getDisplay() {
        Object object = "";
        object = this.appendToInput ? (String)object + (this.sign < 0 ? "-" + this.inputstr : " " + this.inputstr) : (String)object + this.getAccDisplay();
        return (String)object + " ";
    }

    public String getAccDisplay() {
        if (this.acc.isNotNormal()) {
            return this.acc.getStateString();
        }
        String string = this.acc.toString(0);
        return string;
    }

    @Override
    public String getLogDisplay() {
        return this.logstr;
    }

    public String getStatusDisplay() {
        return " " + this.getMemDisplay() + " ";
    }

    @Override
    public String getMemDisplay() {
        return this.testMemDisplay() ? "M" : " ";
    }

    public boolean testMemDisplay() {
        return this.accmem.getValue() != 0.0;
    }

    @Override
    public String getStackDisplay() {
        return "Stack: |acc|=" + this.accStack.size() + " |cmd|=" + this.cmdStack.size();
    }

    @Override
    public void addProcessorListener(ProcessorEventListener processorEventListener) {
        System.out.println("SimpleProcessor: addProcessorListener");
        this.listenerList.add(ProcessorEventListener.class, processorEventListener);
    }

    @Override
    public void removeProcessorListener(ProcessorEventListener processorEventListener) {
        System.out.println("SimpleProcessor: removeProcessorListener");
        this.listenerList.remove(ProcessorEventListener.class, processorEventListener);
    }

    @Override
    public void processCommand(String string) throws ProcessorException {
        System.out.println("SimpleProcessor: processCommand: " + string);
        if (string.equals("BS") || string.equals("0") || string.equals("1") || string.equals("2") || string.equals("3") || string.equals("4") || string.equals("5") || string.equals("6") || string.equals("7") || string.equals("8") || string.equals("9") || string.equals("+/-") || string.equals(".")) {
            this.updateInputString(string);
        }
        if (string.equals("+") || string.equals("-") || string.equals("*") || string.equals("/")) {
            this.opBinary(string);
        }
        if (string.equals("sqr") || string.equals("sqrt") || string.equals("ln") || string.equals("log") || string.equals("exp") || string.equals("exp10") || string.equals("xinv") || string.equals("sin") || string.equals("cos") || string.equals("tan") || string.equals("cot")) {
            this.opUnary(string);
        }
        if (string.equals("=")) {
            this.opExecute();
        }
        if (string.equals("pi") || string.equals("e")) {
            this.opConstant(string);
        }
        if (string.equals("c.a")) {
            this.clear();
            this.appendLog("c.a");
        }
        if (string.equals("c.e")) {
            this.clearEntry();
        }
        if (string.equals("m.c")) {
            this.clearMem();
        }
        if (string.equals("l.c")) {
            this.clearLog();
        }
        if (string.equals("l.cl")) {
            this.clearLastLogLine();
        }
        if (string.equals("m.+")) {
            this.memoryPlus();
        }
        if (string.equals("m.-")) {
            this.memoryMinus();
        }
        if (string.equals("m.s")) {
            this.memoryStore();
        }
        if (string.equals("m.r")) {
            this.memoryRead();
        }
        System.out.println("SimpleProcessor: lastcmd <- " + string);
        this.lastcmd = string;
    }

    public void clear() {
        System.out.println("SimpleProcessor: clear()");
        this.acc.setZero();
        this.accStack.clear();
        this.cmdStack.clear();
        this.appendToInput = true;
        this.hasNewInput = true;
        this.accChanged = false;
        this.inputstr = "0";
        this.sign = 1;
        this.lastop = "";
        this.lastcmd = "";
        this.fireDisplayEvent();
        this.fireStatusEvent(2);
    }

    public void clearMem() {
        System.out.println("SimpleProcessor: clearMem()");
        this.accmem.setZero();
        this.fireStatusEvent(1);
    }

    public void clearLog() {
        System.out.println("SimpleProcessor: clearLog()");
        this.logstr = "";
        this.fireProtocolEvent();
    }

    public void clearLastLogLine() {
        System.out.println("SimpleProcessor: clearLastLogLine()");
        int n = this.logstr.lastIndexOf("\n");
        this.logstr = n < 0 ? "" : this.logstr.substring(0, n);
        this.fireProtocolEvent();
    }

    public void clearEntry() {
        System.out.println("SimpleProcessor: clearEntry()");
        this.acc.setZero();
        this.inputstr = "0";
        this.sign = 1;
        this.appendToInput = true;
        this.hasNewInput = true;
        this.fireDisplayEvent();
    }

    public void memoryPlus() {
        System.out.println("SimpleProcessor: memoryPlus()");
        this.setAccuFromInput();
        DMath.add(this.accmem, this.acc);
        this.fireStatusEvent(1);
    }

    public void memoryMinus() {
        System.out.println("SimpleProcessor: memoryMinus()");
        this.setAccuFromInput();
        DMath.sub(this.accmem, this.acc);
        this.fireStatusEvent(1);
    }

    public void memoryStore() {
        System.out.println("SimpleProcessor: memoryStore()");
        this.setAccuFromInput();
        this.acc.cloneTo(this.accmem);
        this.fireStatusEvent(1);
    }

    public void memoryRead() {
        System.out.println("SimpleProcessor: clearRead()");
        this.accmem.cloneTo(this.acc);
        this.hasNewInput = true;
        this.getAccu();
    }

    protected void updateInputString(String string) {
        System.out.println("SimpleProcessor: updateInputString(): " + string);
        this.hasNewInput = true;
        if (!this.appendToInput) {
            System.out.println("SimpleProcessor: updateInputString(): appendToInput was false, reset to '0'");
            this.inputstr = "0";
            this.appendToInput = true;
        }
        if (string.equals("BS")) {
            if (this.inputstr.equals("0")) {
                System.out.println("SimpleProcessor: updateInputString(): backspace on '0', ignored");
            } else {
                System.out.println("SimpleProcessor: updateInputString(): backspace: clearing last digit");
                this.inputstr = this.inputstr.substring(0, this.inputstr.length() - 1);
                if (this.inputstr.length() < 1) {
                    this.inputstr = "0";
                }
            }
        }
        if (string.equals(".")) {
            if (this.inputstr.indexOf(".") >= 0) {
                System.out.println("SimpleProcessor: updateInputString(): dot: dot already there");
            } else {
                System.out.println("SimpleProcessor: updateInputString(): dot: appending");
                if (this.inputstr.length() < this.maxinputlength) {
                    this.inputstr = this.inputstr + ".";
                }
            }
        }
        if (string.equals("+/-")) {
            System.out.println("SimpleProcessor: updateInputString(): toggle sign");
            this.sign = -this.sign;
        }
        if (string.equals("ex")) {
            // empty if block
        }
        if (string.equals("0") || string.equals("1") || string.equals("2") || string.equals("3") || string.equals("4") || string.equals("5") || string.equals("6") || string.equals("7") || string.equals("8") || string.equals("9")) {
            if (this.inputstr.equals("0")) {
                System.out.println("SimpleProcessor: updateInputString(): 0..9: replace pure 0");
                this.inputstr = string;
            } else {
                System.out.println("SimpleProcessor: updateInputString(): 0..9: append");
                if (this.inputstr.length() < this.maxinputlength) {
                    this.inputstr = this.inputstr + string;
                }
            }
        }
        this.fireDisplayEvent();
    }

    protected void opBinary(String string) throws ProcessorException {
        System.out.println("SimpleProcessor: opBinary(): " + string);
        if (this.lastcmd.equals("+") || this.lastcmd.equals("-") || this.lastcmd.equals("*") || this.lastcmd.equals("/")) {
            this.popCmd();
            this.pushCmd(string);
            this.lastop = string;
            System.out.println("SimpleProcessor: updateBinary(): replacing last op to " + string);
            return;
        }
        this.setAccuFromInput();
        if (this.accStack.size() < 1) {
            System.out.println("SimpleProcessor: updateBinary(): accStack empty, making log");
            this.appendLog("", this.acc);
        }
        System.out.println("SimpleProcessor: updateBinary(): storing acc and calculating if necessary...");
        this.pushAccu(this.acc);
        this.calculateStack();
        System.out.println("SimpleProcessor: updateBinary(): pushing cmd on stack: " + string);
        this.pushCmd(string);
        this.appendToInput = false;
        this.lastop = string;
        System.out.println("SimpleProcessor: updateBinary(): lastop <- " + string);
        this.fireDisplayEvent();
    }

    protected void opUnary(String string) throws ProcessorException {
        System.out.println("SimpleProcessor: opUnary(): " + string);
        this.setAccuFromInput();
        if (this.accStack.size() < 1) {
            System.out.println("SimpleProcessor: opUnary(): accStack empty, appending log entry");
            this.appendLog("", this.acc);
        }
        System.out.println("SimpleProcessor: opUnary(): push acc to stack");
        this.pushAccu(this.acc);
        System.out.println("SimpleProcessor: opUnary(): push cmd to stack");
        this.pushCmd(string);
        System.out.println("SimpleProcessor: opUnary(): calculating");
        this.calculateStack();
        this.appendToInput = false;
        System.out.println("SimpleProcessor: opUnary(): lastop <- " + string);
        this.lastop = string;
        this.fireDisplayEvent();
    }

    protected void opConstant(String string) throws ProcessorException {
        System.out.println("SimpleProcessor: opConstant(): " + string);
        if (string.equals("e")) {
            double d = Math.E;
            this.acc.setValue(d);
            System.out.println("SimpleProcessor: opConstant(): pushing constant on acc stack");
            this.pushAccu(this.acc);
        } else if (string.equals("pi")) {
            double d = Math.PI;
            this.acc.setValue(d);
            System.out.println("SimpleProcessor: opConstant(): pushing constant on acc stack");
            this.pushAccu(this.acc);
        } else {
            System.out.println("SimpleProcessor: opConstant(): unknown constant");
            return;
        }
        this.appendToInput = false;
        System.out.println("SimpleProcessor: opConstant(): lastop <- " + string);
        this.lastop = string;
        this.fireDisplayEvent();
    }

    protected void opExecute() throws ProcessorException {
        System.out.println("SimpleProcessor: opExecute(): ");
        if (this.lastcmd.equals("+") || this.lastcmd.equals("-") || this.lastcmd.equals("*") || this.lastcmd.equals("/")) {
            this.popCmd();
            this.lastop = "";
        } else {
            this.setAccuFromInput();
            if (this.accStack.size() < 1) {
                this.appendLog("", this.acc);
            }
            this.pushAccu(this.acc);
            this.calculateStack();
        }
        this.pushCmd("=");
        while (!this.cmdStack.isEmpty()) {
            this.calculateStack();
        }
        this.appendToInput = false;
        this.lastop = "";
        this.fireDisplayEvent();
    }

    protected void calculateStack() throws ProcessorException {
        if (this.cmdStack.size() >= 1) {
            String string = this.popCmd();
            if (string.equals("+")) {
                CaDouble caDouble = this.popAccu();
                CaDouble caDouble2 = this.popAccu();
                this.appendLog(string, caDouble);
                DMath.add(caDouble2, caDouble);
                this.pushAccu(caDouble2);
            } else if (string.equals("-")) {
                CaDouble caDouble = this.popAccu();
                CaDouble caDouble3 = this.popAccu();
                this.appendLog(string, caDouble);
                DMath.sub(caDouble3, caDouble);
                this.pushAccu(caDouble3);
            } else if (string.equals("*")) {
                CaDouble caDouble = this.popAccu();
                CaDouble caDouble4 = this.popAccu();
                this.appendLog(string, caDouble);
                DMath.mul(caDouble4, caDouble);
                this.pushAccu(caDouble4);
            } else if (string.equals("/")) {
                CaDouble caDouble = this.popAccu();
                CaDouble caDouble5 = this.popAccu();
                this.appendLog(string, caDouble);
                DMath.div(caDouble5, caDouble);
                this.pushAccu(caDouble5);
            } else if (string.equals("sqr")) {
                CaDouble caDouble = this.popAccu();
                this.appendLog(string, caDouble);
                DMath.sqr(caDouble);
                this.setAccu(caDouble);
                this.pushAccu(caDouble);
            } else if (string.equals("sqrt")) {
                CaDouble caDouble = this.popAccu();
                this.appendLog(string, caDouble);
                DMath.sqrt(caDouble);
                this.setAccu(caDouble);
                this.pushAccu(caDouble);
            } else if (string.equals("ln")) {
                CaDouble caDouble = this.popAccu();
                this.appendLog(string, caDouble);
                DMath.ln(caDouble);
                this.setAccu(caDouble);
                this.pushAccu(caDouble);
            } else if (string.equals("log")) {
                CaDouble caDouble = this.popAccu();
                this.appendLog(string, caDouble);
                DMath.log(caDouble);
                this.setAccu(caDouble);
                this.pushAccu(caDouble);
            } else if (string.equals("exp")) {
                CaDouble caDouble = this.popAccu();
                this.appendLog(string, caDouble);
                DMath.exp(caDouble);
                this.setAccu(caDouble);
                this.pushAccu(caDouble);
            } else if (string.equals("exp10")) {
                CaDouble caDouble = this.popAccu();
                this.appendLog(string, caDouble);
                DMath.exp10(caDouble);
                this.setAccu(caDouble);
                this.pushAccu(caDouble);
            } else if (string.equals("xinv")) {
                CaDouble caDouble = this.popAccu();
                this.appendLog(string, caDouble);
                DMath.invx(caDouble);
                this.setAccu(caDouble);
                this.pushAccu(caDouble);
            } else if (string.equals("sin")) {
                CaDouble caDouble = this.popAccu();
                this.appendLog(string, caDouble);
                DMath.sin(caDouble);
                this.setAccu(caDouble);
                this.pushAccu(caDouble);
            } else if (string.equals("cos")) {
                CaDouble caDouble = this.popAccu();
                this.appendLog(string, caDouble);
                DMath.cos(caDouble);
                this.setAccu(caDouble);
                this.pushAccu(caDouble);
            } else if (string.equals("tan")) {
                CaDouble caDouble = this.popAccu();
                this.appendLog(string, caDouble);
                DMath.tan(caDouble);
                this.setAccu(caDouble);
                this.pushAccu(caDouble);
            } else if (string.equals("cot")) {
                CaDouble caDouble = this.popAccu();
                this.appendLog(string, caDouble);
                DMath.cot(caDouble);
                this.setAccu(caDouble);
                this.pushAccu(caDouble);
            } else if (string.equals("pow")) {
                CaDouble caDouble = this.popAccu();
                CaDouble caDouble6 = this.popAccu();
                this.appendLog(string, caDouble);
                DMath.expx(caDouble6, caDouble);
                this.pushAccu(caDouble6);
            } else if (string.equals("xrt")) {
                CaDouble caDouble = this.popAccu();
                CaDouble caDouble7 = this.popAccu();
                this.appendLog(string, caDouble);
                DMath.sqrtx(caDouble7, caDouble);
                this.pushAccu(caDouble7);
            } else if (string.equals("=")) {
                CaDouble caDouble = this.popAccu();
                this.appendLog(string, caDouble);
                try {
                    this.acc = caDouble.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new ProcessorException("calculateStack: clone failed. check Number implementation.");
                }
            }
        }
    }

    protected void setAccuFromInput() {
        if (!this.hasNewInput) {
            return;
        }
        double d = Double.valueOf(this.inputstr);
        if (this.sign < 0) {
            d = -d;
        }
        this.acc = new CaDouble(d);
        this.appendToInput = false;
        this.hasNewInput = false;
        this.accChanged = true;
    }

    protected void setAccu(CaDouble caDouble) throws ProcessorException {
        try {
            this.acc = caDouble.clone();
            this.appendToInput = false;
            this.hasNewInput = false;
            this.accChanged = true;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ProcessorException("calculateStack: clone failed. check Number implementation.");
        }
    }

    protected void getAccu() {
        this.inputstr = this.acc.toString();
        if (this.inputstr.charAt(0) == '-') {
            this.sign = -1;
            this.inputstr = this.inputstr.substring(1, this.inputstr.length() - 1);
        } else {
            this.sign = 1;
        }
        this.hasNewInput = true;
    }

    protected void pushAccu(CaDouble caDouble) throws ProcessorException {
        try {
            this.accStack.push(caDouble.clone());
            this.fireStatusEvent(2);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ProcessorException("pushAccu: v.clone() threw CloneNotSupportedException. Check implementation of Number types.");
        }
    }

    protected CaDouble popAccu() {
        if (this.accStack.isEmpty()) {
            return null;
        }
        CaDouble caDouble = this.accStack.pop();
        this.fireStatusEvent(2);
        return caDouble;
    }

    protected void pushCmd(String string) {
        this.cmdStack.push(string);
        this.fireStatusEvent(2);
    }

    protected String popCmd() {
        if (this.cmdStack.isEmpty()) {
            return null;
        }
        String string = this.cmdStack.pop();
        this.fireStatusEvent(2);
        return string;
    }

    protected void appendLog(String string) {
        this.appendLog(string, this.acc);
    }

    protected void appendLog(String string, CaDouble caDouble) {
        String string2 = string;
        if (string.equals("c.a")) {
            this.logstr = this.logstr + "\n.clear\n";
            this.fireProtocolEvent();
            return;
        }
        if (string.equals("")) {
            string2 = ".";
        }
        if (string.equals("=")) {
            this.logstr = this.logstr + "\n======================";
        }
        this.logstr = this.logstr + "\n" + string2 + " " + caDouble.toString(this.displaywidth - string2.length() + 1);
        if (string.equals("=")) {
            this.logstr = this.logstr + "\n";
        }
        this.fireProtocolEvent();
    }

    public void fireAll() {
        this.fireDisplayEvent();
        this.fireStatusEvent(3);
        this.fireProtocolEvent();
    }

    protected void fireDisplayEvent() {
        Object[] objectArray = this.listenerList.getListenerList();
        ProcessorEvent processorEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ProcessorEventListener.class) continue;
            if (processorEvent == null) {
                processorEvent = new ProcessorEvent(this);
            }
            ((ProcessorEventListener)objectArray[i + 1]).passedDisplayEvent(processorEvent);
        }
    }

    protected void fireStatusEvent(int n) {
        Object[] objectArray = this.listenerList.getListenerList();
        ProcessorEvent processorEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ProcessorEventListener.class) continue;
            if (processorEvent == null) {
                processorEvent = new ProcessorEvent(this);
            }
            processorEvent.setMask(n);
            ((ProcessorEventListener)objectArray[i + 1]).passedStatusEvent(processorEvent);
        }
    }

    protected void fireProtocolEvent() {
        Object[] objectArray = this.listenerList.getListenerList();
        ProcessorEvent processorEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ProcessorEventListener.class) continue;
            if (processorEvent == null) {
                processorEvent = new ProcessorEvent(this);
            }
            ((ProcessorEventListener)objectArray[i + 1]).passedProtocolEvent(processorEvent);
        }
    }

    @Override
    public void addProtocolListener(ProtocolEventListener protocolEventListener) {
    }

    @Override
    public void removeProtocolListener(ProtocolEventListener protocolEventListener) {
    }
}

