/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.processor;

import com.graphbuilder.math.Expression;
import com.graphbuilder.math.ExpressionParseException;
import com.graphbuilder.math.ExpressionTree;
import com.graphbuilder.math.FuncMap;
import com.graphbuilder.math.VarMap;
import de.admadic.calculator.core.LocaleEvent;
import de.admadic.calculator.core.LocaleListener;
import de.admadic.calculator.core.LocaleNumberFormatEvent;
import de.admadic.calculator.core.LocaleProvider;
import de.admadic.calculator.math.DMath;
import de.admadic.calculator.processor.IProcessor;
import de.admadic.calculator.processor.IProcessorCalculation;
import de.admadic.calculator.processor.ProcessorActionAttribute;
import de.admadic.calculator.processor.ProcessorActionAttributeManager;
import de.admadic.calculator.processor.ProcessorContextA;
import de.admadic.calculator.processor.ProcessorEvent;
import de.admadic.calculator.processor.ProcessorEventListener;
import de.admadic.calculator.processor.ProcessorException;
import de.admadic.calculator.processor.ProcessorUnknownOpException;
import de.admadic.calculator.processor.ProtocolEvent;
import de.admadic.calculator.processor.ProtocolEventListener;
import de.admadic.calculator.processor.func.FuncArCosh;
import de.admadic.calculator.processor.func.FuncArCoth;
import de.admadic.calculator.processor.func.FuncArSinh;
import de.admadic.calculator.processor.func.FuncArTanh;
import de.admadic.calculator.processor.func.FuncArcCos;
import de.admadic.calculator.processor.func.FuncArcCot;
import de.admadic.calculator.processor.func.FuncArcSin;
import de.admadic.calculator.processor.func.FuncArcTan;
import de.admadic.calculator.processor.func.FuncCos;
import de.admadic.calculator.processor.func.FuncCosec;
import de.admadic.calculator.processor.func.FuncCosh;
import de.admadic.calculator.processor.func.FuncCot;
import de.admadic.calculator.processor.func.FuncCoth;
import de.admadic.calculator.processor.func.FuncE;
import de.admadic.calculator.processor.func.FuncExp;
import de.admadic.calculator.processor.func.FuncExp10;
import de.admadic.calculator.processor.func.FuncGamma;
import de.admadic.calculator.processor.func.FuncLn;
import de.admadic.calculator.processor.func.FuncLog;
import de.admadic.calculator.processor.func.FuncPi;
import de.admadic.calculator.processor.func.FuncSec;
import de.admadic.calculator.processor.func.FuncSin;
import de.admadic.calculator.processor.func.FuncSinh;
import de.admadic.calculator.processor.func.FuncSqr;
import de.admadic.calculator.processor.func.FuncSqrt;
import de.admadic.calculator.processor.func.FuncTan;
import de.admadic.calculator.processor.func.FuncTanh;
import de.admadic.calculator.processor.func.FuncXinv;
import de.admadic.calculator.types.CaDouble;
import de.admadic.calculator.types.CaDoubleFormat;
import de.admadic.calculator.types.CaNumber;
import de.admadic.util.StringUtil;
import java.util.Stack;
import javax.swing.event.EventListenerList;

public class SimpleProcessor
implements IProcessor,
IProcessorCalculation,
LocaleListener {
    static final boolean DBG = false;
    EventListenerList listenerList = new EventListenerList();
    ProcessorActionAttributeManager paam;
    LocaleProvider localeProvider;
    int maxinputlength = 17;
    int displaywidth = 20;
    int sign = 1;
    String inputstr = null;
    boolean editable;
    boolean logStart = true;
    boolean logStartNotForOp = false;
    static final int LOGSTART_SCOPE_INPUT = 0;
    static final int LOGSTART_SCOPE_OP = 1;
    CaDoubleFormat numberFormat;
    CaDouble memory = null;
    String logstr = null;
    ActionStack actionStack = new ActionStack(this);
    VarMap stdVarMap;
    FuncMap stdFuncMap;
    public static final int ANGULARARG_RAD = 0;
    public static final int ANGULARARG_DEG = 1;
    public static final int ANGULARARG_GRA = 2;
    int angularArgMode = 0;
    static final CaDouble factorDegToRad = new CaDouble(Math.PI / 180);
    static final CaDouble factorGraToRad = new CaDouble(0.015707963267948967);
    static final CaDouble factorRadToDeg = new CaDouble(57.29577951308232);
    static final CaDouble factorRadToGra = new CaDouble(63.66197723675813);

    public SimpleProcessor() {
        ProcessorContextA processorContextA = new ProcessorContextA();
        processorContextA.init();
        this.paam = processorContextA.getPAAM();
        this.memory = new CaDouble();
        this.numberFormat = new CaDoubleFormat(1, 12, 2);
        this.inputstr = "0";
        this.editable = true;
        this.logstr = "";
        this.initVarFuncMaps();
    }

    private void initVarFuncMaps() {
        this.stdVarMap = new VarMap();
        this.stdFuncMap = new FuncMap();
        this.stdFuncMap.setFunction("sqr", new FuncSqr());
        this.stdFuncMap.setFunction("sqrt", new FuncSqrt());
        this.stdFuncMap.setFunction("ln", new FuncLn());
        this.stdFuncMap.setFunction("log", new FuncLog());
        this.stdFuncMap.setFunction("exp", new FuncExp());
        this.stdFuncMap.setFunction("exp10", new FuncExp10());
        this.stdFuncMap.setFunction("xinv", new FuncXinv());
        this.stdFuncMap.setFunction("sin", new FuncSin());
        this.stdFuncMap.setFunction("cos", new FuncCos());
        this.stdFuncMap.setFunction("tan", new FuncTan());
        this.stdFuncMap.setFunction("cot", new FuncCot());
        this.stdFuncMap.setFunction("arcsin", new FuncArcSin());
        this.stdFuncMap.setFunction("arccos", new FuncArcCos());
        this.stdFuncMap.setFunction("arctan", new FuncArcTan());
        this.stdFuncMap.setFunction("arccot", new FuncArcCot());
        this.stdFuncMap.setFunction("sinh", new FuncSinh());
        this.stdFuncMap.setFunction("cosh", new FuncCosh());
        this.stdFuncMap.setFunction("tanh", new FuncTanh());
        this.stdFuncMap.setFunction("coth", new FuncCoth());
        this.stdFuncMap.setFunction("arsinh", new FuncArSinh());
        this.stdFuncMap.setFunction("arcosh", new FuncArCosh());
        this.stdFuncMap.setFunction("artanh", new FuncArTanh());
        this.stdFuncMap.setFunction("arcoth", new FuncArCoth());
        this.stdFuncMap.setFunction("sec", new FuncSec());
        this.stdFuncMap.setFunction("cosec", new FuncCosec());
        this.stdFuncMap.setFunction("pi", new FuncPi());
        this.stdFuncMap.setFunction("e", new FuncE());
        this.stdFuncMap.setFunction("gamma", new FuncGamma());
    }

    public LocaleProvider getLocaleProvider() {
        return this.localeProvider;
    }

    public void setLocaleProvider(LocaleProvider localeProvider) {
        if (this.localeProvider != null) {
            this.localeProvider.removeLocaleListener(this);
        }
        this.localeProvider = localeProvider;
        if (this.localeProvider != null) {
            this.numberFormat.setLocale(localeProvider.getDefaultLocale());
            this.localeProvider.addLocaleListener(this);
        }
    }

    public CaDouble getAccuValue() throws ProcessorException {
        try {
            return this.actionStack.getAccu().clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ProcessorException("calculateStack: clone failed. check Number implementation.");
        }
    }

    @Override
    public String getDisplay() {
        Object object = "";
        object = this.editable ? (String)object + (this.sign < 0 ? "-" + this.inputstr : " " + this.inputstr) : (String)object + this.getAccDisplay();
        return (String)object + " ";
    }

    public String getAccDisplay() {
        CaDouble caDouble = this.actionStack.getAccu();
        if (caDouble.isNotNormal()) {
            return caDouble.getStateString();
        }
        String string = this.numberFormat.format(caDouble);
        string.trim();
        return string;
    }

    @Override
    public String getLogDisplay() {
        return this.logstr;
    }

    public String getStatusDisplay() {
        return " " + this.getMemDisplay() + " ";
    }

    @Override
    public String getMemDisplay() {
        return this.testMemDisplay() ? "M" : " ";
    }

    public boolean testMemDisplay() {
        return this.memory.getValue() != 0.0;
    }

    @Override
    public String getStackDisplay() {
        return "Stack: |action|=" + this.actionStack.size();
    }

    @Override
    public void addProcessorListener(ProcessorEventListener processorEventListener) {
        this.listenerList.add(ProcessorEventListener.class, processorEventListener);
    }

    @Override
    public void removeProcessorListener(ProcessorEventListener processorEventListener) {
        this.listenerList.remove(ProcessorEventListener.class, processorEventListener);
    }

    @Override
    public void addProtocolListener(ProtocolEventListener protocolEventListener) {
        this.listenerList.add(ProtocolEventListener.class, protocolEventListener);
    }

    @Override
    public void removeProtocolListener(ProtocolEventListener protocolEventListener) {
        this.listenerList.remove(ProtocolEventListener.class, protocolEventListener);
    }

    @Override
    public void processCommand(String string) throws ProcessorException {
        ProcessorActionAttribute processorActionAttribute = this.paam.get(string);
        if (processorActionAttribute != null) {
            if (string.equals("percent")) {
                this.opPercent(string);
            } else if (processorActionAttribute.getType() == 1) {
                this.updateInputString(string);
            } else if (processorActionAttribute.getType() == 2 && processorActionAttribute.getOrder() == 2) {
                this.opBinary(string);
            } else if (processorActionAttribute.getType() == 2 && processorActionAttribute.getOrder() == 1) {
                this.opUnary(string);
            } else if (processorActionAttribute.getType() == 2 && processorActionAttribute.getOrder() == 0) {
                this.opConstant(string);
            } else if (string.equals("=")) {
                this.opExecute();
            }
            if (string.equals("c.a")) {
                this.clear();
            }
            if (string.equals("c.e")) {
                this.clearEntry();
            }
            if (string.equals("m.c")) {
                this.memoryClear();
            }
            if (string.equals("l.c")) {
                this.clearLog();
            }
            if (string.equals("l.cl")) {
                this.clearLastLogLine();
            }
            if (string.equals("m.+")) {
                this.memoryPlus();
            }
            if (string.equals("m.-")) {
                this.memoryMinus();
            }
            if (string.equals("m.s")) {
                this.memoryStore();
            }
            if (string.equals("m.r")) {
                this.memoryRead();
            }
        }
    }

    public void clear() {
        this.actionStack.clear();
        this.inputstr = "0";
        this.sign = 1;
        this.editable = true;
        this.appendLog("c.a", null, this.actionStack.getAccu(), this.actionStack.getLastSubResult(), null);
        this.setLogStart(true);
        this.fireDisplayEvent();
        this.fireStatusEvent(2);
    }

    public void memoryClear() {
        this.memory.setZero();
        this.fireStatusEvent(1);
    }

    public void clearLog() {
        this.logstr = "";
        this.fireProtocolEvent();
    }

    public void clearLastLogLine() {
        int n = this.logstr.lastIndexOf("\n");
        this.logstr = n < 0 ? "" : this.logstr.substring(0, n);
        this.fireProtocolEvent();
    }

    public void clearEntry() {
        if (this.actionStack.isTOSActionNum()) {
            this.inputstr = "0";
            this.sign = 1;
            this.editable = true;
            this.setAccuFromInput();
        } else if (this.actionStack.isTOSActionOp()) {
            this.actionStack.pop();
        }
        this.fireDisplayEvent();
    }

    public void memoryPlus() {
        if (this.editable) {
            this.closeInput();
        }
        DMath.add(this.memory, this.actionStack.getAccu());
        this.fireStatusEvent(1);
    }

    public void memoryMinus() {
        if (this.editable) {
            this.closeInput();
        }
        DMath.sub(this.memory, this.actionStack.getAccu());
        this.fireStatusEvent(1);
    }

    public void memoryStore() {
        if (this.editable) {
            this.closeInput();
        }
        this.actionStack.getAccu().cloneTo(this.memory);
        this.fireStatusEvent(1);
    }

    public void memoryRead() {
        if (this.actionStack.isTOSActionOp()) {
            this.actionStack.newAccuForInput();
        }
        this.memory.cloneTo(this.actionStack.getAccu());
        this.getAccuToInput();
        this.fireDisplayEvent();
    }

    public void calcSubExprImpl(String string, CaNumber caNumber, boolean bl) throws ProcessorUnknownOpException {
        double d;
        Object object = string.trim();
        if (((String)object).contains("%")) {
            if (((String)object).startsWith("ex")) {
                object = ((String)object).replaceAll("%", "");
                object = ((String)object).replaceAll("ex", "");
                int n = ((String)(object = ((String)object).replaceAll(":", "*"))).indexOf(42);
                if (n < 0) {
                    throw new ProcessorUnknownOpException("%-expression not supported: " + string);
                }
                String string2 = ((String)object).substring(n + 1);
                object = ((String)object).substring(0, n);
                object = "((" + (String)object + ")*0.01)";
                object = (String)object + " / (1.0 + " + (String)object + ") * " + string2;
            } else {
                object = ((String)object).replaceAll("%", "*0.01");
            }
        }
        try {
            Expression expression = ExpressionTree.parse((String)object);
            d = expression.eval(this.stdVarMap, this.stdFuncMap);
        }
        catch (ExpressionParseException expressionParseException) {
            throw new ProcessorUnknownOpException("expression not supported (1): " + string);
        }
        catch (RuntimeException runtimeException) {
            throw new ProcessorUnknownOpException("expression not supported (2): " + string);
        }
        ((CaDouble)caNumber).setValue(d);
    }

    public void calcBinaryOpImpl(String string, CaNumber caNumber, CaNumber caNumber2, CaNumber caNumber3, boolean bl) throws ProcessorUnknownOpException {
        if (caNumber3 != null) {
            caNumber.cloneTo(caNumber3);
            caNumber = caNumber3;
        }
        String string2 = string;
        CaDouble caDouble = (CaDouble)caNumber;
        CaDouble caDouble2 = (CaDouble)caNumber2;
        CaDouble caDouble3 = null;
        CaDouble caDouble4 = null;
        CaDouble caDouble5 = null;
        String string3 = null;
        String string4 = null;
        try {
            caDouble3 = caDouble.clone();
            caDouble4 = caDouble2.clone();
            string3 = string2;
            if (this.actionStack.getLastSubResult() != null) {
                caDouble5 = this.actionStack.getLastSubResult().clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        if (string2.equals("+")) {
            DMath.add(caDouble, caDouble2);
        } else if (string2.equals("-")) {
            DMath.sub(caDouble, caDouble2);
        } else if (string2.equals("*")) {
            DMath.mul(caDouble, caDouble2);
        } else if (string2.equals("/")) {
            DMath.div(caDouble, caDouble2);
        } else if (string2.equals("pow")) {
            DMath.expx(caDouble, caDouble2);
        } else if (string2.equals("xrt")) {
            DMath.sqrtx(caDouble, caDouble2);
        } else if (string2.equals("percent.+")) {
            String string5 = caDouble2.toString();
            string4 = string5 + "%";
            string3 = "+";
            DMath.mul(caDouble2, new CaDouble(0.01));
            DMath.mul(caDouble2, caDouble);
            caDouble2.cloneTo(caDouble4);
            DMath.add(caDouble, caDouble2);
        } else if (string2.equals("percent.-")) {
            String string6 = caDouble2.toString();
            string4 = string6 + "%";
            string3 = "-";
            DMath.mul(caDouble2, new CaDouble(0.01));
            DMath.mul(caDouble2, caDouble);
            caDouble2.cloneTo(caDouble4);
            DMath.sub(caDouble, caDouble2);
        } else if (string2.equals("percent.*")) {
            String string7 = caDouble2.toString();
            string4 = string7 + "%";
            string3 = "*";
            DMath.mul(caDouble2, new CaDouble(0.01));
            caDouble2.cloneTo(caDouble4);
            DMath.mul(caDouble, caDouble2);
        } else if (string2.equals("percent./")) {
            String string8 = caDouble2.toString();
            string4 = string8 + "%";
            string3 = "/";
            DMath.mul(caDouble2, new CaDouble(0.01));
            caDouble2.cloneTo(caDouble4);
            DMath.div(caDouble, caDouble2);
        } else if (string2.equals("percent.ex")) {
            String string9 = caDouble2.toString();
            string4 = "ex " + string9 + "%";
            string3 = "-";
            CaDouble caDouble6 = new CaDouble();
            CaDouble caDouble7 = new CaDouble();
            caDouble2.cloneTo(caDouble6);
            caDouble2.cloneTo(caDouble7);
            DMath.mul(caDouble6, new CaDouble(0.01));
            DMath.mul(caDouble7, new CaDouble(0.01));
            DMath.add(caDouble7, new CaDouble(1.0));
            DMath.div(caDouble6, caDouble7);
            DMath.mul(caDouble6, caDouble);
            caDouble6.cloneTo(caDouble4);
            DMath.sub(caDouble, caDouble6);
        } else {
            throw new ProcessorUnknownOpException("calcBinaryOp(): unsupported cmd " + string2);
        }
        if (bl) {
            this.actionStack.setLastSubResult(caDouble);
        }
        if (bl) {
            this.checkLogStart(caDouble3, 1);
            this.appendLog(string3, string4, caDouble4, caDouble5, null);
        }
    }

    public void calcUnaryOpImpl(String string, CaNumber caNumber, CaNumber caNumber2, boolean bl) throws ProcessorUnknownOpException {
        if (caNumber2 != null) {
            caNumber.cloneTo(caNumber2);
            caNumber = caNumber2;
        }
        String string2 = string;
        CaDouble caDouble = (CaDouble)caNumber;
        String string3 = string2;
        CaDouble caDouble2 = new CaDouble();
        CaDouble caDouble3 = new CaDouble();
        caDouble.cloneTo(caDouble2);
        caDouble.cloneTo(caDouble3);
        Object object = "ans";
        if (string2.equals("sqr")) {
            DMath.sqr(caDouble);
        } else if (string2.equals("sqrt")) {
            DMath.sqrt(caDouble);
        } else if (string2.equals("ln")) {
            DMath.ln(caDouble);
        } else if (string2.equals("log")) {
            DMath.log(caDouble);
        } else if (string2.equals("exp")) {
            DMath.exp(caDouble);
        } else if (string2.equals("exp10")) {
            DMath.exp10(caDouble);
        } else if (string2.equals("xinv")) {
            DMath.invx(caDouble);
        } else if (string2.equals("sin")) {
            caDouble = this.convertToRad(caDouble);
            DMath.sin(caDouble);
        } else if (string2.equals("cos")) {
            caDouble = this.convertToRad(caDouble);
            DMath.cos(caDouble);
        } else if (string2.equals("tan")) {
            caDouble = this.convertToRad(caDouble);
            DMath.tan(caDouble);
        } else if (string2.equals("cot")) {
            caDouble = this.convertToRad(caDouble);
            DMath.cot(caDouble);
        } else if (string2.equals("arcsin")) {
            DMath.arcsin(caDouble);
            caDouble = this.convertFromRad(caDouble);
        } else if (string2.equals("arccos")) {
            DMath.arccos(caDouble);
            caDouble = this.convertFromRad(caDouble);
        } else if (string2.equals("arctan")) {
            DMath.arctan(caDouble);
            caDouble = this.convertFromRad(caDouble);
        } else if (string2.equals("arccot")) {
            DMath.arccot(caDouble);
            caDouble = this.convertFromRad(caDouble);
        } else if (string2.equals("sinh")) {
            DMath.sinh(caDouble);
        } else if (string2.equals("cosh")) {
            DMath.cosh(caDouble);
        } else if (string2.equals("tanh")) {
            DMath.tanh(caDouble);
        } else if (string2.equals("coth")) {
            DMath.coth(caDouble);
        } else if (string2.equals("arsinh")) {
            DMath.arsinh(caDouble);
        } else if (string2.equals("arcosh")) {
            DMath.arcosh(caDouble);
        } else if (string2.equals("artanh")) {
            DMath.artanh(caDouble);
        } else if (string2.equals("arcoth")) {
            DMath.arcoth(caDouble);
        } else if (string2.equals("sec")) {
            caDouble = this.convertToRad(caDouble);
            DMath.sec(caDouble);
        } else if (string2.equals("cosec")) {
            caDouble = this.convertFromRad(caDouble);
            DMath.cosec(caDouble);
        } else if (string2.equals("gamma")) {
            DMath.gamma(caDouble);
        } else if (string2.equals("percent")) {
            String string4 = caDouble.toString();
            object = string4 + "%";
            DMath.mul(caDouble, new CaDouble(0.01));
        } else {
            throw new ProcessorUnknownOpException("calcUnaryOp(): unsupported cmd " + string2);
        }
        if (bl) {
            this.checkLogStart(caDouble2, 1);
            this.appendLog(string3, (String)object, caDouble, caDouble3, null);
        }
    }

    public void calcConstantOpImpl(String string, CaNumber caNumber, boolean bl) throws ProcessorUnknownOpException {
        double d;
        String string2 = string;
        if (string2.equals("e")) {
            d = Math.E;
        } else if (string2.equals("pi")) {
            d = Math.PI;
        } else {
            throw new ProcessorUnknownOpException("operation " + string + " is not supported.");
        }
        ((CaDouble)caNumber).setValue(d);
    }

    @Override
    public int getOpOrder(String string) throws ProcessorUnknownOpException {
        int n = -1;
        ProcessorActionAttribute processorActionAttribute = this.paam.get(string);
        if (processorActionAttribute == null) {
            throw new ProcessorUnknownOpException("command " + string + " is unknown.");
        }
        n = processorActionAttribute.getOrder();
        return n;
    }

    @Override
    public void calcSubExpr(String string, CaNumber caNumber) throws ProcessorUnknownOpException {
        this.calcSubExprImpl(string, caNumber, false);
    }

    @Override
    public void calcBinaryOp(String string, CaNumber caNumber, CaNumber caNumber2, CaNumber caNumber3) throws ProcessorUnknownOpException {
        this.calcBinaryOpImpl(string, caNumber, caNumber2, caNumber3, false);
    }

    @Override
    public void calcUnaryOp(String string, CaNumber caNumber, CaNumber caNumber2) throws ProcessorUnknownOpException {
        this.calcUnaryOpImpl(string, caNumber, caNumber2, false);
    }

    @Override
    public void calcConstantOp(String string, CaNumber caNumber) throws ProcessorUnknownOpException {
        this.calcConstantOpImpl(string, caNumber, false);
    }

    protected void closeInput() {
        this.editable = false;
        int n = this.actionStack.size() - 1;
        n = this.actionStack.getNextValueIdx(n);
        int n2 = n - 1;
        n2 = this.actionStack.getNextOpIdx(n2);
        if (n >= 0) {
            String string = ".";
            CaDouble caDouble = (CaDouble)this.actionStack.elementAt(n);
            if (n2 >= 0) {
                string = (String)this.actionStack.elementAt(n2);
            }
            this.checkLogStart(caDouble, 0);
        }
        this.fireStatusEvent(2);
    }

    protected void updateInputString(String string) {
        if (!this.editable) {
            this.sign = 1;
            this.inputstr = "0";
            this.actionStack.newAccuForInput();
            this.editable = true;
        }
        if (string.equals("BS") && !this.inputstr.equals("0")) {
            this.inputstr = this.inputstr.substring(0, this.inputstr.length() - 1);
            if (this.inputstr.length() < 1) {
                this.inputstr = "0";
            }
        }
        if (string.equals(".") && this.inputstr.indexOf(".") < 0 && this.inputstr.length() < this.maxinputlength) {
            this.inputstr = this.inputstr + ".";
        }
        if (string.equals("+/-")) {
            this.sign = -this.sign;
        }
        if (string.equals("ex")) {
            // empty if block
        }
        if (string.equals("0") || string.equals("1") || string.equals("2") || string.equals("3") || string.equals("4") || string.equals("5") || string.equals("6") || string.equals("7") || string.equals("8") || string.equals("9")) {
            if (this.inputstr.equals("0")) {
                this.inputstr = string;
            } else if (this.inputstr.length() < this.maxinputlength) {
                this.inputstr = this.inputstr + string;
            }
        }
        this.setAccuFromInput();
        this.fireStatusEvent(2);
        this.fireDisplayEvent();
    }

    protected void opPercent(String string) {
        String string2;
        ProcessorActionAttribute processorActionAttribute;
        Object object;
        if (this.editable) {
            this.closeInput();
        }
        if ((object = this.actionStack.peek()) instanceof String && (processorActionAttribute = this.paam.get(string2 = (String)object)) != null && processorActionAttribute.getType() == 2 && processorActionAttribute.getOrder() == 2) {
            this.actionStack.pop();
        }
        this.actionStack.pushAction(string);
        this.opPercentFixup();
        this.calculateStack();
        this.fireDisplayEvent();
    }

    protected void opPercentFixup() {
        if (this.actionStack.size() < 4) {
            return;
        }
        int n = this.actionStack.size() - 1;
        Object object = this.actionStack.elementAt(n);
        Object object2 = this.actionStack.elementAt(n - 1);
        Object object3 = this.actionStack.elementAt(n - 2);
        Object object4 = this.actionStack.elementAt(n - 3);
        if (!(object instanceof String) || !object.equals("percent")) {
            return;
        }
        if (!(object2 instanceof CaNumber)) {
            return;
        }
        if (!(object3 instanceof String && (object3.equals("+") || object3.equals("-") || object3.equals("*") || object3.equals("/") || object3.equals("percent.ex")))) {
            return;
        }
        if (!(object4 instanceof CaNumber)) {
            return;
        }
        String string = null;
        if (object3.equals("+")) {
            string = "percent.+";
        } else if (object3.equals("-")) {
            string = "percent.-";
        } else if (object3.equals("*")) {
            string = "percent.*";
        } else if (object3.equals("/")) {
            string = "percent./";
        } else if (object3.equals("percent.ex")) {
            string = "percent.ex";
        } else {
            throw new Error("Software is probably corrupted. Please contact customer support.");
        }
        this.actionStack.removeElementAt(n);
        this.actionStack.removeElementAt(n - 1);
        this.actionStack.removeElementAt(n - 2);
        this.actionStack.pushAction(string);
        this.actionStack.pushAction(object2);
    }

    protected void opBinary(String string) {
        String string2;
        ProcessorActionAttribute processorActionAttribute;
        if (this.editable) {
            this.closeInput();
        }
        this.checkLogStart(this.actionStack.getAccu(), 1);
        Object object = this.actionStack.peek();
        if (object instanceof String && (processorActionAttribute = this.paam.get(string2 = (String)object)) != null && processorActionAttribute.getType() == 2 && processorActionAttribute.getOrder() == 2) {
            this.actionStack.pop();
        }
        this.actionStack.pushAction(string);
        this.calculateStack();
        this.fireDisplayEvent();
    }

    protected void opUnary(String string) {
        String string2;
        ProcessorActionAttribute processorActionAttribute;
        if (this.editable) {
            this.closeInput();
        }
        this.checkLogStart(this.actionStack.getAccu(), 1);
        Object object = this.actionStack.peek();
        if (object instanceof String && (processorActionAttribute = this.paam.get(string2 = (String)object)) != null && processorActionAttribute.getType() == 2 && processorActionAttribute.getOrder() == 2) {
            this.actionStack.pop();
        }
        this.calculateStack();
        this.actionStack.pushAction(string);
        this.calculateStack();
        this.fireDisplayEvent();
    }

    protected void opConstant(String string) {
        double d;
        if (string.equals("e")) {
            d = Math.E;
        } else if (string.equals("pi")) {
            d = Math.PI;
        } else {
            return;
        }
        if (this.editable) {
            this.actionStack.getAccu().setValue(d);
            this.getAccuToInput();
            this.closeInput();
        } else {
            this.actionStack.newAccuForInput();
            this.actionStack.getAccu().setValue(d);
            this.closeInput();
        }
        this.getAccuToInput();
        this.fireDisplayEvent();
    }

    protected void opExecute() {
        if (this.editable) {
            this.closeInput();
        }
        this.actionStack.pushAction("=");
        int n = -1;
        while (this.actionStack.size() > 1 && this.actionStack.size() != n) {
            n = this.actionStack.size();
            this.calculateStack();
        }
        this.appendLog("=", null, this.actionStack.getAccu(), this.actionStack.getLastSubResult(), null);
        this.setLogStart(true);
        this.fireDisplayEvent();
    }

    protected void calculateStack() {
        int n = this.actionStack.size() - 1;
        while (true) {
            Object object;
            String string = null;
            while (n >= 0) {
                object = this.actionStack.elementAt(n);
                if (object instanceof String) {
                    string = (String)object;
                    break;
                }
                --n;
            }
            if (string == null) {
                return;
            }
            object = this.paam.get(string);
            if (object == null) {
                return;
            }
            if (this.calculateStack((ProcessorActionAttribute)object, n)) {
                return;
            }
            --n;
        }
    }

    protected CaDouble convertToRad(CaDouble caDouble) {
        switch (this.getAngularArgMode()) {
            case 1: {
                DMath.mul(caDouble, factorDegToRad);
                break;
            }
            case 2: {
                DMath.mul(caDouble, factorGraToRad);
                break;
            }
        }
        return caDouble;
    }

    protected CaDouble convertFromRad(CaDouble caDouble) {
        switch (this.getAngularArgMode()) {
            case 1: {
                DMath.mul(caDouble, factorRadToDeg);
                break;
            }
            case 2: {
                DMath.mul(caDouble, factorRadToGra);
                break;
            }
        }
        return caDouble;
    }

    protected boolean calculateStack(ProcessorActionAttribute processorActionAttribute, int n) {
        String string = processorActionAttribute.getPa();
        if (processorActionAttribute.getOrder() == 1) {
            CaDouble caDouble = (CaDouble)this.actionStack.elementAt(n - 1);
            try {
                this.calcUnaryOpImpl(string, caDouble, null, true);
            }
            catch (ProcessorUnknownOpException processorUnknownOpException) {
                processorUnknownOpException.printStackTrace();
            }
            this.setLogStart(true, true);
            this.actionStack.removeElementAt(n);
        } else if (processorActionAttribute.getOrder() == 2) {
            if (n + 1 >= this.actionStack.size()) {
                return false;
            }
            CaDouble caDouble = (CaDouble)this.actionStack.elementAt(n - 1);
            CaDouble caDouble2 = (CaDouble)this.actionStack.elementAt(n + 1);
            try {
                this.calcBinaryOpImpl(string, caDouble, caDouble2, null, true);
            }
            catch (ProcessorUnknownOpException processorUnknownOpException) {
                processorUnknownOpException.printStackTrace();
            }
            this.actionStack.removeElementAt(n + 1);
            this.actionStack.removeElementAt(n);
        } else if (string.equals("=")) {
            this.actionStack.removeElementAt(n);
        } else {
            this.actionStack.removeElementAt(n);
        }
        this.fireStatusEvent(2);
        return true;
    }

    protected void setAccuFromInput() {
        double d = Double.valueOf(this.inputstr);
        if (this.sign < 0) {
            d = -d;
        }
        this.actionStack.getAccu().setValue(d);
    }

    protected void setAccu(CaDouble caDouble) {
        caDouble.cloneTo(this.actionStack.getAccu());
    }

    protected void getAccuToInput() {
        this.inputstr = this.actionStack.getAccu().toString();
        if (this.inputstr.charAt(0) == '-') {
            this.sign = -1;
            this.inputstr = this.inputstr.substring(1, this.inputstr.length() - 1);
        } else {
            this.sign = 1;
        }
        this.closeInput();
    }

    protected void appendLog(String string, String string2, CaDouble caDouble, CaDouble caDouble2, CaDouble caDouble3) {
        String string3 = string;
        ProcessorActionAttribute processorActionAttribute = this.paam.get(string);
        if (processorActionAttribute != null) {
            string3 = processorActionAttribute.getDisplay();
        }
        if (string.equals("c.a")) {
            this.logstr = this.logstr + "\n" + string3 + "\n";
            this.fireProtocolEvent();
            return;
        }
        if (string.equals("")) {
            string3 = ".";
        }
        if (string.equals("=")) {
            this.logstr = this.logstr + "\n" + StringUtil.fill('-', this.getProtocolWidth());
        }
        String string4 = string3;
        if (string2 != null) {
            this.logstr = this.logstr + "\n-> " + string2;
        }
        this.logstr = string4.length() > 6 ? this.logstr + "\n-> " + string4 + "\n" + (string + "      ").substring(0, 6) + " " + (caDouble != null ? this.numberFormat.format(caDouble) : "./.") : this.logstr + "\n" + (string4 + "     ").substring(0, 6) + " " + (caDouble != null ? this.numberFormat.format(caDouble) : "./.");
        if (string.equals("=")) {
            this.logstr = this.logstr + "\n" + StringUtil.fill('=', this.getProtocolWidth());
            this.logstr = this.logstr + "\n";
        }
        if (string.equals("=")) {
            this.fireProtocolAddResultEvent(string, caDouble, caDouble2, caDouble3);
        } else if (string2 != null) {
            this.fireProtocolAddSubExprEvent(string, string2, caDouble, caDouble2, caDouble3);
        } else {
            this.fireProtocolAddOpEvent(string, caDouble, caDouble2, caDouble3);
        }
        this.fireProtocolEvent();
    }

    public int getProtocolWidth() {
        return 7 + this.numberFormat.getWidth();
    }

    public void fireAll() {
        this.fireDisplayEvent();
        this.fireStatusEvent(7);
        this.fireProtocolEvent();
    }

    protected void fireDisplayEvent() {
        Object[] objectArray = this.listenerList.getListenerList();
        ProcessorEvent processorEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ProcessorEventListener.class) continue;
            if (processorEvent == null) {
                processorEvent = new ProcessorEvent(this);
            }
            ((ProcessorEventListener)objectArray[i + 1]).passedDisplayEvent(processorEvent);
        }
    }

    protected void fireStatusEvent(int n) {
        Object[] objectArray = this.listenerList.getListenerList();
        ProcessorEvent processorEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ProcessorEventListener.class) continue;
            if (processorEvent == null) {
                processorEvent = new ProcessorEvent(this);
            }
            processorEvent.setMask(n);
            ((ProcessorEventListener)objectArray[i + 1]).passedStatusEvent(processorEvent);
        }
    }

    protected void fireProtocolEvent() {
        Object[] objectArray = this.listenerList.getListenerList();
        ProcessorEvent processorEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ProcessorEventListener.class) continue;
            if (processorEvent == null) {
                processorEvent = new ProcessorEvent(this);
            }
            ((ProcessorEventListener)objectArray[i + 1]).passedProtocolEvent(processorEvent);
        }
    }

    protected void fireProtocolAddOpEvent(String string, CaNumber caNumber, CaNumber caNumber2, CaNumber caNumber3) {
        Object[] objectArray = this.listenerList.getListenerList();
        ProtocolEvent protocolEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ProtocolEventListener.class) continue;
            if (protocolEvent == null) {
                protocolEvent = new ProtocolEvent(this, string, null, caNumber, caNumber2, caNumber3);
            }
            ((ProtocolEventListener)objectArray[i + 1]).addOp(protocolEvent);
        }
    }

    protected void fireProtocolAddSubExprEvent(String string, String string2, CaNumber caNumber, CaNumber caNumber2, CaNumber caNumber3) {
        Object[] objectArray = this.listenerList.getListenerList();
        ProtocolEvent protocolEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ProtocolEventListener.class) continue;
            if (protocolEvent == null) {
                protocolEvent = new ProtocolEvent(this, string, string2, caNumber, caNumber2, caNumber3);
            }
            ((ProtocolEventListener)objectArray[i + 1]).addSubExprOp(protocolEvent);
        }
    }

    protected void fireProtocolAddResultEvent(String string, CaNumber caNumber, CaNumber caNumber2, CaNumber caNumber3) {
        Object[] objectArray = this.listenerList.getListenerList();
        ProtocolEvent protocolEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ProtocolEventListener.class) continue;
            if (protocolEvent == null) {
                protocolEvent = new ProtocolEvent(this, string, null, caNumber, caNumber2, caNumber3);
            }
            ((ProtocolEventListener)objectArray[i + 1]).addResult(protocolEvent);
        }
    }

    protected void fireProtocolAddClearEvent() {
        Object[] objectArray = this.listenerList.getListenerList();
        ProtocolEvent protocolEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ProtocolEventListener.class) continue;
            if (protocolEvent == null) {
                protocolEvent = new ProtocolEvent(this, null, null, null, null, null);
            }
            ((ProtocolEventListener)objectArray[i + 1]).addClear(protocolEvent);
        }
    }

    public Stack<Object> getActionStack() {
        return this.actionStack.getActionStack();
    }

    public CaDoubleFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(CaDoubleFormat caDoubleFormat) {
        this.numberFormat = caDoubleFormat;
        if (this.localeProvider != null) {
            this.numberFormat.setLocale(this.localeProvider.getDefaultLocale());
        }
    }

    @Override
    public void localeChanged(LocaleEvent localeEvent) {
        this.numberFormat.setLocale(this.localeProvider.getDefaultLocale());
        this.fireDisplayEvent();
    }

    @Override
    public void localeNumberFormatChanged(LocaleNumberFormatEvent localeNumberFormatEvent) {
        this.numberFormat.setLocale(this.localeProvider.getDefaultLocale());
        this.fireDisplayEvent();
    }

    public int getAngularArgMode() {
        return this.angularArgMode;
    }

    public void setAngularArgMode(int n) {
        this.angularArgMode = n;
    }

    public boolean isLogStart() {
        return this.logStart;
    }

    public void setLogStart(boolean bl) {
        this.logStart = bl;
        this.logStartNotForOp = false;
    }

    public void setLogStart(boolean bl, boolean bl2) {
        this.logStart = bl;
        this.logStartNotForOp = bl2;
    }

    public void checkLogStart(CaDouble caDouble, int n) {
        if (this.isLogStart()) {
            if (this.isLogStartNotForOp()) {
                switch (n) {
                    case 0: {
                        this.appendLog("", null, caDouble, null, null);
                        this.setLogStart(false);
                        break;
                    }
                    case 1: {
                        this.setLogStart(false);
                    }
                }
            } else {
                this.appendLog("", null, caDouble, null, null);
                this.setLogStart(false);
            }
        }
    }

    public boolean isLogStartNotForOp() {
        return this.logStartNotForOp;
    }

    public static class ActionStack {
        private Stack<Object> actionStack = null;
        private CaDouble accuRef;
        private SimpleProcessor procRef;
        private CaDouble lastSubResultRef;

        public ActionStack(SimpleProcessor simpleProcessor) {
            this.procRef = simpleProcessor;
            this.actionStack = new Stack();
            this.accuRef = new CaDouble();
            this.actionStack.push(this.accuRef);
            this.lastSubResultRef = this.accuRef;
        }

        public Stack<Object> getActionStack() {
            return this.actionStack;
        }

        public void pushOp(String string) {
            this.actionStack.push(string);
            this.procRef.fireStatusEvent(2);
        }

        public void pushValue(CaDouble caDouble) {
            this.actionStack.push(caDouble);
            this.procRef.fireStatusEvent(2);
        }

        public void pushAction(Object object) {
            this.actionStack.push(object);
            this.procRef.fireStatusEvent(2);
        }

        public boolean isEmpty() {
            return this.actionStack.isEmpty();
        }

        public Object pop() {
            if (this.actionStack.isEmpty()) {
                return null;
            }
            Object object = this.actionStack.pop();
            this.procRef.fireStatusEvent(2);
            return object;
        }

        public Object peek() {
            if (this.actionStack.isEmpty()) {
                return null;
            }
            return this.actionStack.peek();
        }

        public CaDouble getAccu() {
            return this.accuRef;
        }

        public int size() {
            return this.actionStack.size();
        }

        public void clear() {
            this.actionStack.clear();
            this.accuRef = new CaDouble();
            this.actionStack.push(this.accuRef);
            this.lastSubResultRef = this.accuRef;
            this.procRef.fireStatusEvent(2);
        }

        public void newAccuForInput() {
            if (this.actionStack.size() == 1) {
                this.accuRef.setZero();
            } else {
                this.accuRef = new CaDouble();
                this.actionStack.push(this.accuRef);
            }
            this.procRef.fireStatusEvent(2);
        }

        public Object elementAt(int n) {
            return this.actionStack.elementAt(n);
        }

        public int getNextValueIdx(int n) {
            Object e;
            int n2 = this.actionStack.size() - 1;
            if (n >= 0) {
                n2 = n;
            }
            while (n2 >= 0 && !((e = this.actionStack.elementAt(n2)) instanceof CaDouble)) {
                --n2;
            }
            return n2;
        }

        public int getNextOpIdx(int n) {
            Object e;
            int n2 = this.actionStack.size() - 1;
            if (n >= 0) {
                n2 = n;
            }
            while (n2 >= 0 && !((e = this.actionStack.elementAt(n2)) instanceof String)) {
                --n2;
            }
            return n2;
        }

        public void removeElementAt(int n) {
            Object e = this.actionStack.elementAt(n);
            if (e == this.accuRef) {
                int n2 = this.getNextValueIdx(n - 1);
                if (n2 < 0) {
                    throw new Error("The single accu is being removed!");
                }
                this.accuRef = (CaDouble)this.actionStack.elementAt(n2);
            }
            if (e == this.lastSubResultRef) {
                this.lastSubResultRef = null;
            }
            this.actionStack.removeElementAt(n);
            this.procRef.fireStatusEvent(2);
        }

        public boolean isTOSActionNum() {
            Object object;
            return !this.actionStack.isEmpty() && (object = this.actionStack.peek()) instanceof CaNumber;
        }

        public boolean isTOSActionOp() {
            Object object;
            return !this.actionStack.isEmpty() && (object = this.actionStack.peek()) instanceof String;
        }

        public CaDouble getLastSubResult() {
            return this.lastSubResultRef;
        }

        public void setLastSubResult(CaDouble caDouble) {
            this.lastSubResultRef = caDouble;
        }
    }
}

