/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.matrx.ui;

import de.admadic.calculator.modules.matrx.MatrxActions;
import de.admadic.calculator.modules.matrx.MatrxCfg;
import de.admadic.calculator.modules.matrx.core.DMatrix;
import de.admadic.calculator.modules.matrx.core.MatrixException;
import de.admadic.calculator.modules.matrx.core.MatrixLinearDependentException;
import de.admadic.calculator.modules.matrx.core.MatrixOp;
import de.admadic.calculator.modules.matrx.ui.FloatingPointFormatter;
import de.admadic.calculator.modules.matrx.ui.ICfgHandler;
import de.admadic.calculator.modules.matrx.ui.MatrixPanel;
import de.admadic.calculator.modules.matrx.ui.MatrixUiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;

public class SimpleOpPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    FloatingPointFormatter fpf;
    MatrxCfg cfg;
    ICfgHandler cfghdl;
    JToolBar toolBar;
    JSplitPane splitPane;
    MatrixPanel mtxPanelInput;
    MatrixPanel mtxPanelResult;
    DMatrix mtxInput;
    DMatrix mtxResult;
    CreateNewAction actionNew;
    CreateNewInputAction actionNewInput;
    CreateUTFormAction actionUTForm;
    CalcTransposeAction actionTranspose;
    CalcCofactorAction actionCofactor;
    CalcAdjointAction actionAdjoint;
    CalcInverseAction actionInverse;
    CalcDeterminantAction actionDet;
    CalcTraceAction actionTrace;
    CopyResultToInputAction actionCopy;

    public SimpleOpPanel(FloatingPointFormatter floatingPointFormatter, MatrxCfg matrxCfg, ICfgHandler iCfgHandler) {
        this.fpf = floatingPointFormatter;
        this.cfg = matrxCfg;
        this.cfghdl = iCfgHandler;
        this.initContents();
    }

    private void initContents() {
        this.setLayout(new BorderLayout());
        this.splitPane = new JSplitPane(0);
        this.toolBar = new JToolBar();
        this.add((Component)this.splitPane, "Center");
        this.add((Component)this.toolBar, "First");
        this.mtxPanelInput = new MatrixPanel("Input Matrix:", this.fpf);
        this.mtxPanelResult = new MatrixPanel("Result Matrix:", this.fpf);
        this.mtxPanelInput.setPreferredSize(new Dimension(100, 100));
        this.mtxPanelResult.setPreferredSize(new Dimension(100, 100));
        this.splitPane.setTopComponent(this.mtxPanelInput);
        this.splitPane.setBottomComponent(this.mtxPanelResult);
        this.splitPane.setDividerLocation(0.5);
        this.splitPane.setResizeWeight(0.5);
        this.actionNew = new CreateNewAction();
        this.toolBar.add(new JButton(this.actionNew));
        this.actionNewInput = new CreateNewInputAction();
        this.toolBar.add(new JButton(this.actionNewInput));
        this.actionUTForm = new CreateUTFormAction();
        this.toolBar.add(new JButton(this.actionUTForm));
        this.actionTranspose = new CalcTransposeAction();
        this.toolBar.add(new JButton(this.actionTranspose));
        this.actionCofactor = new CalcCofactorAction();
        this.toolBar.add(new JButton(this.actionCofactor));
        this.actionAdjoint = new CalcAdjointAction();
        this.toolBar.add(new JButton(this.actionAdjoint));
        this.actionInverse = new CalcInverseAction();
        this.toolBar.add(new JButton(this.actionInverse));
        this.actionDet = new CalcDeterminantAction();
        this.toolBar.add(new JButton(this.actionDet));
        this.actionTrace = new CalcTraceAction();
        this.toolBar.add(new JButton(this.actionTrace));
        this.actionCopy = new CopyResultToInputAction();
        this.toolBar.add(new JButton(this.actionCopy));
        this.toolBar.setRollover(true);
        this.setInputMatrix(null);
    }

    public void setInputMatrix(DMatrix dMatrix) {
        this.mtxInput = dMatrix;
        this.mtxPanelInput.setMatrix(dMatrix);
        boolean bl = dMatrix != null;
        this.actionUTForm.setEnabled(bl);
        this.actionDet.setEnabled(bl);
        this.actionTranspose.setEnabled(bl);
        this.actionTrace.setEnabled(bl);
        this.actionCofactor.setEnabled(bl);
        this.actionInverse.setEnabled(bl);
        this.actionAdjoint.setEnabled(bl);
        this.cfghdl.notifyCfgUpdate();
    }

    public void setResultMatrix(DMatrix dMatrix) {
        this.mtxResult = dMatrix;
        this.mtxPanelResult.setMatrix(dMatrix);
        this.cfghdl.notifyCfgUpdate();
    }

    public class CopyResultToInputAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CopyResultToInputAction() {
            this.putValue("Name", "res->inp");
            this.putValue("ShortDescription", "Copy result to input");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SimpleOpPanel.this.mtxInput = SimpleOpPanel.this.mtxResult != null ? new DMatrix(SimpleOpPanel.this.mtxResult) : null;
            SimpleOpPanel.this.setInputMatrix(SimpleOpPanel.this.mtxInput);
        }
    }

    public class CalcInverseAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CalcInverseAction() {
            this.putValue("ShortDescription", "Calculate Inverse");
            this.putValue("SmallIcon", MatrxActions.loadIcon(this.getClass(), "btn-inv.png"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                SimpleOpPanel.this.mtxResult = MatrixOp.calcInverse(SimpleOpPanel.this.mtxInput);
            }
            catch (MatrixException matrixException) {
                JOptionPane.showMessageDialog(null, "Could not calculate inverse matrix.\n(Error: " + matrixException.getMessage() + ")", "Calculation error", 0);
                return;
            }
            SimpleOpPanel.this.setResultMatrix(SimpleOpPanel.this.mtxResult);
        }
    }

    public class CalcAdjointAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CalcAdjointAction() {
            this.putValue("ShortDescription", "Calculate Adjoint");
            this.putValue("SmallIcon", MatrxActions.loadIcon(this.getClass(), "btn-adj.png"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                SimpleOpPanel.this.mtxResult = MatrixOp.calcAdjoint(SimpleOpPanel.this.mtxInput);
            }
            catch (MatrixException matrixException) {
                JOptionPane.showMessageDialog(null, "Could not calculate adjoint matrix.\n(Error: " + matrixException.getMessage() + ")", "Calculation error", 0);
                return;
            }
            SimpleOpPanel.this.setResultMatrix(SimpleOpPanel.this.mtxResult);
        }
    }

    public class CalcCofactorAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CalcCofactorAction() {
            this.putValue("ShortDescription", "Calculate Cofactor");
            this.putValue("SmallIcon", MatrxActions.loadIcon(this.getClass(), "btn-cof.png"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = SimpleOpPanel.this.mtxPanelInput.getSelectedRow();
            int n2 = SimpleOpPanel.this.mtxPanelInput.getSelectedColumn();
            if (n < 0 || n2 < 0) {
                JOptionPane.showMessageDialog(null, "Please select a cell", "Cannot calculate cofactor", 0);
                return;
            }
            Double d = null;
            try {
                d = MatrixOp.calcCofactor(SimpleOpPanel.this.mtxInput, n, n2);
            }
            catch (MatrixException matrixException) {
                JOptionPane.showMessageDialog(null, "Could not calculate cofactor of selected element.\n(Error: " + matrixException.getMessage() + ")", "Calculation error", 0);
                return;
            }
            SimpleOpPanel.this.mtxResult = d == null ? null : new DMatrix(new Double[][]{{d}});
            SimpleOpPanel.this.setResultMatrix(SimpleOpPanel.this.mtxResult);
        }
    }

    public class CalcTraceAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CalcTraceAction() {
            this.putValue("ShortDescription", "Calculate Trace");
            this.putValue("SmallIcon", MatrxActions.loadIcon(this.getClass(), "btn-trc.png"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Double d = MatrixOp.calcTrace(SimpleOpPanel.this.mtxInput);
            SimpleOpPanel.this.mtxResult = d == null ? null : new DMatrix(new Double[][]{{d}});
            SimpleOpPanel.this.setResultMatrix(SimpleOpPanel.this.mtxResult);
        }
    }

    public class CalcTransposeAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CalcTransposeAction() {
            this.putValue("ShortDescription", "Calculate Transpose");
            this.putValue("SmallIcon", MatrxActions.loadIcon(this.getClass(), "btn-tra.png"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SimpleOpPanel.this.mtxResult = MatrixOp.createTranspose(SimpleOpPanel.this.mtxInput);
            SimpleOpPanel.this.setResultMatrix(SimpleOpPanel.this.mtxResult);
        }
    }

    public class CalcDeterminantAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CalcDeterminantAction() {
            this.putValue("ShortDescription", "Calculate Determinant");
            this.putValue("SmallIcon", MatrxActions.loadIcon(this.getClass(), "btn-det.png"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Double d = null;
            try {
                d = MatrixOp.calcDeterminant(SimpleOpPanel.this.mtxInput);
            }
            catch (MatrixException matrixException) {
                JOptionPane.showMessageDialog(null, "Could not calculate determinant of matrix.\n(Error: " + matrixException.getMessage() + ")", "Calculation error", 0);
                return;
            }
            SimpleOpPanel.this.mtxResult = d == null ? null : new DMatrix(new Double[][]{{d}});
            SimpleOpPanel.this.setResultMatrix(SimpleOpPanel.this.mtxResult);
        }
    }

    public class CreateUTFormAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CreateUTFormAction() {
            this.putValue("ShortDescription", "Create Upper Triangular Form");
            this.putValue("SmallIcon", MatrxActions.loadIcon(this.getClass(), "btn-ut.png"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SimpleOpPanel.this.mtxResult = new DMatrix(SimpleOpPanel.this.mtxInput);
            try {
                MatrixOp.convertToUpperTriangularForm(SimpleOpPanel.this.mtxResult);
            }
            catch (MatrixLinearDependentException matrixLinearDependentException) {
                JOptionPane.showMessageDialog(null, "Could not calculate upper triangular form.\n(Error: " + matrixLinearDependentException.getMessage() + ")", "Calculation error", 0);
                return;
            }
            SimpleOpPanel.this.setResultMatrix(SimpleOpPanel.this.mtxResult);
        }
    }

    public class CreateNewInputAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CreateNewInputAction() {
            this.putValue("Name", "New[]");
            this.putValue("ShortDescription", "Create New Matrix from Input");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DMatrix dMatrix = MatrixUiUtil.getNewMatrixInput(SimpleOpPanel.this.cfg);
            if (dMatrix == null) {
                return;
            }
            SimpleOpPanel.this.setInputMatrix(dMatrix);
        }
    }

    public class CreateNewAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CreateNewAction() {
            this.putValue("Name", "New");
            this.putValue("ShortDescription", "Create New Matrix");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DMatrix dMatrix = MatrixUiUtil.getNewMatrix();
            if (dMatrix == null) {
                return;
            }
            SimpleOpPanel.this.setInputMatrix(dMatrix);
        }
    }
}

