/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.matrx.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class QuarterSplitPane
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    JSplitPane spHorz;
    JSplitPane spVertUpr;
    JSplitPane spVertLwr;
    Object forgetSync = new Object();
    int forgetNextUprEvent;
    int forgetNextLwrEvent;

    public QuarterSplitPane() {
        this.initContents();
    }

    void initContents() {
        this.setLayout(new BorderLayout());
        this.spHorz = new JSplitPane(0);
        this.add((Component)this.spHorz, "Center");
        this.spVertUpr = new JSplitPane(1);
        this.spVertLwr = new JSplitPane(1);
        this.spHorz.setTopComponent(this.spVertUpr);
        this.spHorz.setBottomComponent(this.spVertLwr);
        this.spVertUpr.add((Component)this.createTableScroll(), "left");
        this.spVertUpr.add((Component)this.createTableScroll(), "right");
        this.spVertLwr.add((Component)this.createTableScroll(), "left");
        this.spVertLwr.add((Component)this.createTableScroll(), "right");
        this.spVertUpr.addPropertyChangeListener("dividerLocation", this);
        this.spVertLwr.addPropertyChangeListener("dividerLocation", this);
        this.spVertUpr.setContinuousLayout(true);
        this.spVertLwr.setContinuousLayout(true);
    }

    private JScrollPane createTableScroll() {
        JScrollPane jScrollPane = new JScrollPane();
        DefaultTableModel defaultTableModel = new DefaultTableModel(new String[][]{{"One", "Two"}, {"Three", "Four"}}, new String[]{"Column 1", "Column 2"});
        JTable jTable = new JTable();
        jScrollPane.setViewportView(jTable);
        jTable.setModel(defaultTableModel);
        return jScrollPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == "dividerLocation") {
            Integer n = (Integer)propertyChangeEvent.getNewValue();
            Object object = this.forgetSync;
            synchronized (object) {
                if (propertyChangeEvent.getSource() == this.spVertUpr) {
                    if (this.forgetNextUprEvent > 0) {
                        --this.forgetNextUprEvent;
                        return;
                    }
                    ++this.forgetNextLwrEvent;
                    this.spVertLwr.setDividerLocation(n);
                }
                if (propertyChangeEvent.getSource() == this.spVertLwr) {
                    if (this.forgetNextLwrEvent > 0) {
                        --this.forgetNextLwrEvent;
                        return;
                    }
                    ++this.forgetNextUprEvent;
                    this.spVertUpr.setDividerLocation(n);
                }
            }
        }
    }

    public void setDividerLocation(double d, double d2) {
        this.spHorz.setResizeWeight(d);
        this.spHorz.setDividerLocation(d);
        this.spVertUpr.setResizeWeight(d2);
        this.spVertLwr.setResizeWeight(d2);
        this.spVertUpr.setDividerLocation(d2);
    }

    public void setTopRightComponent(Component component) {
        this.spVertUpr.setRightComponent(component);
    }

    public void setTopLeftComponent(Component component) {
        this.spVertUpr.setLeftComponent(component);
    }

    public void setBottomRightComponent(Component component) {
        this.spVertLwr.setRightComponent(component);
    }

    public void setBottomLeftComponent(Component component) {
        this.spVertLwr.setLeftComponent(component);
    }
}

