/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.matrx.ui;

import de.admadic.calculator.appctx.IAppContext;
import de.admadic.calculator.modules.matrx.MatrxActions;
import de.admadic.calculator.modules.matrx.MatrxCfg;
import de.admadic.calculator.modules.matrx.core.DMatrix;
import de.admadic.calculator.modules.matrx.ui.BinaryOpPanel;
import de.admadic.calculator.modules.matrx.ui.CopyPasteCore;
import de.admadic.calculator.modules.matrx.ui.EquSlvOpPanel;
import de.admadic.calculator.modules.matrx.ui.FloatingPointFormatter;
import de.admadic.calculator.modules.matrx.ui.ICfgHandler;
import de.admadic.calculator.modules.matrx.ui.MatrixPanel;
import de.admadic.calculator.modules.matrx.ui.SettingsDialog;
import de.admadic.calculator.modules.matrx.ui.SimpleOpPanel;
import de.admadic.calculator.modules.matrx.ui.TabularCopyPasteCore;
import de.admadic.ui.util.AboutDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;

public class MatrxFrame
extends JFrame
implements ActionListener,
ICfgHandler {
    private static final long serialVersionUID = 1L;
    static final boolean LOG = true;
    Logger logger = Logger.getLogger("de.admadic");
    MatrxCfg cfg;
    MatrxActions actions;
    IAppContext appContext;
    FloatingPointFormatter fpf;
    CopyPasteCore copyPasteCore;
    JTabbedPane tabbedPaneMain;
    JPanel panelMain;
    SimpleOpPanel panelSimpleOp;
    BinaryOpPanel panelBinaryOp;
    EquSlvOpPanel panelEquSlvOp;
    static final int TABIDX_SIMPLE = 0;
    static final int TABIDX_BINARY = 1;
    static final int TABIDX_EQUSLV = 2;
    DMatrix matrixMain;
    MatrixPanel panelMatrix;
    MatrixPanel panelMatrixRes;
    MatrixPanel panelMatrixVec;
    ImageIcon iconLarge;
    ImageIcon iconSmall;
    boolean setupComplete = false;
    boolean allowStoreSettings = false;
    static final String CMD_FILE_EXIT = "mnu.file.exit";
    static final String CMD_EDIT_COPY = "mnu.edit.copy";
    static final String CMD_EDIT_PASTE = "mnu.edit.paste";
    static final String CMD_TOOLS_OPTIONS = "mnu.tools.options";
    static final String CMD_HELP_ABOUT = "mnu.help.about";

    public MatrxFrame(MatrxCfg matrxCfg, MatrxActions matrxActions, IAppContext iAppContext) throws HeadlessException {
        this.cfg = matrxCfg;
        this.actions = matrxActions;
        this.appContext = iAppContext;
    }

    public void initCore() {
        String string = this.cfg.getDisplayFormat();
        if (string == null) {
            string = "%g";
        }
        this.fpf = FloatingPointFormatter.createFormatter(string, Locale.getDefault());
    }

    private void addMenuItem(JMenu jMenu, String string, String string2) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenu.add(jMenuItem);
        jMenuItem.setActionCommand(string2);
        jMenuItem.addActionListener(this);
    }

    protected ImageIcon loadIcon(String string) {
        String string2 = "de/admadic/calculator/modules/matrx/res/" + string;
        URL uRL = this.getClass().getClassLoader().getResource(string2);
        if (uRL == null) {
            if (this.logger != null) {
                this.logger.warning("could not get url for " + string2 + " (icon name = " + string + ")");
            }
            return null;
        }
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        if (image == null) {
            if (this.logger != null) {
                this.logger.warning("could not get image for " + uRL.toString() + " (icon name = " + string + ")");
            }
            return null;
        }
        return new ImageIcon(image);
    }

    public void initComponents() {
        this.initCore();
        this.iconSmall = this.loadIcon("icon-16.png");
        this.iconLarge = this.loadIcon("icon-48.png");
        this.panelMain = (JPanel)this.getContentPane();
        if (this.iconSmall != null) {
            this.setIconImage(this.iconSmall.getImage());
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                super.windowClosing(windowEvent);
                MatrxFrame.this.setVisible(false);
            }
        });
        this.setTitle("Matrx Module");
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        this.addMenuItem(jMenu, "Close", CMD_FILE_EXIT);
        jMenu = new JMenu("Edit");
        jMenuBar.add(jMenu);
        this.addMenuItem(jMenu, "Copy", CMD_EDIT_COPY);
        this.addMenuItem(jMenu, "Paste", CMD_EDIT_PASTE);
        if (this.actions != null && this.actions.getActions() != null) {
            JMenu jMenu2 = new JMenu("Module");
            jMenuBar.add(jMenu2);
            for (int i = 1; i < this.actions.getActions().size(); ++i) {
                jMenu2.add(new JMenuItem(this.actions.getActions().get(i)));
            }
        }
        jMenu = new JMenu("Help");
        jMenuBar.add(jMenu);
        this.addMenuItem(jMenu, "About...", CMD_HELP_ABOUT);
        this.setJMenuBar(jMenuBar);
        this.panelMain.setLayout(new BorderLayout());
        this.tabbedPaneMain = new JTabbedPane();
        this.panelMain.add((Component)this.tabbedPaneMain, "Center");
        this.panelSimpleOp = new SimpleOpPanel(this.fpf, this.cfg, this);
        this.panelBinaryOp = new BinaryOpPanel(this.fpf, this.cfg, this);
        this.panelEquSlvOp = new EquSlvOpPanel(this.fpf, this.cfg, this);
        this.tabbedPaneMain.addTab("Simple", this.panelSimpleOp);
        this.tabbedPaneMain.addTab("Binary", this.panelBinaryOp);
        this.tabbedPaneMain.addTab("Equation Solver", this.panelEquSlvOp);
        this.pack();
        this.setLocationRelativeTo(null);
        this.loadSettings();
    }

    public void doHelpAbout() {
        AboutDialog aboutDialog = new AboutDialog(this);
        aboutDialog.setAboutInfo("admaDIC Calculator Module\nMatrx - Matrix Calculations\nVersion 1.0.0-r12", "Copyright (c) 2005-2022 - admaDIC\nGermany", "For updates or more information \nplease visit http://www.admadic.de/", "This product includes the software JGoodies Forms:\nCopyright (c) 2002-2004 JGoodies Karsten Lentzsch.\nAll rights reserved.");
        aboutDialog.setTitle("About Matrx Module");
        if (this.iconLarge != null) {
            aboutDialog.setLogo(this.iconLarge.getImage());
        }
        aboutDialog.setVisible(true);
    }

    public boolean isSetupComplete() {
        return this.setupComplete;
    }

    public void setSetupComplete(boolean bl) {
        this.setupComplete = bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CMD_FILE_EXIT)) {
            this.doExit();
        } else if (string.equals(CMD_EDIT_COPY)) {
            this.doEditCopy();
        } else if (string.equals(CMD_EDIT_PASTE)) {
            this.doEditPaste();
        } else if (string.equals(CMD_HELP_ABOUT)) {
            this.doHelpAbout();
        } else if (string.equals(CMD_TOOLS_OPTIONS)) {
            this.doToolsOptions();
        }
    }

    private void doEditCopy() {
        JComponent jComponent;
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        if (this.copyPasteCore == null) {
            this.copyPasteCore = new CopyPasteCore();
        }
        if (component instanceof JTextField) {
            jComponent = (JTextField)component;
            this.copyPasteCore.doCopyFrom((JTextField)jComponent);
        }
        if (component instanceof JTable) {
            jComponent = (JTable)component;
            TabularCopyPasteCore tabularCopyPasteCore = new TabularCopyPasteCore();
            tabularCopyPasteCore.doCopyFrom((JTable)jComponent);
        }
    }

    private void doEditPaste() {
        JComponent jComponent;
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        if (this.copyPasteCore == null) {
            this.copyPasteCore = new CopyPasteCore();
        }
        if (component instanceof JTextField) {
            jComponent = (JTextField)component;
            this.copyPasteCore.doPasteInto((JTextField)jComponent);
        }
        if (component instanceof JTable) {
            jComponent = (JTable)component;
            TabularCopyPasteCore tabularCopyPasteCore = new TabularCopyPasteCore();
            tabularCopyPasteCore.doPasteInto((JTable)jComponent, false);
        }
    }

    protected void doExit() {
        this.dispose();
    }

    public void doToolsOptions() {
        SettingsDialog settingsDialog = new SettingsDialog((Frame)this, this.cfg);
        settingsDialog.initContents();
        settingsDialog.loadSettings();
        settingsDialog.setVisible(true);
        int n = settingsDialog.getResultCode();
        if (n == 1) {
            String string = this.cfg.getDisplayFormat();
            if (string == null) {
                string = "%g";
            }
            this.fpf.setFormatString(string);
        }
    }

    public void storeSettings() {
        if (!this.allowStoreSettings) {
            return;
        }
        DMatrix[] dMatrixArray = new DMatrix[]{this.panelSimpleOp.mtxInput, this.panelSimpleOp.mtxResult, this.panelBinaryOp.mtxInput, this.panelBinaryOp.mtxParam, this.panelBinaryOp.mtxResult, this.panelEquSlvOp.mtxInputCoeff, this.panelEquSlvOp.mtxInputAbsEl, this.panelEquSlvOp.mtxResultGauss, this.panelEquSlvOp.mtxResultSol};
        this.cfg.putMtxDataContent(dMatrixArray);
    }

    public void loadSettings() {
        DMatrix[] dMatrixArray = this.cfg.getMtxDataContent();
        this.allowStoreSettings = true;
        if (dMatrixArray == null) {
            return;
        }
        if (dMatrixArray.length < 1) {
            return;
        }
        this.panelSimpleOp.setInputMatrix(dMatrixArray[0]);
        this.panelSimpleOp.setResultMatrix(dMatrixArray[1]);
        this.panelBinaryOp.setFirstInputMatrix(dMatrixArray[2]);
        this.panelBinaryOp.setSecondInputMatrix(dMatrixArray[3]);
        this.panelBinaryOp.setResultMatrix(dMatrixArray[4]);
        this.panelEquSlvOp.setInputMatrixCoeff(dMatrixArray[5]);
        this.panelEquSlvOp.setInputMatrixAbsEl(dMatrixArray[6]);
        this.panelEquSlvOp.setResultMatrixGauss(dMatrixArray[7]);
        this.panelEquSlvOp.setResultMatrixSol(dMatrixArray[8]);
    }

    @Override
    public void notifyCfgUpdate() {
        this.storeSettings();
    }
}

