/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.matrx.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.admadic.calculator.modules.matrx.core.DMatrix;
import de.admadic.calculator.modules.matrx.ui.DoubleCellRenderer;
import de.admadic.calculator.modules.matrx.ui.FloatingPointFormatter;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class MatrixPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    DMatrix mtx;
    JLabel labelMatrix;
    JTable tableMatrix;
    MatrixTableModel tableModelMatrix;
    DoubleCellRenderer cellRenderer;
    JScrollPane scrollMatrix;
    boolean editable;
    FloatingPointFormatter fpf;

    public MatrixPanel(DMatrix dMatrix, String string, FloatingPointFormatter floatingPointFormatter) {
        this.fpf = floatingPointFormatter;
        this.mtx = dMatrix;
        this.initContents(string);
    }

    public MatrixPanel(String string, FloatingPointFormatter floatingPointFormatter) {
        this(null, string, floatingPointFormatter);
    }

    public MatrixPanel() {
        this(null, null, null);
    }

    private void initContents(String string) {
        FormLayout formLayout = new FormLayout("5px, d:grow, 5px", "5px, d, 5px, d:grow, 5px");
        this.setLayout(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        this.labelMatrix = new JLabel();
        if (string != null) {
            this.labelMatrix.setText(string);
        }
        this.add((Component)this.labelMatrix, cellConstraints.xy(2, 2));
        this.tableMatrix = new JTable();
        this.scrollMatrix = new JScrollPane(this.tableMatrix, 22, 32);
        this.add((Component)this.scrollMatrix, cellConstraints.xy(2, 4));
        this.tableModelMatrix = new MatrixTableModel();
        this.tableMatrix.setModel(this.tableModelMatrix);
        this.cellRenderer = new DoubleCellRenderer();
        this.cellRenderer.setFloatingPointFormatter(this.fpf);
        this.tableMatrix.setDefaultRenderer(Double.class, this.cellRenderer);
        this.tableMatrix.setAutoResizeMode(0);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setMatrix(this.mtx);
    }

    public void setMatrix(DMatrix dMatrix) {
        this.mtx = dMatrix;
        this.tableModelMatrix.setData(this.mtx);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public int getSelectedRow() {
        return this.tableMatrix.getSelectedRow();
    }

    public int getSelectedColumn() {
        return this.tableMatrix.getSelectedColumn();
    }

    public static class MatrixTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        DMatrix mtx;
        boolean editable = true;

        public void setData(DMatrix dMatrix) {
            this.mtx = dMatrix;
            this.fireTableStructureChanged();
        }

        @Override
        public int getRowCount() {
            if (this.mtx == null) {
                return 0;
            }
            return this.mtx.getRowCount();
        }

        @Override
        public int getColumnCount() {
            if (this.mtx == null) {
                return 0;
            }
            return this.mtx.getColumnCount();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.mtx == null) {
                return null;
            }
            return this.mtx.elementAt(n, n2);
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return Double.class;
        }

        @Override
        public String getColumnName(int n) {
            return "" + (n + 1);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return this.isEditable();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.mtx.setElementAt(n, n2, (Double)object);
        }

        public boolean isEditable() {
            return this.editable;
        }

        public void setEditable(boolean bl) {
            this.editable = bl;
        }
    }
}

