/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.matrx.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.admadic.calculator.modules.matrx.core.DMatrix;
import de.admadic.ui.util.Dialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class MatrixInputDialog
extends Dialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    JTextArea textInfo;
    JTextArea textMatrix;
    JScrollPane scrollMatrix;
    JButton btnOK;
    JButton btnCancel;
    JButton btnCheck;
    JPanel panelButtons;
    JLabel labelStatus;
    static final String CMD_OK = "ok";
    static final String CMD_CANCEL = "cancel";
    static final String CMD_CHECK = "check";
    DMatrix matrix;

    public MatrixInputDialog(Container container, String string) throws HeadlessException {
        this.initContents(container, string);
    }

    private void initContents(Container container, String string) {
        FormLayout formLayout = new FormLayout("12px, d:grow, 12px", "12px, d: 5px, d:grow, 5px, d, 5px, d, 12px");
        this.getContentPane().setLayout(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        this.setModal(true);
        this.setTitle("Enter Matrix Data");
        this.textInfo = new JTextArea("Enter matrix data:\nFor example: 1 2 3; 3 2 1; 1 3 2\nor put each row on its own line like:\n1 2 3\n3 2 1\n1 3 2");
        this.textInfo.setOpaque(false);
        this.textInfo.setEditable(false);
        this.getContentPane().add((Component)this.textInfo, cellConstraints.xy(2, 2));
        this.textMatrix = new JTextArea(string);
        this.textMatrix.setRows(8);
        this.textMatrix.setColumns(40);
        this.scrollMatrix = new JScrollPane(this.textMatrix, 22, 32);
        this.getContentPane().add((Component)this.scrollMatrix, cellConstraints.xy(2, 4, CellConstraints.FILL, CellConstraints.FILL));
        this.labelStatus = new JLabel(CMD_OK);
        this.getContentPane().add((Component)this.labelStatus, cellConstraints.xy(2, 6));
        this.panelButtons = new JPanel();
        this.getContentPane().add((Component)this.panelButtons, cellConstraints.xy(2, 8));
        this.btnOK = new JButton("OK");
        this.btnOK.setActionCommand(CMD_OK);
        this.btnOK.addActionListener(this);
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.setActionCommand(CMD_CANCEL);
        this.btnCancel.addActionListener(this);
        this.btnCheck = new JButton("Check");
        this.btnCheck.setActionCommand(CMD_CHECK);
        this.btnCheck.addActionListener(this);
        this.panelButtons.add(this.btnOK);
        this.panelButtons.add(this.btnCancel);
        this.panelButtons.add(this.btnCheck);
        this.pack();
        this.setLocationRelativeTo(container);
    }

    public String getInputData() {
        return this.textMatrix.getText();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CMD_OK)) {
            if (!this.doCheck()) {
                return;
            }
            this.setResultCode(1);
            this.setVisible(false);
        } else if (string.equals(CMD_CANCEL)) {
            this.setResultCode(2);
            this.setVisible(false);
        } else if (string.equals(CMD_CHECK) && !this.doCheck()) {
            return;
        }
    }

    private void setStatus(String string) {
        this.labelStatus.setText(string);
    }

    private boolean doCheck() {
        Object object;
        String string = this.textMatrix.getText();
        string = string.replace(';', '\n');
        String[] stringArray = string.split("\n");
        Vector<String> vector = new Vector<String>();
        int n = -1;
        for (String string2 : stringArray) {
            String string3 = string2.trim();
            if (string3.length() < 1) continue;
            vector.add(string3);
        }
        if (vector.size() < 1) {
            this.setStatus("Number of rows must be at least 1!");
            return false;
        }
        for (String string2 : vector) {
            String[] stringArray2;
            int stringArray4 = 0;
            String[] stringArray3 = stringArray2 = string2.split("\\s");
            int n2 = stringArray3.length;
            for (int i = 0; i < n2; ++i) {
                object = stringArray3[i];
                if (((String)(object = ((String)object).trim())).length() < 1) continue;
                ++stringArray4;
            }
            if (n < 0) {
                n = stringArray4;
                continue;
            }
            if (n == stringArray4) continue;
            this.setStatus("Number of columns is not equal in all rows!");
            return false;
        }
        this.matrix = new DMatrix(vector.size(), n);
        for (int i = 0; i < vector.size(); ++i) {
            String[] stringArray4;
            int n3 = 0;
            for (String string4 : stringArray4 = ((String)vector.get(i)).split("\\s")) {
                if ((string4 = string4.trim()).length() < 1) continue;
                try {
                    object = Double.valueOf(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    this.setStatus("could not parse number: " + string4 + "!");
                    this.matrix = null;
                    return false;
                }
                this.matrix.setElementAt(i, n3, (Double)object);
                ++n3;
            }
        }
        this.setStatus("ok.");
        return true;
    }

    public DMatrix getMatrix() {
        return this.matrix;
    }
}

