/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.matrx.ui;

import de.admadic.calculator.modules.matrx.MatrxActions;
import de.admadic.calculator.modules.matrx.MatrxCfg;
import de.admadic.calculator.modules.matrx.core.DMatrix;
import de.admadic.calculator.modules.matrx.core.MatrixLinearDependentException;
import de.admadic.calculator.modules.matrx.core.MatrixOp;
import de.admadic.calculator.modules.matrx.ui.FloatingPointFormatter;
import de.admadic.calculator.modules.matrx.ui.ICfgHandler;
import de.admadic.calculator.modules.matrx.ui.MatrixPanel;
import de.admadic.calculator.modules.matrx.ui.MatrixUiUtil;
import de.admadic.calculator.modules.matrx.ui.QuarterSplitPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class EquSlvOpPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    FloatingPointFormatter fpf;
    MatrxCfg cfg;
    ICfgHandler cfghdl;
    QuarterSplitPane splitPane;
    MatrixPanel mtxPanelInputCoeff;
    MatrixPanel mtxPanelInputAbsEl;
    MatrixPanel mtxPanelResultGauss;
    MatrixPanel mtxPanelResultSol;
    DMatrix mtxInputCoeff;
    DMatrix mtxInputAbsEl;
    DMatrix mtxResultGauss;
    DMatrix mtxResultSol;
    JToolBar toolBar;
    CreateNewAction actionNew;
    CreateNewInputAction actionNewInput;
    CreateNewInputAbsElAction actionNewInputAbsEl;
    SolveEquationAction actionSolve;

    public EquSlvOpPanel(FloatingPointFormatter floatingPointFormatter, MatrxCfg matrxCfg, ICfgHandler iCfgHandler) {
        this.fpf = floatingPointFormatter;
        this.cfg = matrxCfg;
        this.cfghdl = iCfgHandler;
        this.initContents();
    }

    private void initContents() {
        this.setLayout(new BorderLayout());
        this.splitPane = new QuarterSplitPane();
        this.add((Component)this.splitPane, "Center");
        this.mtxPanelInputCoeff = new MatrixPanel("Coefficient Matrix:", this.fpf);
        this.mtxPanelInputAbsEl = new MatrixPanel("Absolute Elements:", this.fpf);
        this.mtxPanelResultGauss = new MatrixPanel("Gaussian Elimination:", this.fpf);
        this.mtxPanelResultSol = new MatrixPanel("Solution:", this.fpf);
        this.mtxPanelInputCoeff.setPreferredSize(new Dimension(100, 100));
        this.mtxPanelInputAbsEl.setPreferredSize(new Dimension(100, 100));
        this.mtxPanelResultGauss.setPreferredSize(new Dimension(100, 100));
        this.mtxPanelResultSol.setPreferredSize(new Dimension(100, 100));
        this.splitPane.setTopLeftComponent(this.mtxPanelInputCoeff);
        this.splitPane.setTopRightComponent(this.mtxPanelInputAbsEl);
        this.splitPane.setBottomLeftComponent(this.mtxPanelResultGauss);
        this.splitPane.setBottomRightComponent(this.mtxPanelResultSol);
        this.splitPane.setDividerLocation(0.5, 0.75);
        this.toolBar = new JToolBar();
        this.add((Component)this.toolBar, "First");
        this.actionNew = new CreateNewAction();
        this.toolBar.add(new JButton(this.actionNew));
        this.actionNewInput = new CreateNewInputAction();
        this.toolBar.add(new JButton(this.actionNewInput));
        this.actionNewInputAbsEl = new CreateNewInputAbsElAction();
        this.toolBar.add(new JButton(this.actionNewInputAbsEl));
        this.actionSolve = new SolveEquationAction();
        this.toolBar.add(new JButton(this.actionSolve));
        this.updateActions();
    }

    public void setInputMatrixCoeff(DMatrix dMatrix) {
        this.mtxInputCoeff = dMatrix;
        this.mtxPanelInputCoeff.setMatrix(dMatrix);
        this.updateActions();
        this.cfghdl.notifyCfgUpdate();
    }

    public void setInputMatrixAbsEl(DMatrix dMatrix) {
        this.mtxInputAbsEl = dMatrix;
        this.mtxPanelInputAbsEl.setMatrix(dMatrix);
        this.updateActions();
        this.cfghdl.notifyCfgUpdate();
    }

    public void setResultMatrixGauss(DMatrix dMatrix) {
        this.mtxResultGauss = dMatrix;
        this.mtxPanelResultGauss.setMatrix(dMatrix);
        this.cfghdl.notifyCfgUpdate();
    }

    public void setResultMatrixSol(DMatrix dMatrix) {
        this.mtxResultSol = dMatrix;
        this.mtxPanelResultSol.setMatrix(dMatrix);
        this.cfghdl.notifyCfgUpdate();
    }

    private void updateActions() {
        boolean bl = true;
        if (this.mtxInputCoeff == null) {
            bl = false;
        }
        if (this.mtxInputAbsEl == null) {
            bl = false;
        }
        this.actionSolve.setEnabled(bl);
    }

    public class SolveEquationAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public SolveEquationAction() {
            this.putValue("Name", "Solve");
            this.putValue("ShortDescription", "Solve Equation");
            this.putValue("SmallIcon", MatrxActions.loadIcon(this.getClass(), "btn-equ.png"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DMatrix dMatrix = new DMatrix(EquSlvOpPanel.this.mtxInputAbsEl);
            MatrixOp.mul(dMatrix, -1.0);
            DMatrix dMatrix2 = MatrixOp.appendMatrixColumns(EquSlvOpPanel.this.mtxInputCoeff, dMatrix);
            try {
                MatrixOp.convertToUpperTriangularForm(dMatrix2);
            }
            catch (MatrixLinearDependentException matrixLinearDependentException) {
                JOptionPane.showMessageDialog(null, "Equations are linear dependent\n(Error: " + matrixLinearDependentException.getMessage() + ")", "Cannot solve LES", 0);
                return;
            }
            EquSlvOpPanel.this.setResultMatrixGauss(dMatrix2);
            DMatrix dMatrix3 = new DMatrix(EquSlvOpPanel.this.mtxInputCoeff.getColumnCount(), 1);
            MatrixOp.calcSolution(dMatrix2, dMatrix3);
            EquSlvOpPanel.this.setResultMatrixSol(dMatrix3);
        }
    }

    public class CreateNewInputAbsElAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CreateNewInputAbsElAction() {
            this.putValue("Name", "New|");
            this.putValue("ShortDescription", "Create New Absolute Elements Matrix from Input");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DMatrix dMatrix = MatrixUiUtil.getNewMatrixInput(EquSlvOpPanel.this.cfg);
            if (dMatrix == null) {
                return;
            }
            if (dMatrix.getColumnCount() != 1) {
                JOptionPane.showMessageDialog(null, "Absolute elements matrix must have 1 column", "Error", 0);
                return;
            }
            EquSlvOpPanel.this.setInputMatrixAbsEl(dMatrix);
        }
    }

    public class CreateNewInputAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CreateNewInputAction() {
            this.putValue("Name", "New[]");
            this.putValue("ShortDescription", "Create New Coefficient Matrix from Input");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DMatrix dMatrix = MatrixUiUtil.getNewMatrixInput(EquSlvOpPanel.this.cfg);
            if (dMatrix == null) {
                return;
            }
            EquSlvOpPanel.this.setInputMatrixCoeff(dMatrix);
        }
    }

    public class CreateNewAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CreateNewAction() {
            this.putValue("Name", "New");
            this.putValue("ShortDescription", "Create New Coefficient and Absolute Elements Matrix");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DMatrix dMatrix = MatrixUiUtil.getNewMatrix();
            if (dMatrix == null) {
                return;
            }
            DMatrix dMatrix2 = new DMatrix(dMatrix.getRowCount(), 1);
            EquSlvOpPanel.this.setInputMatrixCoeff(dMatrix);
            EquSlvOpPanel.this.setInputMatrixAbsEl(dMatrix2);
        }
    }
}

