/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.matrx.ui;

import de.admadic.calculator.modules.matrx.MatrxActions;
import de.admadic.calculator.modules.matrx.MatrxCfg;
import de.admadic.calculator.modules.matrx.core.DMatrix;
import de.admadic.calculator.modules.matrx.core.MatrixDimensionException;
import de.admadic.calculator.modules.matrx.core.MatrixOp;
import de.admadic.calculator.modules.matrx.ui.FloatingPointFormatter;
import de.admadic.calculator.modules.matrx.ui.ICfgHandler;
import de.admadic.calculator.modules.matrx.ui.MatrixPanel;
import de.admadic.calculator.modules.matrx.ui.MatrixUiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;

public class BinaryOpPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    JSplitPane splitPane;
    JSplitPane splitPaneInput;
    MatrixPanel mtxPanelInput;
    MatrixPanel mtxPanelParam;
    MatrixPanel mtxPanelResult;
    FloatingPointFormatter fpf;
    MatrxCfg cfg;
    ICfgHandler cfghdl;
    JToolBar toolBar;
    CreateNewAction actionNewFirst;
    CreateNewInputAction actionNewInputFirst;
    CreateNewSecondAction actionNewSecond;
    CreateNewInputSecondAction actionNewInputSecond;
    CalcAddAction actionAdd;
    CalcMulAction actionMul;
    DMatrix mtxInput;
    DMatrix mtxParam;
    DMatrix mtxResult;

    public BinaryOpPanel(FloatingPointFormatter floatingPointFormatter, MatrxCfg matrxCfg, ICfgHandler iCfgHandler) {
        this.fpf = floatingPointFormatter;
        this.cfg = matrxCfg;
        this.cfghdl = iCfgHandler;
        this.initContents();
    }

    private void initContents() {
        this.setLayout(new BorderLayout());
        this.splitPane = new JSplitPane(0);
        this.add((Component)this.splitPane, "Center");
        this.splitPaneInput = new JSplitPane(1);
        this.mtxPanelInput = new MatrixPanel("First Input Matrix:", this.fpf);
        this.mtxPanelParam = new MatrixPanel("Second Input Matrix:", this.fpf);
        this.mtxPanelResult = new MatrixPanel("Result Matrix:", this.fpf);
        this.mtxPanelInput.setPreferredSize(new Dimension(100, 100));
        this.mtxPanelParam.setPreferredSize(new Dimension(100, 100));
        this.mtxPanelResult.setPreferredSize(new Dimension(100, 100));
        this.splitPaneInput.setLeftComponent(this.mtxPanelInput);
        this.splitPaneInput.setRightComponent(this.mtxPanelParam);
        this.splitPane.setTopComponent(this.splitPaneInput);
        this.splitPane.setBottomComponent(this.mtxPanelResult);
        this.splitPane.setDividerLocation(0.5);
        this.splitPaneInput.setDividerLocation(0.5);
        this.splitPane.setResizeWeight(0.5);
        this.splitPaneInput.setResizeWeight(0.5);
        this.toolBar = new JToolBar();
        this.add((Component)this.toolBar, "First");
        this.actionNewFirst = new CreateNewAction();
        this.toolBar.add(new JButton(this.actionNewFirst));
        this.actionNewInputFirst = new CreateNewInputAction();
        this.toolBar.add(new JButton(this.actionNewInputFirst));
        this.toolBar.addSeparator();
        this.actionNewSecond = new CreateNewSecondAction();
        this.toolBar.add(new JButton(this.actionNewSecond));
        this.actionNewInputSecond = new CreateNewInputSecondAction();
        this.toolBar.add(new JButton(this.actionNewInputSecond));
        this.toolBar.addSeparator();
        this.actionAdd = new CalcAddAction();
        this.toolBar.add(new JButton(this.actionAdd));
        this.actionMul = new CalcMulAction();
        this.toolBar.add(new JButton(this.actionMul));
        this.updateActions();
    }

    public void setFirstInputMatrix(DMatrix dMatrix) {
        this.mtxInput = dMatrix;
        this.mtxPanelInput.setMatrix(dMatrix);
        this.updateActions();
        this.cfghdl.notifyCfgUpdate();
    }

    public void setSecondInputMatrix(DMatrix dMatrix) {
        this.mtxParam = dMatrix;
        this.mtxPanelParam.setMatrix(dMatrix);
        this.updateActions();
        this.cfghdl.notifyCfgUpdate();
    }

    public void setResultMatrix(DMatrix dMatrix) {
        this.mtxResult = dMatrix;
        this.mtxPanelResult.setMatrix(dMatrix);
        this.cfghdl.notifyCfgUpdate();
    }

    private void updateActions() {
        boolean bl = true;
        if (this.mtxInput == null) {
            bl = false;
        }
        if (this.mtxParam == null) {
            bl = false;
        }
        this.actionAdd.setEnabled(bl);
        this.actionMul.setEnabled(bl);
    }

    public class CalcAddAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CalcAddAction() {
            this.putValue("Name", "Add");
            this.putValue("ShortDescription", "Add Matrices");
            this.putValue("SmallIcon", MatrxActions.loadIcon(this.getClass(), "btn-add.png"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DMatrix dMatrix = new DMatrix(BinaryOpPanel.this.mtxInput);
            try {
                MatrixOp.add(dMatrix, BinaryOpPanel.this.mtxParam);
            }
            catch (MatrixDimensionException matrixDimensionException) {
                JOptionPane.showMessageDialog(null, "Matrix dimensions must be identical for addition.\n(Error: " + matrixDimensionException.getMessage() + ")", "Matrix dimensions do not match", 0);
                return;
            }
            BinaryOpPanel.this.setResultMatrix(dMatrix);
        }
    }

    public class CalcMulAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CalcMulAction() {
            this.putValue("Name", "Mul");
            this.putValue("ShortDescription", "Multiply Matrices");
            this.putValue("SmallIcon", MatrxActions.loadIcon(this.getClass(), "btn-mul.png"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DMatrix dMatrix = null;
            try {
                dMatrix = MatrixOp.mul(BinaryOpPanel.this.mtxInput, BinaryOpPanel.this.mtxParam);
            }
            catch (MatrixDimensionException matrixDimensionException) {
                JOptionPane.showMessageDialog(null, "Matrix dimensions must be identical for multiplication.\n(Error: " + matrixDimensionException.getMessage() + ")", "Matrix dimensions do not match", 0);
                return;
            }
            BinaryOpPanel.this.setResultMatrix(dMatrix);
        }
    }

    public class CreateNewInputSecondAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CreateNewInputSecondAction() {
            this.putValue("Name", "New[] 2nd");
            this.putValue("ShortDescription", "Create New 2nd Matrix from Input");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DMatrix dMatrix = MatrixUiUtil.getNewMatrixInput(BinaryOpPanel.this.cfg);
            if (dMatrix == null) {
                return;
            }
            BinaryOpPanel.this.setSecondInputMatrix(dMatrix);
        }
    }

    public class CreateNewSecondAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CreateNewSecondAction() {
            this.putValue("Name", "New 2nd");
            this.putValue("ShortDescription", "Create New 2nd Matrix");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DMatrix dMatrix = MatrixUiUtil.getNewMatrix();
            if (dMatrix == null) {
                return;
            }
            BinaryOpPanel.this.setSecondInputMatrix(dMatrix);
        }
    }

    public class CreateNewInputAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CreateNewInputAction() {
            this.putValue("Name", "New[] 1st");
            this.putValue("ShortDescription", "Create New 1st Matrix from Input");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DMatrix dMatrix = MatrixUiUtil.getNewMatrixInput(BinaryOpPanel.this.cfg);
            if (dMatrix == null) {
                return;
            }
            BinaryOpPanel.this.setFirstInputMatrix(dMatrix);
        }
    }

    public class CreateNewAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CreateNewAction() {
            this.putValue("Name", "New 1st");
            this.putValue("ShortDescription", "Create New 1st Matrix");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DMatrix dMatrix = MatrixUiUtil.getNewMatrix();
            if (dMatrix == null) {
                return;
            }
            BinaryOpPanel.this.setFirstInputMatrix(dMatrix);
        }
    }
}

