/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.matrx.core;

import de.admadic.calculator.modules.matrx.core.DMatrix;
import de.admadic.calculator.modules.matrx.core.DVector;
import de.admadic.calculator.modules.matrx.core.MatrixDataException;
import de.admadic.calculator.modules.matrx.core.MatrixDimensionException;
import de.admadic.calculator.modules.matrx.core.MatrixLinearDependentException;
import de.admadic.calculator.modules.matrx.core.VectorOp;
import java.util.Collections;

public class MatrixOp {
    public static void swapRows(DMatrix dMatrix, int n, int n2) {
        Collections.swap(dMatrix.data, n, n2);
    }

    public static void swapColumns(DMatrix dMatrix, int n, int n2) {
        for (DVector dVector : dMatrix.data) {
            Collections.swap(dVector.data, n, n2);
        }
    }

    public static void addRowToRow(DMatrix dMatrix, int n, int n2) {
        DVector dVector = dMatrix.data.get(n);
        DVector dVector2 = dMatrix.data.get(n2);
        VectorOp.add(dVector2, dVector);
    }

    public static void addOffsetToRow(DMatrix dMatrix, int n, double d) {
        DVector dVector = dMatrix.data.get(n);
        VectorOp.add(dVector, d);
    }

    public static void mulRowByFactor(DMatrix dMatrix, int n, double d) {
        DVector dVector = dMatrix.data.get(n);
        VectorOp.mul(dVector, d);
    }

    public static void convertToUpperTriangularForm(DMatrix dMatrix) throws MatrixLinearDependentException {
        if (dMatrix.getRowCount() < 2) {
            return;
        }
        if (dMatrix.getColumnCount() < 2) {
            return;
        }
        int n = Math.min(dMatrix.getRowCount(), dMatrix.getColumnCount());
        for (int i = 0; i < n - 1; ++i) {
            int n2;
            int n3 = dMatrix.getRowCount() - n + i;
            Double d = dMatrix.elementAt(n3, i);
            if (d == null || d == 0.0) {
                n2 = -1;
                for (int j = n3 + 1; j < dMatrix.getRowCount(); ++j) {
                    Double d2 = dMatrix.elementAt(j, i);
                    if (d2 == null || d2 == 0.0) continue;
                    n2 = j;
                    break;
                }
                if (n2 == -1) {
                    throw new MatrixLinearDependentException("Matrix is linear dependent");
                }
                Collections.swap(dMatrix.data, n3, n2);
                VectorOp.mul(dMatrix.getRow(n2), -1.0);
            }
            for (n2 = n3 + 1; n2 < dMatrix.getRowCount(); ++n2) {
                double d3 = dMatrix.elementAt(n3, i);
                d3 = dMatrix.elementAt(n2, i) / d3;
                d3 = -d3;
                VectorOp.add(dMatrix.getRow(n2), dMatrix.getRow(n3), d3, i, dMatrix.getColumnCount());
                dMatrix.setElementAt(n2, i, 0.0);
            }
        }
    }

    public static void makeMainDiagonalOne(DMatrix dMatrix) {
        int n = Math.min(dMatrix.getRowCount(), dMatrix.getColumnCount());
        for (int i = 0; i < n; ++i) {
            VectorOp.div(dMatrix.getRow(i), dMatrix.elementAt(i, i));
        }
    }

    public static void calcSolution(DMatrix dMatrix, DMatrix dMatrix2) {
        if (dMatrix.getRowCount() != dMatrix2.getRowCount()) {
            return;
        }
        for (int i = dMatrix.getRowCount() - 1; i >= 0; --i) {
            double d = -dMatrix.elementAt(i, dMatrix.getColumnCount() - 1).doubleValue();
            for (int j = dMatrix.getColumnCount() - 2; j > i; --j) {
                d -= dMatrix.elementAt(i, j) * dMatrix2.elementAt(j, 0);
            }
            dMatrix2.setElementAt(i, 0, d /= dMatrix.elementAt(i, i).doubleValue());
        }
    }

    public static DMatrix insertRowAt(DMatrix dMatrix, int n, DVector dVector) {
        int n2;
        int n3 = dMatrix.getColumnCount();
        int n4 = dMatrix.getRowCount() + 1;
        DMatrix dMatrix2 = new DMatrix(n4, n3);
        for (n2 = 0; n2 < n; ++n2) {
            dMatrix2.data.set(n2, dMatrix.data.elementAt(n2));
        }
        dMatrix2.data.set(n, dVector);
        for (n2 = n; n2 < dMatrix.getRowCount(); ++n2) {
            dMatrix2.data.set(n2 + 1, dMatrix.data.elementAt(n2));
        }
        return dMatrix2;
    }

    public static DMatrix insertColumnAt(DMatrix dMatrix, int n, DVector dVector) {
        int n2 = dMatrix.getColumnCount() + 1;
        int n3 = dMatrix.getRowCount();
        DMatrix dMatrix2 = new DMatrix(n3, n2);
        for (int i = 0; i < n3; ++i) {
            int n4;
            DVector dVector2 = dMatrix.getRow(i);
            DVector dVector3 = dMatrix2.getRow(i);
            for (n4 = 0; n4 < n; ++n4) {
                dVector3.data.set(n4, dVector2.data.elementAt(n4));
            }
            dVector3.data.set(n, dVector.elementAt(i));
            for (n4 = n; n4 < dMatrix.getColumnCount(); ++n4) {
                dVector3.data.set(n4 + 1, dVector2.data.elementAt(n4));
            }
        }
        return dMatrix2;
    }

    public static DMatrix appendMatrixColumns(DMatrix dMatrix, DMatrix dMatrix2) {
        int n = dMatrix.getColumnCount() + dMatrix2.getColumnCount();
        int n2 = dMatrix.getRowCount();
        DMatrix dMatrix3 = new DMatrix(n2, n);
        for (int i = 0; i < n2; ++i) {
            int n3;
            DVector dVector = dMatrix.getRow(i);
            DVector dVector2 = dMatrix3.getRow(i);
            for (n3 = 0; n3 < dMatrix.getColumnCount(); ++n3) {
                dVector2.data.set(n3, dVector.data.elementAt(n3));
            }
            dVector = dMatrix2.getRow(i);
            for (n3 = 0; n3 < dMatrix2.getColumnCount(); ++n3) {
                dVector2.data.set(n3 + dMatrix.getColumnCount(), dVector.data.elementAt(n3));
            }
        }
        return dMatrix3;
    }

    public static Double calcDeterminant(DMatrix dMatrix) throws MatrixDimensionException, MatrixLinearDependentException, MatrixDataException {
        if (dMatrix.getRowCount() != dMatrix.getColumnCount()) {
            throw new MatrixDimensionException("Matrix is not quadratic for calculation of determinant");
        }
        double d = 1.0;
        DMatrix dMatrix2 = dMatrix;
        if (!MatrixOp.isUpperTriangularForm(dMatrix)) {
            dMatrix2 = new DMatrix(dMatrix);
            MatrixOp.convertToUpperTriangularForm(dMatrix2);
        }
        for (int i = 0; i < dMatrix2.getRowCount(); ++i) {
            Double d2 = dMatrix2.elementAt(i, i);
            if (d2 == null) {
                throw new MatrixDataException("Matrix element must not be undefined for calculation of determinant");
            }
            if (d2 == 0.0) {
                return 0.0;
            }
            d *= d2.doubleValue();
        }
        return d;
    }

    public static boolean isUpperTriangularForm(DMatrix dMatrix) {
        for (int i = 1; i < dMatrix.getRowCount(); ++i) {
            DVector dVector = dMatrix.getRow(i);
            for (int j = 0; j < i && j < dMatrix.getColumnCount(); ++j) {
                Double d = dVector.elementAt(j);
                if (d == null || d == 0.0) continue;
                return false;
            }
        }
        return true;
    }

    public static DMatrix createTranspose(DMatrix dMatrix) {
        int n = dMatrix.getRowCount();
        int n2 = dMatrix.getColumnCount();
        DMatrix dMatrix2 = new DMatrix(n2, n);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                dMatrix2.setElementAt(i, j, dMatrix.elementAt(j, i));
            }
        }
        return dMatrix2;
    }

    public static Double calcTrace(DMatrix dMatrix) {
        double d = 0.0;
        int n = Math.min(dMatrix.getRowCount(), dMatrix.getColumnCount());
        for (int i = 0; i < n; ++i) {
            Double d2 = dMatrix.elementAt(i, i);
            if (d2 == null || d2 == 0.0) continue;
            d += d2.doubleValue();
        }
        return d;
    }

    public static Double calcCofactor(DMatrix dMatrix, int n, int n2) throws MatrixDimensionException, MatrixLinearDependentException, MatrixDataException {
        DMatrix dMatrix2 = MatrixOp.stripRowAndColumn(dMatrix, n, n2);
        Double d = MatrixOp.calcDeterminant(dMatrix2);
        if (d == null) {
            throw new MatrixLinearDependentException();
        }
        if ((n + n2 & 1) != 0) {
            d = -d.doubleValue();
        }
        return d;
    }

    public static DMatrix calcInverse(DMatrix dMatrix) throws MatrixDimensionException, MatrixLinearDependentException, MatrixDataException {
        Double d = MatrixOp.calcDeterminant(dMatrix);
        if (d == null) {
            return null;
        }
        DMatrix dMatrix2 = MatrixOp.calcAdjoint(dMatrix);
        MatrixOp.mul(dMatrix2, 1.0 / d);
        return dMatrix2;
    }

    public static DMatrix calcAdjoint(DMatrix dMatrix) throws MatrixDimensionException, MatrixLinearDependentException, MatrixDataException {
        DMatrix dMatrix2 = new DMatrix(dMatrix.getRowCount(), dMatrix.getColumnCount());
        for (int i = 0; i < dMatrix.getRowCount(); ++i) {
            for (int j = 0; j < dMatrix.getColumnCount(); ++j) {
                Double d = MatrixOp.calcCofactor(dMatrix, i, j);
                if (d == null) {
                    return null;
                }
                dMatrix2.setElementAt(i, j, d);
            }
        }
        dMatrix2 = MatrixOp.createTranspose(dMatrix2);
        return dMatrix2;
    }

    private static DMatrix stripRowAndColumn(DMatrix dMatrix, int n, int n2) throws MatrixDimensionException {
        int n3;
        DVector dVector;
        int n4;
        int n5 = dMatrix.getRowCount() - 1;
        int n6 = dMatrix.getColumnCount() - 1;
        if (n5 < 1 || n6 < 1) {
            throw new MatrixDimensionException("Matrix must have at least 2 rows and columns for stripping row and column");
        }
        DMatrix dMatrix2 = new DMatrix(n5, n6);
        for (n4 = 0; n4 < n; ++n4) {
            dVector = dMatrix.getRow(n4);
            for (n3 = 0; n3 < n2; ++n3) {
                dMatrix2.setElementAt(n4, n3, dVector.elementAt(n3));
            }
            for (n3 = n2 + 1; n3 < dMatrix.getColumnCount(); ++n3) {
                dMatrix2.setElementAt(n4, n3 - 1, dVector.elementAt(n3));
            }
        }
        for (n4 = n + 1; n4 < dMatrix.getRowCount(); ++n4) {
            dVector = dMatrix.getRow(n4);
            for (n3 = 0; n3 < n2; ++n3) {
                dMatrix2.setElementAt(n4 - 1, n3, dVector.elementAt(n3));
            }
            for (n3 = n2 + 1; n3 < dMatrix.getColumnCount(); ++n3) {
                dMatrix2.setElementAt(n4 - 1, n3 - 1, dVector.elementAt(n3));
            }
        }
        return dMatrix2;
    }

    public static void add(DMatrix dMatrix, double d) {
        for (int i = 0; i < dMatrix.getRowCount(); ++i) {
            DVector dVector = dMatrix.getRow(i);
            VectorOp.add(dVector, d);
        }
    }

    public static void mul(DMatrix dMatrix, double d) {
        for (int i = 0; i < dMatrix.getRowCount(); ++i) {
            DVector dVector = dMatrix.getRow(i);
            VectorOp.mul(dVector, d);
        }
    }

    public static void add(DMatrix dMatrix, DMatrix dMatrix2) throws MatrixDimensionException {
        if (dMatrix.getRowCount() != dMatrix2.getRowCount()) {
            throw new MatrixDimensionException("invalid matrix dimensions for add (# of rows must match)");
        }
        if (dMatrix.getColumnCount() != dMatrix2.getColumnCount()) {
            throw new MatrixDimensionException("invalid matrix dimensions for add (# of columns must match)");
        }
        for (int i = 0; i < dMatrix.getRowCount(); ++i) {
            DVector dVector = dMatrix.getRow(i);
            DVector dVector2 = dMatrix2.getRow(i);
            VectorOp.add(dVector, dVector2);
        }
    }

    public static void sub(DMatrix dMatrix, DMatrix dMatrix2) throws MatrixDimensionException {
        if (dMatrix.getRowCount() != dMatrix2.getRowCount()) {
            throw new MatrixDimensionException("invalid matrix dimensions for sub (# of rows must match)");
        }
        if (dMatrix.getColumnCount() != dMatrix2.getColumnCount()) {
            throw new MatrixDimensionException("invalid matrix dimensions for sub (# of columns must match)");
        }
        for (int i = 0; i < dMatrix.getRowCount(); ++i) {
            DVector dVector = dMatrix.getRow(i);
            DVector dVector2 = dMatrix2.getRow(i);
            VectorOp.sub(dVector, dVector2);
        }
    }

    public static DMatrix mul(DMatrix dMatrix, DMatrix dMatrix2) throws MatrixDimensionException {
        if (dMatrix.getRowCount() != dMatrix2.getColumnCount()) {
            throw new MatrixDimensionException("invalid matrix dimensions for mul");
        }
        DMatrix dMatrix3 = new DMatrix(dMatrix.getRowCount(), dMatrix2.getColumnCount());
        for (int i = 0; i < dMatrix3.getRowCount(); ++i) {
            for (int j = 0; j < dMatrix3.getColumnCount(); ++j) {
                double d = 0.0;
                for (int k = 0; k < dMatrix.getColumnCount(); ++k) {
                    Double d2 = dMatrix.elementAt(i, k);
                    Double d3 = dMatrix2.elementAt(k, j);
                    if (d2 == null || d3 == null) continue;
                    d += d2 * d3;
                }
                dMatrix3.setElementAt(i, j, d);
            }
        }
        return dMatrix3;
    }
}

