/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.matrx.core;

import de.admadic.calculator.modules.matrx.core.DVector;
import java.util.Vector;

public class DMatrix {
    Vector<DVector> data;
    int rows;
    int columns;

    public DMatrix(int n, int n2) {
        this.rows = n;
        this.columns = n2;
        this.data = new Vector(n);
        for (int i = 0; i < n; ++i) {
            DVector dVector = new DVector(n2, 0.0);
            this.data.add(dVector);
        }
    }

    public DMatrix(Double[][] doubleArray) {
        this.rows = doubleArray.length;
        this.columns = doubleArray[0].length;
        this.data = new Vector(this.rows);
        for (int i = 0; i < doubleArray.length; ++i) {
            DVector dVector = new DVector(doubleArray[i]);
            this.data.add(dVector);
        }
    }

    public DMatrix(DMatrix dMatrix) {
        int n;
        this.rows = dMatrix.getRowCount();
        this.columns = dMatrix.getColumnCount();
        this.data = new Vector(this.rows);
        for (n = 0; n < this.rows; ++n) {
            DVector dVector = new DVector(this.columns, 0.0);
            this.data.add(dVector);
        }
        for (n = 0; n < this.rows; ++n) {
            for (int i = 0; i < this.columns; ++i) {
                this.setElementAt(n, i, dMatrix.elementAt(n, i));
            }
        }
    }

    public Double elementAt(int n, int n2) {
        if (n < 0 || n >= this.rows) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n2 < 0 || n2 >= this.columns) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.data.get(n).get(n2);
    }

    public void setElementAt(int n, int n2, Double d) {
        if (n < 0 || n >= this.rows) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n2 < 0 || n2 >= this.columns) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.data.get(n).setElementAt(d, n2);
    }

    public int getRowCount() {
        return this.rows;
    }

    public int getColumnCount() {
        return this.columns;
    }

    public DVector getRow(int n) {
        return this.data.get(n);
    }
}

