/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.matrx;

import de.admadic.calculator.appctx.AppEvent;
import de.admadic.calculator.appctx.AppEventListener;
import de.admadic.calculator.appctx.CancelPhaseException;
import de.admadic.calculator.appctx.IAppContext;
import de.admadic.calculator.appmod.IModule;
import de.admadic.calculator.appmod.ModuleDesc;
import de.admadic.calculator.modules.matrx.MatrxActions;
import de.admadic.calculator.modules.matrx.MatrxCfg;
import de.admadic.calculator.modules.matrx.MatrxItf;
import de.admadic.calculator.modules.matrx.ui.MatrxFrame;
import de.admadic.cfg.Cfg;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class MatrxModule
implements IModule,
AppEventListener,
MatrxItf,
ComponentListener {
    static final boolean LOG = true;
    Logger logger = Logger.getLogger("de.admadic");
    MatrxFrame frame;
    ModuleDesc moduleDesc;
    IAppContext appContext;
    Cfg cfg;
    MatrxCfg modCfg;
    MatrxActions actions;

    public MatrxModule() {
        this.createModuleDesc();
    }

    private void createModuleDesc() {
        this.moduleDesc = new ModuleDesc();
        this.moduleDesc.setImplDetails("admaDIC", "Matrx", "1.0.0");
        this.moduleDesc.setSpecDetails("admaDIC", "Matrx", "1.0.0");
        this.moduleDesc.setCfgName("Matrx");
    }

    @Override
    public ModuleDesc getModuleDesc() {
        return this.moduleDesc;
    }

    @Override
    public void initialize(IAppContext iAppContext) {
        this.appContext = iAppContext;
        this.cfg = iAppContext.getCfg();
        this.actions = new MatrxActions();
        this.modCfg = new MatrxCfg(this.cfg);
        this.modCfg.setPrefix(iAppContext.getCfgModulesPrefix());
        this.modCfg.checkPrevCfg();
        this.actions.initialize(this);
        iAppContext.addAppListener(this);
    }

    @Override
    public JMenu createModuleMenu() {
        JMenu jMenu = new JMenu("Matrx");
        if (this.actions != null && this.actions.getActions() != null) {
            for (int i = 1; i < this.actions.getActions().size(); ++i) {
                JMenuItem jMenuItem = new JMenuItem(this.actions.getActions().get(i));
                jMenu.add(jMenuItem);
            }
        }
        return jMenu;
    }

    @Override
    public Action[] getActions() {
        return this.actions.getActionArray();
    }

    @Override
    public void processPhase(AppEvent appEvent) throws CancelPhaseException {
        switch (appEvent.getPhase()) {
            case 1: {
                break;
            }
            case 2: {
                this.doInitFrame();
                break;
            }
            case 3: {
                this.doShowFrame();
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.checkExit();
                break;
            }
            case 7: {
                this.doExit();
                break;
            }
        }
    }

    private void doInitFrame() {
        this.frame = new MatrxFrame(this.modCfg, this.actions, this.appContext);
        this.frame.initComponents();
        if (this.appContext != null && this.appContext.getLafManager() != null) {
            this.appContext.getLafManager().addComponent(this.frame);
        }
        this.frame.addComponentListener(this);
    }

    private void doShowFrame() {
        Rectangle rectangle = this.modCfg.getPos();
        if (rectangle != null) {
            this.frame.setBounds(rectangle);
        }
        boolean bl = this.modCfg.getShow(true);
        this.frame.setVisible(bl);
    }

    private void checkExit() throws CancelPhaseException {
        this.frame.storeSettings();
    }

    private void doExit() {
        this.frame.dispose();
    }

    @Override
    public void cmdSingleButton() {
        this.frame.setVisible(!this.frame.isVisible());
    }

    @Override
    public void cmdShow() {
        if (!this.frame.isVisible()) {
            this.frame.setVisible(true);
        }
    }

    @Override
    public void cmdHide() {
        if (this.frame.isVisible()) {
            this.frame.setVisible(false);
        }
    }

    @Override
    public void cmdSettings() {
        this.frame.doToolsOptions();
    }

    @Override
    public void cmdAbout() {
        this.frame.doHelpAbout();
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.modCfg.putPos(this.frame.getBounds());
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        this.modCfg.putPos(this.frame.getBounds());
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.modCfg.putPos(this.frame.getBounds());
        this.modCfg.putShow(this.frame.isVisible());
        if (!this.frame.isSetupComplete()) {
            // empty if block
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        this.modCfg.putShow(this.frame.isVisible());
    }
}

