/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.matrx;

import de.admadic.calculator.modules.matrx.core.DMatrix;
import de.admadic.calculator.modules.matrx.core.MatrixUtil;
import de.admadic.cfg.Cfg;
import java.awt.Rectangle;

public class MatrxCfg {
    public static final String MODNAME = "Matrx";
    public static final String KEY_SHOW = "Matrx.show";
    public static final String KEY_POS = "Matrx.pos";
    public static final String KEY_LASTWD = "Matrx.lastwd";
    public static final String KEY_DISPLAY_FORMAT = "Matrx.displayformat";
    public static final String KEY_MTX_EDIT_CONTENT = "Matrx.mtxeditcontent";
    public static final String KEY_MTX_DATA_CONTENT = "Matrx.mtxdatacontent";
    public static final int MTXIDX_SPL_INP = 0;
    public static final int MTXIDX_SPL_RES = 1;
    public static final int MTXIDX_BIN_INP = 2;
    public static final int MTXIDX_BIN_PAR = 3;
    public static final int MTXIDX_BIN_RES = 4;
    public static final int MTXIDX_EQU_COE = 5;
    public static final int MTXIDX_EQU_ABS = 6;
    public static final int MTXIDX_EQU_GAU = 7;
    public static final int MTXIDX_EQU_SOL = 8;
    public static final int MTXCNT = 9;
    String prefix = "";
    Cfg cfg;

    public MatrxCfg(Cfg cfg) {
        this.cfg = cfg;
    }

    public Cfg getCfg() {
        return this.cfg;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String string) {
        this.prefix = string;
        if (this.prefix == null) {
            this.prefix = "";
        }
    }

    public void checkPrevCfg() {
        this.checkPrevCfgImpl(this.prefix + KEY_SHOW);
        this.checkPrevCfgImpl(this.prefix + KEY_POS);
        this.checkPrevCfgImpl(this.prefix + KEY_LASTWD);
    }

    private void checkPrevCfgImpl(String string) {
        String string2 = string.substring((this.prefix + MODNAME).length());
        String string3 = this.prefix + "Matrx.prev" + string2;
        Object object = this.cfg.getValue(string3, null);
        if (object == null) {
            return;
        }
        this.cfg.putValue(string, object);
        this.cfg.removeValue(string3);
    }

    public void putShow(boolean bl) {
        this.cfg.putBooleanValue(this.prefix + KEY_SHOW, bl);
    }

    public boolean getShow(boolean bl) {
        return this.cfg.getBooleanValue(this.prefix + KEY_SHOW, bl);
    }

    public void putPos(Rectangle rectangle) {
        this.cfg.putRectangleValue(this.prefix + KEY_POS, rectangle);
    }

    public Rectangle getPos() {
        return this.cfg.getRectangleValue(this.prefix + KEY_POS, null);
    }

    public void putDisplayFormat(String string) {
        this.cfg.putStringValue(this.prefix + KEY_DISPLAY_FORMAT, string);
    }

    public String getDisplayFormat() {
        return this.cfg.getStringValue(this.prefix + KEY_DISPLAY_FORMAT, null);
    }

    public void putLastWD(String string) {
        this.cfg.putStringValue(this.prefix + KEY_LASTWD, string);
    }

    public String getLastWD() {
        return this.cfg.getStringValue(this.prefix + KEY_LASTWD, null);
    }

    public String getMtxEditContent() {
        String string = this.cfg.getStringValue(this.prefix + KEY_MTX_EDIT_CONTENT, "");
        string = string.replace(';', '\n');
        return string;
    }

    public void putMtxEditContent(String string) {
        string = string.replace('\n', ';');
        this.cfg.putStringValue(this.prefix + KEY_MTX_EDIT_CONTENT, string);
    }

    public DMatrix[] getMtxDataContent() {
        Object[] objectArray = this.cfg.getValueArray(this.prefix + "Matrx.mtxdatacontent.");
        if (objectArray == null) {
            return null;
        }
        DMatrix[] dMatrixArray = new DMatrix[objectArray.length];
        for (int i = 0; i < dMatrixArray.length; ++i) {
            DMatrix dMatrix;
            dMatrixArray[i] = dMatrix = MatrixUtil.parseMatrixString((String)objectArray[i]);
        }
        return dMatrixArray;
    }

    public void putMtxDataContent(DMatrix[] dMatrixArray) {
        Object[] objectArray = new String[dMatrixArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = MatrixUtil.makeString(dMatrixArray[i]);
        }
        this.cfg.putValueArray(this.prefix + "Matrx.mtxdatacontent.", objectArray);
    }
}

