/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.matrx;

import de.admadic.calculator.modules.matrx.MatrxItf;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;

public class MatrxActions {
    static final boolean LOG = true;
    Logger logger = Logger.getLogger("de.admadic");
    Vector<Action> actions = new Vector();
    Hashtable<Class, Action> classToAction = new Hashtable();

    public Vector<Action> getActions() {
        return this.actions;
    }

    public void initialize(MatrxItf matrxItf) {
        this.actions.add(new SingleButtonAction(matrxItf));
        this.actions.add(new ShowAction(matrxItf));
        this.actions.add(new HideAction(matrxItf));
        this.actions.add(new SettingsAction(matrxItf));
        this.actions.add(new AboutAction(matrxItf));
        for (Action action : this.actions) {
            this.classToAction.put(action.getClass(), action);
        }
    }

    public Action[] getActionArray() {
        Action[] actionArray = new Action[this.actions.size()];
        actionArray = this.actions.toArray(actionArray);
        return actionArray;
    }

    public ImageIcon loadIcon(String string) {
        String string2 = "de/admadic/calculator/modules/matrx/res/" + string;
        URL uRL = this.getClass().getClassLoader().getResource(string2);
        if (uRL == null) {
            if (this.logger != null) {
                this.logger.warning("could not get url for " + string2 + " (icon name = " + string + ")");
            }
            return null;
        }
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        if (image == null) {
            if (this.logger != null) {
                this.logger.warning("could not get image for " + uRL.toString() + " (icon name = " + string + ")");
            }
            return null;
        }
        return new ImageIcon(image);
    }

    public static ImageIcon loadIcon(Class clazz, String string) {
        String string2 = "de/admadic/calculator/modules/matrx/res/" + string;
        URL uRL = clazz.getClassLoader().getResource(string2);
        if (uRL == null) {
            return null;
        }
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        if (image == null) {
            return null;
        }
        return new ImageIcon(image);
    }

    public class AboutAction
    extends AbstractMaSCaAction {
        private static final long serialVersionUID = 1L;

        public AboutAction(MatrxItf matrxItf) {
            super(matrxItf);
            this.putValue("Name", "About");
            this.putValue("ShortDescription", "About MaSCa Module");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.itf.cmdAbout();
        }
    }

    public class SettingsAction
    extends AbstractMaSCaAction {
        private static final long serialVersionUID = 1L;

        public SettingsAction(MatrxItf matrxItf) {
            super(matrxItf);
            this.putValue("Name", "Settings");
            this.putValue("ShortDescription", "Change Settings of MaSCa Module");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.itf.cmdSettings();
        }
    }

    public class HideAction
    extends AbstractMaSCaAction {
        private static final long serialVersionUID = 1L;

        public HideAction(MatrxItf matrxItf) {
            super(matrxItf);
            this.putValue("Name", "Hide");
            this.putValue("ShortDescription", "Hide the MaSCa Module");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.itf.cmdHide();
        }
    }

    public class ShowAction
    extends AbstractMaSCaAction {
        private static final long serialVersionUID = 1L;

        public ShowAction(MatrxItf matrxItf) {
            super(matrxItf);
            this.putValue("Name", "Show");
            this.putValue("ShortDescription", "Show the MaSCa Module");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.itf.cmdShow();
        }
    }

    public class SingleButtonAction
    extends AbstractMaSCaAction {
        private static final long serialVersionUID = 1L;

        public SingleButtonAction(MatrxItf matrxItf) {
            super(matrxItf);
            this.putValue("Name", "");
            this.putValue("ShortDescription", "Module Materials Science Calculations");
            this.putValue("SmallIcon", MatrxActions.this.loadIcon("icon-16.png"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.itf.cmdSingleButton();
        }
    }

    public static abstract class AbstractMaSCaAction
    extends AbstractAction {
        MatrxItf itf;

        public AbstractMaSCaAction(MatrxItf matrxItf) {
            this.itf = matrxItf;
        }
    }
}

