/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.masca.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.admadic.calculator.modules.masca.core.ValueConstraints;
import de.admadic.calculator.modules.masca.ui.UnitSelector;
import de.admadic.calculator.modules.masca.ui.ValueFieldContext;
import de.admadic.units.core.IMeasure;
import de.admadic.units.core.IUnit;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class ValueField
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    JLabel labelName;
    JLabel labelSymbol;
    JTextField textValue;
    UnitSelector comboUnit;
    IMeasure measure;
    Vector<IUnit> units;
    ValueConstraints valueConstraints;
    public static final int STYLE_INPUT = 0;
    public static final int STYLE_OUTPUT = 1;
    int style = 0;
    public static final int STATUS_OK = 0;
    public static final int STATUS_BAD = 1;
    public static final int STATUS_WARN = 2;
    int fieldStatus = 0;

    public ValueField() {
        this.initContents();
        this.setStyle(0);
        this.setMeasure(null);
    }

    public void setStyle(int n) {
        this.style = n;
        this.updateStyle();
    }

    public int getFieldStatus() {
        return this.fieldStatus;
    }

    public void setFieldStatus(int n) {
        boolean bl = false;
        if (this.fieldStatus != n) {
            bl = true;
        }
        this.fieldStatus = n;
        if (!bl) {
            return;
        }
        switch (this.fieldStatus) {
            case 0: {
                Border border = UIManager.getBorder("TextField.border");
                this.textValue.setBorder(border);
                break;
            }
            case 2: {
                Border border = BorderFactory.createLineBorder(Color.ORANGE, 2);
                this.textValue.setBorder(border);
                break;
            }
            default: {
                Border border = BorderFactory.createLineBorder(Color.RED, 2);
                this.textValue.setBorder(border);
            }
        }
    }

    protected void initContents() {
        FormLayout formLayout = new FormLayout("0px, 80dlu, 5px, 25dlu, 5px, 80dlu, 5px, 40dlu, 0px", "0px, p, 0px");
        CellConstraints cellConstraints = new CellConstraints();
        this.setLayout(formLayout);
        this.labelName = new JLabel("(name)");
        this.add((Component)this.labelName, cellConstraints.xy(2, 2));
        this.labelSymbol = new JLabel("(sym)");
        this.add((Component)this.labelSymbol, cellConstraints.xy(4, 2));
        this.textValue = new JTextField("(value)");
        this.add((Component)this.textValue, cellConstraints.xy(6, 2));
        this.comboUnit = new UnitSelector();
        this.add((Component)this.comboUnit, cellConstraints.xy(8, 2));
        this.comboUnit.addActionListener(this);
    }

    public void setUnits(Vector<IUnit> vector) {
        this.units = vector;
        this.comboUnit.setUnits(vector);
    }

    public IMeasure getMeasure() {
        return this.measure;
    }

    public void setMeasure(IMeasure iMeasure) {
        this.measure = iMeasure;
        this.updateMeasure();
    }

    public void refreshDisplay() {
        this.updateMeasure();
    }

    private void updateStyle() {
        if (this.style == 0) {
            this.textValue.setEditable(true);
        } else {
            this.textValue.setEditable(false);
        }
    }

    private void updateMeasure() {
        if (this.measure == null) {
            this.labelName.setText("-");
            this.labelSymbol.setText("-");
            this.textValue.setText("");
            this.comboUnit.setSelectedItem(null);
        } else {
            this.labelName.setText(this.measure.getNameDisplay());
            this.labelSymbol.setText(this.measure.getSymbolDisplay());
            String string = this.measure.getValueView();
            this.textValue.setText(string);
            IUnit iUnit = this.measure.getUnit();
            int n = this.units.indexOf(iUnit);
            this.comboUnit.setSelectedIndex(n);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.comboUnit.getSelectedIndex();
        if (n < 0) {
            return;
        }
        if (this.measure == null) {
            return;
        }
        IUnit iUnit = this.units.get(n);
        this.commitInput(null);
        this.measure.changeUnit(iUnit);
        String string = this.measure.getValueView();
        this.textValue.setText(string);
    }

    public void commitInput(ValueFieldContext valueFieldContext) {
        Double d;
        try {
            d = Double.valueOf(this.textValue.getText());
        }
        catch (NumberFormatException numberFormatException) {
            if (valueFieldContext != null) {
                valueFieldContext.addEntry(this, numberFormatException.getMessage(), 1);
            }
            this.setFieldStatus(1);
            return;
        }
        if (this.valueConstraints != null && !this.valueConstraints.checkValue(d)) {
            this.setFieldStatus(2);
        } else {
            this.setFieldStatus(0);
        }
        this.measure.setValue(d);
    }

    public ValueConstraints getValueConstraints() {
        return this.valueConstraints;
    }

    public void setValueConstraints(ValueConstraints valueConstraints) {
        this.valueConstraints = valueConstraints;
    }
}

