/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.masca.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.admadic.calculator.appctx.IAppContext;
import de.admadic.calculator.modules.masca.MaSCaActions;
import de.admadic.calculator.modules.masca.MaSCaCfg;
import de.admadic.calculator.modules.masca.core.AbstractCalculation;
import de.admadic.calculator.modules.masca.core.CalcManager;
import de.admadic.calculator.modules.masca.ui.CalcPanel;
import de.admadic.calculator.modules.masca.ui.CalculationTree;
import de.admadic.calculator.modules.masca.ui.CopyPasteCore;
import de.admadic.calculator.modules.masca.ui.SettingsDialog;
import de.admadic.ui.util.AboutDialog;
import de.admadic.units.core.MeasureFormatter;
import de.admadic.units.core.UnitManager;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.net.URL;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class MaSCaFrame
extends JFrame
implements TreeSelectionListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    static final boolean LOG = true;
    Logger logger = Logger.getLogger("de.admadic");
    UnitManager um;
    CalcManager cm;
    MaSCaCfg cfg;
    MaSCaActions actions;
    IAppContext appContext;
    MeasureFormatter mf;
    JPanel panelMain;
    JPanel panelContent;
    JScrollPane scrollContent;
    CalcPanel panelCalc;
    JTree treeSelector;
    JScrollPane scrollSelector;
    ImageIcon iconLarge;
    ImageIcon iconSmall;
    boolean setupComplete = false;
    AbstractCalculation activeCalcEngine;
    CopyPasteCore copyPasteCore;
    static final String CMD_FILE_EXIT = "mnu.file.exit";
    static final String CMD_EDIT_COPY = "mnu.edit.copy";
    static final String CMD_EDIT_PASTE = "mnu.edit.paste";
    static final String CMD_TOOLS_OPTIONS = "mnu.tools.options";
    static final String CMD_HELP_ABOUT = "mnu.help.about";

    public MaSCaFrame(UnitManager unitManager, CalcManager calcManager, MaSCaCfg maSCaCfg, MaSCaActions maSCaActions, IAppContext iAppContext) throws HeadlessException {
        this.um = unitManager;
        this.cm = calcManager;
        this.cfg = maSCaCfg;
        this.actions = maSCaActions;
        this.appContext = iAppContext;
    }

    public void initCore() {
        String string = this.cfg.getDisplayFormat();
        if (string == null) {
            string = "%g";
        }
        this.mf = MeasureFormatter.createFormatter(string, Locale.getDefault());
    }

    private void addMenuItem(JMenu jMenu, String string, String string2) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenu.add(jMenuItem);
        jMenuItem.setActionCommand(string2);
        jMenuItem.addActionListener(this);
    }

    protected ImageIcon loadIcon(String string) {
        String string2 = "de/admadic/calculator/modules/masca/res/" + string;
        URL uRL = this.getClass().getClassLoader().getResource(string2);
        if (uRL == null) {
            if (this.logger != null) {
                this.logger.warning("could not get url for " + string2 + " (icon name = " + string + ")");
            }
            return null;
        }
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        if (image == null) {
            if (this.logger != null) {
                this.logger.warning("could not get image for " + uRL.toString() + " (icon name = " + string + ")");
            }
            return null;
        }
        return new ImageIcon(image);
    }

    public void initComponents() {
        Serializable serializable;
        this.initCore();
        this.iconSmall = this.loadIcon("icon-16.png");
        this.iconLarge = this.loadIcon("icon-48.png");
        this.panelMain = (JPanel)this.getContentPane();
        if (this.iconSmall != null) {
            this.setIconImage(this.iconSmall.getImage());
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                super.windowClosing(windowEvent);
                MaSCaFrame.this.setVisible(false);
            }
        });
        this.setTitle("MaSCa Module");
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        this.addMenuItem(jMenu, "Close", CMD_FILE_EXIT);
        jMenu = new JMenu("Edit");
        jMenuBar.add(jMenu);
        this.addMenuItem(jMenu, "Copy", CMD_EDIT_COPY);
        this.addMenuItem(jMenu, "Paste", CMD_EDIT_PASTE);
        if (this.actions != null && this.actions.getActions() != null) {
            serializable = new JMenu("Module");
            jMenuBar.add((JMenu)serializable);
            for (int i = 1; i < this.actions.getActions().size(); ++i) {
                serializable.add(new JMenuItem(this.actions.getActions().get(i)));
            }
        }
        jMenu = new JMenu("Help");
        jMenuBar.add(jMenu);
        this.addMenuItem(jMenu, "About...", CMD_HELP_ABOUT);
        this.setJMenuBar(jMenuBar);
        serializable = new FormLayout("12px, 150dlu, 5px, d:grow, 12px", "12px, d:grow, 12px");
        CellConstraints cellConstraints = new CellConstraints();
        this.panelMain.setLayout((LayoutManager)((Object)serializable));
        this.treeSelector = new CalculationTree();
        this.treeSelector.setVisibleRowCount(10);
        this.scrollSelector = new JScrollPane(this.treeSelector, 22, 32);
        this.panelMain.add((Component)this.scrollSelector, cellConstraints.xy(2, 2, CellConstraints.FILL, CellConstraints.FILL));
        this.panelContent = new JPanel();
        this.panelContent.setLayout(new GridLayout(1, 1));
        this.scrollContent = new JScrollPane();
        this.scrollContent.setVerticalScrollBarPolicy(22);
        this.scrollContent.setHorizontalScrollBarPolicy(32);
        this.panelContent.add(this.scrollContent);
        this.panelCalc = new CalcPanel(this.um, this.mf);
        this.panelCalc.initPlain("Calculations", "Please select the desired calculation from the list on the left hand side of this window.", 1, 1);
        this.panelMain.add((Component)this.panelContent, cellConstraints.xy(4, 2, CellConstraints.FILL, CellConstraints.FILL));
        this.scrollContent.setViewportView(this.panelCalc);
        this.treeSelector.getSelectionModel().setSelectionMode(1);
        this.treeSelector.addTreeSelectionListener(this);
        this.treeSelector.setModel(new DefaultTreeModel(null));
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public void initTreeData() {
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(this.cm.getCategoryTree().getRoot());
        this.treeSelector.setModel(defaultTreeModel);
        this.treeSelector.setRootVisible(false);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.treeSelector.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (defaultMutableTreeNode.isLeaf() && object instanceof AbstractCalculation) {
            AbstractCalculation abstractCalculation = (AbstractCalculation)object;
            this.displayCalcEngine(abstractCalculation);
        }
    }

    private void displayCalcEngine(AbstractCalculation abstractCalculation) {
        final AbstractCalculation abstractCalculation2 = abstractCalculation;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (MaSCaFrame.this.activeCalcEngine != null) {
                    MaSCaFrame.this.activeCalcEngine.unlinkFromCalcPanel();
                }
                MaSCaFrame.this.activeCalcEngine = abstractCalculation2;
                abstractCalculation2.linkToCalcPanel(MaSCaFrame.this.panelCalc);
            }
        });
    }

    public void doHelpAbout() {
        AboutDialog aboutDialog = new AboutDialog(this);
        aboutDialog.setAboutInfo("admaDIC Calculator Module\nMaSCa - Materials Science Calculations\nVersion 1.0.0-r16", "Copyright (c) 2005-2022 - admaDIC\nGermany", "For updates or more information \nplease visit http://www.admadic.de/", "This product includes the software JGoodies Forms:\nCopyright (c) 2002-2004 JGoodies Karsten Lentzsch.\nAll rights reserved.");
        aboutDialog.setTitle("About MaSCa Module");
        if (this.iconLarge != null) {
            aboutDialog.setLogo(this.iconLarge.getImage());
        }
        aboutDialog.setVisible(true);
    }

    public boolean isSetupComplete() {
        return this.setupComplete;
    }

    public void setSetupComplete(boolean bl) {
        this.setupComplete = bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CMD_FILE_EXIT)) {
            this.doExit();
        } else if (string.equals(CMD_EDIT_COPY)) {
            this.doEditCopy();
        } else if (string.equals(CMD_EDIT_PASTE)) {
            this.doEditPaste();
        } else if (string.equals(CMD_HELP_ABOUT)) {
            this.doHelpAbout();
        } else if (string.equals(CMD_TOOLS_OPTIONS)) {
            this.doToolsOptions();
        }
    }

    private void doEditCopy() {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        if (this.copyPasteCore == null) {
            this.copyPasteCore = new CopyPasteCore();
        }
        if (component instanceof JTextField) {
            JTextField jTextField = (JTextField)component;
            this.copyPasteCore.doCopyFrom(jTextField);
        }
    }

    private void doEditPaste() {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        if (this.copyPasteCore == null) {
            this.copyPasteCore = new CopyPasteCore();
        }
        if (component instanceof JTextField) {
            JTextField jTextField = (JTextField)component;
            this.copyPasteCore.doPasteInto(jTextField);
        }
    }

    protected void doExit() {
        this.dispose();
    }

    public void doToolsOptions() {
        SettingsDialog settingsDialog = new SettingsDialog((Frame)this, this.cfg);
        settingsDialog.initContents();
        settingsDialog.loadSettings();
        settingsDialog.setVisible(true);
        int n = settingsDialog.getResultCode();
        if (n == 1) {
            String string = this.cfg.getDisplayFormat();
            if (string == null) {
                string = "%g";
            }
            this.mf.setFormatString(string);
            this.panelCalc.refreshDisplay();
        }
    }
}

