/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.masca.ui;

import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.admadic.calculator.modules.masca.core.ValueConstraints;
import de.admadic.calculator.modules.masca.ui.ValueField;
import de.admadic.calculator.modules.masca.ui.ValueFieldContext;
import de.admadic.units.core.IMeasure;
import de.admadic.units.core.MeasureFormatter;
import de.admadic.units.core.UnitManager;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;

public class CalcPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    UnitManager um;
    MeasureFormatter mf;
    JLabel textTitle;
    JTextPane textDesc;
    JComponent labelInputs;
    JComponent labelOutputs;
    JButton btnCalc;
    Vector<ValueField> inputs;
    Vector<ValueField> outputs;
    ValueFieldContext vfc;
    Hashtable<IMeasure, ValueConstraints> inputConstraints;

    public CalcPanel(UnitManager unitManager, MeasureFormatter measureFormatter) {
        this.um = unitManager;
        this.mf = measureFormatter;
        this.inputs = new Vector();
        this.outputs = new Vector();
        this.vfc = new ValueFieldContext();
        this.inputConstraints = new Hashtable();
    }

    public void initPlain(String string, String string2, int n, int n2) {
        ValueField valueField;
        int n3;
        this.removeAll();
        this.inputs.clear();
        this.outputs.clear();
        this.inputConstraints.clear();
        String string3 = "5px, p, 5px";
        Object object = "5px, p, 5px, 30dlu, 5px, p, 5px";
        for (int i = 0; i < 1 + n + 1 + n2; ++i) {
            object = (String)object + ", p, 5px";
        }
        FormLayout formLayout = new FormLayout(string3, (String)object);
        CellConstraints cellConstraints = new CellConstraints();
        this.setLayout(formLayout);
        int n4 = 0;
        this.textTitle = new JLabel(string);
        this.add((Component)this.textTitle, cellConstraints.xy(2, n4 += 2));
        this.textDesc = new JTextPane();
        this.add((Component)this.textDesc, cellConstraints.xy(2, n4 += 2, CellConstraints.FILL, CellConstraints.FILL));
        this.textDesc.setText(string2);
        this.btnCalc = new JButton("Calculate");
        this.add((Component)this.btnCalc, cellConstraints.xy(2, n4 += 2));
        this.labelInputs = DefaultComponentFactory.getInstance().createSeparator("Inputs:");
        this.labelOutputs = DefaultComponentFactory.getInstance().createSeparator("Outputs:");
        this.textDesc.setEditable(false);
        for (n3 = 0; n3 < n; ++n3) {
            this.inputs.add(new ValueField());
        }
        for (n3 = 0; n3 < n2; ++n3) {
            this.outputs.add(new ValueField());
        }
        this.add((Component)this.labelInputs, cellConstraints.xy(2, n4 += 2));
        for (n3 = 0; n3 < this.inputs.size(); ++n3) {
            valueField = this.inputs.get(n3);
            valueField.setStyle(0);
            this.add((Component)valueField, cellConstraints.xy(2, n4 += 2));
        }
        this.add((Component)this.labelOutputs, cellConstraints.xy(2, n4 += 2));
        for (n3 = 0; n3 < this.outputs.size(); ++n3) {
            valueField = this.outputs.get(n3);
            valueField.setStyle(1);
            this.add((Component)valueField, cellConstraints.xy(2, n4 += 2));
        }
    }

    public void registerMeasures(Vector<IMeasure> vector, Vector<IMeasure> vector2) {
        ValueField valueField;
        IMeasure iMeasure;
        int n;
        for (n = 0; n < vector.size(); ++n) {
            iMeasure = vector.get(n);
            iMeasure.setMeasureFormatter(this.mf);
            valueField = this.inputs.get(n);
            valueField.setUnits(this.um.getUnitsForDomain(iMeasure.getUnit().getDomain(), null));
            valueField.setMeasure(iMeasure);
            valueField.setValueConstraints(this.inputConstraints.get(iMeasure));
        }
        for (n = 0; n < vector2.size(); ++n) {
            iMeasure = vector2.get(n);
            iMeasure.setMeasureFormatter(this.mf);
            valueField = this.outputs.get(n);
            valueField.setUnits(this.um.getUnitsForDomain(iMeasure.getUnit().getDomain(), null));
            valueField.setMeasure(iMeasure);
        }
    }

    public void refreshDisplay() {
        for (ValueField valueField : this.inputs) {
            valueField.refreshDisplay();
        }
        for (ValueField valueField : this.outputs) {
            valueField.refreshDisplay();
        }
    }

    public void addInputConstraints(IMeasure iMeasure, ValueConstraints valueConstraints) {
        this.inputConstraints.put(iMeasure, valueConstraints);
    }

    public void clearInputConstraints() {
        this.inputConstraints.clear();
    }

    public boolean commitInputs() {
        this.vfc.clear();
        for (ValueField valueField : this.inputs) {
            valueField.commitInput(this.vfc);
        }
        return this.vfc.getRecordCount() <= 0;
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.btnCalc != null) {
            this.btnCalc.addActionListener(actionListener);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this.btnCalc != null) {
            this.btnCalc.removeActionListener(actionListener);
        }
    }
}

