/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.masca.core;

import java.util.Vector;

public class ValueConstraints {
    Vector<Interval> allowedIntervals;
    Vector<Interval> prohibitedIntervals;
    public static final int TYPE_OPEN_OPEN = 0;
    public static final int TYPE_OPEN_CLOSED = 1;
    public static final int TYPE_CLOSED_OPEN = 2;
    public static final int TYPE_CLOSED_CLOSED = 3;

    public void addAllowedInterval(double d, double d2, int n) {
        if (this.allowedIntervals == null) {
            this.allowedIntervals = new Vector();
        }
        this.addInterval(this.allowedIntervals, d, d2, n);
    }

    public void addProhibitedInterval(double d, double d2, int n) {
        if (this.prohibitedIntervals == null) {
            this.prohibitedIntervals = new Vector();
        }
        this.addInterval(this.prohibitedIntervals, d, d2, n);
    }

    private void addInterval(Vector<Interval> vector, double d, double d2, int n) {
        AbstractInterval abstractInterval;
        switch (n) {
            case 0: {
                abstractInterval = new IntervalOpenOpen(d, d2);
                break;
            }
            case 1: {
                abstractInterval = new IntervalOpenClosed(d, d2);
                break;
            }
            case 2: {
                abstractInterval = new IntervalClosedOpen(d, d2);
                break;
            }
            case 3: {
                abstractInterval = new IntervalClosedClosed(d, d2);
                break;
            }
            default: {
                throw new Error("invalid id in ValueConstraints.addInterval");
            }
        }
        vector.add(abstractInterval);
    }

    public boolean checkValue(double d) {
        boolean bl;
        if (this.allowedIntervals != null) {
            bl = false;
            for (Interval interval : this.allowedIntervals) {
                if (!interval.isInside(d)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return false;
            }
        }
        if (this.prohibitedIntervals != null) {
            bl = true;
            for (Interval interval : this.prohibitedIntervals) {
                if (!interval.isInside(d)) continue;
                bl = false;
                break;
            }
            if (!bl) {
                return false;
            }
        }
        return true;
    }

    public static class IntervalClosedOpen
    extends AbstractInterval {
        public IntervalClosedOpen(double d, double d2) {
            super(d, d2);
        }

        @Override
        public boolean isInside(double d) {
            return d >= this.begin && d < this.end;
        }
    }

    public static class IntervalOpenClosed
    extends AbstractInterval {
        public IntervalOpenClosed(double d, double d2) {
            super(d, d2);
        }

        @Override
        public boolean isInside(double d) {
            return d > this.begin && d <= this.end;
        }
    }

    public static class IntervalClosedClosed
    extends AbstractInterval {
        public IntervalClosedClosed(double d, double d2) {
            super(d, d2);
        }

        @Override
        public boolean isInside(double d) {
            return d >= this.begin && d <= this.end;
        }
    }

    public static class IntervalOpenOpen
    extends AbstractInterval {
        public IntervalOpenOpen(double d, double d2) {
            super(d, d2);
        }

        @Override
        public boolean isInside(double d) {
            return d > this.begin && d < this.end;
        }
    }

    public static abstract class AbstractInterval
    implements Interval {
        double begin;
        double end;

        public AbstractInterval(double d, double d2) {
            this.begin = d;
            this.end = d2;
        }
    }

    public static interface Interval {
        public boolean isInside(double var1);
    }
}

