/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.masca.core;

import com.graphbuilder.math.Expression;
import com.graphbuilder.math.ExpressionTree;
import com.graphbuilder.math.FuncMap;
import com.graphbuilder.math.VarMap;
import de.admadic.calculator.modules.masca.core.AbstractCalculation;
import de.admadic.units.core.IMeasure;
import de.admadic.units.core.UnitFactory;
import de.admadic.units.core.UnitManager;

public class CalculationGeneric
extends AbstractCalculation {
    UnitManager um;
    String exprStr;
    String varStr;
    Expression expr;
    FuncMap funcMap;
    VarMap varMap;

    public CalculationGeneric(UnitManager unitManager) {
        this.um = unitManager;
        this.funcMap = new FuncMap();
        this.funcMap.loadDefaultFunctions();
        this.varMap = new VarMap();
    }

    public CalculationGeneric setup(String string, String string2, String[] stringArray, String string3) {
        this.setTitle(string);
        this.setDescription(string2);
        for (int i = 0; i < stringArray.length; ++i) {
            if (i == 0) {
                this.addOutput(stringArray[i]);
                continue;
            }
            this.addInput(stringArray[i]);
        }
        this.expr = ExpressionTree.parse(string3);
        return this;
    }

    public void addInput(String string) {
        String[] stringArray = string.split(",");
        String string2 = stringArray[0].trim();
        String string3 = stringArray[1].trim();
        String string4 = stringArray[2].trim();
        String string5 = stringArray[3].trim();
        String string6 = stringArray.length > 4 ? stringArray[4].trim() : null;
        String string7 = stringArray.length > 5 ? stringArray[5].trim() : null;
        this.addInput(string2, string3, string4, string5, string6, string7);
    }

    public void addInput(String string, String string2, String string3, String string4, String string5, String string6) {
        double d = Double.parseDouble(string3);
        IMeasure iMeasure = UnitFactory.createMeasure(this.um, string, string2, d, string4, string5, string6);
        this.getInputs().add(iMeasure);
    }

    public void addOutput(String string) {
        String[] stringArray = string.split(",");
        String string2 = stringArray[0].trim();
        String string3 = stringArray[1].trim();
        String string4 = stringArray[2].trim();
        String string5 = stringArray[3].trim();
        String string6 = stringArray.length > 4 ? stringArray[4].trim() : null;
        String string7 = stringArray.length > 5 ? stringArray[5].trim() : null;
        this.addOutput(string2, string3, string4, string5, string6, string7);
    }

    public void addOutput(String string, String string2, String string3, String string4, String string5, String string6) {
        double d = Double.parseDouble(string3);
        IMeasure iMeasure = UnitFactory.createMeasure(this.um, string, string2, d, string4, string5, string6);
        this.getOutputs().add(iMeasure);
    }

    public void setExpression(String string) {
        this.expr = ExpressionTree.parse(string);
    }

    public void testExpression() {
        for (int i = 0; i < this.getInputs().size(); ++i) {
            IMeasure iMeasure = this.getInputs().get(i);
            this.varMap.setValue(iMeasure.getId().substring(1), iMeasure.getRootValue());
        }
        double d = this.expr.eval(this.varMap, this.funcMap);
        this.getOutputs().firstElement().setRootValue(d);
    }

    @Override
    protected void calculateCore() {
        for (int i = 0; i < this.getInputs().size(); ++i) {
            IMeasure iMeasure = this.getInputs().get(i);
            this.varMap.setValue(iMeasure.getId().substring(1), iMeasure.getRootValue());
        }
        double d = this.expr.eval(this.varMap, this.funcMap);
        this.getOutputs().firstElement().setRootValue(d);
    }
}

