/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.masca.core;

import de.admadic.calculator.modules.masca.core.CalcCategory;
import de.admadic.calculator.modules.masca.core.CalcFactory;
import de.admadic.calculator.modules.masca.core.CalcManager;
import de.admadic.calculator.modules.masca.core.CalcSpecIoError;
import de.admadic.calculator.modules.masca.core.CalculationGeneric;
import de.admadic.calculator.modules.masca.core.ValueConstraints;
import de.admadic.units.core.UnitManager;
import de.admadic.util.FileUtil;
import java.io.File;
import java.net.URL;
import java.util.Vector;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.IXMLParser;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLParserFactory;

public class CalcSpecIo {
    CalcManager cm;
    UnitManager um;

    public CalcSpecIo(CalcManager calcManager, UnitManager unitManager) {
        this.cm = calcManager;
        this.um = unitManager;
    }

    public void readFile(File file) {
        try {
            String string = file.toString();
            string = FileUtil.fixFileName1(string);
            IXMLParser iXMLParser = XMLParserFactory.createDefaultXMLParser();
            IXMLReader iXMLReader = StdXMLReader.fileReader(string);
            iXMLParser.setReader(iXMLReader);
            IXMLElement iXMLElement = (IXMLElement)iXMLParser.parse();
            String string2 = iXMLElement.getName();
            if (!string2.equals("calcspec")) {
                throw new CalcSpecIoError("invalid root: only calcspec allowed.");
            }
            this.readCalcSpec(iXMLElement);
        }
        catch (Exception exception) {
            throw new CalcSpecIoError("Load Error: " + exception.getMessage());
        }
    }

    public void readFile(URL uRL) {
        try {
            IXMLParser iXMLParser = XMLParserFactory.createDefaultXMLParser();
            StdXMLReader stdXMLReader = new StdXMLReader(null, uRL.toString());
            iXMLParser.setReader(stdXMLReader);
            IXMLElement iXMLElement = (IXMLElement)iXMLParser.parse();
            String string = iXMLElement.getName();
            if (!string.equals("calcspec")) {
                throw new CalcSpecIoError("invalid root: only calcspec allowed.");
            }
            this.readCalcSpec(iXMLElement);
        }
        catch (Exception exception) {
            throw new CalcSpecIoError("Load Error: " + exception.getMessage());
        }
    }

    protected void readCalcSpec(IXMLElement iXMLElement) {
        Vector vector = iXMLElement.getChildren();
        for (Object e : vector) {
            IXMLElement iXMLElement2 = (IXMLElement)e;
            String string = iXMLElement2.getName();
            if (string.equals("calculations")) {
                this.readCalculations(iXMLElement2);
                continue;
            }
            if (!string.equals("categories")) continue;
            this.readCategories(iXMLElement2, null);
        }
    }

    protected void readCalculations(IXMLElement iXMLElement) {
        Vector vector = iXMLElement.getChildrenNamed("calculation");
        for (Object e : vector) {
            IXMLElement iXMLElement2 = (IXMLElement)e;
            String string = iXMLElement2.getAttribute("id", null);
            String string2 = iXMLElement2.getAttribute("catid", null);
            CalculationGeneric calculationGeneric = CalcFactory.createGenericCalculation(this.um, string);
            this.readCalculation(iXMLElement2, calculationGeneric);
            this.cm.addCalculation(calculationGeneric);
            this.cm.addCalculationToCategory(calculationGeneric, string2);
        }
    }

    protected void readCalculation(IXMLElement iXMLElement, CalculationGeneric calculationGeneric) {
        IXMLElement iXMLElement2 = iXMLElement.getFirstChildNamed("title");
        if (iXMLElement2 != null) {
            calculationGeneric.setTitle(iXMLElement2.getContent());
        }
        if ((iXMLElement2 = iXMLElement.getFirstChildNamed("description")) != null) {
            calculationGeneric.setDescription(iXMLElement2.getContent());
        }
        if ((iXMLElement2 = iXMLElement.getFirstChildNamed("expression")) == null) {
            throw new CalcSpecIoError("no element <expression> found for " + calculationGeneric.getId());
        }
        calculationGeneric.setExpression(iXMLElement2.getContent());
        iXMLElement2 = iXMLElement.getFirstChildNamed("output");
        if (iXMLElement2 == null) {
            throw new CalcSpecIoError("no element <output> found for " + calculationGeneric.getId());
        }
        this.readCalculationVariable(iXMLElement2, calculationGeneric);
        Vector vector = iXMLElement.getChildrenNamed("input");
        for (Object e : vector) {
            IXMLElement iXMLElement3 = (IXMLElement)e;
            this.readCalculationVariable(iXMLElement3, calculationGeneric);
        }
        calculationGeneric.testExpression();
    }

    protected void readCalculationVariable(IXMLElement iXMLElement, CalculationGeneric calculationGeneric) {
        String string = iXMLElement.getAttribute("mid", null);
        String string2 = iXMLElement.getAttribute("qid", null);
        String string3 = iXMLElement.getAttribute("value", null);
        String string4 = iXMLElement.getAttribute("uid", null);
        String string5 = iXMLElement.getAttribute("symbol", null);
        String string6 = iXMLElement.getAttribute("name", null);
        if (string == null || string2 == null || string3 == null || string4 == null) {
            throw new CalcSpecIoError("Not all of mid, qid, value, uid are specified for " + calculationGeneric.getId());
        }
        if (iXMLElement.getName().equals("output")) {
            calculationGeneric.addOutput(string, string2, string3, string4, string5, string6);
        } else if (iXMLElement.getName().equals("input")) {
            calculationGeneric.addInput(string, string2, string3, string4, string5, string6);
        } else {
            throw new CalcSpecIoError("Internal error. only <output> or <input> allowed for " + calculationGeneric.getId());
        }
        Vector vector = iXMLElement.getChildrenNamed("constraint");
        for (Object e : vector) {
            IXMLElement iXMLElement2 = (IXMLElement)e;
            this.readCalculationInputConstraint(iXMLElement2, string, calculationGeneric);
        }
    }

    protected void readCalculationInputConstraint(IXMLElement iXMLElement, String string, CalculationGeneric calculationGeneric) {
        ValueConstraints valueConstraints = new ValueConstraints();
        Vector vector = iXMLElement.getChildrenNamed("interval");
        for (Object e : vector) {
            int n;
            IXMLElement iXMLElement2 = (IXMLElement)e;
            String string2 = iXMLElement2.getAttribute("kind", "allowed");
            String string3 = iXMLElement2.getAttribute("type", "closedclosed");
            String string4 = iXMLElement2.getAttribute("begin", null);
            String string5 = iXMLElement2.getAttribute("end", null);
            if (string4 == null || string5 == null) {
                throw new CalcSpecIoError("no interval bounds given in constraints for " + calculationGeneric.getId());
            }
            if (string3.equals("openopen")) {
                n = 0;
            } else if (string3.equals("openclosed")) {
                n = 1;
            } else if (string3.equals("closedopen")) {
                n = 2;
            } else if (string3.equals("closedclosed")) {
                n = 3;
            } else {
                throw new CalcSpecIoError("invalid type given for interval in constraints for " + calculationGeneric.getId());
            }
            double d = Double.parseDouble(string4);
            double d2 = Double.parseDouble(string5);
            if (string2.equals("allowed")) {
                valueConstraints.addAllowedInterval(d, d2, n);
                continue;
            }
            if (string2.equals("prohibited")) {
                valueConstraints.addProhibitedInterval(d, d2, n);
                continue;
            }
            throw new CalcSpecIoError("invalid kind given for interval in constraints for " + calculationGeneric.getId());
        }
        calculationGeneric.addInputConstraints(string, valueConstraints);
    }

    protected void readCategories(IXMLElement iXMLElement, String string) {
        Vector vector = iXMLElement.getChildrenNamed("category");
        for (Object e : vector) {
            IXMLElement iXMLElement2 = (IXMLElement)e;
            String string2 = iXMLElement2.getAttribute("id", null);
            String string3 = iXMLElement2.getAttribute("name", null);
            if (string2 == null || string3 == null) {
                throw new CalcSpecIoError("id or name missing in category");
            }
            CalcCategory calcCategory = new CalcCategory(string2, string3);
            this.cm.addCategory(string, calcCategory);
            this.readCategories(iXMLElement2, string2);
        }
    }
}

