/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.masca.core;

import de.admadic.calculator.modules.masca.core.ValueConstraints;
import de.admadic.calculator.modules.masca.ui.CalcPanel;
import de.admadic.units.core.IMeasure;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;

public abstract class AbstractCalculation
implements ActionListener {
    Vector<IMeasure> inputs = new Vector();
    Vector<IMeasure> outputs = new Vector();
    Hashtable<IMeasure, ValueConstraints> inputConstraints = new Hashtable();
    String id;
    String title;
    String description;
    CalcPanel calcPanel;

    public void linkToCalcPanel(CalcPanel calcPanel) {
        this.unlinkFromCalcPanel();
        this.calcPanel = calcPanel;
        this.setupPanel();
        if (this.calcPanel != null) {
            this.calcPanel.addActionListener(this);
        }
    }

    public void unlinkFromCalcPanel() {
        if (this.calcPanel != null) {
            this.calcPanel.removeActionListener(this);
        }
    }

    public void setupPanel() {
        this.calcPanel.initPlain(this.title, this.description, this.inputs.size(), this.outputs.size());
        for (IMeasure iMeasure : this.inputConstraints.keySet()) {
            this.calcPanel.addInputConstraints(iMeasure, this.inputConstraints.get(iMeasure));
        }
        this.calcPanel.registerMeasures(this.inputs, this.outputs);
        this.calcPanel.repaint();
    }

    protected abstract void calculateCore();

    public void calculate() {
        if (!this.getCalcPanel().commitInputs()) {
            return;
        }
        this.calculateCore();
        this.getCalcPanel().refreshDisplay();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public Vector<IMeasure> getInputs() {
        return this.inputs;
    }

    public Vector<IMeasure> getOutputs() {
        return this.outputs;
    }

    public CalcPanel getCalcPanel() {
        return this.calcPanel;
    }

    public void setCalcPanel(CalcPanel calcPanel) {
        this.calcPanel = calcPanel;
    }

    public ValueConstraints getInputConstraints(IMeasure iMeasure) {
        return this.inputConstraints.get(iMeasure);
    }

    public void addInputConstraints(IMeasure iMeasure, ValueConstraints valueConstraints) {
        this.inputConstraints.put(iMeasure, valueConstraints);
    }

    public void addInputConstraints(String string, ValueConstraints valueConstraints) {
        for (IMeasure iMeasure : this.inputs) {
            if (!iMeasure.getId().equals(string)) continue;
            this.addInputConstraints(iMeasure, valueConstraints);
            return;
        }
        throw new Error("Could not find input with id " + string + " in calculation with id " + this.getId());
    }

    public void clearInputConstraints() {
        this.inputConstraints.clear();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.calculate();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }
}

