/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.masca;

import de.admadic.calculator.appctx.AppEvent;
import de.admadic.calculator.appctx.AppEventListener;
import de.admadic.calculator.appctx.CancelPhaseException;
import de.admadic.calculator.appctx.IAppContext;
import de.admadic.calculator.appmod.IModule;
import de.admadic.calculator.appmod.ModuleDesc;
import de.admadic.calculator.modules.masca.MaSCaActions;
import de.admadic.calculator.modules.masca.MaSCaCfg;
import de.admadic.calculator.modules.masca.MaSCaItf;
import de.admadic.calculator.modules.masca.core.CalcManager;
import de.admadic.calculator.modules.masca.core.CalcSpecIo;
import de.admadic.calculator.modules.masca.ui.MaSCaFrame;
import de.admadic.cfg.Cfg;
import de.admadic.units.core.UnitManager;
import de.admadic.units.core.UnitsIo;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class MaSCaModule
implements IModule,
AppEventListener,
MaSCaItf,
ComponentListener {
    static final boolean LOG = true;
    Logger logger = Logger.getLogger("de.admadic");
    UnitManager um;
    CalcManager cm;
    MaSCaFrame frame;
    ModuleDesc moduleDesc;
    IAppContext appContext;
    Cfg cfg;
    MaSCaCfg modCfg;
    MaSCaActions actions;

    public MaSCaModule() {
        this.createModuleDesc();
    }

    private void createModuleDesc() {
        this.moduleDesc = new ModuleDesc();
        this.moduleDesc.setImplDetails("admaDIC", "MaSCa", "1.0.0");
        this.moduleDesc.setSpecDetails("admaDIC", "MaSCa", "1.0.0");
        this.moduleDesc.setCfgName("MaSCa");
    }

    @Override
    public ModuleDesc getModuleDesc() {
        return this.moduleDesc;
    }

    @Override
    public void initialize(IAppContext iAppContext) {
        this.appContext = iAppContext;
        this.cfg = iAppContext.getCfg();
        this.actions = new MaSCaActions();
        this.modCfg = new MaSCaCfg(this.cfg);
        this.modCfg.setPrefix(iAppContext.getCfgModulesPrefix());
        this.modCfg.checkPrevCfg();
        this.actions.initialize(this);
        iAppContext.addAppListener(this);
    }

    @Override
    public JMenu createModuleMenu() {
        JMenu jMenu = new JMenu("MaSCa");
        if (this.actions != null && this.actions.getActions() != null) {
            for (int i = 1; i < this.actions.getActions().size(); ++i) {
                JMenuItem jMenuItem = new JMenuItem(this.actions.getActions().get(i));
                jMenu.add(jMenuItem);
            }
        }
        return jMenu;
    }

    @Override
    public Action[] getActions() {
        return this.actions.getActionArray();
    }

    @Override
    public void processPhase(AppEvent appEvent) throws CancelPhaseException {
        switch (appEvent.getPhase()) {
            case 1: {
                break;
            }
            case 2: {
                this.doInitFrame();
                break;
            }
            case 3: {
                this.doShowFrame();
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.checkExit();
                break;
            }
            case 7: {
                this.doExit();
                break;
            }
        }
    }

    private void readUnitsResource(UnitsIo unitsIo, String string) {
        String[] stringArray;
        for (String string2 : stringArray = new String[]{"de/admadic/calculator/modules/masca/res/", "de/admadic/calculator/units/"}) {
            URL uRL = this.getClass().getClassLoader().getResource(string2 + string);
            if (uRL == null) {
                if (this.logger == null) continue;
                this.logger.severe("Could not access standard unit definition. (" + string + ")");
                continue;
            }
            unitsIo.readFile(uRL);
            return;
        }
        this.showError("Could not access standard unit definition. (" + string + ")\nPlease contact customer support.");
    }

    private void readCalcResource(CalcSpecIo calcSpecIo, String string) {
        String[] stringArray;
        for (String string2 : stringArray = new String[]{"de/admadic/calculator/modules/masca/res/", "de/admadic/calculator/units/"}) {
            URL uRL = this.getClass().getClassLoader().getResource(string2 + string);
            if (uRL == null) {
                if (this.logger == null) continue;
                this.logger.severe("Could not access standard calculations definition. (" + string + ")");
                continue;
            }
            calcSpecIo.readFile(uRL);
            return;
        }
        this.showError("Could not access standard calculations definition. (" + string + ")\nPlease contact customer support.");
    }

    private void doLoadData() {
        UnitsIo unitsIo = new UnitsIo(this.um);
        CalcSpecIo calcSpecIo = new CalcSpecIo(this.cm, this.um);
        this.readUnitsResource(unitsIo, "unitstdset.xml");
        this.readUnitsResource(unitsIo, "quantdef.xml");
        this.readCalcResource(calcSpecIo, "calcspec.xml");
        this.frame.setSetupComplete(true);
        this.frame.initTreeData();
    }

    private void doInitFrame() {
        this.um = new UnitManager();
        this.cm = new CalcManager();
        this.frame = new MaSCaFrame(this.um, this.cm, this.modCfg, this.actions, this.appContext);
        this.frame.initComponents();
        if (this.appContext != null && this.appContext.getLafManager() != null) {
            this.appContext.getLafManager().addComponent(this.frame);
        }
        this.frame.addComponentListener(this);
    }

    private void showError(String string) {
        JOptionPane.showMessageDialog(this.frame, string, "MaSCa Module", 0);
    }

    private void doShowFrame() {
        Rectangle rectangle = this.modCfg.getPos();
        if (rectangle != null) {
            this.frame.setBounds(rectangle);
        }
        boolean bl = this.modCfg.getShow(true);
        this.frame.setVisible(bl);
    }

    private void checkExit() throws CancelPhaseException {
    }

    private void doExit() {
        this.frame.dispose();
    }

    @Override
    public void cmdSingleButton() {
        this.frame.setVisible(!this.frame.isVisible());
    }

    @Override
    public void cmdShow() {
        if (!this.frame.isVisible()) {
            this.frame.setVisible(true);
        }
    }

    @Override
    public void cmdHide() {
        if (this.frame.isVisible()) {
            this.frame.setVisible(false);
        }
    }

    @Override
    public void cmdSettings() {
        this.frame.doToolsOptions();
    }

    @Override
    public void cmdAbout() {
        this.frame.doHelpAbout();
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.modCfg.putPos(this.frame.getBounds());
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        this.modCfg.putPos(this.frame.getBounds());
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.modCfg.putPos(this.frame.getBounds());
        this.modCfg.putShow(this.frame.isVisible());
        if (!this.frame.isSetupComplete()) {
            this.doLoadData();
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        this.modCfg.putShow(this.frame.isVisible());
    }
}

