/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.masca;

import de.admadic.calculator.modules.masca.MaSCaItf;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;

public class MaSCaActions {
    static final boolean LOG = true;
    Logger logger = Logger.getLogger("de.admadic");
    Vector<Action> actions = new Vector();
    Hashtable<Class, Action> classToAction = new Hashtable();

    public Vector<Action> getActions() {
        return this.actions;
    }

    public void initialize(MaSCaItf maSCaItf) {
        this.actions.add(new SingleButtonAction(maSCaItf));
        this.actions.add(new ShowAction(maSCaItf));
        this.actions.add(new HideAction(maSCaItf));
        this.actions.add(new SettingsAction(maSCaItf));
        this.actions.add(new AboutAction(maSCaItf));
        for (Action action : this.actions) {
            this.classToAction.put(action.getClass(), action);
        }
    }

    public Action[] getActionArray() {
        Action[] actionArray = new Action[this.actions.size()];
        actionArray = this.actions.toArray(actionArray);
        return actionArray;
    }

    public ImageIcon loadIcon(String string) {
        String string2 = "de/admadic/calculator/modules/masca/res/" + string;
        URL uRL = this.getClass().getClassLoader().getResource(string2);
        if (uRL == null) {
            if (this.logger != null) {
                this.logger.warning("could not get url for " + string2 + " (icon name = " + string + ")");
            }
            return null;
        }
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        if (image == null) {
            if (this.logger != null) {
                this.logger.warning("could not get image for " + uRL.toString() + " (icon name = " + string + ")");
            }
            return null;
        }
        return new ImageIcon(image);
    }

    public class AboutAction
    extends AbstractMaSCaAction {
        private static final long serialVersionUID = 1L;

        public AboutAction(MaSCaItf maSCaItf) {
            super(maSCaItf);
            this.putValue("Name", "About");
            this.putValue("ShortDescription", "About MaSCa Module");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.itf.cmdAbout();
        }
    }

    public class SettingsAction
    extends AbstractMaSCaAction {
        private static final long serialVersionUID = 1L;

        public SettingsAction(MaSCaItf maSCaItf) {
            super(maSCaItf);
            this.putValue("Name", "Settings");
            this.putValue("ShortDescription", "Change Settings of MaSCa Module");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.itf.cmdSettings();
        }
    }

    public class HideAction
    extends AbstractMaSCaAction {
        private static final long serialVersionUID = 1L;

        public HideAction(MaSCaItf maSCaItf) {
            super(maSCaItf);
            this.putValue("Name", "Hide");
            this.putValue("ShortDescription", "Hide the MaSCa Module");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.itf.cmdHide();
        }
    }

    public class ShowAction
    extends AbstractMaSCaAction {
        private static final long serialVersionUID = 1L;

        public ShowAction(MaSCaItf maSCaItf) {
            super(maSCaItf);
            this.putValue("Name", "Show");
            this.putValue("ShortDescription", "Show the MaSCa Module");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.itf.cmdShow();
        }
    }

    public class SingleButtonAction
    extends AbstractMaSCaAction {
        private static final long serialVersionUID = 1L;

        public SingleButtonAction(MaSCaItf maSCaItf) {
            super(maSCaItf);
            this.putValue("Name", "");
            this.putValue("ShortDescription", "Module Materials Science Calculations");
            this.putValue("SmallIcon", MaSCaActions.this.loadIcon("icon-16.png"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.itf.cmdSingleButton();
        }
    }

    public static abstract class AbstractMaSCaAction
    extends AbstractAction {
        MaSCaItf itf;

        public AbstractMaSCaAction(MaSCaItf maSCaItf) {
            this.itf = maSCaItf;
        }
    }
}

