/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.indxp.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WizardPanel
extends JPanel
implements ActionListener,
ChangeListener {
    JTabbedPane tabbedPane;
    JPanel panelButtons;
    JButton btnPrev;
    JButton btnNext;
    static final String CMD_NEXT = "wiz.next";
    static final String CMD_PREV = "wiz.prev";
    private static final long serialVersionUID = 1L;

    public WizardPanel() {
        this.initialize();
    }

    private void initialize() {
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        this.tabbedPane = new JTabbedPane();
        this.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.addChangeListener(this);
        this.tabbedPane.setTabLayoutPolicy(1);
        this.panelButtons = new JPanel();
        this.add((Component)this.panelButtons, "Last");
        this.btnNext = new JButton("Next >");
        this.btnNext.setActionCommand(CMD_NEXT);
        this.btnNext.addActionListener(this);
        this.btnPrev = new JButton("< Back");
        this.btnPrev.setActionCommand(CMD_PREV);
        this.btnPrev.addActionListener(this);
        this.panelButtons.add(this.btnPrev);
        this.panelButtons.add(this.btnNext);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CMD_NEXT)) {
            this.doNext();
        } else if (string.equals(CMD_PREV)) {
            this.doPrev();
        }
    }

    public void addPanel(JPanel jPanel) {
        this.addPanel(jPanel, null);
    }

    public void addPanel(JPanel jPanel, String object) {
        if (object == null) {
            object = "Panel" + this.tabbedPane.getTabCount() + "1";
        }
        this.tabbedPane.addTab((String)object, jPanel);
        this.updateButtonState();
    }

    public int getPanelCount() {
        return this.tabbedPane.getTabCount();
    }

    public void removePanel(int n) {
        this.tabbedPane.removeTabAt(n);
        this.updateButtonState();
    }

    public void doPrev() {
        int n = this.tabbedPane.getSelectedIndex();
        if (n < 0) {
            return;
        }
        if (--n >= 0) {
            this.tabbedPane.setSelectedIndex(n);
        }
    }

    public void doNext() {
        int n = this.tabbedPane.getSelectedIndex();
        if (n < 0) {
            return;
        }
        if (++n < this.tabbedPane.getTabCount()) {
            this.tabbedPane.setSelectedIndex(n);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object != this.tabbedPane) {
            return;
        }
        this.updateButtonState();
    }

    protected void updateButtonState() {
        int n = this.tabbedPane.getSelectedIndex();
        if (n < 0) {
            return;
        }
        boolean bl = true;
        boolean bl2 = true;
        if (n == 0) {
            bl = false;
        }
        if (n == this.tabbedPane.getTabCount() - 1) {
            bl2 = false;
        }
        this.btnPrev.setEnabled(bl);
        this.btnNext.setEnabled(bl2);
    }
}

