/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.indxp.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.admadic.calculator.modules.indxp.InDXpCfg;
import de.admadic.ui.util.Dialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SettingsDialog
extends Dialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    static final String CMD_OK = "cmd.ok";
    static final String CMD_CANCEL = "cmd.cancel";
    JPanel panelButtons;
    JButton btnOK;
    JButton btnCancel;
    JLabel labelPrecision;
    JSlider sliderPrecision;
    JSpinner spinnerPrecision;
    boolean updatePrecisionBusy = false;
    InDXpCfg cfg;

    public SettingsDialog(Frame frame, InDXpCfg inDXpCfg) throws HeadlessException {
        super(frame);
        this.cfg = inDXpCfg;
    }

    public void initContents() {
        FormLayout formLayout = new FormLayout("12px, p, 5px, p, 5px, p, 12px", "12px, p, 12px, p, 12px");
        CellConstraints cellConstraints = new CellConstraints();
        Container container = this.getContentPane();
        this.setModal(true);
        this.setTitle("Settings");
        container.setLayout(formLayout);
        this.labelPrecision = new JLabel("Number Display Precision:");
        container.add((Component)this.labelPrecision, cellConstraints.xy(2, 2));
        this.sliderPrecision = new JSlider();
        container.add((Component)this.sliderPrecision, cellConstraints.xy(4, 2));
        this.spinnerPrecision = new JSpinner();
        container.add((Component)this.spinnerPrecision, cellConstraints.xy(6, 2));
        this.panelButtons = new JPanel();
        container.add((Component)this.panelButtons, cellConstraints.xywh(2, 4, 5, 1));
        this.btnOK = new JButton("OK");
        this.btnOK.setActionCommand(CMD_OK);
        this.btnOK.addActionListener(this);
        this.panelButtons.add(this.btnOK);
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.setActionCommand(CMD_CANCEL);
        this.btnCancel.addActionListener(this);
        this.panelButtons.add(this.btnCancel);
        this.registerEnterAction(this.btnOK);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.sliderPrecision.setMinimum(0);
        this.sliderPrecision.setMaximum(15);
        this.sliderPrecision.setMajorTickSpacing(3);
        this.sliderPrecision.setMinorTickSpacing(1);
        this.sliderPrecision.setSnapToTicks(true);
        this.sliderPrecision.setPaintLabels(true);
        this.sliderPrecision.setPaintTicks(true);
        this.sliderPrecision.setValue(0);
        this.spinnerPrecision.setModel(new SpinnerNumberModel(0, 0, 15, 1));
        this.spinnerPrecision.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SettingsDialog.this.updatePrecisionValue(SettingsDialog.this.spinnerPrecision);
            }
        });
        this.sliderPrecision.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SettingsDialog.this.updatePrecisionValue(SettingsDialog.this.sliderPrecision);
            }
        });
    }

    protected void updatePrecisionValue(JComponent jComponent) {
        if (this.updatePrecisionBusy) {
            return;
        }
        this.updatePrecisionBusy = true;
        if (jComponent == this.spinnerPrecision) {
            this.sliderPrecision.setValue((Integer)this.spinnerPrecision.getValue());
        }
        if (jComponent == this.sliderPrecision) {
            this.spinnerPrecision.setValue(this.sliderPrecision.getValue());
        }
        this.updatePrecisionBusy = false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CMD_OK)) {
            this.storeSettings();
            this.setResultCode(1);
            this.setVisible(false);
        } else if (string.equals(CMD_CANCEL)) {
            this.setResultCode(2);
            this.setVisible(false);
        }
    }

    public void storeSettings() {
        int n = this.sliderPrecision.getValue();
        Object object = "%g";
        if (n > 0) {
            object = "%." + n + "g";
        }
        this.cfg.putDisplayFormat((String)object);
    }

    public void loadSettings() {
        String string = this.cfg.getDisplayFormat();
        int n = 0;
        if (string == null || string.equals("%g")) {
            n = 0;
        } else {
            try {
                String string2 = string.substring(2, string.length() - 1);
                n = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                n = 6;
            }
        }
        this.sliderPrecision.setValue(n);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

