/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.indxp.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.admadic.calculator.modules.indxp.core.DataEvent;
import de.admadic.calculator.modules.indxp.core.DataEventDispatcher;
import de.admadic.calculator.modules.indxp.core.DataEventListener;
import de.admadic.calculator.modules.indxp.core.DataEventServer;
import de.admadic.calculator.modules.indxp.core.DataItemStatus;
import de.admadic.calculator.modules.indxp.core.FactorInteraction;
import de.admadic.calculator.modules.indxp.core.Run;
import de.admadic.calculator.modules.indxp.core.RunsBuilder;
import de.admadic.calculator.modules.indxp.core.RunsTableModel;
import de.admadic.calculator.modules.indxp.ui.DataPanel;
import de.admadic.calculator.modules.indxp.ui.LevelCellEditor;
import de.admadic.calculator.modules.indxp.ui.LevelCellRenderer;
import de.admadic.calculator.modules.indxp.ui.NumberInputDialog;
import de.admadic.calculator.modules.indxp.ui.NumberInputSet;
import de.admadic.ui.util.VetoableToggleButtonModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumnModel;

public class RunsPanel
extends DataPanel
implements ActionListener,
DataEventListener,
TableColumnModelListener {
    JTable tableRuns;
    JScrollPane scrollRuns;
    RunsTableModel tableModelRuns;
    JPanel panelButtons;
    JButton btnCreate;
    JButton btnCreateRg;
    JButton btnRemove;
    JToggleButton btnLock;
    static final String CMD_CREATE = "runs.create";
    static final String CMD_CREATE_RG = "runs.createrg";
    static final String CMD_REMOVE = "runs.remove";
    static final String CMD_LOCK = "runs.lock";
    private static final long serialVersionUID = 1L;
    RunsBuilder runsBuilder;
    ArrayList<Run> runsLink;
    ArrayList<FactorInteraction> factorInteractionsLink;

    public RunsPanel() {
        this.initContents(false);
    }

    public RunsPanel(boolean bl) {
        this.initContents(bl);
    }

    private void initContents(boolean bl) {
        FormLayout formLayout = bl ? new FormLayout("0px, p:grow, 5px, p, 0px", "0px, p:grow, 0px") : new FormLayout("12px, p:grow, 5px, p, 12px", "12px, p:grow, 12px");
        this.setLayout(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        this.tableModelRuns = new RunsTableModel();
        this.tableRuns = new JTable();
        this.tableRuns.setModel(this.tableModelRuns);
        this.tableRuns.getColumnModel().addColumnModelListener(this);
        this.scrollRuns = new JScrollPane();
        this.add((Component)this.scrollRuns, cellConstraints.xy(2, 2, CellConstraints.DEFAULT, CellConstraints.FILL));
        this.scrollRuns.setViewportView(this.tableRuns);
        this.scrollRuns.setHorizontalScrollBarPolicy(32);
        this.scrollRuns.setVerticalScrollBarPolicy(22);
        this.tableRuns.setPreferredScrollableViewportSize(new Dimension(300, 200));
        this.tableRuns.setAutoResizeMode(0);
        this.panelButtons = new JPanel();
        this.add((Component)this.panelButtons, cellConstraints.xy(4, 2, CellConstraints.DEFAULT, CellConstraints.FILL));
        FormLayout formLayout2 = new FormLayout("p", "p, 5px, p, 5px, p, 5px, p");
        this.panelButtons.setLayout(formLayout2);
        CellConstraints cellConstraints2 = new CellConstraints();
        this.btnCreate = new JButton("Create");
        this.btnCreate.setActionCommand(CMD_CREATE);
        this.btnCreate.addActionListener(this);
        this.btnCreateRg = new JButton("Create...");
        this.btnCreateRg.setActionCommand(CMD_CREATE_RG);
        this.btnCreateRg.addActionListener(this);
        this.btnRemove = new JButton("Remove");
        this.btnRemove.setActionCommand(CMD_REMOVE);
        this.btnRemove.addActionListener(this);
        this.btnLock = new JToggleButton("Lock");
        this.btnLock.setActionCommand(CMD_LOCK);
        this.btnLock.addActionListener(this);
        VetoableToggleButtonModel vetoableToggleButtonModel = new VetoableToggleButtonModel();
        vetoableToggleButtonModel.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                String string = propertyChangeEvent.getPropertyName();
                if (!string.equals("selected")) {
                    return;
                }
                if (propertyChangeEvent.getSource() != RunsPanel.this.btnLock.getModel()) {
                    return;
                }
                Boolean bl = (Boolean)propertyChangeEvent.getOldValue();
                Boolean bl2 = (Boolean)propertyChangeEvent.getNewValue();
                if (!RunsPanel.this.allowLockOp(bl, bl2)) {
                    throw new PropertyVetoException(string, propertyChangeEvent);
                }
            }
        });
        this.btnLock.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    RunsPanel.this.doLock(true);
                } else {
                    RunsPanel.this.doLock(false);
                }
            }
        });
        this.panelButtons.add((Component)this.btnCreate, cellConstraints2.xy(1, 1));
        this.panelButtons.add((Component)this.btnCreateRg, cellConstraints2.xy(1, 3));
        this.panelButtons.add((Component)this.btnRemove, cellConstraints2.xy(1, 5));
        this.panelButtons.add((Component)this.btnLock, cellConstraints2.xy(1, 7));
    }

    protected void doLock(boolean bl) {
        this.tableModelRuns.setLocked(bl);
        DataPanel.enableComponents((Container)this.panelButtons, !bl, this.btnLock);
        if (this.getDataItemStatusServer() != null) {
            DataItemStatus dataItemStatus = this.getDataItemStatusServer().getDataItemStatus(2);
            if (bl) {
                dataItemStatus.lock(3);
            } else {
                dataItemStatus.unlock(3);
            }
        }
    }

    protected boolean allowLockOp(boolean bl, boolean bl2) {
        int n;
        DataItemStatus dataItemStatus;
        return this.getDataItemStatusServer() == null || !(dataItemStatus = this.getDataItemStatusServer().getDataItemStatus(2)).isLocked() || !bl || bl2 || (n = JOptionPane.showConfirmDialog(null, "Are you sure, that you want to unlock the data?\nIf you unlock, the data may be changed which may\ninfluence subsequent calculations.\nThe results of these calculations may then be invalid.", "Confirm data unlock", 0)) != 1;
    }

    public void linkData(ArrayList<Run> arrayList, ArrayList<FactorInteraction> arrayList2) {
        this.runsLink = arrayList;
        this.factorInteractionsLink = arrayList2;
        this.tableModelRuns.setData(arrayList, arrayList2);
    }

    @Override
    public void setDataEventDispatcher(DataEventDispatcher dataEventDispatcher) {
        super.setDataEventDispatcher(dataEventDispatcher);
        this.tableModelRuns.setDataEventDispatcher(dataEventDispatcher);
    }

    @Override
    public void setDataEventServer(DataEventServer dataEventServer) {
        if (this.dataEventServer != null) {
            this.dataEventServer.removeDataListener(this.tableModelRuns);
            this.dataEventServer.removeDataListener(this);
        }
        super.setDataEventServer(dataEventServer);
        if (this.dataEventServer != null) {
            this.dataEventServer.addDataListener(this.tableModelRuns);
            this.dataEventServer.addDataListener(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CMD_CREATE)) {
            this.doCreate();
        } else if (string.equals(CMD_CREATE_RG)) {
            this.doCreateRg();
        } else if (string.equals(CMD_REMOVE)) {
            this.doRemove();
        } else if (string.equals(CMD_LOCK)) {
            // empty if block
        }
    }

    private void doCreate() {
        int n;
        int n2 = this.countSingleFactorInteractions();
        if (n2 > 10) {
            JOptionPane.showMessageDialog(null, "Too many factors.\nThere are more than 10 factors to be used. A full\nfactorial set of runs is not supported for this amount of data.\nTry to create a limited/ranged run set or reduce the factors.", "Too many factors", 0);
            return;
        }
        if (this.runsLink.size() > 0 && (n = JOptionPane.showConfirmDialog(null, "There are already existing runs which would be removed.\nDo you want to create new runs?", "Confirm creation of new runs", 0)) != 0) {
            return;
        }
        this.runsLink.clear();
        this.runsBuilder.createFullFactorialRuns();
        if (this.dataEventDispatcher != null) {
            this.dataEventDispatcher.notifyEvent(this, 16);
        }
    }

    private int countSingleFactorInteractions() {
        int n = 0;
        for (FactorInteraction factorInteraction : this.factorInteractionsLink) {
            if (factorInteraction.getFactors().size() != 1) continue;
            ++n;
        }
        return n;
    }

    private void doCreateRg() {
        int n = -1;
        NumberInputSet[] numberInputSetArray = new NumberInputSet[]{new NumberInputSet("Number of runs:", "(1..1024)", 8, 1, 1024, 1)};
        NumberInputDialog numberInputDialog = new NumberInputDialog("Please enter the number of runs to generate.", numberInputSetArray);
        numberInputDialog.setVisible(true);
        int n2 = numberInputDialog.getResultCode();
        if (n2 != 1) {
            return;
        }
        n = numberInputSetArray[0].getValue();
        this.runsBuilder.createRangedRuns(n);
        if (this.dataEventDispatcher != null) {
            this.dataEventDispatcher.notifyEvent(this, 32);
        }
    }

    private void doRemove() {
        int[] nArray = this.tableRuns.getSelectedRows();
        if (nArray.length < 1) {
            JOptionPane.showMessageDialog(null, "No runs selected.\nYou need to select runs which are to be removed.", "No runs selected", 0);
            return;
        }
        int n = JOptionPane.showConfirmDialog(null, "Please confirm that the " + nArray.length + " selected runs shall be deleted.\nDo you want to delete these runs?", "Confirm deletion of selected runs", 0);
        if (n != 0) {
            return;
        }
        Vector<Run> vector = new Vector<Run>();
        for (int n2 : nArray) {
            vector.add(this.runsLink.get(n2));
        }
        this.runsLink.removeAll(vector);
        if (this.dataEventDispatcher != null) {
            this.dataEventDispatcher.notifyEvent(this, 32);
        }
    }

    public void setRunsBuilder(RunsBuilder runsBuilder) {
        this.runsBuilder = runsBuilder;
    }

    @Override
    public void dataEventSignalled(DataEvent dataEvent) {
        if (dataEvent.getSource() == this) {
            return;
        }
        if ((dataEvent.getMask() & 8) != 0) {
            // empty if block
        }
        if ((dataEvent.getMask() & 0x10) != 0 && this.getDataItemStatusServer() != null) {
            DataItemStatus dataItemStatus = this.getDataItemStatusServer().getDataItemStatus(2);
            this.btnLock.setSelected(dataItemStatus.isLocked());
        }
    }

    @Override
    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        int n = tableColumnModelEvent.getToIndex();
        TableColumnModel tableColumnModel = this.tableRuns.getColumnModel();
        if (n == 0) {
            tableColumnModel.getColumn(n).setPreferredWidth(75);
        } else {
            tableColumnModel.getColumn(n).setPreferredWidth(50);
        }
        if (n > 0) {
            FactorInteraction factorInteraction = this.factorInteractionsLink.get(n - 1);
            boolean bl = factorInteraction.getFactors().size() == 1;
            tableColumnModel.getColumn(n).setCellRenderer(new LevelCellRenderer(true, !bl));
            if (bl) {
                tableColumnModel.getColumn(n).setCellEditor(new LevelCellEditor());
            }
        }
    }

    @Override
    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    @Override
    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    @Override
    public void columnMarginChanged(ChangeEvent changeEvent) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }
}

