/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.indxp.ui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class LevelCellRenderer
extends DefaultTableCellRenderer
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    Border borderUnselected = null;
    Border borderSelected = null;
    boolean isBordered = true;
    boolean isReadOnly = true;
    Color colorLevelHigh;
    Color colorLevelLow;
    Color colorLevelHighRO;
    Color colorLevelLowRO;
    Color colorLevelNone;

    public LevelCellRenderer(boolean bl, boolean bl2) {
        this.isBordered = bl;
        this.isReadOnly = bl2;
        this.setOpaque(true);
        this.setHorizontalAlignment(4);
        this.colorLevelHigh = Color.decode("#00FF00");
        this.colorLevelHighRO = Color.decode("#80FF80");
        this.colorLevelLow = Color.decode("#FF0000");
        this.colorLevelLowRO = Color.decode("#FF8080");
        this.colorLevelNone = Color.GRAY;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Color color;
        Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (component == null) {
            // empty if block
        }
        Integer n3 = (Integer)object;
        String string = String.format("%+d", n3);
        boolean bl3 = jTable.isCellEditable(n, n2);
        switch (n3) {
            case -1: {
                color = bl3 ? this.colorLevelLow : this.colorLevelLowRO;
                break;
            }
            case 1: {
                color = bl3 ? this.colorLevelHigh : this.colorLevelHighRO;
                break;
            }
            default: {
                color = this.colorLevelNone;
            }
        }
        this.setText(string);
        if (this.isBordered) {
            if (this.borderSelected == null) {
                this.borderSelected = BorderFactory.createMatteBorder(2, 5, 2, 5, jTable.getSelectionBackground());
            }
            if (this.borderUnselected == null) {
                this.borderUnselected = BorderFactory.createMatteBorder(2, 5, 2, 5, jTable.getBackground());
            }
            Border border = this.getBorder();
            MatteBorder matteBorder = BorderFactory.createMatteBorder(0, 0, 0, 5, color);
            border = BorderFactory.createCompoundBorder(border, matteBorder);
            this.setBorder(border);
        }
        return this;
    }
}

