/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.indxp.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.admadic.calculator.modules.indxp.core.DataEvent;
import de.admadic.calculator.modules.indxp.core.DataEventDispatcher;
import de.admadic.calculator.modules.indxp.core.DataEventListener;
import de.admadic.calculator.modules.indxp.core.DataEventServer;
import de.admadic.calculator.modules.indxp.core.ExpResults;
import de.admadic.calculator.modules.indxp.core.FactorInteraction;
import de.admadic.calculator.modules.indxp.core.LevelAnalysis;
import de.admadic.calculator.modules.indxp.core.LevelAnalysisTableModel;
import de.admadic.calculator.modules.indxp.ui.DataPanel;
import de.admadic.calculator.modules.indxp.ui.FloatingPointFormatter;
import de.admadic.calculator.modules.indxp.ui.GradientCellRenderer;
import de.admadic.ui.util.ColorGradient;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumnModel;

public class LevelAnalysisPanel
extends DataPanel
implements ActionListener,
DataEventListener,
TableColumnModelListener {
    private static final long serialVersionUID = 1L;
    JTable tableLevelAnalysis;
    JScrollPane scrollLevelAnalysis;
    LevelAnalysisTableModel tableModelLevelAnalysis;
    GradientCellRenderer gradientCellRenderer;
    JPanel panelButtons;
    JButton btnCalculate;
    JButton btnReset;
    JToggleButton btnColorize;
    static final String CMD_CALCULATE = "levan.calculate";
    static final String CMD_RESET = "levan.reset";
    static final String CMD_COLORIZE = "levan.colorize";
    LevelAnalysis levelAnalysisLink;
    ArrayList<FactorInteraction> factorInteractionsLink;
    ArrayList<ExpResults> expResultsLink;
    FloatingPointFormatter fpf;

    public LevelAnalysisPanel(FloatingPointFormatter floatingPointFormatter) {
        this.setFloatingPointFormatter(floatingPointFormatter);
        this.initContents(false);
    }

    public LevelAnalysisPanel(boolean bl) {
        this.initContents(bl);
    }

    private void initContents(boolean bl) {
        FormLayout formLayout = bl ? new FormLayout("0px, p:grow, 5px, p, 0px", "0px, p:grow, 0px") : new FormLayout("12px, p:grow, 5px, p, 12px", "12px, p:grow, 12px");
        this.setLayout(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        this.tableModelLevelAnalysis = new LevelAnalysisTableModel();
        this.tableLevelAnalysis = new JTable();
        this.tableLevelAnalysis.setModel(this.tableModelLevelAnalysis);
        this.tableLevelAnalysis.getColumnModel().addColumnModelListener(this);
        this.scrollLevelAnalysis = new JScrollPane();
        this.add((Component)this.scrollLevelAnalysis, cellConstraints.xy(2, 2, CellConstraints.DEFAULT, CellConstraints.FILL));
        this.scrollLevelAnalysis.setViewportView(this.tableLevelAnalysis);
        this.scrollLevelAnalysis.setHorizontalScrollBarPolicy(32);
        this.scrollLevelAnalysis.setVerticalScrollBarPolicy(22);
        this.tableLevelAnalysis.setPreferredScrollableViewportSize(new Dimension(300, 80));
        this.tableLevelAnalysis.setAutoResizeMode(0);
        this.gradientCellRenderer = new GradientCellRenderer(ColorGradient.JET(), GradientCellRenderer.BORDER_BOTTOM, 0);
        this.gradientCellRenderer.setFloatingPointFormatter(this.fpf);
        this.tableLevelAnalysis.setDefaultRenderer(Double.class, this.gradientCellRenderer);
        this.panelButtons = new JPanel();
        this.add((Component)this.panelButtons, cellConstraints.xy(4, 2, CellConstraints.DEFAULT, CellConstraints.FILL));
        FormLayout formLayout2 = new FormLayout("p", "p, 5px, p, 5px, p, 5px, p");
        this.panelButtons.setLayout(formLayout2);
        CellConstraints cellConstraints2 = new CellConstraints();
        this.btnCalculate = new JButton("Create");
        this.btnCalculate.setActionCommand(CMD_CALCULATE);
        this.btnCalculate.addActionListener(this);
        this.btnReset = new JButton("Reset...");
        this.btnReset.setActionCommand(CMD_RESET);
        this.btnReset.addActionListener(this);
        this.btnColorize = new JToggleButton("Color");
        this.btnColorize.setActionCommand(CMD_COLORIZE);
        this.btnColorize.addActionListener(this);
        this.btnColorize.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    LevelAnalysisPanel.this.doColorize(true);
                } else {
                    LevelAnalysisPanel.this.doColorize(false);
                }
            }
        });
        this.panelButtons.add((Component)this.btnCalculate, cellConstraints2.xy(1, 1));
        this.panelButtons.add((Component)this.btnReset, cellConstraints2.xy(1, 3));
        this.panelButtons.add((Component)this.btnColorize, cellConstraints2.xy(1, 5));
    }

    public void linkData(LevelAnalysis levelAnalysis, ArrayList<ExpResults> arrayList, ArrayList<FactorInteraction> arrayList2) {
        this.levelAnalysisLink = levelAnalysis;
        this.expResultsLink = arrayList;
        this.factorInteractionsLink = arrayList2;
        this.tableModelLevelAnalysis.setData(this.factorInteractionsLink, levelAnalysis);
    }

    @Override
    public void setDataEventDispatcher(DataEventDispatcher dataEventDispatcher) {
        super.setDataEventDispatcher(dataEventDispatcher);
        this.tableModelLevelAnalysis.setDataEventDispatcher(dataEventDispatcher);
    }

    @Override
    public void setDataEventServer(DataEventServer dataEventServer) {
        if (this.dataEventServer != null) {
            this.dataEventServer.removeDataListener(this.tableModelLevelAnalysis);
            this.dataEventServer.removeDataListener(this);
        }
        super.setDataEventServer(dataEventServer);
        if (this.dataEventServer != null) {
            this.dataEventServer.addDataListener(this.tableModelLevelAnalysis);
            this.dataEventServer.addDataListener(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CMD_CALCULATE)) {
            this.doCalculate();
        } else if (string.equals(CMD_RESET)) {
            this.doReset();
        } else if (string.equals(CMD_COLORIZE)) {
            // empty if block
        }
    }

    protected void doColorize(boolean bl) {
        this.gradientCellRenderer.setOn(bl);
        this.tableModelLevelAnalysis.fireTableDataChanged();
    }

    private void doCalculate() {
        this.levelAnalysisLink.calculate();
        this.updateRanges();
        if (this.dataEventDispatcher != null) {
            this.dataEventDispatcher.notifyEvent(this, 256);
        }
    }

    private void doReset() {
        int n = JOptionPane.showConfirmDialog(null, "Please confirm that the analysis data shall be reset.\nDo you want to reset them?", "Confirm reset of analysis data", 0);
        if (n != 0) {
            return;
        }
        this.levelAnalysisLink.resetData();
        if (this.dataEventDispatcher != null) {
            this.dataEventDispatcher.notifyEvent(this, 128);
        }
    }

    @Override
    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        int n = tableColumnModelEvent.getToIndex();
        TableColumnModel tableColumnModel = this.tableLevelAnalysis.getColumnModel();
        if (n == 0) {
            tableColumnModel.getColumn(n).setPreferredWidth(75);
        } else {
            tableColumnModel.getColumn(n).setPreferredWidth(50);
        }
    }

    @Override
    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    @Override
    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    @Override
    public void columnMarginChanged(ChangeEvent changeEvent) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }

    protected void updateRanges() {
        this.gradientCellRenderer.clearRanges();
        Double[] doubleArray = this.levelAnalysisLink.getRange(0);
        this.gradientCellRenderer.addCellRange((Integer)0, doubleArray[0], doubleArray[1]);
        doubleArray = this.levelAnalysisLink.getRange(1);
        this.gradientCellRenderer.addCellRange((Integer)1, doubleArray[0], doubleArray[1]);
        doubleArray = this.levelAnalysisLink.getRange(2);
        this.gradientCellRenderer.addCellRange((Integer)2, doubleArray[0], doubleArray[1]);
        this.tableModelLevelAnalysis.fireTableDataChanged();
    }

    @Override
    public void dataEventSignalled(DataEvent dataEvent) {
        if (dataEvent.getSource() == this) {
            return;
        }
        if ((dataEvent.getMask() & 0x200) != 0 || (dataEvent.getMask() & 0x100) != 0) {
            this.updateRanges();
        }
    }

    public void setFloatingPointFormatter(FloatingPointFormatter floatingPointFormatter) {
        this.fpf = floatingPointFormatter;
    }
}

